/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitamui.iam.server.user.service;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import fr.gouv.vitamui.commons.api.exception.InternalServerException;
import fr.gouv.vitamui.iam.server.user.service.TranslateService;
import java.util.HashMap;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class OperationParser {
    private static final Logger LOGGER = LoggerFactory.getLogger(OperationParser.class);
    private static final String OLD_VALUE_PREFIX = "-";
    private static final String NEW_VALUE_PREFIX = "+";
    private static final String DIFF_KEY = "diff";
    private final ObjectMapper objectMapper;
    private final TranslateService translateService;

    public String parseOldValues(String json) {
        return this.parse(json, OLD_VALUE_PREFIX);
    }

    public String parseNewValues(String json) {
        return this.parse(json, NEW_VALUE_PREFIX);
    }

    public String parseUserId(String evIdAppSession) {
        if (evIdAppSession == null) {
            return null;
        }
        String[] sessionData = evIdAppSession.split(":");
        if (sessionData.length < 4) {
            return null;
        }
        return sessionData[3];
    }

    private String parse(String json, String prefix) {
        try {
            HashMap updateOperation = (HashMap)this.objectMapper.readValue(json, HashMap.class);
            if (updateOperation == null || !updateOperation.containsKey(DIFF_KEY)) {
                return "";
            }
            return ((HashMap)updateOperation.get(DIFF_KEY)).entrySet().stream().filter(s -> ((String)s.getKey()).startsWith(prefix)).map(s -> this.removePrefix((String)s.getKey(), prefix) + ":" + this.translateService.translate(this.removePrefix((String)s.getValue(), prefix))).collect(Collectors.joining(","));
        }
        catch (JsonProcessingException | IllegalArgumentException e) {
            throw new InternalServerException("cannot parse operation %s".formatted(json), e);
        }
    }

    private String removePrefix(String value, String prefix) {
        return value.replace(prefix, "");
    }

    @Generated
    public OperationParser(ObjectMapper objectMapper, TranslateService translateService) {
        this.objectMapper = objectMapper;
        this.translateService = translateService;
    }
}

