/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitamui.iam.server.user.domain;

import fr.gouv.vitamui.commons.api.domain.BaseIdentifierDocument;
import fr.gouv.vitamui.commons.api.enums.UserStatusEnum;
import fr.gouv.vitamui.commons.api.enums.UserTypeEnum;
import fr.gouv.vitamui.iam.server.common.domain.Address;
import fr.gouv.vitamui.iam.server.common.domain.CustomerIdDocument;
import fr.gouv.vitamui.iam.server.user.domain.Analytics;
import jakarta.validation.constraints.Email;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Size;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import org.springframework.data.annotation.TypeAlias;
import org.springframework.data.mongodb.core.index.CompoundIndex;
import org.springframework.data.mongodb.core.index.Indexed;
import org.springframework.data.mongodb.core.mapping.Document;

@Document(collection="users")
@TypeAlias(value="users")
@CompoundIndex(def="{'email': 1, 'customerId': 1}", name="idx_user_email_customerid", unique=true)
public class User
extends CustomerIdDocument
implements BaseIdentifierDocument {
    @Size(max=100)
    private @Size(max=100) String password;
    private List<String> oldPasswords = new ArrayList();
    @NotNull
    @Size(min=4, max=100)
    @Email
    private @NotNull @Size(min=4, max=100) @Email String email;
    @NotNull
    @Size(min=2, max=50)
    private @NotNull @Size(min=2, max=50) String firstname;
    @NotNull
    @Indexed(name="idx_user_identifier", unique=true, background=true)
    @Size(min=1, max=12)
    private @NotNull @Size(min=1, max=12) String identifier;
    private boolean otp;
    private boolean subrogeable;
    @NotNull
    @Size(min=2, max=50)
    private @NotNull @Size(min=2, max=50) String lastname;
    @NotNull
    private String language;
    private String phone;
    private String mobile;
    @NotNull
    private String groupId;
    private OffsetDateTime lastConnection;
    private int nbFailedAttempts = 0;
    @NotNull
    private UserStatusEnum status;
    @NotNull
    private UserTypeEnum type;
    private boolean readonly = false;
    @NotNull
    private String level;
    private OffsetDateTime passwordExpirationDate;
    private Address address = new Address();
    private OffsetDateTime disablingDate;
    private String internalCode;
    private OffsetDateTime removingDate;
    private String siteCode;
    private List<String> centerCodes;
    private Analytics analytics = new Analytics();
    private boolean autoProvisioningEnabled;
    private String userInfoId;

    @Generated
    public String getPassword() {
        return this.password;
    }

    @Generated
    public List<String> getOldPasswords() {
        return this.oldPasswords;
    }

    @Generated
    public String getEmail() {
        return this.email;
    }

    @Generated
    public String getFirstname() {
        return this.firstname;
    }

    @Generated
    public String getIdentifier() {
        return this.identifier;
    }

    @Generated
    public boolean isOtp() {
        return this.otp;
    }

    @Generated
    public boolean isSubrogeable() {
        return this.subrogeable;
    }

    @Generated
    public String getLastname() {
        return this.lastname;
    }

    @Generated
    public String getLanguage() {
        return this.language;
    }

    @Generated
    public String getPhone() {
        return this.phone;
    }

    @Generated
    public String getMobile() {
        return this.mobile;
    }

    @Generated
    public String getGroupId() {
        return this.groupId;
    }

    @Generated
    public OffsetDateTime getLastConnection() {
        return this.lastConnection;
    }

    @Generated
    public int getNbFailedAttempts() {
        return this.nbFailedAttempts;
    }

    @Generated
    public UserStatusEnum getStatus() {
        return this.status;
    }

    @Generated
    public UserTypeEnum getType() {
        return this.type;
    }

    @Generated
    public String getLevel() {
        return this.level;
    }

    @Generated
    public OffsetDateTime getPasswordExpirationDate() {
        return this.passwordExpirationDate;
    }

    @Generated
    public Address getAddress() {
        return this.address;
    }

    @Generated
    public OffsetDateTime getDisablingDate() {
        return this.disablingDate;
    }

    @Generated
    public String getInternalCode() {
        return this.internalCode;
    }

    @Generated
    public OffsetDateTime getRemovingDate() {
        return this.removingDate;
    }

    @Generated
    public String getSiteCode() {
        return this.siteCode;
    }

    @Generated
    public List<String> getCenterCodes() {
        return this.centerCodes;
    }

    @Generated
    public Analytics getAnalytics() {
        return this.analytics;
    }

    @Generated
    public boolean isAutoProvisioningEnabled() {
        return this.autoProvisioningEnabled;
    }

    @Generated
    public String getUserInfoId() {
        return this.userInfoId;
    }

    @Generated
    public void setPassword(String password) {
        this.password = password;
    }

    @Generated
    public void setOldPasswords(List<String> oldPasswords) {
        this.oldPasswords = oldPasswords;
    }

    @Generated
    public void setEmail(String email) {
        this.email = email;
    }

    @Generated
    public void setFirstname(String firstname) {
        this.firstname = firstname;
    }

    @Generated
    public void setIdentifier(String identifier) {
        this.identifier = identifier;
    }

    @Generated
    public void setOtp(boolean otp) {
        this.otp = otp;
    }

    @Generated
    public void setSubrogeable(boolean subrogeable) {
        this.subrogeable = subrogeable;
    }

    @Generated
    public void setLastname(String lastname) {
        this.lastname = lastname;
    }

    @Generated
    public void setLanguage(String language) {
        this.language = language;
    }

    @Generated
    public void setPhone(String phone) {
        this.phone = phone;
    }

    @Generated
    public void setMobile(String mobile) {
        this.mobile = mobile;
    }

    @Generated
    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    @Generated
    public void setLastConnection(OffsetDateTime lastConnection) {
        this.lastConnection = lastConnection;
    }

    @Generated
    public void setNbFailedAttempts(int nbFailedAttempts) {
        this.nbFailedAttempts = nbFailedAttempts;
    }

    @Generated
    public void setStatus(UserStatusEnum status) {
        this.status = status;
    }

    @Generated
    public void setType(UserTypeEnum type) {
        this.type = type;
    }

    @Generated
    public void setReadonly(boolean readonly) {
        this.readonly = readonly;
    }

    @Generated
    public void setLevel(String level) {
        this.level = level;
    }

    @Generated
    public void setPasswordExpirationDate(OffsetDateTime passwordExpirationDate) {
        this.passwordExpirationDate = passwordExpirationDate;
    }

    @Generated
    public void setAddress(Address address) {
        this.address = address;
    }

    @Generated
    public void setDisablingDate(OffsetDateTime disablingDate) {
        this.disablingDate = disablingDate;
    }

    @Generated
    public void setInternalCode(String internalCode) {
        this.internalCode = internalCode;
    }

    @Generated
    public void setRemovingDate(OffsetDateTime removingDate) {
        this.removingDate = removingDate;
    }

    @Generated
    public void setSiteCode(String siteCode) {
        this.siteCode = siteCode;
    }

    @Generated
    public void setCenterCodes(List<String> centerCodes) {
        this.centerCodes = centerCodes;
    }

    @Generated
    public void setAnalytics(Analytics analytics) {
        this.analytics = analytics;
    }

    @Generated
    public void setAutoProvisioningEnabled(boolean autoProvisioningEnabled) {
        this.autoProvisioningEnabled = autoProvisioningEnabled;
    }

    @Generated
    public void setUserInfoId(String userInfoId) {
        this.userInfoId = userInfoId;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof User)) {
            return false;
        }
        User other = (User)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.isOtp() != other.isOtp()) {
            return false;
        }
        if (this.isSubrogeable() != other.isSubrogeable()) {
            return false;
        }
        if (this.getNbFailedAttempts() != other.getNbFailedAttempts()) {
            return false;
        }
        if (this.isReadonly() != other.isReadonly()) {
            return false;
        }
        if (this.isAutoProvisioningEnabled() != other.isAutoProvisioningEnabled()) {
            return false;
        }
        String this$password = this.getPassword();
        String other$password = other.getPassword();
        if (this$password == null ? other$password != null : !this$password.equals(other$password)) {
            return false;
        }
        List this$oldPasswords = this.getOldPasswords();
        List other$oldPasswords = other.getOldPasswords();
        if (this$oldPasswords == null ? other$oldPasswords != null : !((Object)this$oldPasswords).equals(other$oldPasswords)) {
            return false;
        }
        String this$email = this.getEmail();
        String other$email = other.getEmail();
        if (this$email == null ? other$email != null : !this$email.equals(other$email)) {
            return false;
        }
        String this$firstname = this.getFirstname();
        String other$firstname = other.getFirstname();
        if (this$firstname == null ? other$firstname != null : !this$firstname.equals(other$firstname)) {
            return false;
        }
        String this$identifier = this.getIdentifier();
        String other$identifier = other.getIdentifier();
        if (this$identifier == null ? other$identifier != null : !this$identifier.equals(other$identifier)) {
            return false;
        }
        String this$lastname = this.getLastname();
        String other$lastname = other.getLastname();
        if (this$lastname == null ? other$lastname != null : !this$lastname.equals(other$lastname)) {
            return false;
        }
        String this$language = this.getLanguage();
        String other$language = other.getLanguage();
        if (this$language == null ? other$language != null : !this$language.equals(other$language)) {
            return false;
        }
        String this$phone = this.getPhone();
        String other$phone = other.getPhone();
        if (this$phone == null ? other$phone != null : !this$phone.equals(other$phone)) {
            return false;
        }
        String this$mobile = this.getMobile();
        String other$mobile = other.getMobile();
        if (this$mobile == null ? other$mobile != null : !this$mobile.equals(other$mobile)) {
            return false;
        }
        String this$groupId = this.getGroupId();
        String other$groupId = other.getGroupId();
        if (this$groupId == null ? other$groupId != null : !this$groupId.equals(other$groupId)) {
            return false;
        }
        OffsetDateTime this$lastConnection = this.getLastConnection();
        OffsetDateTime other$lastConnection = other.getLastConnection();
        if (this$lastConnection == null ? other$lastConnection != null : !((Object)this$lastConnection).equals(other$lastConnection)) {
            return false;
        }
        UserStatusEnum this$status = this.getStatus();
        UserStatusEnum other$status = other.getStatus();
        if (this$status == null ? other$status != null : !this$status.equals(other$status)) {
            return false;
        }
        UserTypeEnum this$type = this.getType();
        UserTypeEnum other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        String this$level = this.getLevel();
        String other$level = other.getLevel();
        if (this$level == null ? other$level != null : !this$level.equals(other$level)) {
            return false;
        }
        OffsetDateTime this$passwordExpirationDate = this.getPasswordExpirationDate();
        OffsetDateTime other$passwordExpirationDate = other.getPasswordExpirationDate();
        if (this$passwordExpirationDate == null ? other$passwordExpirationDate != null : !((Object)this$passwordExpirationDate).equals(other$passwordExpirationDate)) {
            return false;
        }
        Address this$address = this.getAddress();
        Address other$address = other.getAddress();
        if (this$address == null ? other$address != null : !this$address.equals(other$address)) {
            return false;
        }
        OffsetDateTime this$disablingDate = this.getDisablingDate();
        OffsetDateTime other$disablingDate = other.getDisablingDate();
        if (this$disablingDate == null ? other$disablingDate != null : !((Object)this$disablingDate).equals(other$disablingDate)) {
            return false;
        }
        String this$internalCode = this.getInternalCode();
        String other$internalCode = other.getInternalCode();
        if (this$internalCode == null ? other$internalCode != null : !this$internalCode.equals(other$internalCode)) {
            return false;
        }
        OffsetDateTime this$removingDate = this.getRemovingDate();
        OffsetDateTime other$removingDate = other.getRemovingDate();
        if (this$removingDate == null ? other$removingDate != null : !((Object)this$removingDate).equals(other$removingDate)) {
            return false;
        }
        String this$siteCode = this.getSiteCode();
        String other$siteCode = other.getSiteCode();
        if (this$siteCode == null ? other$siteCode != null : !this$siteCode.equals(other$siteCode)) {
            return false;
        }
        List this$centerCodes = this.getCenterCodes();
        List other$centerCodes = other.getCenterCodes();
        if (this$centerCodes == null ? other$centerCodes != null : !((Object)this$centerCodes).equals(other$centerCodes)) {
            return false;
        }
        Analytics this$analytics = this.getAnalytics();
        Analytics other$analytics = other.getAnalytics();
        if (this$analytics == null ? other$analytics != null : !this$analytics.equals(other$analytics)) {
            return false;
        }
        String this$userInfoId = this.getUserInfoId();
        String other$userInfoId = other.getUserInfoId();
        return !(this$userInfoId == null ? other$userInfoId != null : !this$userInfoId.equals(other$userInfoId));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof User;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.isOtp() ? 79 : 97);
        result = result * 59 + (this.isSubrogeable() ? 79 : 97);
        result = result * 59 + this.getNbFailedAttempts();
        result = result * 59 + (this.isReadonly() ? 79 : 97);
        result = result * 59 + (this.isAutoProvisioningEnabled() ? 79 : 97);
        String $password = this.getPassword();
        result = result * 59 + ($password == null ? 43 : $password.hashCode());
        List $oldPasswords = this.getOldPasswords();
        result = result * 59 + ($oldPasswords == null ? 43 : ((Object)$oldPasswords).hashCode());
        String $email = this.getEmail();
        result = result * 59 + ($email == null ? 43 : $email.hashCode());
        String $firstname = this.getFirstname();
        result = result * 59 + ($firstname == null ? 43 : $firstname.hashCode());
        String $identifier = this.getIdentifier();
        result = result * 59 + ($identifier == null ? 43 : $identifier.hashCode());
        String $lastname = this.getLastname();
        result = result * 59 + ($lastname == null ? 43 : $lastname.hashCode());
        String $language = this.getLanguage();
        result = result * 59 + ($language == null ? 43 : $language.hashCode());
        String $phone = this.getPhone();
        result = result * 59 + ($phone == null ? 43 : $phone.hashCode());
        String $mobile = this.getMobile();
        result = result * 59 + ($mobile == null ? 43 : $mobile.hashCode());
        String $groupId = this.getGroupId();
        result = result * 59 + ($groupId == null ? 43 : $groupId.hashCode());
        OffsetDateTime $lastConnection = this.getLastConnection();
        result = result * 59 + ($lastConnection == null ? 43 : ((Object)$lastConnection).hashCode());
        UserStatusEnum $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : $status.hashCode());
        UserTypeEnum $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        String $level = this.getLevel();
        result = result * 59 + ($level == null ? 43 : $level.hashCode());
        OffsetDateTime $passwordExpirationDate = this.getPasswordExpirationDate();
        result = result * 59 + ($passwordExpirationDate == null ? 43 : ((Object)$passwordExpirationDate).hashCode());
        Address $address = this.getAddress();
        result = result * 59 + ($address == null ? 43 : $address.hashCode());
        OffsetDateTime $disablingDate = this.getDisablingDate();
        result = result * 59 + ($disablingDate == null ? 43 : ((Object)$disablingDate).hashCode());
        String $internalCode = this.getInternalCode();
        result = result * 59 + ($internalCode == null ? 43 : $internalCode.hashCode());
        OffsetDateTime $removingDate = this.getRemovingDate();
        result = result * 59 + ($removingDate == null ? 43 : ((Object)$removingDate).hashCode());
        String $siteCode = this.getSiteCode();
        result = result * 59 + ($siteCode == null ? 43 : $siteCode.hashCode());
        List $centerCodes = this.getCenterCodes();
        result = result * 59 + ($centerCodes == null ? 43 : ((Object)$centerCodes).hashCode());
        Analytics $analytics = this.getAnalytics();
        result = result * 59 + ($analytics == null ? 43 : $analytics.hashCode());
        String $userInfoId = this.getUserInfoId();
        result = result * 59 + ($userInfoId == null ? 43 : $userInfoId.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "User(super=" + super.toString() + ", email=" + this.getEmail() + ", firstname=" + this.getFirstname() + ", identifier=" + this.getIdentifier() + ", otp=" + this.isOtp() + ", subrogeable=" + this.isSubrogeable() + ", lastname=" + this.getLastname() + ", language=" + this.getLanguage() + ", phone=" + this.getPhone() + ", mobile=" + this.getMobile() + ", groupId=" + this.getGroupId() + ", lastConnection=" + String.valueOf(this.getLastConnection()) + ", nbFailedAttempts=" + this.getNbFailedAttempts() + ", status=" + String.valueOf(this.getStatus()) + ", type=" + String.valueOf(this.getType()) + ", readonly=" + this.isReadonly() + ", level=" + this.getLevel() + ", passwordExpirationDate=" + String.valueOf(this.getPasswordExpirationDate()) + ", address=" + String.valueOf(this.getAddress()) + ", disablingDate=" + String.valueOf(this.getDisablingDate()) + ", internalCode=" + this.getInternalCode() + ", removingDate=" + String.valueOf(this.getRemovingDate()) + ", siteCode=" + this.getSiteCode() + ", centerCodes=" + String.valueOf(this.getCenterCodes()) + ", analytics=" + String.valueOf(this.getAnalytics()) + ", autoProvisioningEnabled=" + this.isAutoProvisioningEnabled() + ", userInfoId=" + this.getUserInfoId() + ")";
    }

    @Generated
    public boolean isReadonly() {
        return this.readonly;
    }
}

