/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitamui.iam.server.tenant.service;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import fr.gouv.vitam.common.client.VitamContext;
import fr.gouv.vitam.common.exception.VitamClientException;
import fr.gouv.vitamui.commons.api.converter.Converter;
import fr.gouv.vitamui.commons.api.domain.BaseIdDocument;
import fr.gouv.vitamui.commons.api.domain.Criterion;
import fr.gouv.vitamui.commons.api.domain.CriterionOperator;
import fr.gouv.vitamui.commons.api.domain.ExternalParametersDto;
import fr.gouv.vitamui.commons.api.domain.GroupDto;
import fr.gouv.vitamui.commons.api.domain.IdDto;
import fr.gouv.vitamui.commons.api.domain.OwnerDto;
import fr.gouv.vitamui.commons.api.domain.QueryDto;
import fr.gouv.vitamui.commons.api.domain.TenantDto;
import fr.gouv.vitamui.commons.api.domain.UserDto;
import fr.gouv.vitamui.commons.api.domain.VitamConfigurationDto;
import fr.gouv.vitamui.commons.api.exception.ApplicationServerException;
import fr.gouv.vitamui.commons.api.exception.InternalServerException;
import fr.gouv.vitamui.commons.api.exception.NoRightsException;
import fr.gouv.vitamui.commons.api.exception.NotFoundException;
import fr.gouv.vitamui.commons.api.exception.NotImplementedException;
import fr.gouv.vitamui.commons.api.utils.CastUtils;
import fr.gouv.vitamui.commons.logbook.dto.EventDiffDto;
import fr.gouv.vitamui.commons.mongo.service.SequenceGeneratorService;
import fr.gouv.vitamui.commons.utils.JsonUtils;
import fr.gouv.vitamui.commons.vitam.api.access.LogbookService;
import fr.gouv.vitamui.commons.vitam.api.administration.ConfigurationService;
import fr.gouv.vitamui.commons.vitam.api.dto.LogbookOperationsCommonResponseDto;
import fr.gouv.vitamui.iam.common.enums.Application;
import fr.gouv.vitamui.iam.security.service.SecurityService;
import fr.gouv.vitamui.iam.server.common.ApiIamConstants;
import fr.gouv.vitamui.iam.server.common.utils.EntityFactory;
import fr.gouv.vitamui.iam.server.customer.config.CustomerInitConfig;
import fr.gouv.vitamui.iam.server.customer.dao.CustomerRepository;
import fr.gouv.vitamui.iam.server.customer.domain.Customer;
import fr.gouv.vitamui.iam.server.externalParameters.dao.ExternalParametersRepository;
import fr.gouv.vitamui.iam.server.externalParameters.domain.ExternalParameters;
import fr.gouv.vitamui.iam.server.externalParameters.service.ExternalParametersService;
import fr.gouv.vitamui.iam.server.group.service.GroupService;
import fr.gouv.vitamui.iam.server.logbook.service.IamLogbookService;
import fr.gouv.vitamui.iam.server.owner.dao.OwnerRepository;
import fr.gouv.vitamui.iam.server.owner.domain.Owner;
import fr.gouv.vitamui.iam.server.owner.service.OwnerService;
import fr.gouv.vitamui.iam.server.profile.dao.ProfileRepository;
import fr.gouv.vitamui.iam.server.profile.domain.Profile;
import fr.gouv.vitamui.iam.server.security.AbstractResourceClientService;
import fr.gouv.vitamui.iam.server.tenant.converter.TenantConverter;
import fr.gouv.vitamui.iam.server.tenant.dao.TenantRepository;
import fr.gouv.vitamui.iam.server.tenant.domain.Tenant;
import fr.gouv.vitamui.iam.server.tenant.service.InitVitamTenantService;
import fr.gouv.vitamui.iam.server.tenant.service.TenantService;
import fr.gouv.vitamui.iam.server.user.service.UserService;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

public class TenantService
extends AbstractResourceClientService<TenantDto, Tenant> {
    private static final Logger LOGGER = LoggerFactory.getLogger(TenantService.class);
    private final String TENANT_INSUFFICIENT_PERMISSION_MESSAGE = "Unable to access to the tenant %s: insufficient permissions.";
    private final TenantRepository tenantRepository;
    private final CustomerRepository customerRepository;
    private final OwnerRepository ownerRepository;
    private final ProfileRepository profileRepository;
    private final GroupService groupService;
    private final UserService userService;
    private final OwnerService ownerService;
    private final SecurityService securityService;
    private final IamLogbookService iamLogbookService;
    private final TenantConverter tenantConverter;
    private final InitVitamTenantService initVitamTenantService;
    private final LogbookService logbookService;
    private final CustomerInitConfig customerInitConfig;
    private final ExternalParametersRepository externalParametersRepository;
    private final ExternalParametersService externalParametersService;
    private final ConfigurationService configurationService;

    @Autowired
    public TenantService(SequenceGeneratorService sequenceGeneratorService, TenantRepository tenantRepository, CustomerRepository customerRepository, OwnerRepository ownerRepository, ProfileRepository profileRepository, GroupService groupService, UserService userService, OwnerService ownerService, SecurityService securityService, IamLogbookService iamLogbookService, TenantConverter tenantConverter, InitVitamTenantService initVitamTenantService, LogbookService logbookService, CustomerInitConfig customerInitConfig, ExternalParametersRepository externalParametersRepository, ExternalParametersService externalParametersService, ConfigurationService configurationService) {
        super(sequenceGeneratorService, securityService);
        this.tenantRepository = tenantRepository;
        this.customerRepository = customerRepository;
        this.ownerRepository = ownerRepository;
        this.profileRepository = profileRepository;
        this.groupService = groupService;
        this.userService = userService;
        this.ownerService = ownerService;
        this.securityService = securityService;
        this.iamLogbookService = iamLogbookService;
        this.tenantConverter = tenantConverter;
        this.initVitamTenantService = initVitamTenantService;
        this.logbookService = logbookService;
        this.customerInitConfig = customerInitConfig;
        this.externalParametersRepository = externalParametersRepository;
        this.externalParametersService = externalParametersService;
        this.configurationService = configurationService;
    }

    public List<Profile> getDefaultProfiles(String customerId, Integer tenantIdentifier) {
        ArrayList<Profile> profiles = new ArrayList<Profile>();
        profiles.add(EntityFactory.buildProfile((String)("Hierarchy Profiles " + tenantIdentifier), (String)this.getNextSequenceId("profileIdentifier"), (String)"Profil de l'application de gestion des hi\u00e9rarchies de profils", (boolean)true, (String)"", (Integer)tenantIdentifier, (String)"HIERARCHY_PROFILE_APP", (List)ApiIamConstants.getHierarchyRoles(), (String)customerId));
        if (this.customerInitConfig.getTenantProfiles() != null) {
            this.customerInitConfig.getTenantProfiles().forEach(p -> profiles.add(EntityFactory.buildProfile((String)(p.getName() + " " + tenantIdentifier), (String)this.getNextSequenceId("profileIdentifier"), (String)p.getDescription(), (boolean)true, (String)p.getLevel(), (Integer)tenantIdentifier, (String)p.getAppName(), (List)p.getRoles(), (String)customerId)));
        }
        return profiles;
    }

    protected void beforeCreate(TenantDto tenantDto) {
        String message = "Unable to create tenant " + tenantDto.getName();
        Customer customer = this.checkCustomer(tenantDto.getCustomerId(), message);
        this.checkIdentifier(tenantDto.getIdentifier(), message);
        this.checkOwner(tenantDto, message);
        this.checkProof(tenantDto.isProof(), tenantDto.getCustomerId(), message);
        this.checkIfTenantIdIsAvailable(tenantDto.getIdentifier());
        if (!tenantDto.isProof()) {
            this.checkSetReadonly(tenantDto.isReadonly(), message);
        }
        ExternalParametersDto fullAccessContract = this.initFullAccessContractExternalParameter(customer.getIdentifier(), tenantDto.getName());
        LOGGER.debug("Initializing VITAM Tenant with customer identifier {} and tenant name {}", (Object)customer.getIdentifier(), (Object)tenantDto.getName());
        this.initVitamTenantService.init(tenantDto, fullAccessContract);
        fullAccessContract.setName("DEFAULT_EXT_PARAM_" + tenantDto.getIdentifier());
        this.externalParametersService.create(fullAccessContract);
        String name = tenantDto.getName() != null ? tenantDto.getName().trim() : tenantDto.getName();
        List tenants = this.tenantRepository.findByNameIgnoreCaseAndCustomerId(name, tenantDto.getCustomerId());
        Assert.isTrue((tenants == null || tenants.isEmpty() ? 1 : 0) != 0, (String)(message + ": a tenant with the name: " + name + " already exists."));
    }

    @Transactional
    public TenantDto create(TenantDto tenantDto) {
        Optional customerOptional = this.customerRepository.findById((Object)tenantDto.getCustomerId());
        Assert.isTrue((boolean)customerOptional.isPresent(), (String)("No customer found with id " + tenantDto.getCustomerId()));
        Customer customer = (Customer)customerOptional.get();
        TenantDto createdTenantDto = (TenantDto)super.create((IdDto)tenantDto);
        Optional fullAccessContractOpt = this.externalParametersRepository.findByIdentifier("DEFAULT_EXT_PARAM_" + customer.getIdentifier() + "_" + tenantDto.getName());
        Assert.isTrue((boolean)fullAccessContractOpt.isPresent(), (String)("No external parameter found with id DEFAULT_EXT_PARAM_" + customer.getIdentifier() + "_" + tenantDto.getName()));
        this.createExternalParameterProfileForDefaultAccessContract(tenantDto.getCustomerId(), tenantDto.getIdentifier(), ((ExternalParameters)fullAccessContractOpt.get()).getId());
        this.iamLogbookService.createTenantEvent(createdTenantDto);
        List profiles = this.getDefaultProfiles(createdTenantDto.getCustomerId(), createdTenantDto.getIdentifier());
        profiles.forEach(profile -> this.saveProfile(profile));
        this.addAdminProfilesToAdminGroup(createdTenantDto.getCustomerId(), profiles);
        return createdTenantDto;
    }

    protected void beforeUpdate(TenantDto tenantDto) {
        Tenant tenant = this.findById(tenantDto.getId());
        String message = "Unable to update tenant " + tenantDto.getId();
        this.checkCustomer(tenantDto.getCustomerId(), message);
        this.checkIsReadonly(tenant.isReadonly(), message);
        this.checkIdentifier(tenant.getIdentifier().intValue(), tenantDto.getIdentifier().intValue(), message);
        this.checkOwner(tenant, tenantDto.getOwnerId(), message);
        this.checkSetReadonly(tenantDto.isReadonly(), message);
        String name = tenantDto.getName() != null ? tenantDto.getName().trim() : tenantDto.getName();
        List tenants = this.tenantRepository.findByNameIgnoreCaseAndCustomerId(name, tenant.getCustomerId());
        if (tenants != null && !tenants.isEmpty()) {
            Assert.isTrue((tenants.size() == 1 && tenants.contains(tenant) ? 1 : 0) != 0, (String)(message + ": a tenant with the name: " + name + " already exists."));
        }
    }

    protected Tenant beforePatch(Map<String, Object> partialDto) {
        List tenants;
        String name;
        String ownerId;
        Boolean readonly;
        String id = CastUtils.toString((Object)partialDto.get("id"));
        String message = "Unable to patch tenant " + id;
        Tenant tenant = (Tenant)this.tenantRepository.findById((Object)id).orElseThrow(() -> new NotFoundException("Entity not found " + this.getObjectName() + " with id : " + id));
        Assert.isTrue((!this.checkMapContainsOnlyFieldsUnmodifiable(partialDto, Arrays.asList("id", "customerId", "readonly", "identifier", "proof")) ? 1 : 0) != 0, (String)message);
        String customerId = CastUtils.toString((Object)partialDto.get("customerId"));
        if (customerId != null) {
            this.checkCustomer(customerId, message);
        }
        this.checkIsReadonly(tenant.isReadonly(), message);
        Integer identifier = CastUtils.toInteger((Object)partialDto.get("identifier"));
        if (identifier != null) {
            this.checkIdentifier(tenant.getIdentifier().intValue(), identifier.intValue(), message);
        }
        if ((readonly = CastUtils.toBoolean((Object)partialDto.get("readonly"))) != null) {
            this.checkSetReadonly(readonly.booleanValue(), message);
        }
        if ((ownerId = CastUtils.toString((Object)partialDto.get("ownerId"))) != null) {
            this.checkOwner(tenant, ownerId, message);
        }
        if ((name = CastUtils.toString((Object)partialDto.get("name"))) != null && (tenants = this.tenantRepository.findByNameIgnoreCaseAndCustomerId(name.trim(), tenant.getCustomerId())) != null && !tenants.isEmpty()) {
            Assert.isTrue((tenants.size() == 1 && tenants.contains(tenant) ? 1 : 0) != 0, (String)(message + ": a tenant with the name: " + name + " already exists."));
        }
        return tenant;
    }

    @Transactional
    public TenantDto patch(Map<String, Object> partialDto) {
        return (TenantDto)super.patch(partialDto);
    }

    protected void processPatch(Tenant tenant, Map<String, Object> partialDto) {
        ArrayList<EventDiffDto> logbooks = new ArrayList<EventDiffDto>();
        VitamContext vitamContext = this.securityService.buildVitamContext(this.securityService.getTenantIdentifier());
        if (vitamContext != null) {
            LOGGER.info("Patch Tenant EvIdAppSession : {} ", (Object)vitamContext.getApplicationSessionId());
        }
        block24: for (Map.Entry<String, Object> entry : partialDto.entrySet()) {
            switch (entry.getKey()) {
                case "id": 
                case "readonly": 
                case "customerId": 
                case "identifier": 
                case "proof": {
                    continue block24;
                }
                case "name": {
                    logbooks.add(new EventDiffDto("Nom", (Object)tenant.getName(), entry.getValue()));
                    tenant.setName(CastUtils.toString((Object)entry.getValue()));
                    continue block24;
                }
                case "enabled": {
                    logbooks.add(new EventDiffDto("Activ\u00e9", (Object)tenant.getEnabled(), entry.getValue()));
                    tenant.setEnabled(CastUtils.toBoolean((Object)entry.getValue()));
                    continue block24;
                }
                case "ownerId": {
                    OwnerDto oldOwner = (OwnerDto)this.ownerService.getOne(tenant.getOwnerId(), Optional.empty());
                    OwnerDto newOwner = (OwnerDto)this.ownerService.getOne(CastUtils.toString((Object)entry.getValue()), Optional.empty());
                    logbooks.add(new EventDiffDto("Identifiant du propri\u00e9taire", (Object)oldOwner.getIdentifier(), (Object)newOwner.getIdentifier()));
                    tenant.setOwnerId(CastUtils.toString((Object)entry.getValue()));
                    continue block24;
                }
                case "accessContractHoldingIdentifier": {
                    String accessContractHoldingIdentifier = CastUtils.toString((Object)entry.getValue());
                    logbooks.add(new EventDiffDto("Identifiant du contrat d'acc\u00e8s pour l'arbre", (Object)tenant.getAccessContractHoldingIdentifier(), (Object)accessContractHoldingIdentifier));
                    tenant.setAccessContractHoldingIdentifier(accessContractHoldingIdentifier);
                    continue block24;
                }
                case "accessContractLogbookIdentifier": {
                    String accessContractLogbookIdentifier = CastUtils.toString((Object)entry.getValue());
                    logbooks.add(new EventDiffDto("Identifiant du contrat d'acc\u00e8s pour le logbook", (Object)tenant.getAccessContractLogbookIdentifier(), (Object)accessContractLogbookIdentifier));
                    tenant.setAccessContractLogbookIdentifier(accessContractLogbookIdentifier);
                    continue block24;
                }
                case "ingestContractHoldingIdentifier": {
                    String ingestContractHoldingIdentifier = CastUtils.toString((Object)entry.getValue());
                    logbooks.add(new EventDiffDto("Identifiant du contrat d'entr\u00e9e pour l'arbre", (Object)tenant.getIngestContractHoldingIdentifier(), (Object)ingestContractHoldingIdentifier));
                    tenant.setIngestContractHoldingIdentifier(ingestContractHoldingIdentifier);
                    continue block24;
                }
                case "itemIngestContractIdentifier": {
                    String itemIngestContractIdentifier = CastUtils.toString((Object)entry.getValue());
                    logbooks.add(new EventDiffDto("Identifiant du contrat d'entr\u00e9e pour les bordereaux", (Object)tenant.getItemIngestContractIdentifier(), (Object)itemIngestContractIdentifier));
                    tenant.setItemIngestContractIdentifier(itemIngestContractIdentifier);
                    continue block24;
                }
            }
            throw new IllegalArgumentException("Unable to patch tenant " + tenant.getId() + ": key " + entry.getKey() + " is not allowed");
        }
        this.iamLogbookService.updateTenantEvent(tenant, logbooks);
    }

    private void checkIsReadonly(boolean readonly, String message) {
        Assert.isTrue((!readonly ? 1 : 0) != 0, (String)(message + ": readonly tenant"));
    }

    private void checkIdentifier(int identifier1, int identifier2, String message) {
        Assert.isTrue((identifier1 == identifier2 ? 1 : 0) != 0, (String)(message + ": tenant identifiers " + identifier1 + " and " + identifier2 + " are not equals"));
    }

    private void checkProof(boolean isProof, String customerId, String message) {
        if (isProof) {
            Optional optTenant = this.tenantRepository.findByCustomerIdAndProofIsTrue(customerId);
            Assert.isTrue((boolean)optTenant.isEmpty(), (String)(message + ": a proof tenant already exists for customerId: " + customerId));
        }
    }

    private void checkIdentifier(Integer identifier, String message) {
        if (identifier != null) {
            Tenant tenant = this.tenantRepository.findByIdentifier(identifier);
            Assert.isNull((Object)tenant, (String)(message + ": a tenant with the identifier: " + identifier + " already exists."));
        }
    }

    private Customer checkCustomer(String customerId, String message) {
        Optional customer = this.customerRepository.findById((Object)customerId);
        Assert.isTrue((boolean)customer.isPresent(), (String)(message + ": customer does not exist"));
        return (Customer)customer.get();
    }

    private void checkSetReadonly(boolean readonly, String message) {
        Assert.isTrue((!readonly ? 1 : 0) != 0, (String)(message + ": readonly must be set to false"));
    }

    private void checkOwner(TenantDto tenantDto, String message) {
        Optional optOwner = this.ownerRepository.findById((Object)tenantDto.getOwnerId());
        Assert.isTrue((boolean)optOwner.isPresent(), (String)(message + ": owner " + tenantDto.getOwnerId() + " does not exist"));
        String ownerCustId = ((Owner)optOwner.get()).getCustomerId();
        String tenantCustId = ((Owner)optOwner.get()).getCustomerId();
        Assert.isTrue((boolean)StringUtils.equals((CharSequence)ownerCustId, (CharSequence)tenantCustId), (String)(message + " owner.customerId " + ownerCustId + " and tenant.customerId " + tenantCustId + " must be equals"));
    }

    private void checkOwner(Tenant tenant, String ownerId, String message) {
        Optional optOwner = this.ownerRepository.findById((Object)ownerId);
        Assert.isTrue((boolean)optOwner.isPresent(), (String)(message + ": owner " + ownerId + " does not exist"));
        String ownerCustId = ((Owner)optOwner.get()).getCustomerId();
        String tenantCustId = tenant.getCustomerId();
        Assert.isTrue((boolean)StringUtils.equals((CharSequence)ownerCustId, (CharSequence)tenantCustId), (String)(message + " owner.customerId " + ownerCustId + " and tenant.customerId " + tenantCustId + " must be equals"));
    }

    public TenantDto findByIdentifier(Integer identifier) {
        return (TenantDto)this.convertFromEntityToDto((BaseIdDocument)this.tenantRepository.findByIdentifier(identifier));
    }

    public List<TenantDto> findByCustomerId(String customerId) {
        return this.convertIterableToList((Iterable)this.tenantRepository.findByCustomerId(customerId));
    }

    protected Tenant findById(String id) {
        return (Tenant)this.tenantRepository.findById((Object)id).orElseThrow(() -> new NotFoundException("Entity not found " + this.getObjectName() + " with id : " + id));
    }

    private Profile saveProfile(Profile profile) {
        profile.setId(this.profileRepository.generateSuperId());
        profile.setIdentifier(this.getNextSequenceId("profileIdentifier"));
        this.iamLogbookService.createProfileEvent(profile);
        return (Profile)this.profileRepository.save((Object)profile);
    }

    private void addAdminProfilesToAdminGroup(String customerId, List<Profile> profiles) {
        String[] apps = new String[]{"HIERARCHY_PROFILE_APP"};
        UserDto adminUserDto = this.userService.getDefaultAdminUser(customerId);
        GroupDto adminGroupDto = this.groupService.getOne(adminUserDto.getGroupId(), Optional.empty(), Optional.empty());
        for (String app : apps) {
            Profile profile = profiles.stream().filter(p -> app.equals(p.getApplicationName())).findFirst().orElseThrow(() -> new ApplicationServerException("Profile not found for app %s and customer %s.".formatted(app, customerId)));
            adminGroupDto.getProfileIds().add(profile.getId());
        }
        this.groupService.updateProfilesById(adminGroupDto.getId(), adminGroupDto.getProfileIds());
    }

    public LogbookOperationsCommonResponseDto findHistoryById(String id) throws VitamClientException {
        LOGGER.debug("findHistoryById for id" + id);
        Integer tenantIdentifier = this.securityService.getTenantIdentifier();
        VitamContext vitamContext = new VitamContext(tenantIdentifier).setAccessContract(this.securityService.getTenant(tenantIdentifier).getAccessContractLogbookIdentifier()).setApplicationSessionId(this.securityService.getApplicationId());
        Optional tenant = this.getRepository().findById((Object)id);
        tenant.orElseThrow(() -> new NotFoundException("No tenant found with id : %s".formatted(id)));
        LOGGER.info("Tenant History EvIdAppSession : {} ", (Object)this.securityService.buildVitamContext(this.securityService.getTenantIdentifier()).getApplicationSessionId());
        JsonNode body = this.logbookService.findEventsByIdentifierAndCollectionNames(String.valueOf(((Tenant)tenant.get()).getIdentifier()), "tenants", vitamContext).toJsonNode();
        try {
            return (LogbookOperationsCommonResponseDto)JsonUtils.treeToValue((JsonNode)body, LogbookOperationsCommonResponseDto.class, (boolean)false);
        }
        catch (JsonProcessingException e) {
            throw new InternalServerException("Error while parsing Vitam response", (Throwable)e);
        }
    }

    protected TenantRepository getRepository() {
        return this.tenantRepository;
    }

    protected String getObjectName() {
        return "tenant";
    }

    protected Class<Tenant> getEntityClass() {
        return Tenant.class;
    }

    protected Converter<TenantDto, Tenant> getConverter() {
        return this.tenantConverter;
    }

    private Profile createExternalParameterProfileForDefaultAccessContract(String customerId, Integer tenantIdentifier, String externalParameterId) {
        Profile defaultAccessContractProfile = EntityFactory.buildProfile((String)("Profil pour la gestion des param\u00e9trages externes du tenant  " + tenantIdentifier), (String)String.valueOf(this.sequenceGeneratorService.getNextSequenceId("profileIdentifier", 1)), (String)("Profil pour la gestion des param\u00e9trages externes du tenant  " + tenantIdentifier), (boolean)true, (String)"", (Integer)tenantIdentifier, (String)Application.EXTERNAL_PARAMS.name(), List.of("ROLE_GET_EXTERNAL_PARAMS"), (String)customerId, (String)externalParameterId);
        return this.saveProfile(defaultAccessContractProfile);
    }

    private ExternalParametersDto initFullAccessContractExternalParameter(String customerIdentifier, String tenantName) {
        ExternalParametersDto fullAccessContract = new ExternalParametersDto();
        fullAccessContract.setIdentifier("DEFAULT_EXT_PARAM_" + customerIdentifier + "_" + tenantName);
        fullAccessContract.setName("Liste des param\u00e9trages externes du tenant " + customerIdentifier + "_" + tenantName);
        return fullAccessContract;
    }

    public List<Integer> extractUnusedTenants(List<Integer> currentTenants, List<Integer> availableTenants) {
        ArrayList<Integer> copyList = new ArrayList<Integer>(availableTenants);
        copyList.removeAll(currentTenants);
        return copyList;
    }

    public List<Integer> getAvailableTenantsIds() {
        LOGGER.debug("Retrieve free tenant list ");
        VitamConfigurationDto vitamConfigurationDto = this.configurationService.getVitamPublicConfigurations();
        List tenantsList = vitamConfigurationDto.getTenants();
        List currentUsedTenants = this.getAll(Optional.empty());
        ArrayList<Integer> tenantCouldNotUse = new ArrayList<Integer>(vitamConfigurationDto.getAdminTenant());
        tenantCouldNotUse.addAll(currentUsedTenants.stream().map(TenantDto::getIdentifier).toList());
        return this.extractUnusedTenants(tenantCouldNotUse, tenantsList);
    }

    public void checkIfTenantIdIsAvailable(Integer tenantId) {
        List availableTenantsId = this.getAvailableTenantsIds();
        Assert.isTrue((CollectionUtils.isNotEmpty((Collection)availableTenantsId) && availableTenantsId.contains(tenantId) ? 1 : 0) != 0, (String)("The tenant " + tenantId + ": is already used "));
    }

    protected boolean canAccessToCustomer(String customerId) {
        return this.securityService.hasRole("ROLE_UPDATE_TENANTS_ALL_CUSTOMERS") || customerId.equals(this.securityService.getCustomerId());
    }

    protected boolean canAccessToTenant(Integer tenantIdentifier) {
        if (!this.securityService.hasRole("ROLE_GET_ALL_TENANTS")) {
            Integer securityTenantIdentifier = this.securityService.getTenantIdentifier();
            return Objects.equals(securityTenantIdentifier, tenantIdentifier);
        }
        return true;
    }

    protected Collection<String> getAllowedKeys() {
        return List.of("id", "customerId", "enabled", "proof", "name", "identifier", "ownerId");
    }

    protected Collection<String> getRestrictedKeys() {
        ArrayList<String> restrictedKeys = new ArrayList<String>();
        if (!this.securityService.hasRole("ROLE_GET_ALL_TENANTS")) {
            restrictedKeys.add("customerId");
            if (!this.securityService.hasRole("ROLE_GET_TENANTS_MY_CUSTOMER")) {
                restrictedKeys.add("identifier");
            }
        }
        return restrictedKeys;
    }

    protected void checkCustomerCriteria(Criterion customerCriteria) {
        Assert.isTrue((boolean)this.canAccessToCustomer(CastUtils.toString((Object)customerCriteria.getValue())), (String)"customerId's criteria is not equal to the customerId from context");
    }

    protected void addRestriction(String key, QueryDto criteria) {
        switch (key) {
            case "identifier": {
                Optional criterionOpt = criteria.find("identifier");
                if (criterionOpt.isPresent()) {
                    this.checkIdentifierCriteria((Criterion)criterionOpt.get());
                    break;
                }
                criteria.addCriterion(this.getIdentifierRestriction());
                break;
            }
            default: {
                throw new NotImplementedException("Restriction not defined for key: " + key);
            }
        }
    }

    private Criterion getIdentifierRestriction() {
        return new Criterion("identifier", (Object)this.securityService.getTenantIdentifier(), CriterionOperator.EQUALS);
    }

    protected void checkIdentifierCriteria(Criterion identifierCriterion) {
        ArrayList<Integer> identifiers = new ArrayList<Integer>();
        switch (1.$SwitchMap$fr$gouv$vitamui$commons$api$domain$CriterionOperator[identifierCriterion.getOperator().ordinal()]) {
            case 1: {
                identifiers.add(CastUtils.toInteger((Object)identifierCriterion.getValue()));
                break;
            }
            case 2: {
                identifiers.addAll(CastUtils.toList((Object)identifierCriterion.getValue()));
                break;
            }
            default: {
                throw new IllegalArgumentException("Operation " + String.valueOf(identifierCriterion.getOperator()) + " is not supported for field : identifier");
            }
        }
        List<Integer> wrongIdentifiers = identifiers.stream().filter(arg_0 -> this.canAccessToTenant(arg_0)).toList();
        if (!wrongIdentifiers.isEmpty()) {
            throw new NoRightsException("Unable to access to the tenant %s: insufficient permissions.".formatted(wrongIdentifiers.toString()));
        }
    }

    protected String getVersionApiCriteria() {
        return "v2";
    }

    @Generated
    public String getTENANT_INSUFFICIENT_PERMISSION_MESSAGE() {
        Objects.requireNonNull(this);
        return "Unable to access to the tenant %s: insufficient permissions.";
    }

    @Generated
    public TenantRepository getTenantRepository() {
        return this.tenantRepository;
    }

    @Generated
    public CustomerRepository getCustomerRepository() {
        return this.customerRepository;
    }

    @Generated
    public OwnerRepository getOwnerRepository() {
        return this.ownerRepository;
    }

    @Generated
    public ProfileRepository getProfileRepository() {
        return this.profileRepository;
    }

    @Generated
    public GroupService getGroupService() {
        return this.groupService;
    }

    @Generated
    public UserService getUserService() {
        return this.userService;
    }

    @Generated
    public OwnerService getOwnerService() {
        return this.ownerService;
    }

    @Generated
    public SecurityService getSecurityService() {
        return this.securityService;
    }

    @Generated
    public IamLogbookService getIamLogbookService() {
        return this.iamLogbookService;
    }

    @Generated
    public TenantConverter getTenantConverter() {
        return this.tenantConverter;
    }

    @Generated
    public InitVitamTenantService getInitVitamTenantService() {
        return this.initVitamTenantService;
    }

    @Generated
    public LogbookService getLogbookService() {
        return this.logbookService;
    }

    @Generated
    public CustomerInitConfig getCustomerInitConfig() {
        return this.customerInitConfig;
    }

    @Generated
    public ExternalParametersRepository getExternalParametersRepository() {
        return this.externalParametersRepository;
    }

    @Generated
    public ExternalParametersService getExternalParametersService() {
        return this.externalParametersService;
    }

    @Generated
    public ConfigurationService getConfigurationService() {
        return this.configurationService;
    }
}

