/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitamui.iam.server.tenant.service;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import fr.gouv.vitam.access.external.common.exception.AccessExternalClientException;
import fr.gouv.vitam.common.client.VitamContext;
import fr.gouv.vitam.common.database.builder.request.single.Select;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.exception.VitamClientException;
import fr.gouv.vitam.common.model.RequestResponse;
import fr.gouv.vitam.common.model.administration.AccessContractModel;
import fr.gouv.vitamui.commons.api.domain.ExternalParametersDto;
import fr.gouv.vitamui.commons.api.domain.IngestContractDto;
import fr.gouv.vitamui.commons.api.domain.ParameterDto;
import fr.gouv.vitamui.commons.api.domain.TenantDto;
import fr.gouv.vitamui.commons.api.exception.ApplicationServerException;
import fr.gouv.vitamui.commons.vitam.api.administration.AccessContractCommonService;
import fr.gouv.vitamui.commons.vitam.api.administration.IngestContractCommonService;
import fr.gouv.vitamui.commons.vitam.api.dto.AccessContractResponseDto;
import fr.gouv.vitamui.commons.vitam.api.dto.IngestContractResponseDto;
import fr.gouv.vitamui.commons.vitam.api.util.VitamRestUtils;
import fr.gouv.vitamui.iam.security.service.SecurityService;
import fr.gouv.vitamui.iam.server.tenant.converter.TenantConverter;
import fr.gouv.vitamui.iam.server.tenant.domain.Tenant;
import jakarta.annotation.PostConstruct;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.io.Resource;

public class InitVitamTenantService {
    public static final String PARAM_ACCESS_CONTRACT_NAME = "PARAM_ACCESS_CONTRACT";
    private final AccessContractCommonService accessContractCommonService;
    private final IngestContractCommonService ingestContractCommonService;
    private final SecurityService securityService;
    private final TenantConverter tenantConverter;
    private ObjectMapper objectMapper;
    @Value(value="classpath:data/tenant/ingest-contract/holding.json")
    private Resource holdingIngestContract;
    @Value(value="classpath:data/tenant/ingest-contract/items.json")
    private Resource itemsIngestContract;
    @Value(value="classpath:data/tenant/access-contract/full-access.json")
    private Resource fullAccessAccessContract;
    @Value(value="classpath:data/tenant/access-contract/logbook.json")
    private Resource logbookAccessContract;
    @Value(value="classpath:data/tenant/access-contract/holding.json")
    private Resource holdingAccessContract;
    @Value(value="${vitam.tenant.init.mandatory:true}")
    private Boolean mandatory;
    private Map<String, Resource> contractResources;
    public static final String HOLDING_ACCESS_CONTRACT_NAME = "Contrat Acces Arbre";
    public static final String HOLDING_INGEST_CONTRACT_NAME = "Contrat Entree Arbre";
    public static final String ITEMS_INGEST_CONTRACT_NAME = "Contrat Entree Bordereaux";
    public static final String LOGBOOK_ACCESS_CONTRACT_NAME = "Contrat Acces Logbook";
    public static final String FULL_ACCESS_CONTRACT_NAME = "Contrat Acces Full";
    private static final String STATUS = "ACTIVE";
    private static final Logger LOGGER = LoggerFactory.getLogger(InitVitamTenantService.class);

    public InitVitamTenantService(AccessContractCommonService accessContractCommonService, IngestContractCommonService ingestContractCommonService, SecurityService securityService, TenantConverter tenantConverter) {
        this.accessContractCommonService = accessContractCommonService;
        this.ingestContractCommonService = ingestContractCommonService;
        this.securityService = securityService;
        this.tenantConverter = tenantConverter;
        this.objectMapper = new ObjectMapper();
        this.objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    }

    public Tenant init(Tenant tenant, ExternalParametersDto externalParametersDto) {
        TenantDto tenantDto = this.tenantConverter.convertEntityToDto(tenant);
        this.init(tenantDto, externalParametersDto);
        return this.tenantConverter.convertDtoToEntity(tenantDto);
    }

    @PostConstruct
    public void postConstruct() {
        LOGGER.debug("init vitam tenant is mandatory : {}", (Object)this.mandatory);
        this.contractResources = Map.of(HOLDING_ACCESS_CONTRACT_NAME, this.holdingAccessContract, HOLDING_INGEST_CONTRACT_NAME, this.holdingIngestContract, LOGBOOK_ACCESS_CONTRACT_NAME, this.logbookAccessContract, ITEMS_INGEST_CONTRACT_NAME, this.itemsIngestContract, FULL_ACCESS_CONTRACT_NAME, this.fullAccessAccessContract);
    }

    public void init(TenantDto tenantDto, ExternalParametersDto fullAccessContract) {
        if (!this.mandatory.booleanValue()) {
            return;
        }
        VitamContext vitamContext = new VitamContext(tenantDto.getIdentifier()).setApplicationSessionId(this.securityService.getApplicationId());
        try {
            this.initAccessContracts(tenantDto, fullAccessContract, vitamContext);
            this.initIngestContracts(tenantDto, vitamContext);
        }
        catch (AccessExternalClientException | InvalidParseOperationException | IOException e) {
            LOGGER.error("Exception during initialization of tenant {}", (Object)tenantDto.getIdentifier(), (Object)e);
            throw new ApplicationServerException("Unable to init vitam tenant", e);
        }
    }

    private void initIngestContracts(TenantDto tenantDto, VitamContext vitamContext) throws InvalidParseOperationException, AccessExternalClientException, IOException {
        tenantDto.setIngestContractHoldingIdentifier(this.initIngestContract(HOLDING_INGEST_CONTRACT_NAME, tenantDto, vitamContext));
        tenantDto.setItemIngestContractIdentifier(this.initIngestContract(ITEMS_INGEST_CONTRACT_NAME, tenantDto, vitamContext));
    }

    private String initIngestContract(String ingestContractName, TenantDto tenantDto, VitamContext vitamContext) throws InvalidParseOperationException, AccessExternalClientException, IOException {
        try {
            Optional optIngestContract = this.retrieveIngestContractByName(vitamContext, ingestContractName);
            if (optIngestContract.isEmpty() || !StringUtils.equals((CharSequence)((IngestContractDto)optIngestContract.get()).getStatus(), (CharSequence)STATUS)) {
                RequestResponse responseIngestContract = this.ingestContractCommonService.createIngestContracts(vitamContext, ((Resource)this.contractResources.get(ingestContractName)).getInputStream());
                VitamRestUtils.checkResponse((RequestResponse)responseIngestContract, (Integer[])new Integer[]{200});
                optIngestContract = this.retrieveIngestContractByName(vitamContext, ingestContractName);
            }
            this.checkOptionalIsPresent(optIngestContract, "Unable to find ingest contract with name " + ingestContractName);
            return ((IngestContractDto)optIngestContract.get()).getIdentifier();
        }
        catch (VitamClientException e) {
            LOGGER.error("Exception during ingest contracts initialization for tenant {}", (Object)tenantDto.getIdentifier(), (Object)e);
            throw new ApplicationServerException((Throwable)e);
        }
    }

    private Optional<IngestContractDto> retrieveIngestContractByName(VitamContext vitamContext, String Name2) throws VitamClientException, JsonProcessingException {
        RequestResponse requestResponse = this.ingestContractCommonService.findIngestContracts(vitamContext, (JsonNode)new Select().getFinalSelect());
        IngestContractResponseDto ingestContractResponseDto = (IngestContractResponseDto)this.objectMapper.treeToValue((TreeNode)requestResponse.toJsonNode(), IngestContractResponseDto.class);
        return ingestContractResponseDto.getResults().stream().filter(i -> StringUtils.equals((CharSequence)i.getName(), (CharSequence)Name2) && StringUtils.equals((CharSequence)i.getStatus(), (CharSequence)STATUS)).findFirst();
    }

    private void initAccessContracts(TenantDto tenantDto, ExternalParametersDto fullAccessContract, VitamContext vitamContext) throws InvalidParseOperationException, AccessExternalClientException, IOException {
        tenantDto.setAccessContractHoldingIdentifier(this.initAccessContract(HOLDING_ACCESS_CONTRACT_NAME, tenantDto, vitamContext));
        tenantDto.setAccessContractLogbookIdentifier(this.initAccessContract(LOGBOOK_ACCESS_CONTRACT_NAME, tenantDto, vitamContext));
        String fullAccessContractCreated = this.initAccessContract(FULL_ACCESS_CONTRACT_NAME, tenantDto, vitamContext);
        LOGGER.info("fill full access contract created in VITAM{} ", (Object)fullAccessContractCreated);
        if (!StringUtils.isEmpty((CharSequence)fullAccessContractCreated)) {
            fullAccessContract.setParameters(List.of(new ParameterDto(PARAM_ACCESS_CONTRACT_NAME, fullAccessContractCreated)));
        }
    }

    private String initAccessContract(String accessContractName, TenantDto tenantDto, VitamContext vitamContext) throws InvalidParseOperationException, AccessExternalClientException, IOException {
        try {
            Optional accessContract = this.retrieveAccessContractByName(vitamContext, accessContractName);
            if (accessContract.isEmpty() || !StringUtils.equals((CharSequence)((AccessContractModel)accessContract.get()).getStatus().name(), (CharSequence)STATUS)) {
                RequestResponse responseAccessContract = this.accessContractCommonService.createAccessContracts(vitamContext, ((Resource)this.contractResources.get(accessContractName)).getInputStream());
                VitamRestUtils.checkResponse((RequestResponse)responseAccessContract, (Integer[])new Integer[]{200});
                accessContract = this.retrieveAccessContractByName(vitamContext, accessContractName);
            }
            this.checkOptionalIsPresent(accessContract, "Unable to find access contract with name " + accessContractName);
            return ((AccessContractModel)accessContract.get()).getIdentifier();
        }
        catch (VitamClientException e) {
            LOGGER.error("Exception during access contracts initialization for tenant {}", (Object)tenantDto.getIdentifier(), (Object)e);
            throw new ApplicationServerException((Throwable)e);
        }
    }

    private Optional<AccessContractModel> retrieveAccessContractByName(VitamContext vitamContext, String Name2) throws VitamClientException, JsonProcessingException {
        RequestResponse requestResponse = this.accessContractCommonService.findAccessContracts(vitamContext, (JsonNode)new Select().getFinalSelect());
        AccessContractResponseDto accessContractResponseDto = (AccessContractResponseDto)this.objectMapper.treeToValue((TreeNode)requestResponse.toJsonNode(), AccessContractResponseDto.class);
        return accessContractResponseDto.getResults().stream().filter(a -> StringUtils.equals((CharSequence)a.getName(), (CharSequence)Name2) && StringUtils.equals((CharSequence)a.getStatus().name(), (CharSequence)STATUS)).findFirst();
    }

    private void checkOptionalIsPresent(Optional<?> optional, String msg) {
        optional.orElseThrow(() -> new ApplicationServerException(msg));
    }

    @Generated
    public AccessContractCommonService getAccessContractCommonService() {
        return this.accessContractCommonService;
    }

    @Generated
    public IngestContractCommonService getIngestContractCommonService() {
        return this.ingestContractCommonService;
    }

    @Generated
    public SecurityService getSecurityService() {
        return this.securityService;
    }

    @Generated
    public TenantConverter getTenantConverter() {
        return this.tenantConverter;
    }

    @Generated
    public ObjectMapper getObjectMapper() {
        return this.objectMapper;
    }

    @Generated
    public Resource getHoldingIngestContract() {
        return this.holdingIngestContract;
    }

    @Generated
    public Resource getItemsIngestContract() {
        return this.itemsIngestContract;
    }

    @Generated
    public Resource getFullAccessAccessContract() {
        return this.fullAccessAccessContract;
    }

    @Generated
    public Resource getLogbookAccessContract() {
        return this.logbookAccessContract;
    }

    @Generated
    public Resource getHoldingAccessContract() {
        return this.holdingAccessContract;
    }

    @Generated
    public Boolean getMandatory() {
        return this.mandatory;
    }

    @Generated
    public Map<String, Resource> getContractResources() {
        return this.contractResources;
    }

    @Generated
    public void setObjectMapper(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    @Generated
    public void setHoldingIngestContract(Resource holdingIngestContract) {
        this.holdingIngestContract = holdingIngestContract;
    }

    @Generated
    public void setItemsIngestContract(Resource itemsIngestContract) {
        this.itemsIngestContract = itemsIngestContract;
    }

    @Generated
    public void setFullAccessAccessContract(Resource fullAccessAccessContract) {
        this.fullAccessAccessContract = fullAccessAccessContract;
    }

    @Generated
    public void setLogbookAccessContract(Resource logbookAccessContract) {
        this.logbookAccessContract = logbookAccessContract;
    }

    @Generated
    public void setHoldingAccessContract(Resource holdingAccessContract) {
        this.holdingAccessContract = holdingAccessContract;
    }

    @Generated
    public void setMandatory(Boolean mandatory) {
        this.mandatory = mandatory;
    }

    @Generated
    public void setContractResources(Map<String, Resource> contractResources) {
        this.contractResources = contractResources;
    }
}

