/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitamui.iam.server.subrogation.service;

import fr.gouv.vitamui.commons.api.converter.Converter;
import fr.gouv.vitamui.commons.api.domain.BaseIdDocument;
import fr.gouv.vitamui.commons.api.domain.CriterionOperator;
import fr.gouv.vitamui.commons.api.domain.DirectionDto;
import fr.gouv.vitamui.commons.api.domain.GroupDto;
import fr.gouv.vitamui.commons.api.domain.IdDto;
import fr.gouv.vitamui.commons.api.domain.PaginatedValuesDto;
import fr.gouv.vitamui.commons.api.domain.QueryDto;
import fr.gouv.vitamui.commons.api.domain.UserDto;
import fr.gouv.vitamui.commons.api.enums.UserStatusEnum;
import fr.gouv.vitamui.commons.api.enums.UserTypeEnum;
import fr.gouv.vitamui.commons.api.exception.ApplicationServerException;
import fr.gouv.vitamui.commons.logbook.common.EventType;
import fr.gouv.vitamui.commons.mongo.repository.VitamUIRepository;
import fr.gouv.vitamui.commons.mongo.service.SequenceGeneratorService;
import fr.gouv.vitamui.commons.security.client.dto.AuthUserDto;
import fr.gouv.vitamui.iam.common.dto.SubrogationDto;
import fr.gouv.vitamui.iam.common.enums.SubrogationStatusEnum;
import fr.gouv.vitamui.iam.security.service.SecurityService;
import fr.gouv.vitamui.iam.server.customer.dao.CustomerRepository;
import fr.gouv.vitamui.iam.server.customer.domain.Customer;
import fr.gouv.vitamui.iam.server.group.dao.GroupRepository;
import fr.gouv.vitamui.iam.server.group.service.GroupService;
import fr.gouv.vitamui.iam.server.logbook.service.IamLogbookService;
import fr.gouv.vitamui.iam.server.profile.dao.ProfileRepository;
import fr.gouv.vitamui.iam.server.security.AbstractResourceClientService;
import fr.gouv.vitamui.iam.server.subrogation.converter.SubrogationConverter;
import fr.gouv.vitamui.iam.server.subrogation.dao.SubrogationRepository;
import fr.gouv.vitamui.iam.server.subrogation.domain.Subrogation;
import fr.gouv.vitamui.iam.server.user.dao.UserRepository;
import fr.gouv.vitamui.iam.server.user.domain.User;
import fr.gouv.vitamui.iam.server.user.service.UserService;
import jakarta.validation.constraints.NotNull;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

public class SubrogationService
extends AbstractResourceClientService<SubrogationDto, Subrogation> {
    private SubrogationRepository subrogationRepository;
    private UserRepository userRepository;
    private UserService userService;
    private GroupService groupService;
    private GroupRepository groupRepository;
    private ProfileRepository profilRepository;
    private SecurityService securityService;
    private CustomerRepository customerRepository;
    private final SubrogationConverter subrogationConverter;
    private final IamLogbookService iamLogbookService;
    @Value(value="${subrogation.ttl}")
    @NotNull
    private Integer subrogationTtl;
    @Value(value="${generic.users.subrogation.ttl}")
    @NotNull
    private Integer genericUsersSubrogationTtl;

    @Autowired
    public SubrogationService(SequenceGeneratorService sequenceGeneratorService, SubrogationRepository subrogationRepository, UserRepository userRepository, UserService userService, GroupService groupService, GroupRepository groupRepository, ProfileRepository profilRepository, SecurityService securityService, CustomerRepository customerRepository, SubrogationConverter subrogationConverter, IamLogbookService iamLogbookService) {
        super(sequenceGeneratorService, securityService);
        this.subrogationRepository = subrogationRepository;
        this.userRepository = userRepository;
        this.userService = userService;
        this.groupService = groupService;
        this.groupRepository = groupRepository;
        this.profilRepository = profilRepository;
        this.securityService = securityService;
        this.customerRepository = customerRepository;
        this.subrogationConverter = subrogationConverter;
        this.iamLogbookService = iamLogbookService;
    }

    public SubrogationDto getMySubrogationAsSuperuser() {
        AuthUserDto user = this.securityService.getUser();
        return (SubrogationDto)this.internalConvertFromEntityToDto((BaseIdDocument)this.subrogationRepository.findOneBySuperUserAndSuperUserCustomerId(user.getEmail(), user.getCustomerId()));
    }

    public SubrogationDto getMySubrogationAsSurrogate() {
        AuthUserDto user = this.securityService.getUser();
        Optional optionalCustomer = this.customerRepository.findById((Object)user.getCustomerId());
        Assert.isTrue((boolean)optionalCustomer.isPresent(), (String)(" No customer found with id " + user.getCustomerId()));
        SubrogationDto subrogationDto = (SubrogationDto)this.convertFromEntityToDto((BaseIdDocument)this.subrogationRepository.findOneBySurrogateAndSurrogateCustomerId(user.getEmail(), user.getCustomerId()));
        if (subrogationDto != null) {
            subrogationDto.setSurrogateCustomerCode(((Customer)optionalCustomer.get()).getCode());
            subrogationDto.setSurrogateCustomerName(((Customer)optionalCustomer.get()).getName());
        }
        return subrogationDto;
    }

    protected void beforeCreate(SubrogationDto dto) {
        super.beforeCreate((IdDto)dto);
        Assert.isTrue((boolean)dto.getStatus().equals((Object)SubrogationStatusEnum.CREATED), (String)"the subrogation must have the status CREATED at the creation");
        this.checkUsers(dto);
        int ttlInMinutes = dto.getStatus().equals((Object)SubrogationStatusEnum.ACCEPTED) ? this.genericUsersSubrogationTtl.intValue() : this.subrogationTtl.intValue();
        Instant nowPlusXMinutes = Instant.now().plus((long)ttlInMinutes, ChronoUnit.MINUTES);
        dto.setDate(nowPlusXMinutes);
        this.checkSubrogationAlreadyExist(dto.getSurrogate(), dto.getSurrogateCustomerId());
        this.checkSubrogationWithSuperUserAlreadyExist(dto.getSuperUser(), dto.getSuperUserCustomerId());
    }

    private void checkSubrogationWithSuperUserAlreadyExist(String superUser, String customerId) {
        Subrogation subro = this.subrogationRepository.findOneBySuperUserAndSuperUserCustomerId(superUser, customerId);
        if (subro != null) {
            throw new IllegalArgumentException(subro.getSuperUser() + "(" + subro.getSuperUserCustomerId() + ") is already subrogating " + subro.getSurrogate() + "(" + subro.getSurrogateCustomerId() + ")");
        }
    }

    private void checkSubrogationAlreadyExist(String email, String customerId) {
        Subrogation subro = this.subrogationRepository.findOneBySurrogateAndSurrogateCustomerId(email, customerId);
        if (subro != null) {
            throw new IllegalArgumentException(subro.getSurrogate() + "(" + subro.getSurrogateCustomerId() + ") is already subrogated by " + subro.getSuperUser() + "(" + subro.getSuperUserCustomerId() + ")");
        }
    }

    protected void beforeUpdate(SubrogationDto dto) {
        this.checkUsers(dto);
    }

    private void checkUsers(SubrogationDto dto) {
        String emailSurrogate = dto.getSurrogate();
        String emailSuperUser = dto.getSuperUser();
        User surrogate = this.userRepository.findByEmailIgnoreCaseAndCustomerId(emailSurrogate, dto.getSurrogateCustomerId());
        User superUser = this.userRepository.findByEmailIgnoreCaseAndCustomerId(emailSuperUser, dto.getSuperUserCustomerId());
        Assert.isTrue((surrogate != null ? 1 : 0) != 0, (String)("No surrogate found with email : " + emailSurrogate));
        dto.setSurrogateCustomerId(surrogate.getCustomerId());
        Optional optCustomer = this.customerRepository.findById((Object)surrogate.getCustomerId());
        Customer surrogateCustomer = (Customer)optCustomer.orElseThrow(() -> new ApplicationServerException("Unable to check users : customer not found"));
        Assert.isTrue((boolean)surrogate.isSubrogeable(), (String)" User is not subrogeable");
        Assert.isTrue((boolean)surrogateCustomer.isSubrogeable(), (String)" Customer is not subrogeable");
        Assert.isTrue((boolean)surrogate.getStatus().equals((Object)UserStatusEnum.ENABLED), (String)"User status is not enabled");
        Assert.isTrue((superUser != null ? 1 : 0) != 0, (String)("No superUser found with email : " + emailSuperUser));
        dto.setSuperUserCustomerId(superUser.getCustomerId());
        Assert.isTrue((!surrogate.getId().equals(superUser.getId()) ? 1 : 0) != 0, (String)("Users cannot subrogate itself, email : " + emailSuperUser));
        AuthUserDto currentUser = this.securityService.getUser();
        Assert.isTrue((boolean)StringUtils.equals((CharSequence)emailSuperUser, (CharSequence)currentUser.getEmail()), (String)"Only super user can create subrogation");
        Assert.isTrue((boolean)StringUtils.equals((CharSequence)dto.getSuperUserCustomerId(), (CharSequence)currentUser.getCustomerId()), (String)"Only super user can create subrogation");
        dto.setStatus(UserTypeEnum.GENERIC.equals((Object)surrogate.getType()) ? SubrogationStatusEnum.ACCEPTED : SubrogationStatusEnum.CREATED);
    }

    protected String getObjectName() {
        return "subrogation";
    }

    protected VitamUIRepository<Subrogation, String> getRepository() {
        return this.subrogationRepository;
    }

    protected void beforeDelete(String id) {
        Optional subrogation = this.subrogationRepository.findById((Object)id);
        if (subrogation.isPresent()) {
            String emailSuperUser = ((Subrogation)subrogation.get()).getSuperUser();
            String emailCurrentUser = this.securityService.getUser().getEmail();
            Assert.isTrue((boolean)emailSuperUser.equals(emailCurrentUser), (String)"Only super user can stop subrogation");
        }
    }

    public SubrogationDto accept(String id) {
        Optional optSubrogation = this.subrogationRepository.findById((Object)id);
        Subrogation subro = (Subrogation)optSubrogation.orElseThrow(() -> new IllegalArgumentException("Unable to accept subrogation: no subrogation found with id=" + id));
        AuthUserDto currentUser = this.securityService.getUser();
        Assert.isTrue((boolean)subro.getSurrogate().equals(currentUser.getEmail()), (String)("Users " + currentUser.getEmail() + " can't accept subrogation of " + subro.getSurrogate()));
        Assert.isTrue((boolean)subro.getSurrogateCustomerId().equals(currentUser.getCustomerId()), (String)("Users " + currentUser.getCustomerId() + " can't accept subrogation of " + subro.getSurrogate()));
        subro.setStatus(SubrogationStatusEnum.ACCEPTED);
        Date nowPlusXMinutes = DateUtils.addMinutes((Date)new Date(), (int)this.subrogationTtl);
        subro.setDate(nowPlusXMinutes);
        Subrogation createdSubro = (Subrogation)this.subrogationRepository.save((Object)subro);
        return (SubrogationDto)this.convertFromEntityToDto((BaseIdDocument)createdSubro);
    }

    @Transactional
    public void decline(String id) {
        Optional optSubrogation = this.subrogationRepository.findById((Object)id);
        Subrogation subro = (Subrogation)optSubrogation.orElseThrow(() -> new IllegalArgumentException("Unable to decline subrogation: no subrogation found with id=" + id));
        if (subro.getStatus().equals((Object)SubrogationStatusEnum.ACCEPTED)) {
            this.iamLogbookService.subrogation(subro, EventType.EXT_VITAMUI_STOP_SURROGATE);
        } else {
            this.iamLogbookService.subrogation(subro, EventType.EXT_VITAMUI_DECLINE_SURROGATE);
        }
        String emailCurrentUser = this.securityService.getUser().getEmail();
        Assert.isTrue((boolean)subro.getSurrogate().equals(emailCurrentUser), (String)("Users " + emailCurrentUser + " can't decline subrogation of " + subro.getSurrogate()));
        this.subrogationRepository.deleteById((Object)id);
    }

    protected Class<Subrogation> getEntityClass() {
        return Subrogation.class;
    }

    protected Converter<SubrogationDto, Subrogation> getConverter() {
        return this.subrogationConverter;
    }

    public PaginatedValuesDto<UserDto> getGenericUsers(Integer page, Integer size, Optional<String> criteria, Optional<String> orderBy, Optional<DirectionDto> direction) {
        QueryDto criteriaFiltered = QueryDto.fromJson(criteria);
        criteriaFiltered.addCriterion("type", (Object)UserTypeEnum.GENERIC, CriterionOperator.EQUALS);
        return this.getUsers(page, size, criteriaFiltered.toOptionalJson(), orderBy, direction);
    }

    public PaginatedValuesDto<UserDto> getUsers(Integer page, Integer size, Optional<String> criteria, Optional<String> orderBy, Optional<DirectionDto> direction) {
        return this.userService.getAllPaginatedByPassSecurity(page, size, criteria, orderBy, direction);
    }

    public GroupDto getGroupById(String id, Optional<String> embedded) {
        return (GroupDto)this.groupService.getOneByPassSecurity(id, embedded);
    }

    protected Collection<String> getRestrictedKeys() {
        return CollectionUtils.emptyCollection();
    }

    protected Collection<String> getAllowedKeys() {
        return List.of("surrogateCustomerId");
    }

    protected String getVersionApiCriteria() {
        return "v2";
    }

    @Generated
    public SubrogationRepository getSubrogationRepository() {
        return this.subrogationRepository;
    }

    @Generated
    public UserRepository getUserRepository() {
        return this.userRepository;
    }

    @Generated
    public UserService getUserService() {
        return this.userService;
    }

    @Generated
    public GroupService getGroupService() {
        return this.groupService;
    }

    @Generated
    public GroupRepository getGroupRepository() {
        return this.groupRepository;
    }

    @Generated
    public ProfileRepository getProfilRepository() {
        return this.profilRepository;
    }

    @Generated
    public SecurityService getSecurityService() {
        return this.securityService;
    }

    @Generated
    public CustomerRepository getCustomerRepository() {
        return this.customerRepository;
    }

    @Generated
    public SubrogationConverter getSubrogationConverter() {
        return this.subrogationConverter;
    }

    @Generated
    public IamLogbookService getIamLogbookService() {
        return this.iamLogbookService;
    }

    @Generated
    public Integer getSubrogationTtl() {
        return this.subrogationTtl;
    }

    @Generated
    public Integer getGenericUsersSubrogationTtl() {
        return this.genericUsersSubrogationTtl;
    }

    @Generated
    public void setSubrogationRepository(SubrogationRepository subrogationRepository) {
        this.subrogationRepository = subrogationRepository;
    }

    @Generated
    public void setUserRepository(UserRepository userRepository) {
        this.userRepository = userRepository;
    }

    @Generated
    public void setUserService(UserService userService) {
        this.userService = userService;
    }

    @Generated
    public void setGroupService(GroupService groupService) {
        this.groupService = groupService;
    }

    @Generated
    public void setGroupRepository(GroupRepository groupRepository) {
        this.groupRepository = groupRepository;
    }

    @Generated
    public void setProfilRepository(ProfileRepository profilRepository) {
        this.profilRepository = profilRepository;
    }

    @Generated
    public void setSecurityService(SecurityService securityService) {
        this.securityService = securityService;
    }

    @Generated
    public void setCustomerRepository(CustomerRepository customerRepository) {
        this.customerRepository = customerRepository;
    }

    @Generated
    public void setSubrogationTtl(Integer subrogationTtl) {
        this.subrogationTtl = subrogationTtl;
    }

    @Generated
    public void setGenericUsersSubrogationTtl(Integer genericUsersSubrogationTtl) {
        this.genericUsersSubrogationTtl = genericUsersSubrogationTtl;
    }
}

