/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitamui.iam.server.security;

import fr.gouv.vitamui.commons.api.domain.UserDto;
import fr.gouv.vitamui.commons.rest.client.HttpContext;
import fr.gouv.vitamui.commons.security.client.dto.AuthUserDto;
import fr.gouv.vitamui.iam.security.service.UserAuthenticationService;
import fr.gouv.vitamui.iam.server.subrogation.dao.SubrogationRepository;
import fr.gouv.vitamui.iam.server.subrogation.domain.Subrogation;
import fr.gouv.vitamui.iam.server.token.dao.TokenRepository;
import fr.gouv.vitamui.iam.server.token.domain.Token;
import fr.gouv.vitamui.iam.server.user.service.UserService;
import jakarta.validation.constraints.NotNull;
import java.util.Date;
import lombok.Generated;
import org.apache.commons.lang3.time.DateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.web.authentication.preauth.PreAuthenticatedAuthenticationToken;
import org.springframework.stereotype.Service;

@Service
public class IamUserAuthentificationService
implements UserAuthenticationService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(IamUserAuthentificationService.class);
    public static final String INTERNAL_CAS_USER_NAME = "casuser";
    private final TokenRepository tokenRepository;
    private final UserService userService;
    private final SubrogationRepository subrogationRepository;
    @Value(value="${token.max-ttl:480}")
    @NotNull
    private Integer tokenMaxTtl;
    @Value(value="${token.additional.ttl}")
    @NotNull
    private Integer tokenAdditionalTtl;
    @Value(value="${cas.secret.token}")
    @NotNull
    private String casSecretToken;

    public IamUserAuthentificationService(UserService userService, TokenRepository tokenRepository, SubrogationRepository subrogationRepository) {
        this.userService = userService;
        this.tokenRepository = tokenRepository;
        this.subrogationRepository = subrogationRepository;
    }

    public AuthUserDto getUserFromHttpContext(PreAuthenticatedAuthenticationToken preAuthenticatedAuthenticationToken) {
        String userToken = ((HttpContext)preAuthenticatedAuthenticationToken.getPrincipal()).getUserToken();
        if (userToken == null) {
            throw new BadCredentialsException("Usertoken not found in header");
        }
        Token token = this.getToken(userToken);
        return this.getUserByToken(token);
    }

    private Token getToken(String userToken) {
        if (this.casSecretToken.equals(userToken)) {
            log.debug("Granted access to CAS token");
            Token token = new Token();
            token.setRefId(INTERNAL_CAS_USER_NAME);
            return token;
        }
        log.debug("Checking access for user token: '{}'", (Object)userToken);
        Token token = (Token)this.tokenRepository.findById((Object)userToken).orElseThrow(() -> new BadCredentialsException("No user found for usertoken: " + userToken));
        log.debug("Found valid token: {}", (Object)token);
        if (!token.isSurrogation()) {
            Date tokenMaxExpirationDate = DateUtils.addMinutes((Date)token.getCreatedDate(), (int)this.tokenMaxTtl);
            Date currentTokenExpirationDate = token.getUpdatedDate();
            Date newTokenExpirationDate = DateUtils.addMinutes((Date)new Date(), (int)this.tokenAdditionalTtl);
            if (currentTokenExpirationDate.before(new Date())) {
                throw new BadCredentialsException("Expired token  usertoken: " + userToken);
            }
            if (currentTokenExpirationDate.before(newTokenExpirationDate) && newTokenExpirationDate.before(tokenMaxExpirationDate)) {
                token.setUpdatedDate(newTokenExpirationDate);
                this.tokenRepository.save((Object)token);
            }
        }
        return token;
    }

    private AuthUserDto getUserByToken(Token token) {
        UserDto userDto = this.userService.findUserById(token.getRefId());
        AuthUserDto authUserDto = this.userService.loadGroupAndProfiles(userDto);
        if (token.isSurrogation()) {
            String surrogateEmail = userDto.getEmail();
            Subrogation subrogation = this.subrogationRepository.findOneBySurrogateAndSurrogateCustomerId(surrogateEmail, userDto.getCustomerId());
            String superUserEmail = subrogation.getSuperUser();
            authUserDto.setSuperUser(superUserEmail);
            authUserDto.setSuperUserCustomerId(subrogation.getSuperUserCustomerId());
            UserDto superUserDto = this.userService.findUserByEmailAndCustomerId(superUserEmail, subrogation.getSuperUserCustomerId());
            authUserDto.setSuperUserIdentifier(superUserDto.getIdentifier());
        }
        this.userService.addBasicCustomerAndProofTenantIdentifierInformation(authUserDto);
        this.userService.addTenantsByAppInformation(authUserDto);
        authUserDto.setAuthToken(token.getRefId());
        return authUserDto;
    }
}

