/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitamui.iam.server.security;

import fr.gouv.vitamui.commons.api.ParameterChecker;
import fr.gouv.vitamui.commons.api.domain.BaseIdDocument;
import fr.gouv.vitamui.commons.api.domain.Criterion;
import fr.gouv.vitamui.commons.api.domain.CriterionOperator;
import fr.gouv.vitamui.commons.api.domain.DirectionDto;
import fr.gouv.vitamui.commons.api.domain.IdDto;
import fr.gouv.vitamui.commons.api.domain.PaginatedValuesDto;
import fr.gouv.vitamui.commons.api.domain.QueryDto;
import fr.gouv.vitamui.commons.api.domain.QueryOperator;
import fr.gouv.vitamui.commons.api.exception.ForbiddenException;
import fr.gouv.vitamui.commons.api.exception.InvalidFormatException;
import fr.gouv.vitamui.commons.api.exception.NotImplementedException;
import fr.gouv.vitamui.commons.api.utils.CastUtils;
import fr.gouv.vitamui.commons.mongo.service.SequenceGeneratorService;
import fr.gouv.vitamui.commons.mongo.service.VitamUICrudService;
import fr.gouv.vitamui.iam.security.service.SecurityService;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.springframework.util.Assert;

public abstract class AbstractResourceClientService<E extends IdDto, I extends BaseIdDocument>
extends VitamUICrudService<E, I> {
    protected static final String EXTERNAL_PARAM_ID_KEY = "externalParamId";
    protected static final String TENANT_IDENTIFIER_KEY = "tenantIdentifier";
    protected static final String CUSTOMER_ID_KEY = "customerId";
    protected static final String LEVEL_KEY = "level";
    protected static final String CRITERIA_VERSION_V1 = "v1";
    protected static final String CRITERIA_VERSION_V2 = "v2";
    protected final SecurityService securityService;

    protected AbstractResourceClientService(SequenceGeneratorService sequenceGeneratorService, SecurityService securityService) {
        super(sequenceGeneratorService);
        this.securityService = securityService;
    }

    public PaginatedValuesDto<E> getAllPaginated(Integer page, Integer size, Optional<String> criteria, Optional<String> orderBy, Optional<DirectionDto> direction) {
        ParameterChecker.checkPagination((Integer)size, (Integer)page);
        this.checkAllowedOrderby(orderBy);
        return super.getAllPaginated(page, size, this.checkAuthorization(criteria), orderBy, direction);
    }

    public PaginatedValuesDto<E> getAllPaginated(Integer page, Integer size, Optional<String> criteria, Optional<String> orderBy, Optional<DirectionDto> direction, Optional<String> embedded) {
        ParameterChecker.checkPagination((Integer)size, (Integer)page);
        this.checkAllowedOrderby(orderBy);
        return super.getAllPaginated(page, size, this.checkAuthorization(criteria), orderBy, direction, embedded);
    }

    protected void checkAllowedOrderby(Optional<String> optOrderBy) {
    }

    protected Optional<String> checkAuthorization(Optional<String> criteria) throws InvalidFormatException {
        return this.addAccessRestriction(QueryDto.fromJson(criteria)).toOptionalJson();
    }

    protected QueryDto addAccessRestriction(QueryDto query) {
        if (CRITERIA_VERSION_V1.equals(this.getVersionApiCriteria())) {
            return this.addAccessRestrictionV1(query);
        }
        if (CRITERIA_VERSION_V2.equals(this.getVersionApiCriteria())) {
            return this.addAccessRestrictionV2(query);
        }
        throw new NotImplementedException("Unknow version");
    }

    protected QueryDto addAccessRestrictionV2(QueryDto query) {
        this.checkContainsAuthorizedKeys(query);
        QueryDto securedQuery = QueryDto.andQuery();
        query.keyFilter(this.getAllowedKeys());
        this.getRestrictedKeys(query).forEach(key -> this.addAccessRestrictionByKey(key, securedQuery));
        securedQuery.addQuery(query);
        return securedQuery;
    }

    private void checkContainsAuthorizedKeys(QueryDto query) {
        query.keyFilter(this.getAllowedKeys());
        if (query.getSubQueries() != null) {
            query.getSubQueries().forEach(arg_0 -> this.checkContainsAuthorizedKeys(arg_0));
        }
    }

    protected QueryDto addAccessRestrictionV1(QueryDto criteria) {
        criteria.keyFilter(this.getAllowedKeys());
        this.getRestrictedKeys().forEach(key -> this.addAccessRestrictionByKey(key, criteria));
        if (criteria.getQueryOperator() != null && !QueryOperator.AND.equals((Object)criteria.getQueryOperator())) {
            throw new UnsupportedOperationException("Unsupported operator " + String.valueOf(criteria.getQueryOperator()) + ". This API only supports the queryOperator \"AND\" on the root query.");
        }
        return criteria;
    }

    protected abstract String getVersionApiCriteria();

    protected void addAccessRestrictionByKey(String key, QueryDto criteria) {
        switch (key) {
            case "customerId": {
                this.addCustomerRestriction(criteria);
                break;
            }
            case "tenantIdentifier": {
                this.addTenantIdentifierRestriction(criteria);
                break;
            }
            default: {
                this.addRestriction(key, criteria);
            }
        }
    }

    protected void addRestriction(String key, QueryDto criteria) {
        throw new NotImplementedException("Restriction not defined for key: " + key);
    }

    protected void addTenantIdentifierRestriction(QueryDto criteria) {
        Optional optCriteria = criteria.find(TENANT_IDENTIFIER_KEY);
        if (optCriteria.isPresent()) {
            this.checkTenantIdentifierCriteria((Criterion)optCriteria.get());
        } else {
            criteria.addCriterion(this.getTenantIdentifierRestriction());
        }
    }

    public void checkCustomerId(String customerId, String message) {
        Assert.isTrue((boolean)StringUtils.equals((CharSequence)customerId, (CharSequence)this.securityService.getCustomerId()), (String)(message + ": customerId " + customerId + " is not allowed"));
    }

    public void checkTenantIdentifier(Integer tenantIdentifier, String message) {
        Assert.isTrue((boolean)this.securityService.getTenantIdentifier().equals(tenantIdentifier), (String)(message + ": tenantIdentifier " + tenantIdentifier + " is not allowed"));
    }

    protected void checkTenantIdentifierCriteria(Criterion tenantIdentifierCriteria) {
        if (!CastUtils.toInteger((Object)tenantIdentifierCriteria.getValue()).equals(this.securityService.getTenantIdentifier()) || !tenantIdentifierCriteria.getOperator().equals((Object)CriterionOperator.EQUALS)) {
            throw new ForbiddenException("tenantIdentifier's criteria is not equal to the tenantIdentifier from context");
        }
    }

    protected void addCustomerRestriction(QueryDto criteria) {
        Optional customerCriteria = criteria.find(CUSTOMER_ID_KEY);
        if (customerCriteria.isPresent()) {
            this.checkCustomerCriteria((Criterion)customerCriteria.get());
        } else {
            criteria.addCriterion(this.getCustomerRestriction());
        }
    }

    protected void checkCustomerCriteria(Criterion customerCriteria) {
        if (!StringUtils.equals((CharSequence)CastUtils.toString((Object)customerCriteria.getValue()), (CharSequence)this.securityService.getCustomerId()) || !customerCriteria.getOperator().equals((Object)CriterionOperator.EQUALS)) {
            throw new ForbiddenException("customerId's criteria is not equal to the customerId from context");
        }
    }

    protected Collection<String> getRestrictedKeys() {
        return Arrays.asList(CUSTOMER_ID_KEY);
    }

    protected Collection<String> getRestrictedKeys(QueryDto criteria) {
        return this.getRestrictedKeys();
    }

    protected Collection<String> getAllowedKeys() {
        return Collections.emptyList();
    }

    protected Collection<String> getAllowedAggregationKeys() {
        return Collections.emptyList();
    }

    protected Collection<String> getAllowedExcludeKeys() {
        return Collections.emptyList();
    }

    protected Criterion getCustomerRestriction() {
        return new Criterion(CUSTOMER_ID_KEY, (Object)this.securityService.getCustomerId(), CriterionOperator.EQUALS);
    }

    protected Criterion getTenantIdentifierRestriction() {
        return new Criterion(TENANT_IDENTIFIER_KEY, (Object)this.securityService.getTenantIdentifier(), CriterionOperator.EQUALS);
    }

    public List<E> getAll(Optional<String> criteria) {
        return super.getAll(this.checkAuthorization(criteria));
    }

    public List<E> getAll(Optional<String> criteria, Optional<String> embedded) {
        return super.getAll(this.checkAuthorization(criteria), embedded);
    }

    public boolean checkExist(String criteria) {
        return super.checkExist((String)this.checkAuthorization(Optional.ofNullable(criteria)).get());
    }

    @Generated
    public SecurityService getSecurityService() {
        return this.securityService;
    }
}

