/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitamui.iam.server.rest;

import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.exception.VitamClientException;
import fr.gouv.vitamui.common.security.SanityChecker;
import fr.gouv.vitamui.commons.api.ParameterChecker;
import fr.gouv.vitamui.commons.api.domain.DirectionDto;
import fr.gouv.vitamui.commons.api.domain.PaginatedValuesDto;
import fr.gouv.vitamui.commons.api.domain.UserDto;
import fr.gouv.vitamui.commons.api.exception.PreconditionFailedException;
import fr.gouv.vitamui.commons.rest.CrudController;
import fr.gouv.vitamui.commons.rest.util.RestUtils;
import fr.gouv.vitamui.commons.security.client.dto.AuthUserDto;
import fr.gouv.vitamui.commons.vitam.api.dto.LogbookOperationsCommonResponseDto;
import fr.gouv.vitamui.iam.security.service.SecurityService;
import fr.gouv.vitamui.iam.server.user.service.ConnectionHistoryService;
import fr.gouv.vitamui.iam.server.user.service.UserService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.validation.Valid;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.annotation.Secured;
import org.springframework.util.Assert;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/iam/v1/users"})
@Tag(name="Users", description="Users Management")
public class UserController
implements CrudController<UserDto> {
    private static final Logger LOGGER = LoggerFactory.getLogger(UserController.class);
    private final UserService userService;
    private final ConnectionHistoryService connectionHistoryService;
    private final SecurityService securityService;

    @Operation(operationId="users_exportUsers", summary="Export users to xlsx file")
    @Secured(value={"ROLE_GET_USERS"})
    @GetMapping(value={"/export"})
    public Resource exportUsers(@RequestParam(required=false) Optional<String> criteria) {
        LOGGER.debug("Export all users to xlsx file");
        return this.userService.exportUsers(criteria);
    }

    @Operation(operationId="users_getAllPaginated", summary="Get all users, paginated")
    @Secured(value={"ROLE_GET_USERS"})
    @GetMapping(value={"/paginated"}, params={"page", "size"})
    public PaginatedValuesDto<UserDto> getAllPaginated(@RequestParam Integer page, @RequestParam Integer size, @RequestParam(required=false) Optional<String> criteria, @RequestParam(required=false) Optional<String> orderBy, @RequestParam(required=false) Optional<DirectionDto> direction) throws InvalidParseOperationException, PreconditionFailedException {
        SanityChecker.checkSecureParameter((String[])new String[]{String.valueOf(size), String.valueOf(page)});
        SanityChecker.sanitizeCriteria(criteria);
        direction.ifPresent(SanityChecker::sanitizeCriteria);
        orderBy.ifPresent(xva$0 -> SanityChecker.checkSecureParameter((String[])new String[]{xva$0}));
        LOGGER.debug("getPaginateEntities page={}, size={}, criteria={}, orderBy={}, direction={}", new Object[]{page, size, criteria, orderBy, direction});
        return this.userService.getAllPaginated(page, size, criteria, orderBy, direction);
    }

    @GetMapping(value={"/{id}"})
    @Operation(operationId="users_getOne", summary="Get a user by its id")
    @Secured(value={"ROLE_GET_USERS"})
    public UserDto getOne(@PathVariable(value="id") String id) throws InvalidParseOperationException, PreconditionFailedException {
        ParameterChecker.checkParameter((String)"The Identifier is a mandatory parameter: ", (String[])new String[]{id});
        SanityChecker.checkSecureParameter((String[])new String[]{id});
        LOGGER.debug("Get {}", (Object)id);
        return (UserDto)this.userService.getOne(id);
    }

    @Operation(operationId="users_getMe", summary="Get the current user")
    @GetMapping(value={"/me"})
    @Secured(value={"ROLE_INTERNAL"})
    public AuthUserDto getMe() {
        LOGGER.debug("getMe");
        return this.userService.getMe();
    }

    @Operation(operationId="users_checkExist", summary="Check the existence of a user by criteria")
    @Secured(value={"ROLE_GET_USERS", "ROLE_CHECK_USERS"})
    @RequestMapping(path={"/check"}, method={RequestMethod.HEAD})
    public ResponseEntity<Void> checkExist(@RequestParam String criteria) {
        SanityChecker.sanitizeCriteria(Optional.of(criteria));
        LOGGER.debug("Check exists by criteria", (Object)criteria);
        boolean exist = this.userService.checkExist(criteria);
        return RestUtils.buildBooleanResponse((boolean)exist);
    }

    @PostMapping
    @Operation(operationId="users_create", summary="Create a user")
    @Secured(value={"ROLE_CREATE_USERS"})
    public UserDto create(@Valid @RequestBody UserDto dto) throws InvalidParseOperationException, PreconditionFailedException {
        SanityChecker.sanitizeCriteria((Object)dto);
        LOGGER.debug("Create {}", (Object)dto);
        this.userService.checkCustomerId(dto.getCustomerId(), "Unable to create user " + dto.getEmail() + " (" + dto.getCustomerId() + ")");
        return this.userService.create(dto);
    }

    @PutMapping(value={"/{id}"})
    @Operation(operationId="users_update", summary="Update a user")
    @Secured(value={"ROLE_UPDATE_USERS"})
    public UserDto update(@PathVariable(value="id") String id, @Valid @RequestBody UserDto dto) throws InvalidParseOperationException, PreconditionFailedException {
        ParameterChecker.checkParameter((String)"The Identifier is a mandatory parameter: ", (String[])new String[]{id});
        SanityChecker.checkSecureParameter((String[])new String[]{id});
        SanityChecker.sanitizeCriteria((Object)dto);
        LOGGER.debug("Update {} with {}", (Object)id, (Object)dto);
        Assert.isTrue((boolean)StringUtils.equals((CharSequence)id, (CharSequence)dto.getId()), (String)"The DTO identifier must match the path identifier for update.");
        this.userService.checkCustomerId(dto.getCustomerId(), "Unable to update user " + dto.getId());
        return this.userService.update(dto);
    }

    @PatchMapping(value={"/{id}"})
    @Operation(operationId="users_patch", summary="Patch a user")
    @Secured(value={"ROLE_UPDATE_USERS"})
    public UserDto patch(@PathVariable(value="id") String id, @RequestBody Map<String, Object> partialDto) throws InvalidParseOperationException, PreconditionFailedException {
        ParameterChecker.checkParameter((String)"Identifier is mandatory : ", (String[])new String[]{id});
        SanityChecker.checkSecureParameter((String[])new String[]{id});
        SanityChecker.sanitizeCriteria(partialDto);
        LOGGER.debug("Patch User {} with {}", (Object)id, partialDto);
        Assert.isTrue((boolean)StringUtils.equals((CharSequence)id, (CharSequence)((String)partialDto.get("id"))), (String)"Unable to patch user : the DTO id must match the path id");
        String customerId = (String)partialDto.get("customerId");
        if (StringUtils.isNotEmpty((CharSequence)customerId)) {
            this.userService.checkCustomerId(customerId, "Unable to patch user");
        }
        partialDto.put("customerId", this.securityService.getCustomerId());
        return this.userService.patch(partialDto);
    }

    @Operation(operationId="users_findHistoryById", summary="Get user history by its id")
    @GetMapping(value={"/{id}/history"})
    public LogbookOperationsCommonResponseDto findHistoryById(@PathVariable(value="id") String id) throws VitamClientException, InvalidParseOperationException {
        ParameterChecker.checkParameter((String)"The Identifier is a mandatory parameter: ", (String[])new String[]{id});
        SanityChecker.checkSecureParameter((String[])new String[]{id});
        LOGGER.debug("get logbook for users with id :{}", (Object)id);
        return this.userService.findHistoryById(id);
    }

    @GetMapping(value={"/levels"})
    @Operation(operationId="users_getLevels", summary="Get levels by criteria")
    @Secured(value={"ROLE_GET_USERS"})
    public List<String> getLevels(Optional<String> criteria) {
        SanityChecker.sanitizeCriteria(criteria);
        LOGGER.debug("Get levels with criteria={}", criteria);
        return this.userService.getLevels(criteria);
    }

    @Operation(operationId="users_patchAnalytics", summary="Create/refresh current user analytics")
    @PostMapping(value={"/analytics"})
    public UserDto patchAnalytics(@RequestBody Map<String, Object> partialDto) throws InvalidParseOperationException, PreconditionFailedException {
        SanityChecker.sanitizeCriteria(partialDto);
        LOGGER.debug("Patch analytics with {}", partialDto);
        return this.userService.patchAnalytics(partialDto);
    }

    @Generated
    public UserController(UserService userService, ConnectionHistoryService connectionHistoryService, SecurityService securityService) {
        this.userService = userService;
        this.connectionHistoryService = connectionHistoryService;
        this.securityService = securityService;
    }

    @Generated
    public UserService getUserService() {
        return this.userService;
    }

    @Generated
    public ConnectionHistoryService getConnectionHistoryService() {
        return this.connectionHistoryService;
    }

    @Generated
    public SecurityService getSecurityService() {
        return this.securityService;
    }
}

