/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitamui.iam.server.rest;

import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.exception.VitamClientException;
import fr.gouv.vitamui.common.security.SanityChecker;
import fr.gouv.vitamui.commons.api.ParameterChecker;
import fr.gouv.vitamui.commons.api.domain.DirectionDto;
import fr.gouv.vitamui.commons.api.domain.GroupDto;
import fr.gouv.vitamui.commons.api.domain.PaginatedValuesDto;
import fr.gouv.vitamui.commons.api.exception.PreconditionFailedException;
import fr.gouv.vitamui.commons.api.utils.CastUtils;
import fr.gouv.vitamui.commons.api.utils.EnumUtils;
import fr.gouv.vitamui.commons.rest.CrudController;
import fr.gouv.vitamui.commons.rest.util.RestUtils;
import fr.gouv.vitamui.commons.vitam.api.dto.LogbookOperationsCommonResponseDto;
import fr.gouv.vitamui.iam.common.dto.common.EmbeddedOptions;
import fr.gouv.vitamui.iam.security.service.SecurityService;
import fr.gouv.vitamui.iam.server.group.service.GroupService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.validation.Valid;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.Resource;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.annotation.Secured;
import org.springframework.util.Assert;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/iam/v1/groups"})
@Tag(name="Groups", description="Profiles Groups Management")
public class GroupController
implements CrudController<GroupDto> {
    private static final Logger LOGGER = LoggerFactory.getLogger(GroupController.class);
    protected static final String LEVEL_KEY = "level";
    private final GroupService groupService;
    private final SecurityService securityService;

    @Autowired
    public GroupController(GroupService groupService, SecurityService securityService) {
        this.groupService = groupService;
        this.securityService = securityService;
    }

    @GetMapping
    @Operation(operationId="groups_getAll", summary="Get all groups")
    @Secured(value={"ROLE_GET_GROUPS"})
    public List<GroupDto> getAll(Optional<String> criteria, @RequestParam Optional<String> embedded) {
        SanityChecker.sanitizeCriteria(criteria);
        EnumUtils.checkValidEnum(EmbeddedOptions.class, embedded);
        LOGGER.debug("get all group criteria={}, embedded={}", criteria, embedded);
        return this.groupService.getAll(criteria, embedded);
    }

    @RequestMapping(path={"/check"}, method={RequestMethod.HEAD})
    @Operation(operationId="groups_checkExist", summary="Check group existence")
    @Secured(value={"ROLE_GET_GROUPS"})
    public ResponseEntity<Void> checkExist(@RequestParam String criteria) {
        SanityChecker.sanitizeCriteria(Optional.of(criteria));
        LOGGER.debug("check exist by criteria={}", (Object)criteria);
        boolean exist = this.groupService.checkExist(criteria);
        return RestUtils.buildBooleanResponse((boolean)exist);
    }

    @GetMapping(value={"/{id}"})
    @Operation(operationId="groups_getOne", summary="Get group by id")
    @Secured(value={"ROLE_GET_GROUPS"})
    public GroupDto getOne(@PathVariable(value="id") String id, @RequestParam Optional<String> criteria, @RequestParam Optional<String> embedded) throws InvalidParseOperationException, PreconditionFailedException {
        ParameterChecker.checkParameter((String)"Identifier is mandatory : ", (String[])new String[]{id});
        SanityChecker.checkSecureParameter((String[])new String[]{id});
        SanityChecker.sanitizeCriteria(criteria);
        EnumUtils.checkValidEnum(EmbeddedOptions.class, embedded);
        LOGGER.debug("Get group {} embedded={}", (Object)id, embedded);
        return this.groupService.getOne(id, criteria, embedded);
    }

    @Secured(value={"ROLE_GET_GROUPS"})
    @GetMapping(value={"/paginated"}, params={"page", "size"})
    @Operation(operationId="groups_getAllPaginated", summary="Get all groups, paginated")
    public PaginatedValuesDto<GroupDto> getAllPaginated(@RequestParam Integer page, @RequestParam Integer size, @RequestParam(required=false) Optional<String> criteria, @RequestParam(required=false) Optional<String> orderBy, @RequestParam(required=false) Optional<DirectionDto> direction, @RequestParam(required=false) Optional<String> embedded) throws InvalidParseOperationException, PreconditionFailedException {
        EnumUtils.checkValidEnum(EmbeddedOptions.class, embedded);
        SanityChecker.sanitizeCriteria(criteria);
        direction.ifPresent(SanityChecker::sanitizeCriteria);
        orderBy.ifPresent(xva$0 -> SanityChecker.checkSecureParameter((String[])new String[]{xva$0}));
        SanityChecker.checkSecureParameter((String[])new String[]{String.valueOf(size), String.valueOf(page)});
        LOGGER.debug("getPaginateEntities page={}, size={}, criteria={}, orderBy={}, direction={}, embedded = {}", new Object[]{page, size, orderBy, direction, embedded});
        return this.groupService.getAllPaginated(page, size, criteria, orderBy, direction, embedded);
    }

    @PostMapping
    @Operation(operationId="groups_create", summary="Create a group")
    @Secured(value={"ROLE_CREATE_GROUPS"})
    public GroupDto create(@Valid @RequestBody GroupDto dto) throws InvalidParseOperationException, PreconditionFailedException {
        SanityChecker.sanitizeCriteria((Object)dto);
        LOGGER.debug("Create group {}", (Object)dto);
        this.groupService.checkCustomerId(dto.getCustomerId(), "Unable to create group");
        return this.groupService.create(dto);
    }

    public GroupDto update(@PathVariable(value="id") String id, @Valid @RequestBody GroupDto dto) {
        throw new UnsupportedOperationException("update not implemented");
    }

    @PatchMapping(value={"/{id}"})
    @Operation(operationId="groups_patch", summary="Patch a group")
    @Secured(value={"ROLE_UPDATE_GROUPS"})
    public GroupDto patch(@PathVariable(value="id") String id, @RequestBody Map<String, Object> partialDto) throws InvalidParseOperationException, PreconditionFailedException {
        ParameterChecker.checkParameter((String)"Identifier is mandatory : ", (String[])new String[]{id});
        SanityChecker.checkSecureParameter((String[])new String[]{id});
        SanityChecker.sanitizeCriteria(partialDto);
        LOGGER.debug("Patch group {} with {}", (Object)id, partialDto);
        Assert.isTrue((boolean)StringUtils.equals((CharSequence)id, (CharSequence)((String)partialDto.get("id"))), (String)"Unable to patch group : the DTO id must match the path id");
        String customerId = (String)partialDto.get("customerId");
        String level = CastUtils.toString((Object)partialDto.get(LEVEL_KEY));
        if (StringUtils.isNotEmpty((CharSequence)customerId)) {
            this.groupService.checkCustomerId(customerId, "Unable to patch group");
        }
        if (StringUtils.isNotEmpty((CharSequence)level)) {
            this.groupService.checkLevel(level, "Unable to patch profile");
        }
        partialDto.put("customerId", this.securityService.getCustomerId());
        return this.groupService.patch(partialDto);
    }

    @GetMapping(value={"/{id}/history"})
    @Operation(operationId="groups_findHistoryById", summary="Get group history by id")
    public LogbookOperationsCommonResponseDto findHistoryById(@PathVariable(value="id") String id) throws InvalidParseOperationException, VitamClientException {
        ParameterChecker.checkParameter((String)"Identifier is mandatory : ", (String[])new String[]{id});
        SanityChecker.checkSecureParameter((String[])new String[]{id});
        LOGGER.debug("get logbook for group with id :{}", (Object)id);
        return this.groupService.findHistoryById(id);
    }

    @GetMapping(value={"/levels"})
    @Operation(operationId="groups_getLevels", summary="Get levels by criteria")
    @Secured(value={"ROLE_GET_GROUPS"})
    public List<String> getLevels(Optional<String> criteria) {
        SanityChecker.sanitizeCriteria(criteria);
        LOGGER.debug("Get levels with criteria={}", criteria);
        return this.groupService.getLevels(criteria);
    }

    @GetMapping(value={"/export"})
    @Operation(operationId="groups_exportProfileGroups", summary="Export all profile groups to xlsx file")
    @Secured(value={"ROLE_GET_GROUPS"})
    public Resource exportProfileGroups() {
        LOGGER.debug("Export all profile groups to xlsx file");
        return this.groupService.exportProfileGroups(Optional.empty());
    }

    @Generated
    public GroupService getGroupService() {
        return this.groupService;
    }

    @Generated
    public SecurityService getSecurityService() {
        return this.securityService;
    }
}

