/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitamui.iam.server.rest;

import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.exception.VitamClientException;
import fr.gouv.vitamui.common.security.SanityChecker;
import fr.gouv.vitamui.commons.api.ParameterChecker;
import fr.gouv.vitamui.commons.api.domain.DirectionDto;
import fr.gouv.vitamui.commons.api.domain.PaginatedValuesDto;
import fr.gouv.vitamui.commons.api.enums.AttachmentType;
import fr.gouv.vitamui.commons.api.exception.PreconditionFailedException;
import fr.gouv.vitamui.commons.rest.CrudController;
import fr.gouv.vitamui.commons.rest.enums.ContentDispositionType;
import fr.gouv.vitamui.commons.rest.util.RestUtils;
import fr.gouv.vitamui.commons.vitam.api.dto.LogbookOperationsCommonResponseDto;
import fr.gouv.vitamui.iam.common.dto.CustomerCreationFormData;
import fr.gouv.vitamui.iam.common.dto.CustomerDto;
import fr.gouv.vitamui.iam.common.dto.CustomerPatchFormData;
import fr.gouv.vitamui.iam.common.utils.CustomerDtoEditor;
import fr.gouv.vitamui.iam.common.utils.MapEditor;
import fr.gouv.vitamui.iam.server.customer.service.CustomerService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.validation.Valid;
import java.beans.PropertyEditor;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import org.apache.commons.lang3.NotImplementedException;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.Resource;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.annotation.Secured;
import org.springframework.util.Assert;
import org.springframework.web.bind.WebDataBinder;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.InitBinder;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/iam/v1/customers"})
@Tag(name="Customers", description="Customers Management")
public class CustomerController
implements CrudController<CustomerDto> {
    private static final Logger LOGGER = LoggerFactory.getLogger(CustomerController.class);
    private final CustomerService customerService;

    @Autowired
    public CustomerController(CustomerService customerService) {
        this.customerService = customerService;
    }

    @InitBinder
    public void initBinder(WebDataBinder binder) {
        binder.registerCustomEditor(CustomerDto.class, (PropertyEditor)new CustomerDtoEditor());
        binder.registerCustomEditor(Map.class, (PropertyEditor)new MapEditor());
    }

    @GetMapping
    @Operation(operationId="customers_getAll", summary="Get all customer objects")
    @Secured(value={"ROLE_GET_CUSTOMERS"})
    public Collection<CustomerDto> getAll(Optional<String> criteria) {
        SanityChecker.sanitizeCriteria(criteria);
        LOGGER.debug("Get all with criteria={}", criteria);
        return this.customerService.getAll(criteria);
    }

    @Operation(operationId="customers_checkExist", summary="Check that a customer exists")
    @Secured(value={"ROLE_GET_CUSTOMERS"})
    @RequestMapping(path={"/check"}, method={RequestMethod.HEAD})
    public ResponseEntity<Void> checkExist(@RequestParam String criteria) {
        SanityChecker.sanitizeCriteria(Optional.of(criteria));
        LOGGER.debug("check exist by criteria={}", (Object)criteria);
        boolean exist = this.customerService.checkExist(criteria);
        return RestUtils.buildBooleanResponse((boolean)exist);
    }

    @Operation(operationId="customers_getOne", summary="Get a customer by its id")
    @Secured(value={"ROLE_GET_CUSTOMERS"})
    @GetMapping(value={"/{id}"})
    public CustomerDto getOne(@PathVariable(value="id") String id) throws InvalidParseOperationException, PreconditionFailedException {
        SanityChecker.checkSecureParameter((String[])new String[]{id});
        ParameterChecker.checkParameter((String)"Identifier is mandatory : ", (String[])new String[]{id});
        LOGGER.debug("Get {}", (Object)id);
        return (CustomerDto)this.customerService.getOne(id);
    }

    @Operation(operationId="customers_getMyCustomer", summary="Get the customer for the authenticated user")
    @GetMapping(path={"/me"})
    public CustomerDto getMyCustomer() {
        return this.customerService.getMyCustomer();
    }

    @Secured(value={"ROLE_GET_CUSTOMERS"})
    @GetMapping(value={"/paginated"}, params={"page", "size"})
    @Operation(operationId="customers_getAllPaginated", summary="Get all customers using pagination")
    public PaginatedValuesDto<CustomerDto> getAllPaginated(@RequestParam Integer page, @RequestParam Integer size, @RequestParam(required=false) Optional<String> criteria, @RequestParam(required=false) Optional<String> orderBy, @RequestParam(required=false) Optional<DirectionDto> direction) throws InvalidParseOperationException, PreconditionFailedException {
        SanityChecker.sanitizeCriteria(criteria);
        SanityChecker.checkSecureParameter((String[])new String[]{String.valueOf(page), String.valueOf(size)});
        direction.ifPresent(SanityChecker::sanitizeCriteria);
        orderBy.ifPresent(xva$0 -> SanityChecker.checkSecureParameter((String[])new String[]{xva$0}));
        LOGGER.debug("getPaginateEntities page={}, size={}, criteria={}, orderBy={}, ascendant={}", new Object[]{page, size, criteria, orderBy, direction});
        return this.customerService.getAllPaginated(page, size, criteria, orderBy, direction);
    }

    @Operation(operationId="customers_create", summary="Create a customer")
    @Secured(value={"ROLE_CREATE_CUSTOMERS"})
    @PostMapping(consumes={"multipart/form-data"})
    @ResponseStatus(value=HttpStatus.CREATED)
    public CustomerDto create(@ModelAttribute CustomerCreationFormData customerData) throws InvalidParseOperationException, PreconditionFailedException {
        SanityChecker.sanitizeCriteria((Object)customerData);
        LOGGER.debug("Create {}", (Object)customerData);
        return this.customerService.create(customerData);
    }

    @Operation(operationId="customers_update", summary="Update a customer")
    @Secured(value={"ROLE_UPDATE_CUSTOMERS"})
    @PutMapping(value={"/{id}"})
    public CustomerDto update(@PathVariable(value="id") String id, @Valid @RequestBody CustomerDto dto) throws InvalidParseOperationException, PreconditionFailedException {
        ParameterChecker.checkParameter((String)"Identifier is mandatory : ", (String[])new String[]{id});
        SanityChecker.checkSecureParameter((String[])new String[]{id});
        SanityChecker.sanitizeCriteria((Object)dto);
        LOGGER.debug("Update {} with {}", (Object)id, (Object)dto);
        Assert.isTrue((boolean)StringUtils.equals((CharSequence)id, (CharSequence)dto.getId()), (String)"The DTO identifier must match the path identifier for update.");
        return this.customerService.update(dto);
    }

    @Operation(operationId="customers_patch", summary="Patch a customer entity")
    @PatchMapping(value={"/{id}"})
    @Secured(value={"ROLE_UPDATE_CUSTOMERS"})
    public CustomerDto patch(@PathVariable(value="id") String id, @ModelAttribute CustomerPatchFormData customerData) throws InvalidParseOperationException, PreconditionFailedException {
        ParameterChecker.checkParameter((String)"Identifier is mandatory : ", (String[])new String[]{id});
        SanityChecker.checkSecureParameter((String[])new String[]{id});
        SanityChecker.sanitizeCriteria((Object)customerData.getPartialCustomerDto());
        Assert.isTrue((boolean)StringUtils.equals((CharSequence)id, (CharSequence)((String)customerData.getPartialCustomerDto().get("id"))), (String)"The DTO identifier must match the path identifier for update.");
        LOGGER.debug("Patch customer with {}", customerData.getPartialCustomerDto().get("id"));
        return this.customerService.patch(customerData);
    }

    @Operation(operationId="customers_findHistoryById", summary="Find history for a customer by its id")
    @GetMapping(value={"/{id}/history"})
    public LogbookOperationsCommonResponseDto findHistoryById(@PathVariable(value="id") String id) throws VitamClientException {
        LOGGER.debug("get logbook for customer with id :{}", (Object)id);
        SanityChecker.checkSecureParameter((String[])new String[]{id});
        return this.customerService.findHistoryById(id);
    }

    public CustomerDto create(CustomerDto dto) {
        throw new NotImplementedException("Method is not implemented");
    }

    public CustomerDto patch(String id, Map<String, Object> partialCustomerDto) {
        throw new NotImplementedException("Method is not implemented");
    }

    @Operation(operationId="customers_getLogo", summary="Get customer logo")
    @GetMapping(value={"/{id}/logo"})
    @ResponseStatus(value=HttpStatus.OK)
    public ResponseEntity<Resource> getLogo(@PathVariable String id, @RequestParam(value="type") AttachmentType type) throws InvalidParseOperationException, PreconditionFailedException {
        ParameterChecker.checkParameter((String)"Identifier is mandatory : ", (String[])new String[]{id});
        SanityChecker.checkSecureParameter((String[])new String[]{id});
        LOGGER.debug("get logo for customer with id :{}, type : {}", (Object)id, (Object)type);
        ResponseEntity response = this.customerService.getLogo(id, type);
        if (HttpStatus.NO_CONTENT.equals((Object)response.getStatusCode())) {
            return response;
        }
        return RestUtils.buildFileResponse((ResponseEntity)response, Optional.of(ContentDispositionType.INLINE), Optional.empty());
    }

    @Operation(operationId="customers_getGdprSettingStatus", summary="Get Gdpr Setting Status")
    @GetMapping(value={"/gdpr-status"})
    @ResponseStatus(value=HttpStatus.OK)
    public boolean getGdprSettingStatus() {
        LOGGER.debug("Get Gdpr Setting Status");
        return this.customerService.getGdprSettingStatus();
    }

    @Generated
    public CustomerService getCustomerService() {
        return this.customerService;
    }
}

