/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitamui.iam.server.rest;

import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitamui.common.security.SanityChecker;
import fr.gouv.vitamui.commons.api.ParameterChecker;
import fr.gouv.vitamui.commons.api.domain.BaseIdDocument;
import fr.gouv.vitamui.commons.api.domain.UserDto;
import fr.gouv.vitamui.commons.api.enums.UserStatusEnum;
import fr.gouv.vitamui.commons.api.exception.NotFoundException;
import fr.gouv.vitamui.commons.api.exception.TooManyRequestsException;
import fr.gouv.vitamui.commons.api.exception.UnAuthorizedException;
import fr.gouv.vitamui.iam.common.dto.CustomerDto;
import fr.gouv.vitamui.iam.common.dto.SubrogationDto;
import fr.gouv.vitamui.iam.common.dto.cas.LoginRequestDto;
import fr.gouv.vitamui.iam.server.cas.service.CasService;
import fr.gouv.vitamui.iam.server.logbook.service.IamLogbookService;
import fr.gouv.vitamui.iam.server.user.domain.User;
import fr.gouv.vitamui.iam.server.user.service.UserService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.annotation.Secured;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/iam/v1/cas"})
@Tag(name="Cas", description="User authentication management for CAS")
public class CasController {
    private static final Logger LOGGER = LoggerFactory.getLogger(CasController.class);
    @Value(value="${login.attempts.maximum.failures}")
    @NotNull
    private Integer maximumFailuresForLoginAttempts;
    @Autowired
    private IamLogbookService iamLogbookService;
    private final CasService casService;
    private final PasswordEncoder passwordEncoder;
    private final UserService userService;

    @Autowired
    public CasController(CasService casService, PasswordEncoder passwordEncoder, UserService userService) {
        this.casService = casService;
        this.passwordEncoder = passwordEncoder;
        this.userService = userService;
    }

    @PostMapping(value={"/login"})
    @Operation(operationId="cas_login", summary="Performs the login of a user")
    @Secured(value={"ROLE_CAS_LOGIN"})
    public ResponseEntity<UserDto> login(@Valid @RequestBody LoginRequestDto dto) {
        boolean passwordMatch;
        String username = dto.getLoginEmail();
        User user = this.casService.findUserByEmailAndCustomerId(dto.getLoginEmail(), dto.getLoginCustomerId());
        UserStatusEnum oldStatus = user.getStatus();
        String password = user.getPassword();
        int nbFailedAttemps = user.getNbFailedAttempts();
        OffsetDateTime lastConnection = user.getLastConnection();
        OffsetDateTime now = OffsetDateTime.now();
        OffsetDateTime nowLess20Minutes = now.plusMinutes(-this.casService.getTimeIntervalForLoginAttempts().intValue());
        if (lastConnection != null && lastConnection.isBefore(nowLess20Minutes)) {
            LOGGER.debug("reset nbFailedAttemps");
            nbFailedAttemps = 0;
        }
        if (!(passwordMatch = this.passwordEncoder.matches((CharSequence)dto.getPassword(), password))) {
            ++nbFailedAttemps;
        } else if (nbFailedAttemps < this.maximumFailuresForLoginAttempts) {
            nbFailedAttemps = 0;
        }
        user.setNbFailedAttempts(nbFailedAttemps);
        user.setLastConnection(now);
        if (nbFailedAttemps >= this.maximumFailuresForLoginAttempts) {
            user.setStatus(UserStatusEnum.BLOCKED);
        } else if (user.getStatus() == UserStatusEnum.BLOCKED) {
            user.setStatus(UserStatusEnum.ENABLED);
        }
        this.casService.updateNbFailedAttempsPlusLastConnectionAndStatus(user, nbFailedAttemps, oldStatus);
        LOGGER.debug("username: {} -> passwordMatch: {} / nbFailedAttemps: {}", new Object[]{username, passwordMatch, nbFailedAttemps});
        if (nbFailedAttemps >= this.maximumFailuresForLoginAttempts) {
            String message = "Too many login attempts for username: " + username;
            this.iamLogbookService.loginEvent(user, this.findSurrogateDescriptionStringForLogging(dto), dto.getIp(), message);
            throw new TooManyRequestsException(message);
        }
        if (passwordMatch) {
            UserDto userDto = (UserDto)this.userService.internalConvertFromEntityToDto((BaseIdDocument)user);
            this.iamLogbookService.loginEvent(user, this.findSurrogateDescriptionStringForLogging(dto), dto.getIp(), null);
            return new ResponseEntity((Object)userDto, (HttpStatusCode)HttpStatus.OK);
        }
        String message = "Bad credentials for username: " + username;
        this.iamLogbookService.loginEvent(user, this.findSurrogateDescriptionStringForLogging(dto), dto.getIp(), message);
        throw new UnAuthorizedException(message);
    }

    private String findSurrogateDescriptionStringForLogging(LoginRequestDto loginRequest) {
        String surrogate = loginRequest.getSurrogateEmail();
        String surrogateCustomerId = loginRequest.getSurrogateCustomerId();
        if (surrogate != null) {
            try {
                return this.userService.findUserByEmailAndCustomerId(surrogate, surrogateCustomerId).getIdentifier();
            }
            catch (NotFoundException e) {
                return "User not found: " + surrogate + " and customerId " + surrogateCustomerId;
            }
        }
        return null;
    }

    @PostMapping(value={"/password/change"})
    @Operation(operationId="cas_changePassword", summary="Change password of a user")
    @Secured(value={"ROLE_CAS_CHANGE_PASSWORD"})
    @ResponseBody
    public String changePassword(@RequestHeader String username, @RequestHeader String password, @RequestHeader String customerId) {
        LOGGER.debug("changePassword for username: {} / password_exists? {}, customerId {} ", new Object[]{username, StringUtils.isNotBlank((CharSequence)password), customerId});
        ParameterChecker.checkParameter((String)"The user, customer id and password are mandatory : ", (String[])new String[]{username, customerId, password});
        SanityChecker.checkSecureParameter((String[])new String[]{username});
        this.casService.updatePassword(username, password, customerId);
        return "true";
    }

    @GetMapping(value={"/users"}, params={"email"})
    @Operation(operationId="cas_getUsersByEmail", summary="Get all users having a given email address")
    @Secured(value={"ROLE_CAS_USERS"})
    public List<UserDto> getUsersByEmail(@RequestParam String email, @RequestParam Optional<String> embedded) {
        LOGGER.debug("getUserByEmail: {} embedded: {}", (Object)email, embedded);
        ParameterChecker.checkParameter((String)"The email is mandatory : ", (String[])new String[]{email});
        return this.casService.getUsersByEmail(email, (String)embedded.orElse(null));
    }

    @GetMapping(value={"/users/provisioning"}, params={"loginEmail", "loginCustomerId", "idp"})
    @Operation(operationId="cas_getUser", summary="Get a user by their loginEmail, loginCustomerId and idp")
    @Secured(value={"ROLE_CAS_USERS"})
    public UserDto getUser(@RequestParam String loginEmail, @RequestParam String loginCustomerId, @RequestParam String idp, @RequestParam Optional<String> userIdentifier, @RequestParam Optional<String> embedded) throws InvalidParseOperationException {
        SanityChecker.checkSecureParameter((String[])new String[]{idp, loginEmail, loginCustomerId});
        userIdentifier.ifPresent(xva$0 -> SanityChecker.checkSecureParameter((String[])new String[]{xva$0}));
        LOGGER.debug("getUser - email : {}, customerId : {}, idp : {}, userIdentifier : {}, embedded options : {}", new Object[]{loginEmail, loginCustomerId, idp, userIdentifier, embedded});
        return this.casService.getUser(loginEmail, loginCustomerId, idp, (String)userIdentifier.orElse(null), (String)embedded.orElse(null));
    }

    @GetMapping(value={"/subrogations"})
    @Operation(operationId="getSubrogationsBySuperUserIdOrEmailAndCustomerId", summary="Get available subrogations for a super user by super user id or by super user email and customerId")
    @Secured(value={"ROLE_CAS_SUBROGATIONS"})
    public List<SubrogationDto> getSubrogationsBySuperUserIdOrEmailAndCustomerId(@RequestParam(required=false) String superUserId, @RequestParam(required=false) String superUserEmail, @RequestParam(required=false) String superUserCustomerId) {
        LOGGER.debug("getSubrogationsBySuperUserIdOrEmailAndCustomerId: id: {} | email: {} / customerId: {}", new Object[]{superUserId, superUserEmail, superUserCustomerId});
        String email = superUserEmail;
        String customerId = superUserCustomerId;
        if (superUserId != null && !superUserId.isEmpty() && !superUserId.trim().isEmpty()) {
            SanityChecker.checkSecureParameter((String[])new String[]{superUserId});
            UserDto user = (UserDto)this.userService.getOne(superUserId, Optional.empty());
            if (user != null && user.getStatus() == UserStatusEnum.ENABLED) {
                email = user.getEmail();
                customerId = user.getCustomerId();
                LOGGER.debug("-> email: {}, customerId: {}", (Object)email, (Object)customerId);
            } else {
                return new ArrayList<SubrogationDto>();
            }
        }
        ParameterChecker.checkParameter((String)"The superUserEmail is mandatory : ", (String[])new String[]{email});
        ParameterChecker.checkParameter((String)"The superUserCustomerId is mandatory : ", (String[])new String[]{customerId});
        return this.casService.getSubrogationsBySuperUser(email, customerId);
    }

    @GetMapping(value={"/logout"})
    @Operation(operationId="cas_logout", summary="Logout a user, remove the token and delete the subrogation if needed")
    @Secured(value={"ROLE_CAS_LOGOUT"})
    @ResponseStatus(value=HttpStatus.OK)
    public void logout(@RequestParam String authToken, @RequestParam String superUser, @RequestParam String superUserCustomerId) {
        LOGGER.debug("logout: authToken={}, superUser={}, superUserCustomerId={}", new Object[]{authToken, superUser, superUserCustomerId});
        ParameterChecker.checkParameter((String)"The arguments authToken is mandatory : ", (String[])new String[]{authToken});
        CasService.PrincipalFromToken principal = this.casService.removeTokenAndGetPrincipal(authToken);
        if (null != principal && StringUtils.isNotBlank((CharSequence)superUser)) {
            this.casService.deleteSubrogationBySuperUserAndSurrogate(superUser, superUserCustomerId, principal.getEmail(), principal.getCustomerId());
        }
    }

    @GetMapping(value={"/customers"})
    @Operation(operationId="cas_getCustomersByIds", summary="Get all customers by ids")
    @Secured(value={"ROLE_CAS_CUSTOMERS"})
    public Collection<CustomerDto> getCustomersByIds(@RequestParam List<String> customerIds) {
        LOGGER.debug("get all customers by ids={}", customerIds);
        ParameterChecker.checkParameter((String)"CustomerIds are mandatory : ", (Object[])new Object[]{customerIds});
        SanityChecker.checkSecureParameter((String[])customerIds.toArray(new String[0]));
        return this.casService.getCustomersByIds(customerIds);
    }

    @Generated
    public void setMaximumFailuresForLoginAttempts(Integer maximumFailuresForLoginAttempts) {
        this.maximumFailuresForLoginAttempts = maximumFailuresForLoginAttempts;
    }

    @Generated
    public void setIamLogbookService(IamLogbookService iamLogbookService) {
        this.iamLogbookService = iamLogbookService;
    }
}

