/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitamui.iam.server.rest;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import fr.gouv.vitam.common.client.VitamContext;
import fr.gouv.vitam.common.database.builder.request.single.Select;
import fr.gouv.vitam.common.exception.VitamClientException;
import fr.gouv.vitam.common.model.RequestResponse;
import fr.gouv.vitam.common.model.administration.AccessContractModel;
import fr.gouv.vitamui.commons.api.converter.AccessContractConverter;
import fr.gouv.vitamui.commons.api.domain.AccessContractDto;
import fr.gouv.vitamui.commons.api.exception.InternalServerException;
import fr.gouv.vitamui.commons.vitam.api.administration.AccessContractCommonService;
import fr.gouv.vitamui.commons.vitam.api.dto.AccessContractResponseDto;
import fr.gouv.vitamui.iam.security.service.SecurityService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.access.annotation.Secured;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/v1"})
@Tag(name="AccessContracts", description="Access Contracts Management")
public class AccessContractController {
    static final Logger LOGGER = LoggerFactory.getLogger(AccessContractController.class);
    protected final SecurityService securityService;
    private final AccessContractCommonService accessContractCommonService;
    private final ObjectMapper objectMapper;

    public AccessContractController(SecurityService securityService, AccessContractCommonService accessContractCommonService, ObjectMapper objectMapper) {
        this.securityService = securityService;
        this.accessContractCommonService = accessContractCommonService;
        this.objectMapper = objectMapper;
    }

    @GetMapping(value={"/accesscontracts"})
    @Operation(operationId="accessContracts_getAll", summary="Get all access contracts")
    @Secured(value={"ROLE_CREATE_EXTERNAL_PARAM_PROFILE"})
    public List<AccessContractDto> getAll() {
        VitamContext vitamContext = this.securityService.buildVitamContext(this.securityService.getTenantIdentifier());
        try {
            RequestResponse requestResponse = this.accessContractCommonService.findAccessContracts(vitamContext, (JsonNode)new Select().getFinalSelect());
            AccessContractResponseDto accessContractResponseDto = (AccessContractResponseDto)this.objectMapper.treeToValue((TreeNode)requestResponse.toJsonNode(), AccessContractResponseDto.class);
            return AccessContractConverter.convertVitamsToDtos((List)accessContractResponseDto.getResults());
        }
        catch (JsonProcessingException | VitamClientException e) {
            throw new InternalServerException("Unable to get Access Contrats", e);
        }
    }

    @GetMapping(path={"/accesscontracts/{identifier:.+}"})
    @Operation(operationId="accessContracts_getAccessContractById", summary="Get access contract by ID")
    @Secured(value={"ROLE_GET_ACCESS_CONTRACTS"})
    public AccessContractDto getAccessContractById(@PathVariable(value="identifier") String identifier) throws UnsupportedEncodingException {
        LOGGER.debug("get accessContract identifier={} / {}", (Object)identifier, (Object)URLDecoder.decode(identifier, StandardCharsets.UTF_8));
        VitamContext vitamContext = this.securityService.buildVitamContext(this.securityService.getTenantIdentifier());
        try {
            LOGGER.info("Access Contract EvIdAppSession : {} ", (Object)vitamContext.getApplicationSessionId());
            RequestResponse requestResponse = this.accessContractCommonService.findAccessContractById(vitamContext, identifier);
            AccessContractResponseDto accessContractResponseDto = (AccessContractResponseDto)this.objectMapper.treeToValue((TreeNode)requestResponse.toJsonNode(), AccessContractResponseDto.class);
            if (accessContractResponseDto.getResults().isEmpty()) {
                return null;
            }
            return AccessContractConverter.convertVitamToDto((AccessContractModel)((AccessContractModel)accessContractResponseDto.getResults().get(0)));
        }
        catch (JsonProcessingException | VitamClientException e) {
            throw new InternalServerException("Unable to get Access Contrat", e);
        }
    }
}

