/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitamui.iam.server.owner.service;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import fr.gouv.vitam.common.client.VitamContext;
import fr.gouv.vitam.common.exception.VitamClientException;
import fr.gouv.vitamui.commons.api.converter.Converter;
import fr.gouv.vitamui.commons.api.domain.IdDto;
import fr.gouv.vitamui.commons.api.domain.OwnerDto;
import fr.gouv.vitamui.commons.api.exception.InternalServerException;
import fr.gouv.vitamui.commons.api.exception.NotFoundException;
import fr.gouv.vitamui.commons.api.utils.CastUtils;
import fr.gouv.vitamui.commons.logbook.dto.EventDiffDto;
import fr.gouv.vitamui.commons.mongo.service.SequenceGeneratorService;
import fr.gouv.vitamui.commons.utils.JsonUtils;
import fr.gouv.vitamui.commons.vitam.api.access.LogbookService;
import fr.gouv.vitamui.commons.vitam.api.dto.LogbookOperationsCommonResponseDto;
import fr.gouv.vitamui.iam.security.service.SecurityService;
import fr.gouv.vitamui.iam.server.common.domain.Address;
import fr.gouv.vitamui.iam.server.common.service.AddressService;
import fr.gouv.vitamui.iam.server.customer.dao.CustomerRepository;
import fr.gouv.vitamui.iam.server.logbook.service.IamLogbookService;
import fr.gouv.vitamui.iam.server.owner.converter.OwnerConverter;
import fr.gouv.vitamui.iam.server.owner.dao.OwnerRepository;
import fr.gouv.vitamui.iam.server.owner.domain.Owner;
import fr.gouv.vitamui.iam.server.security.AbstractResourceClientService;
import fr.gouv.vitamui.iam.server.tenant.dao.TenantRepository;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

public class OwnerService
extends AbstractResourceClientService<OwnerDto, Owner> {
    private static final String IS_PROOF_TENANT_KEY = "proof";
    private static final String CUSTOMER_KEY = "customerId";
    private final OwnerRepository ownerRepository;
    private final CustomerRepository customerRepository;
    private final AddressService addressService;
    private final IamLogbookService iamLogbookService;
    private final SecurityService securityService;
    private final OwnerConverter ownerConverter;
    private final LogbookService logbookService;
    private final TenantRepository tenantRepository;
    private static final Logger LOGGER = LoggerFactory.getLogger(OwnerService.class);

    @Autowired
    public OwnerService(SequenceGeneratorService sequenceGeneratorService, OwnerRepository ownerRepository, CustomerRepository customerRepository, AddressService addressService, IamLogbookService iamLogbookService, SecurityService securityService, OwnerConverter ownerConverter, LogbookService logbookService, TenantRepository tenantRepository) {
        super(sequenceGeneratorService, securityService);
        this.ownerRepository = ownerRepository;
        this.customerRepository = customerRepository;
        this.addressService = addressService;
        this.iamLogbookService = iamLogbookService;
        this.securityService = securityService;
        this.ownerConverter = ownerConverter;
        this.logbookService = logbookService;
        this.tenantRepository = tenantRepository;
    }

    protected void beforeCreate(OwnerDto dto) {
        String message = "Unable to create owner " + dto.getName();
        this.checkSetReadonly(dto.isReadonly(), message);
        this.checkCode(dto.getCode(), message);
        this.checkCustomer(dto.getCustomerId(), message);
        super.checkIdentifier(dto.getIdentifier(), message);
        dto.setIdentifier(this.getNextSequenceId("ownerIdentifier"));
    }

    @Transactional
    public OwnerDto create(OwnerDto dto) {
        OwnerDto createdOwner = (OwnerDto)super.create((IdDto)dto);
        this.iamLogbookService.createOwnerEvent(createdOwner);
        return createdOwner;
    }

    protected void beforeUpdate(OwnerDto dto) {
        Owner owner = this.find(dto.getId(), "Unable to update owner");
        String message = "Unable to update owner " + dto.getId();
        this.checkIsReadonly(owner.isReadonly(), message);
        this.checkSetReadonly(dto.isReadonly(), message);
        this.checkCode(dto.getId(), dto.getCode(), message);
        this.checkCustomer(dto.getCustomerId(), message);
    }

    protected Owner beforePatch(Map<String, Object> partialDto) {
        Boolean readonly;
        String id = CastUtils.toString((Object)partialDto.get("id"));
        String message = "Unable to update owner " + id;
        Owner owner = this.find(id, message);
        this.checkIsReadonly(owner.isReadonly(), message);
        Assert.isTrue((!this.checkMapContainsOnlyFieldsUnmodifiable(partialDto, Arrays.asList("id", "readonly", "identifier", CUSTOMER_KEY)) ? 1 : 0) != 0, (String)message);
        String customerId = CastUtils.toString((Object)partialDto.get(CUSTOMER_KEY));
        if (customerId != null) {
            this.checkCustomer(customerId, message);
        }
        if ((readonly = CastUtils.toBoolean((Object)partialDto.get("readonly"))) != null) {
            this.checkSetReadonly(readonly.booleanValue(), message);
        }
        if (partialDto.containsKey("code")) {
            this.checkCode(owner.getId(), CastUtils.toString((Object)partialDto.get("code")), message);
        }
        return owner;
    }

    @Transactional
    public OwnerDto patch(Map<String, Object> partialDto) {
        LOGGER.info("Patch {} with {}", (Object)this.getObjectName(), partialDto);
        return (OwnerDto)super.patch(partialDto);
    }

    protected void processPatch(Owner owner, Map<String, Object> partialDto) {
        ArrayList<EventDiffDto> logbooks = new ArrayList<EventDiffDto>();
        VitamContext vitamContext = this.securityService.buildVitamContext(this.securityService.getTenantIdentifier());
        if (vitamContext != null) {
            LOGGER.info("Patch Owner EvIdAppSession : {} ", (Object)vitamContext.getApplicationSessionId());
        }
        block19: for (Map.Entry<String, Object> entry : partialDto.entrySet()) {
            switch (entry.getKey()) {
                case "id": 
                case "readonly": 
                case "customerId": 
                case "identifier": {
                    continue block19;
                }
                case "name": {
                    logbooks.add(new EventDiffDto("Nom", (Object)owner.getName(), entry.getValue()));
                    owner.setName(CastUtils.toString((Object)entry.getValue()));
                    continue block19;
                }
                case "code": {
                    logbooks.add(new EventDiffDto("Code propri\u00e9taire", (Object)owner.getCode(), entry.getValue()));
                    owner.setCode(CastUtils.toString((Object)entry.getValue()));
                    continue block19;
                }
                case "companyName": {
                    logbooks.add(new EventDiffDto("Raison sociale", (Object)owner.getCompanyName(), entry.getValue()));
                    owner.setCompanyName(CastUtils.toString((Object)entry.getValue()));
                    continue block19;
                }
                case "internalCode": {
                    logbooks.add(new EventDiffDto("Code interne", (Object)owner.getInternalCode(), entry.getValue()));
                    owner.setInternalCode(CastUtils.toString((Object)entry.getValue()));
                    continue block19;
                }
                case "address": {
                    Address address;
                    if (owner.getAddress() == null) {
                        address = new Address();
                        owner.setAddress(address);
                    } else {
                        address = owner.getAddress();
                    }
                    this.addressService.processPatch(address, CastUtils.toMap((Object)entry.getValue()), logbooks, false);
                    continue block19;
                }
            }
            throw new IllegalArgumentException("Unable to patch owner " + owner.getId() + ": key " + entry.getKey() + " is not allowed");
        }
        this.iamLogbookService.updateOwnerEvent(owner, logbooks);
    }

    private Owner find(String id, String message) {
        Assert.isTrue((boolean)StringUtils.isNotEmpty((CharSequence)id), (String)(message + ": no id"));
        return (Owner)this.getRepository().findById((Object)id).orElseThrow(() -> new IllegalArgumentException(message + ": no owner found for id " + id));
    }

    private void checkSetReadonly(boolean readonly, String message) {
        Assert.isTrue((!readonly ? 1 : 0) != 0, (String)(message + ": readonly must be set to false"));
    }

    private void checkCustomer(String customerId, String message) {
        Optional customer = this.customerRepository.findById((Object)customerId);
        Assert.isTrue((boolean)customer.isPresent(), (String)(message + ": customer " + customerId + " does not exist"));
    }

    private void checkCode(String code, String message) {
        Optional optOwner = this.getRepository().findByCode(code);
        Assert.isTrue((boolean)optOwner.isEmpty(), (String)(message + ": a owner with code: " + code + " already exists."));
    }

    private void checkCode(String id, String code, String message) {
        Optional optOwner = this.getRepository().findByCode(code);
        optOwner.ifPresent(owner -> Assert.isTrue((boolean)StringUtils.equals((CharSequence)owner.getId(), (CharSequence)id), (String)(message + ": a owner with code: " + code + " already exists.")));
    }

    public LogbookOperationsCommonResponseDto findHistoryById(String id) throws VitamClientException {
        LOGGER.debug("findHistoryById for id {}", (Object)id);
        Integer tenantIdentifier = this.securityService.getTenantIdentifier();
        VitamContext vitamContext = new VitamContext(tenantIdentifier).setAccessContract(this.securityService.getTenant(tenantIdentifier).getAccessContractLogbookIdentifier()).setApplicationSessionId(this.securityService.getApplicationId());
        Optional owner = this.getRepository().findById((Object)id);
        owner.orElseThrow(() -> new NotFoundException("No owner found with id : %s".formatted(id)));
        LOGGER.info("Find History EvIdAppSession : {} ", (Object)vitamContext.getApplicationSessionId());
        JsonNode body = this.logbookService.findEventsByIdentifierAndCollectionNames(((Owner)owner.get()).getIdentifier(), "owners", vitamContext).toJsonNode();
        try {
            return (LogbookOperationsCommonResponseDto)JsonUtils.treeToValue((JsonNode)body, LogbookOperationsCommonResponseDto.class, (boolean)false);
        }
        catch (JsonProcessingException e) {
            throw new InternalServerException("Error while parsing Vitam response", (Throwable)e);
        }
    }

    private void checkIsReadonly(boolean readonly, String message) {
        Assert.isTrue((!readonly ? 1 : 0) != 0, (String)(message + ": readonly owner"));
    }

    public List<OwnerDto> findByCustomerId(String customerId) {
        return this.convertIterableToList((Iterable)this.ownerRepository.findByCustomerId(customerId));
    }

    protected OwnerRepository getRepository() {
        return this.ownerRepository;
    }

    protected Converter<OwnerDto, Owner> getConverter() {
        return this.ownerConverter;
    }

    protected String getObjectName() {
        return "owner";
    }

    protected Class<Owner> getEntityClass() {
        return Owner.class;
    }

    protected Collection<String> getAllowedKeys() {
        return List.of("id", "name", "code", "companyName", CUSTOMER_KEY);
    }

    protected Collection<String> getRestrictedKeys() {
        return Collections.emptyList();
    }

    protected String getVersionApiCriteria() {
        return "v2";
    }

    @Generated
    public OwnerRepository getOwnerRepository() {
        return this.ownerRepository;
    }

    @Generated
    public CustomerRepository getCustomerRepository() {
        return this.customerRepository;
    }

    @Generated
    public AddressService getAddressService() {
        return this.addressService;
    }

    @Generated
    public IamLogbookService getIamLogbookService() {
        return this.iamLogbookService;
    }

    @Generated
    public SecurityService getSecurityService() {
        return this.securityService;
    }

    @Generated
    public OwnerConverter getOwnerConverter() {
        return this.ownerConverter;
    }

    @Generated
    public LogbookService getLogbookService() {
        return this.logbookService;
    }

    @Generated
    public TenantRepository getTenantRepository() {
        return this.tenantRepository;
    }
}

