/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitamui.iam.server.idp.service;

import com.fasterxml.jackson.databind.ObjectMapper;
import fr.gouv.vitamui.common.security.SanityChecker;
import fr.gouv.vitamui.commons.api.ParameterChecker;
import fr.gouv.vitamui.commons.api.converter.Converter;
import fr.gouv.vitamui.commons.api.domain.IdDto;
import fr.gouv.vitamui.commons.api.exception.InvalidFormatException;
import fr.gouv.vitamui.commons.api.utils.CastUtils;
import fr.gouv.vitamui.commons.api.utils.EnumUtils;
import fr.gouv.vitamui.commons.logbook.dto.EventDiffDto;
import fr.gouv.vitamui.commons.mongo.service.SequenceGeneratorService;
import fr.gouv.vitamui.commons.utils.VitamUIUtils;
import fr.gouv.vitamui.iam.common.dto.IdentityProviderDto;
import fr.gouv.vitamui.iam.common.dto.common.ProviderEmbeddedOptions;
import fr.gouv.vitamui.iam.common.enums.AuthnRequestBindingEnum;
import fr.gouv.vitamui.iam.common.utils.IdentityProviderBuilder;
import fr.gouv.vitamui.iam.security.service.SecurityService;
import fr.gouv.vitamui.iam.server.customer.dao.CustomerRepository;
import fr.gouv.vitamui.iam.server.customer.domain.Customer;
import fr.gouv.vitamui.iam.server.domain.dto.ProviderPatchType;
import fr.gouv.vitamui.iam.server.idp.converter.IdentityProviderConverter;
import fr.gouv.vitamui.iam.server.idp.dao.IdentityProviderRepository;
import fr.gouv.vitamui.iam.server.idp.domain.IdentityProvider;
import fr.gouv.vitamui.iam.server.idp.service.IdentityProviderService;
import fr.gouv.vitamui.iam.server.idp.service.SpMetadataGenerator;
import fr.gouv.vitamui.iam.server.logbook.service.IamLogbookService;
import fr.gouv.vitamui.iam.server.security.AbstractResourceClientService;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.core.io.Resource;
import org.springframework.data.domain.Example;
import org.springframework.data.domain.ExampleMatcher;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.web.multipart.MultipartFile;

public class IdentityProviderService
extends AbstractResourceClientService<IdentityProviderDto, IdentityProvider> {
    private final IdentityProviderRepository identityProviderRepository;
    private final SpMetadataGenerator spMetadataGenerator;
    private final CustomerRepository customerRepository;
    private final IamLogbookService iamLogbookService;
    private final IdentityProviderConverter idpConverter;
    private static final String CUSTOMER = "customerId";
    private static final String AUTO_PROVISIONING_ENABLED = "autoProvisioningEnabled";
    private static final String READ_ONLY = "readonly";

    @Autowired
    public IdentityProviderService(SequenceGeneratorService sequenceGeneratorService, IdentityProviderRepository identityProviderRepository, SpMetadataGenerator spMetadataGenerator, CustomerRepository customerRepository, IamLogbookService iamLogbookService, IdentityProviderConverter idpConverter, SecurityService securityService) {
        super(sequenceGeneratorService, securityService);
        this.identityProviderRepository = identityProviderRepository;
        this.spMetadataGenerator = spMetadataGenerator;
        this.customerRepository = customerRepository;
        this.idpConverter = idpConverter;
        this.iamLogbookService = iamLogbookService;
    }

    protected void beforeCreate(IdentityProviderDto dto) {
        String message = "Unable to create identity provider " + dto.getName();
        this.checkSetReadonly(dto.isReadonly(), message);
        this.checkAndComputeTechnicalName(dto, message);
        this.checkCustomer(dto.getCustomerId(), message);
        super.checkIdentifier(dto.getIdentifier(), message);
        this.checkEmailPatterns(dto.getPatterns(), message);
        if (Boolean.TRUE.equals(dto.getInternal())) {
            this.checkIdendityProviderInternUniqueByCustomer(dto.getCustomerId(), message);
            this.checkAutoUpdateUsersDisabledForInternalProvider(dto.isAutoProvisioningEnabled());
        }
        dto.setIdentifier(this.getNextSequenceId("providerIdentifier"));
    }

    private void checkEmailPatterns(List<String> patterns, String message) {
        HashSet elements = new HashSet();
        List duplicatesDomains = patterns.stream().filter(n -> !elements.add(n)).collect(Collectors.toList());
        Assert.isTrue((boolean)CollectionUtils.isEmpty(duplicatesDomains), (String)(message + ":Duplicate pattern found " + String.join((CharSequence)",", duplicatesDomains)));
    }

    protected void beforeUpdate(IdentityProviderDto dto) {
        IdentityProvider idp = this.find(dto.getId(), "Unable to update identity provider");
        String message = "Unable to update identity provider " + dto.getId();
        this.checkIsReadonly(idp.isReadonly(), message);
        this.checkSetReadonly(dto.isReadonly(), message);
        this.checkCustomer(dto.getCustomerId(), message);
        this.checkEmailPatterns(dto.getPatterns(), message);
        if (Boolean.TRUE.equals(dto.getInternal())) {
            this.checkIdendityProviderInternUniqueByCustomer(dto.getCustomerId(), message);
            this.checkAutoUpdateUsersDisabledForInternalProvider(dto.isAutoProvisioningEnabled());
        }
        if (StringUtils.isBlank((CharSequence)dto.getTechnicalName())) {
            throw new IllegalArgumentException(message + ": technical name must not be blank at update");
        }
    }

    protected IdentityProvider beforePatch(Map<String, Object> partialDto) {
        Boolean readonly;
        String id = CastUtils.toString((Object)partialDto.get("id"));
        String message = "Unable to patch identity provider " + id;
        IdentityProvider idp = this.find(id, message);
        this.checkIsReadonly(idp.isReadonly(), message);
        Assert.isTrue((!this.checkMapContainsOnlyFieldsUnmodifiable(partialDto, Arrays.asList("id", CUSTOMER, READ_ONLY, "identifier")) ? 1 : 0) != 0, (String)message);
        String customerId = CastUtils.toString((Object)partialDto.get(CUSTOMER));
        if (customerId != null) {
            this.checkCustomer(customerId, message);
        }
        if ((readonly = CastUtils.toBoolean((Object)partialDto.get(READ_ONLY))) != null) {
            this.checkSetReadonly(readonly.booleanValue(), message);
        }
        boolean autoProvisioningEnabled = false;
        Boolean internal = (Boolean)partialDto.get("internal");
        if (partialDto.get(AUTO_PROVISIONING_ENABLED) != null) {
            autoProvisioningEnabled = (Boolean)partialDto.get(AUTO_PROVISIONING_ENABLED);
        }
        if (Boolean.TRUE.equals(internal)) {
            this.checkIdendityProviderInternUniqueByCustomer(idp.getCustomerId(), message);
            this.checkAutoUpdateUsersDisabledForInternalProvider(autoProvisioningEnabled);
        }
        return idp;
    }

    protected void beforePatch(Map<String, Object> partialDto, MultipartFile keystore, MultipartFile idpMetadata, String id, ProviderPatchType patchType) {
        Assert.isTrue((boolean)StringUtils.equals((CharSequence)id, (CharSequence)((String)partialDto.get("id"))), (String)"The DTO identifier must match the path identifier for patch.");
        switch (1.$SwitchMap$fr$gouv$vitamui$iam$server$domain$dto$ProviderPatchType[patchType.ordinal()]) {
            case 1: {
                Assert.isTrue((StringUtils.isNotEmpty((CharSequence)((String)partialDto.get("keystorePassword"))) && !keystore.isEmpty() ? 1 : 0) != 0, (String)"The keystorePassword is missing");
                break;
            }
            case 2: {
                Assert.isTrue((!idpMetadata.isEmpty() ? 1 : 0) != 0, (String)"idpMetadata is missing");
                break;
            }
        }
    }

    public IdentityProviderDto patch(Map<String, Object> partialDto, MultipartFile keystore, MultipartFile idpMetadata, String id, ProviderPatchType patchType) {
        this.beforePatch(partialDto, keystore, idpMetadata, id, patchType);
        switch (1.$SwitchMap$fr$gouv$vitamui$iam$server$domain$dto$ProviderPatchType[patchType.ordinal()]) {
            case 1: {
                String keystoreBase64 = this.getKeystoreBase64(keystore);
                partialDto.put("keystoreBase64", keystoreBase64);
                break;
            }
            case 2: {
                String idpMetadataFormatter = this.getIdpMetadata(idpMetadata);
                partialDto.put("idpMetadata", idpMetadataFormatter);
                break;
            }
        }
        return this.convertDtoFromApi((IdentityProviderDto)super.patch(partialDto));
    }

    private String getIdpMetadata(MultipartFile idpMetadata) {
        String string;
        block8: {
            InputStream isIdpMeta = idpMetadata.getInputStream();
            try {
                string = IOUtils.toString((InputStream)isIdpMeta);
                if (isIdpMeta == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (isIdpMeta != null) {
                        try {
                            isIdpMeta.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new InvalidFormatException("IdpMetadata is unreadable");
                }
            }
            isIdpMeta.close();
        }
        return string;
    }

    protected IdentityProviderDto convertDtoFromApi(IdentityProviderDto apiDto) {
        IdentityProviderDto dto = new IdentityProviderDto();
        VitamUIUtils.copyProperties((Object)apiDto, (Object)dto);
        this.convertPatterns(dto);
        return dto;
    }

    private void convertPatterns(IdentityProviderDto dto) {
        if (CollectionUtils.isNotEmpty((Collection)dto.getPatterns())) {
            dto.setPatterns(dto.getPatterns().stream().map(s -> s.replace(".*@", "")).collect(Collectors.toList()));
        }
    }

    private String getKeystoreBase64(MultipartFile keystoreFile) {
        String string;
        block8: {
            InputStream isKeystore = keystoreFile.getInputStream();
            try {
                byte[] keystore = IOUtils.toByteArray((InputStream)isKeystore);
                string = new String(Base64.getEncoder().encode(keystore), StandardCharsets.UTF_8);
                if (isKeystore == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (isKeystore != null) {
                        try {
                            isKeystore.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new InvalidFormatException("Keystore is unreadable");
                }
            }
            isKeystore.close();
        }
        return string;
    }

    @Transactional
    public IdentityProviderDto create(IdentityProviderDto dto) {
        IdentityProviderDto idpCreated = (IdentityProviderDto)super.create((IdDto)dto);
        this.iamLogbookService.createIdpEvent(idpCreated);
        return idpCreated;
    }

    @Transactional
    public IdentityProviderDto patch(Map<String, Object> partialDto) {
        return (IdentityProviderDto)super.patch(partialDto);
    }

    protected void processPatch(IdentityProvider entity, Map<String, Object> partialDto) {
        boolean generateMetadata = false;
        ArrayList<EventDiffDto> logbooks = new ArrayList<EventDiffDto>();
        block61: for (Map.Entry<String, Object> entry : partialDto.entrySet()) {
            switch (entry.getKey()) {
                case "id": 
                case "readonly": 
                case "customerId": 
                case "identifier": {
                    continue block61;
                }
                case "name": {
                    logbooks.add(new EventDiffDto("Nom", (Object)entity.getName(), entry.getValue()));
                    entity.setName(CastUtils.toString((Object)entry.getValue()));
                    continue block61;
                }
                case "internal": {
                    logbooks.add(new EventDiffDto("Type", (Object)entity.getInternal(), entry.getValue()));
                    entity.setInternal(CastUtils.toBoolean((Object)entry.getValue()));
                    continue block61;
                }
                case "enabled": {
                    logbooks.add(new EventDiffDto("Statut", (Object)entity.getEnabled(), entry.getValue()));
                    entity.setEnabled(CastUtils.toBoolean((Object)entry.getValue()));
                    continue block61;
                }
                case "patterns": {
                    List patterns = CastUtils.toList((Object)entry.getValue());
                    logbooks.add(new EventDiffDto("Pattern", (Object)entity.getPatterns(), (Object)patterns));
                    if (patterns.isEmpty()) {
                        entity.setPatterns(null);
                        continue block61;
                    }
                    patterns = patterns.stream().map(s -> s.startsWith(".*@") ? s : ".*@" + s).collect(Collectors.toList());
                    entity.setPatterns(patterns);
                    continue block61;
                }
                case "mailAttribute": {
                    logbooks.add(new EventDiffDto("Attribut mail", (Object)"", (Object)""));
                    entity.setMailAttribute(CastUtils.toString((Object)entry.getValue()));
                    continue block61;
                }
                case "identifierAttribute": {
                    logbooks.add(new EventDiffDto("Attribut identifier", (Object)"", (Object)""));
                    entity.setIdentifierAttribute(CastUtils.toString((Object)entry.getValue()));
                    continue block61;
                }
                case "autoProvisioningEnabled": {
                    logbooks.add(new EventDiffDto("Mise \u00e0 jour automatique des utilisateurs", (Object)entity.isAutoProvisioningEnabled(), entry.getValue()));
                    entity.setAutoProvisioningEnabled(CastUtils.toBoolean((Object)entry.getValue()).booleanValue());
                    continue block61;
                }
                case "keystoreBase64": {
                    logbooks.add(new EventDiffDto("Keystore", (Object)"", (Object)""));
                    entity.setKeystoreBase64(CastUtils.toString((Object)entry.getValue()));
                    generateMetadata = true;
                    continue block61;
                }
                case "keystorePassword": {
                    logbooks.add(new EventDiffDto("Mot de passe du keystore", (Object)"", (Object)""));
                    String keypwd = CastUtils.toString((Object)entry.getValue());
                    entity.setKeystorePassword(keypwd);
                    entity.setPrivateKeyPassword(keypwd);
                    generateMetadata = true;
                    continue block61;
                }
                case "idpMetadata": {
                    logbooks.add(new EventDiffDto("Idp Metadata", (Object)"", (Object)""));
                    entity.setIdpMetadata(CastUtils.toString((Object)entry.getValue()));
                    generateMetadata = true;
                    continue block61;
                }
                case "spMetadata": {
                    logbooks.add(new EventDiffDto("Sp metadata", (Object)"", (Object)""));
                    entity.setSpMetadata(CastUtils.toString((Object)entry.getValue()));
                    continue block61;
                }
                case "maximumAuthenticationLifetime": {
                    Integer maximumAuthenticationLifeTime = CastUtils.toInteger((Object)entry.getValue());
                    logbooks.add(new EventDiffDto("Temps maximum de connexion", (Object)entity.getMaximumAuthenticationLifetime(), (Object)maximumAuthenticationLifeTime));
                    entity.setMaximumAuthenticationLifetime(maximumAuthenticationLifeTime);
                    continue block61;
                }
                case "authnRequestBinding": {
                    String authnRequestBindingAsString = CastUtils.toString((Object)entry.getValue());
                    AuthnRequestBindingEnum newAuthnRequestBinding = (AuthnRequestBindingEnum)EnumUtils.stringToEnum(AuthnRequestBindingEnum.class, (String)authnRequestBindingAsString);
                    logbooks.add(new EventDiffDto("Authentication request binding", (Object)entity.getAuthnRequestBinding(), (Object)newAuthnRequestBinding));
                    entity.setAuthnRequestBinding(newAuthnRequestBinding);
                    continue block61;
                }
                case "clientId": {
                    logbooks.add(new EventDiffDto("Identifiant client", (Object)entity.getClientId(), entry.getValue()));
                    entity.setClientId(CastUtils.toString((Object)entry.getValue()));
                    continue block61;
                }
                case "clientSecret": {
                    logbooks.add(new EventDiffDto("Secret client", (Object)"", (Object)""));
                    entity.setClientSecret(CastUtils.toString((Object)entry.getValue()));
                    continue block61;
                }
                case "discoveryUrl": {
                    logbooks.add(new EventDiffDto("URL de d\u00e9couverte des metadata", (Object)entity.getDiscoveryUrl(), entry.getValue()));
                    entity.setDiscoveryUrl(CastUtils.toString((Object)entry.getValue()));
                    continue block61;
                }
                case "scope": {
                    logbooks.add(new EventDiffDto("P\u00e9rim\u00e8tre", (Object)entity.getScope(), entry.getValue()));
                    entity.setScope(CastUtils.toString((Object)entry.getValue()));
                    continue block61;
                }
                case "preferredJwsAlgorithm": {
                    logbooks.add(new EventDiffDto("Algorithme JWS pr\u00e9f\u00e9r\u00e9", (Object)entity.getPreferredJwsAlgorithm(), entry.getValue()));
                    entity.setPreferredJwsAlgorithm(CastUtils.toString((Object)entry.getValue()));
                    continue block61;
                }
                case "customParams": {
                    Map customParams = CastUtils.toMap((Object)entry.getValue());
                    logbooks.add(new EventDiffDto("Param\u00e8tres sp\u00e9cifiques", (Object)entity.getCustomParams(), (Object)customParams));
                    entity.setCustomParams(customParams);
                    continue block61;
                }
                case "useState": {
                    logbooks.add(new EventDiffDto("Avec state", (Object)entity.getUseState(), entry.getValue()));
                    entity.setUseState(CastUtils.toBoolean((Object)entry.getValue()));
                    continue block61;
                }
                case "useNonce": {
                    logbooks.add(new EventDiffDto("Avec nonce", (Object)entity.getUseNonce(), entry.getValue()));
                    entity.setUseNonce(CastUtils.toBoolean((Object)entry.getValue()));
                    continue block61;
                }
                case "usePkce": {
                    logbooks.add(new EventDiffDto("Avec PKCE", (Object)entity.getUsePkce(), entry.getValue()));
                    entity.setUsePkce(CastUtils.toBoolean((Object)entry.getValue()));
                    continue block61;
                }
                case "protocoleType": {
                    logbooks.add(new EventDiffDto("Protocole Type", (Object)entity.getProtocoleType(), entry.getValue()));
                    entity.setProtocoleType(CastUtils.toString((Object)entry.getValue()));
                    continue block61;
                }
                case "authnRequestSigned": {
                    logbooks.add(new EventDiffDto("Requ\u00eate d'authentification sign\u00e9e", (Object)entity.getAuthnRequestSigned(), entry.getValue()));
                    entity.setAuthnRequestSigned(CastUtils.toBoolean((Object)entry.getValue()));
                    generateMetadata = true;
                    continue block61;
                }
                case "propagateLogout": {
                    logbooks.add(new EventDiffDto("D\u00e9connexion propag\u00e9e", (Object)entity.isPropagateLogout(), entry.getValue()));
                    entity.setPropagateLogout(CastUtils.toBoolean((Object)entry.getValue()).booleanValue());
                    generateMetadata = true;
                    continue block61;
                }
                case "wantsAssertionsSigned": {
                    logbooks.add(new EventDiffDto("Assertions sign\u00e9es", (Object)entity.getWantsAssertionsSigned(), entry.getValue()));
                    entity.setWantsAssertionsSigned(CastUtils.toBoolean((Object)entry.getValue()));
                    generateMetadata = true;
                    continue block61;
                }
            }
            throw new IllegalArgumentException("Unable to patch provider " + entity.getId() + ": key " + entry.getKey() + " is not allowed");
        }
        if (generateMetadata) {
            entity.setSpMetadata(this.generateMetaData(entity));
            logbooks.add(new EventDiffDto("Sp metadata", (Object)"", (Object)""));
        }
        this.iamLogbookService.updateIdpEvent(entity, logbooks);
    }

    private IdentityProvider find(String id, String message) {
        Assert.isTrue((boolean)StringUtils.isNotEmpty((CharSequence)id), (String)(message + ": no id"));
        return (IdentityProvider)this.getRepository().findById((Object)id).orElseThrow(() -> new IllegalArgumentException(message + ": no provider found for id " + id));
    }

    private void checkAndComputeTechnicalName(IdentityProviderDto dto, String message) {
        Assert.isNull((Object)dto.getTechnicalName(), (String)(message + ": technical name must be null at creation"));
        dto.setTechnicalName(this.idpConverter.buildTechnicalName(dto.getName()));
    }

    private void checkIdendityProviderInternUniqueByCustomer(String customerId, String message) {
        IdentityProvider example = new IdentityProvider();
        example.setCustomerId(customerId);
        example.setInternal(Boolean.valueOf(true));
        Example idp = Example.of((Object)example, (ExampleMatcher)ExampleMatcher.matching().withIgnoreNullValues());
        boolean exists = this.identityProviderRepository.exists(idp);
        Assert.isTrue((!exists ? 1 : 0) != 0, (String)(message + ": the customer: " + customerId + " has already an identityProvider internal."));
    }

    private void checkAutoUpdateUsersDisabledForInternalProvider(boolean autoProvisioningEnabled) {
        if (autoProvisioningEnabled) {
            throw new IllegalArgumentException("autoProvisioningEnabled cannot be true for an internal provider");
        }
    }

    private void checkCustomer(String customerId, String message) {
        Optional customer = this.customerRepository.findById((Object)customerId);
        Assert.isTrue((boolean)customer.isPresent(), (String)(message + ": customer " + customerId + " does not exist"));
    }

    private void checkSetReadonly(boolean readonly, String message) {
        Assert.isTrue((!readonly ? 1 : 0) != 0, (String)(message + ": readonly must be set to false"));
    }

    private void checkIsReadonly(boolean readonly, String message) {
        Assert.isTrue((!readonly ? 1 : 0) != 0, (String)(message + ": readonly provider"));
    }

    protected void loadExtraInformation(IdentityProviderDto dto, Optional<String> embeddedList) {
        String keystore = dto.getKeystoreBase64();
        dto.setKeystoreBase64(null);
        String idpMetadata = dto.getIdpMetadata();
        dto.setIdpMetadata(null);
        if (embeddedList.isPresent()) {
            String[] arrayEmbedded;
            EnumUtils.checkValidEnum(ProviderEmbeddedOptions.class, embeddedList);
            block4: for (String embedded : arrayEmbedded = embeddedList.get().split(",")) {
                ProviderEmbeddedOptions embeddedEnum = ProviderEmbeddedOptions.valueOf((String)embedded.toUpperCase());
                switch (1.$SwitchMap$fr$gouv$vitamui$iam$common$dto$common$ProviderEmbeddedOptions[embeddedEnum.ordinal()]) {
                    case 1: {
                        dto.setKeystoreBase64(keystore);
                        continue block4;
                    }
                    case 2: {
                        dto.setIdpMetadata(idpMetadata);
                        continue block4;
                    }
                }
            }
        }
    }

    public List<String> getDomainsNotAssigned(String customerId) {
        ArrayList<String> filterDomains = new ArrayList<String>();
        List idp = this.identityProviderRepository.findAll(new CriteriaDefinition[]{Criteria.where((String)CUSTOMER).is((Object)customerId)});
        if (idp != null && !idp.isEmpty()) {
            for (IdentityProvider i : idp) {
                filterDomains.addAll(i.getPatterns().stream().map(s -> s.replace(".*@", "")).toList());
            }
        }
        Customer customer = (Customer)this.customerRepository.findById((Object)customerId).orElseThrow(() -> new IllegalArgumentException("no customer found for " + customerId));
        List availablesDomains = customer.getEmailDomains();
        if (CollectionUtils.isNotEmpty((Collection)idp)) {
            availablesDomains = availablesDomains.stream().filter(s -> !filterDomains.contains(s)).collect(Collectors.toList());
        }
        return availablesDomains;
    }

    private String generateMetaData(IdentityProvider provider) {
        IdentityProviderDto dto = new IdentityProviderDto();
        dto.setName(provider.getName());
        dto.setIdentifier(provider.getIdentifier());
        dto.setKeystoreBase64(provider.getKeystoreBase64());
        dto.setPrivateKeyPassword(provider.getPrivateKeyPassword());
        dto.setKeystorePassword(provider.getKeystorePassword());
        dto.setIdpMetadata(provider.getIdpMetadata());
        dto.setTechnicalName(provider.getTechnicalName());
        dto.setWantsAssertionsSigned(provider.getWantsAssertionsSigned());
        dto.setAuthnRequestSigned(provider.getAuthnRequestSigned());
        dto.setPropagateLogout(provider.isPropagateLogout());
        dto.setMaximumAuthenticationLifetime(provider.getMaximumAuthenticationLifetime());
        return this.spMetadataGenerator.generate(dto);
    }

    protected IdentityProviderRepository getRepository() {
        return this.identityProviderRepository;
    }

    protected String getObjectName() {
        return "provider";
    }

    protected Converter<IdentityProviderDto, IdentityProvider> getConverter() {
        return this.idpConverter;
    }

    protected Class<IdentityProvider> getEntityClass() {
        return IdentityProvider.class;
    }

    public Resource getMetadataProviderByProviderId(String id, ProviderEmbeddedOptions option, Optional<String> embedded) {
        ParameterChecker.checkParameter((String)"Identifier is mandatory : ", (String[])new String[]{id});
        SanityChecker.checkSecureParameter((String[])new String[]{id});
        IdentityProviderDto dto = (IdentityProviderDto)this.getOne(id, Optional.empty(), embedded);
        return new ByteArrayResource(ProviderEmbeddedOptions.IDPMETADATA.equals((Object)option) ? dto.getIdpMetadata().getBytes() : dto.getSpMetadata().getBytes());
    }

    public IdentityProviderDto mapToIdentityProviderDto(MultipartFile keystore, MultipartFile idpMetadata, String provider) throws Exception {
        IdentityProviderDto dto = (IdentityProviderDto)new ObjectMapper().readValue(provider, IdentityProviderDto.class);
        IdentityProviderBuilder builder = new IdentityProviderBuilder(dto.getName(), dto.getTechnicalName(), dto.getEnabled(), dto.getInternal(), dto.getPatterns(), (Resource)(Objects.nonNull(keystore) ? new ByteArrayResource(keystore.getBytes()) : null), dto.getKeystorePassword(), dto.getPrivateKeyPassword(), (Resource)(Objects.nonNull(idpMetadata) ? new ByteArrayResource(idpMetadata.getBytes()) : null), dto.getCustomerId(), Boolean.valueOf(dto.isReadonly()), dto.getMailAttribute(), dto.getIdentifierAttribute(), dto.getMaximumAuthenticationLifetime(), dto.getAuthnRequestBinding(), Boolean.valueOf(Objects.isNull(dto.getWantsAssertionsSigned()) ? true : dto.getWantsAssertionsSigned()), Boolean.valueOf(Objects.isNull(dto.getAuthnRequestSigned()) ? true : dto.getAuthnRequestSigned()), dto.isPropagateLogout(), Boolean.valueOf(dto.isAutoProvisioningEnabled()), dto.getClientId(), dto.getClientSecret(), dto.getDiscoveryUrl(), dto.getScope(), dto.getPreferredJwsAlgorithm(), dto.getCustomParams(), dto.getUseState(), dto.getUseNonce(), dto.getUsePkce(), dto.getProtocoleType());
        return builder.build();
    }

    protected Collection<String> getAllowedKeys() {
        return List.of("id", "name", "internal", "enabled", "patterns", CUSTOMER);
    }

    protected Collection<String> getRestrictedKeys() {
        return Collections.emptyList();
    }

    protected String getVersionApiCriteria() {
        return "v2";
    }

    @Generated
    public IdentityProviderRepository getIdentityProviderRepository() {
        return this.identityProviderRepository;
    }

    @Generated
    public SpMetadataGenerator getSpMetadataGenerator() {
        return this.spMetadataGenerator;
    }

    @Generated
    public CustomerRepository getCustomerRepository() {
        return this.customerRepository;
    }

    @Generated
    public IamLogbookService getIamLogbookService() {
        return this.iamLogbookService;
    }

    @Generated
    public IdentityProviderConverter getIdpConverter() {
        return this.idpConverter;
    }
}

