/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitamui.iam.server.externalParameters.converter;

import fr.gouv.vitamui.commons.api.converter.Converter;
import fr.gouv.vitamui.commons.api.domain.ExternalParametersDto;
import fr.gouv.vitamui.commons.api.domain.ParameterDto;
import fr.gouv.vitamui.commons.api.utils.ApiUtils;
import fr.gouv.vitamui.commons.logbook.util.LogbookUtils;
import fr.gouv.vitamui.commons.utils.VitamUIUtils;
import fr.gouv.vitamui.iam.server.common.domain.Parameter;
import fr.gouv.vitamui.iam.server.externalParameters.domain.ExternalParameters;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.stream.Collectors;

public class ExternalParametersConverter
implements Converter<ExternalParametersDto, ExternalParameters> {
    public static final String ID_KEY = "Id";
    public static final String IDENTIFIER_KEY = "Identifiant";
    public static final String NAME_KEY = "Nom";
    public static final String PARAMETERS_KEY = "Param\u00e8tres";
    public static final String PARAMETER_KEY = "Cl\u00e9";
    public static final String PARAMETER_VALUE_KEY = "Valeur";

    public String convertToLogbook(ExternalParametersDto dto) {
        LinkedHashMap<String, String> logbookData = new LinkedHashMap<String, String>();
        logbookData.put(ID_KEY, LogbookUtils.getValue((Object)dto.getId()));
        logbookData.put(IDENTIFIER_KEY, LogbookUtils.getValue((Object)dto.getIdentifier()));
        logbookData.put(NAME_KEY, LogbookUtils.getValue((Object)dto.getName()));
        logbookData.put(PARAMETERS_KEY, this.convertParametersToLogbook((Collection)dto.getParameters()));
        return ApiUtils.toJson(logbookData);
    }

    public ExternalParameters convertDtoToEntity(ExternalParametersDto dto) {
        ExternalParameters externalParameters = (ExternalParameters)VitamUIUtils.copyProperties((Object)dto, (Object)new ExternalParameters());
        if (dto.getParameters() != null) {
            externalParameters.setParameters(dto.getParameters().stream().map(parameterDto -> (Parameter)VitamUIUtils.copyProperties((Object)parameterDto, (Object)new Parameter())).collect(Collectors.toList()));
        }
        return externalParameters;
    }

    public ExternalParametersDto convertEntityToDto(ExternalParameters externalParameters) {
        ExternalParametersDto dto = (ExternalParametersDto)VitamUIUtils.copyProperties((Object)externalParameters, (Object)new ExternalParametersDto());
        if (externalParameters.getParameters() != null) {
            dto.setParameters(externalParameters.getParameters().stream().map(parameter -> (ParameterDto)VitamUIUtils.copyProperties((Object)parameter, (Object)new ParameterDto())).collect(Collectors.toList()));
        }
        return dto;
    }

    public String convertParametersToLogbook(Collection<ParameterDto> parameterDtos) {
        List parameters = parameterDtos.stream().map(ApiUtils::toJson).collect(Collectors.toList());
        return parameters.toString();
    }
}

