/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitamui.iam.server.customer.service;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import fr.gouv.vitam.common.client.VitamContext;
import fr.gouv.vitam.common.exception.VitamClientException;
import fr.gouv.vitamui.commons.api.converter.Converter;
import fr.gouv.vitamui.commons.api.domain.BaseIdDocument;
import fr.gouv.vitamui.commons.api.domain.IdDto;
import fr.gouv.vitamui.commons.api.domain.OwnerDto;
import fr.gouv.vitamui.commons.api.enums.AttachmentType;
import fr.gouv.vitamui.commons.api.exception.InternalServerException;
import fr.gouv.vitamui.commons.api.exception.InvalidFormatException;
import fr.gouv.vitamui.commons.api.exception.NotFoundException;
import fr.gouv.vitamui.commons.api.utils.CastUtils;
import fr.gouv.vitamui.commons.api.utils.EnumUtils;
import fr.gouv.vitamui.commons.logbook.dto.EventDiffDto;
import fr.gouv.vitamui.commons.mongo.service.SequenceGeneratorService;
import fr.gouv.vitamui.commons.utils.JsonUtils;
import fr.gouv.vitamui.commons.utils.VitamUIUtils;
import fr.gouv.vitamui.commons.vitam.api.access.LogbookService;
import fr.gouv.vitamui.commons.vitam.api.dto.LogbookOperationsCommonResponseDto;
import fr.gouv.vitamui.iam.common.dto.CustomerCreationFormData;
import fr.gouv.vitamui.iam.common.dto.CustomerDto;
import fr.gouv.vitamui.iam.common.dto.CustomerPatchFormData;
import fr.gouv.vitamui.iam.common.enums.OtpEnum;
import fr.gouv.vitamui.iam.security.service.SecurityService;
import fr.gouv.vitamui.iam.server.common.domain.Address;
import fr.gouv.vitamui.iam.server.common.service.AddressService;
import fr.gouv.vitamui.iam.server.customer.converter.CustomerConverter;
import fr.gouv.vitamui.iam.server.customer.dao.CustomerRepository;
import fr.gouv.vitamui.iam.server.customer.domain.Customer;
import fr.gouv.vitamui.iam.server.customer.service.CustomerService;
import fr.gouv.vitamui.iam.server.customer.service.InitCustomerService;
import fr.gouv.vitamui.iam.server.logbook.service.IamLogbookService;
import fr.gouv.vitamui.iam.server.owner.service.OwnerService;
import fr.gouv.vitamui.iam.server.security.AbstractResourceClientService;
import fr.gouv.vitamui.iam.server.user.service.UserService;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.NotImplementedException;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.core.io.Resource;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.MultiValueMap;
import org.springframework.web.multipart.MultipartFile;

public class CustomerService
extends AbstractResourceClientService<CustomerDto, Customer> {
    private static final Logger LOGGER = LoggerFactory.getLogger(CustomerService.class);
    @Value(value="${gdpr_alert_readonly:true}")
    private boolean gdprAlertReadonly;
    private final CustomerRepository customerRepository;
    private final OwnerService ownerService;
    private final UserService userService;
    private final SecurityService securityService;
    private final AddressService addressService;
    private final InitCustomerService initCustomerService;
    private final IamLogbookService iamLogbookService;
    private final CustomerConverter customerConverter;
    private final LogbookService logbookService;

    @Autowired
    public CustomerService(SequenceGeneratorService sequenceGeneratorService, CustomerRepository customerRepository, OwnerService ownerService, UserService userService, SecurityService securityService, AddressService addressService, InitCustomerService initCustomerService, IamLogbookService iamLogbookService, CustomerConverter customerConverter, LogbookService logbookService) {
        super(sequenceGeneratorService, securityService);
        this.customerRepository = customerRepository;
        this.ownerService = ownerService;
        this.userService = userService;
        this.securityService = securityService;
        this.addressService = addressService;
        this.initCustomerService = initCustomerService;
        this.iamLogbookService = iamLogbookService;
        this.customerConverter = customerConverter;
        this.logbookService = logbookService;
    }

    protected void beforeCreate(CustomerDto customerDto) {
        String message = "Unable to create customer " + customerDto.getName();
        this.checkCode(Optional.empty(), customerDto.getCode());
        this.checkEmailDomains(customerDto.getEmailDomains(), message);
        this.checkDefaultEmailDomains(customerDto.getDefaultEmailDomain(), customerDto.getEmailDomains(), message);
        this.checkOwners(customerDto.getOwners(), message);
        super.checkIdentifier(customerDto.getIdentifier(), message);
        customerDto.setSubrogeable(true);
        customerDto.setIdentifier(this.getNextSequenceId("customerIdentifier"));
    }

    @Transactional
    public CustomerDto create(CustomerDto customerDto) {
        throw new NotImplementedException("Method is not implemented");
    }

    @Transactional
    public CustomerDto create(CustomerCreationFormData customerData) {
        CustomerDto createdCustomerDto = null;
        CustomerDto dto = customerData.getCustomerDto();
        LOGGER.debug("Create {} with {}", (Object)this.getObjectName(), (Object)dto);
        Assert.isNull((Object)dto.getId(), (String)"The DTO identifier must be null for creation.");
        Assert.isTrue((boolean)StringUtils.isNotBlank((CharSequence)customerData.getTenantName()), (String)"Tenant name is mandatory");
        this.beforeCreate(dto);
        dto.setId(this.generateSuperId());
        Customer entity = (Customer)this.convertFromDtoToEntity((IdDto)dto);
        CustomerPatchFormData patchFormCustomer = new CustomerPatchFormData();
        patchFormCustomer.setHeader(customerData.getHeader());
        patchFormCustomer.setFooter(customerData.getFooter());
        patchFormCustomer.setPortal(customerData.getPortal());
        this.processGraphicIdentity(dto.isHasCustomGraphicIdentity(), entity, patchFormCustomer);
        this.beforeCreate((BaseIdDocument)entity);
        createdCustomerDto = (CustomerDto)this.convertFromEntityToDto((BaseIdDocument)((Customer)this.getRepository().save((Object)entity)));
        this.iamLogbookService.createCustomerEvent(dto);
        this.initCustomerService.initCustomer(customerData.getTenantId(), customerData.getTenantName(), createdCustomerDto, dto.getOwners());
        return createdCustomerDto;
    }

    protected void beforeUpdate(CustomerDto dto) {
        Customer customer = this.find(dto.getId(), "Unable to update customer");
        String message = "Unable to update customer " + dto.getName();
        this.checkCode(Optional.of(dto.getId()), dto.getCode());
        this.checkEmailDomains(dto.getEmailDomains(), customer.getId(), message);
        this.checkDefaultEmailDomains(dto.getDefaultEmailDomain(), dto.getEmailDomains(), message);
    }

    public CustomerDto update(CustomerDto dto) {
        CustomerDto updatedCustomerDto = (CustomerDto)super.update((IdDto)dto);
        this.updateOtpforUsers(dto.getOtp(), updatedCustomerDto.getOtp(), updatedCustomerDto.getId());
        return updatedCustomerDto;
    }

    private void updateOtpforUsers(OtpEnum oldOtp, OtpEnum newOtp, String customerId) {
        if (oldOtp != newOtp && newOtp != OtpEnum.OPTIONAL) {
            this.userService.updateOtpForUsersByCustomerId(newOtp == OtpEnum.MANDATORY, customerId);
        }
    }

    protected Customer beforePatch(Map<String, Object> partialDto) {
        String id = CastUtils.toString((Object)partialDto.get("id"));
        Customer customer = this.find(id, "Unable to patch customer");
        String message = "Unable to patch customer " + id;
        Assert.isTrue((!this.checkMapContainsOnlyFieldsUnmodifiable(partialDto, Arrays.asList("id", "readonly", "identifier")) ? 1 : 0) != 0, (String)message);
        String code = CastUtils.toString((Object)partialDto.get("code"));
        if (code != null) {
            this.checkCode(Optional.of(customer.getId()), code);
        }
        List emailDomains = CastUtils.toList((Object)partialDto.get("emailDomains"));
        String defaultEmailDomain = CastUtils.toString((Object)partialDto.get("defaultEmailDomain"));
        if (emailDomains != null) {
            this.checkEmailDomains(emailDomains, id, message);
        }
        String domain = defaultEmailDomain == null ? customer.getDefaultEmailDomain() : defaultEmailDomain;
        List domains = emailDomains == null ? customer.getEmailDomains() : emailDomains;
        this.checkDefaultEmailDomains(domain, domains, message);
        return customer;
    }

    protected void processPatch(Customer customer, CustomerPatchFormData customerFormData) {
        ArrayList<EventDiffDto> logbooks = new ArrayList<EventDiffDto>();
        VitamContext vitamContext = this.securityService.buildVitamContext(this.securityService.getTenantIdentifier());
        if (vitamContext != null) {
            LOGGER.debug("Patching Customer EvIdAppSession : {} ", (Object)vitamContext.getApplicationSessionId());
        }
        block44: for (Map.Entry entry : customerFormData.getPartialCustomerDto().entrySet()) {
            switch ((String)entry.getKey()) {
                case "id": 
                case "readonly": 
                case "identifier": {
                    continue block44;
                }
                case "code": {
                    logbooks.add(new EventDiffDto("Code client", (Object)customer.getCode(), entry.getValue()));
                    customer.setCode(CastUtils.toString(entry.getValue()));
                    continue block44;
                }
                case "name": {
                    logbooks.add(new EventDiffDto("Nom", (Object)customer.getName(), entry.getValue()));
                    customer.setName(CastUtils.toString(entry.getValue()));
                    continue block44;
                }
                case "companyName": {
                    logbooks.add(new EventDiffDto("Raison sociale", (Object)customer.getCompanyName(), entry.getValue()));
                    customer.setCompanyName(CastUtils.toString(entry.getValue()));
                    continue block44;
                }
                case "enabled": {
                    logbooks.add(new EventDiffDto("Activ\u00e9", (Object)customer.isEnabled(), entry.getValue()));
                    customer.setEnabled(CastUtils.toBoolean(entry.getValue()).booleanValue());
                    continue block44;
                }
                case "language": {
                    logbooks.add(new EventDiffDto("Langue", (Object)customer.getLanguage(), entry.getValue()));
                    customer.setLanguage(CastUtils.toString(entry.getValue()));
                    continue block44;
                }
                case "passwordRevocationDelay": {
                    logbooks.add(new EventDiffDto("Dur\u00e9e de r\u00e9vocation de mot de passe (en mois)", (Object)customer.getPasswordRevocationDelay(), entry.getValue()));
                    customer.setPasswordRevocationDelay(CastUtils.toInteger(entry.getValue()));
                    continue block44;
                }
                case "otp": {
                    String otpAsString = CastUtils.toString(entry.getValue());
                    OtpEnum newOtp = (OtpEnum)EnumUtils.stringToEnum(OtpEnum.class, (String)otpAsString);
                    logbooks.add(new EventDiffDto("OTP", (Object)customer.getOtp(), (Object)newOtp));
                    this.updateOtpforUsers(customer.getOtp(), newOtp, customer.getId());
                    customer.setOtp(newOtp);
                    continue block44;
                }
                case "emailDomains": {
                    List emailDomains = CastUtils.toList(entry.getValue());
                    logbooks.add(new EventDiffDto("Domaines", (Object)customer.getEmailDomains(), (Object)emailDomains));
                    customer.setEmailDomains(emailDomains);
                    continue block44;
                }
                case "defaultEmailDomain": {
                    String defaultEmailDomain = CastUtils.toString(entry.getValue());
                    logbooks.add(new EventDiffDto("Domaine par d\u00e9faut", (Object)customer.getDefaultEmailDomain(), entry.getValue()));
                    customer.setDefaultEmailDomain(defaultEmailDomain);
                    continue block44;
                }
                case "gdprAlertDelay": {
                    if (this.isGdprAlertReadonly()) {
                        LOGGER.error("Cannot update  gdprAlertDelay because the main setting is readOnly, please contact your administrator to update it ");
                        throw new IllegalArgumentException("Unable to patch customer " + customer.getId() + ": value for " + (String)entry.getKey() + " is not allowed, because the main setting is readOnly, please contact your administrator to update it");
                    }
                    if (CastUtils.toInt(entry.getValue()) > 0) {
                        logbooks.add(new EventDiffDto("GDPR D\u00e9lai d'alerte", (Object)customer.getGdprAlertDelay(), entry.getValue()));
                        customer.setGdprAlertDelay(CastUtils.toInt(entry.getValue()));
                        continue block44;
                    }
                    LOGGER.error("Wrong value , gdprAlertDelay should be greater than 0 ");
                    throw new IllegalArgumentException("Wrong value , gdprAlertDelay should be greater than 0");
                }
                case "gdprAlert": {
                    if (this.isGdprAlertReadonly()) {
                        LOGGER.error("Cannot update  gdprAlert because the main setting is readOnly, please contact your administrator to update it ");
                        throw new IllegalArgumentException("Unable to patch customer " + customer.getId() + ": value for " + (String)entry.getKey() + " is not allowed, because the main setting is readOnly, please contact your administrator to update it");
                    }
                    logbooks.add(new EventDiffDto("GDPR Alerte", (Object)customer.isGdprAlert(), entry.getValue()));
                    customer.setGdprAlert(CastUtils.toBoolean(entry.getValue()).booleanValue());
                    continue block44;
                }
                case "address": {
                    Address address = customer.getAddress();
                    if (address == null) {
                        customer.setAddress(new Address());
                    }
                    this.addressService.processPatch(customer.getAddress(), CastUtils.toMap(entry.getValue()), logbooks, false);
                    continue block44;
                }
                case "internalCode": {
                    logbooks.add(new EventDiffDto("Code interne", (Object)customer.getInternalCode(), entry.getValue()));
                    customer.setInternalCode(CastUtils.toString(entry.getValue()));
                    continue block44;
                }
                case "subrogeable": {
                    logbooks.add(new EventDiffDto("Subrogeable", (Object)customer.isSubrogeable(), entry.getValue()));
                    customer.setSubrogeable(CastUtils.toBoolean(entry.getValue()).booleanValue());
                    continue block44;
                }
                case "hasCustomGraphicIdentity": {
                    LOGGER.debug("Update GraphicalIdentity");
                    boolean newCustomGraphicIdentityValue = CastUtils.toBoolean(entry.getValue());
                    logbooks.add(new EventDiffDto("Identit\u00e9 graphique personnalis\u00e9e", (Object)customer.getGraphicIdentity().isHasCustomGraphicIdentity(), (Object)newCustomGraphicIdentityValue));
                    this.processGraphicIdentity(newCustomGraphicIdentityValue, customer, customerFormData);
                    continue block44;
                }
                case "themeColors": {
                    Object themeColorsValue = entry.getValue();
                    if (themeColorsValue instanceof Map) {
                        Map themeColors = (Map)themeColorsValue;
                        customer.getGraphicIdentity().setThemeColors(themeColors);
                        continue block44;
                    }
                    LOGGER.error("Cannot instantiate themeColors value as a Map<String, String>.");
                    throw new IllegalArgumentException("Unable to patch customer " + customer.getId() + ": value for " + (String)entry.getKey() + " is not allowed");
                }
                case "portalTitles": {
                    Object portalTitlesValue = entry.getValue();
                    if (portalTitlesValue instanceof Map) {
                        Map portalTitles = (Map)portalTitlesValue;
                        customer.setPortalTitles(portalTitles);
                        continue block44;
                    }
                    LOGGER.error("Cannot instantiate portalTitles value as a Map<String, String>.");
                    throw new IllegalArgumentException("Unable to patch customer " + customer.getId() + ": value for " + (String)entry.getKey() + " is not allowed");
                }
                case "portalMessages": {
                    Object portalMessagesValue = entry.getValue();
                    if (portalMessagesValue instanceof Map) {
                        Map portalMessages = (Map)portalMessagesValue;
                        customer.setPortalMessages(portalMessages);
                        continue block44;
                    }
                    LOGGER.error("Cannot instantiate portalMessages value as a Map<String, String>.");
                    throw new IllegalArgumentException("Unable to patch customer " + customer.getId() + ": value for " + (String)entry.getKey() + " is not allowed");
                }
            }
            throw new IllegalArgumentException("Unable to patch customer " + customer.getId() + ": key " + (String)entry.getKey() + " is not allowed");
        }
        this.iamLogbookService.updateCustomerEvent(customer, logbooks);
    }

    private void patchLogos(Customer customer, MultipartFile file, AttachmentType attachmentType) {
        try {
            VitamContext vitamContext = this.securityService.buildVitamContext(this.securityService.getTenantIdentifier());
            LOGGER.debug("Graphic identity EvIdAppSession : {} ", (Object)vitamContext.getApplicationSessionId());
            String base64 = VitamUIUtils.getBase64((MultipartFile)file);
            switch (1.$SwitchMap$fr$gouv$vitamui$commons$api$enums$AttachmentType[attachmentType.ordinal()]) {
                case 1: {
                    customer.getGraphicIdentity().setLogoHeaderBase64(base64);
                    break;
                }
                case 2: {
                    customer.getGraphicIdentity().setLogoFooterBase64(base64);
                    break;
                }
                case 3: {
                    customer.getGraphicIdentity().setLogoPortalBase64(base64);
                    break;
                }
            }
        }
        catch (IOException e) {
            throw new InvalidFormatException("Cannot store logo", (Throwable)e);
        }
    }

    private void processGraphicIdentity(boolean newCustomGraphicIdentityValue, Customer customer, CustomerPatchFormData customerFormData) {
        Optional header = customerFormData.getHeader();
        Optional footer = customerFormData.getFooter();
        Optional portal = customerFormData.getPortal();
        if (header != null && header.isPresent() || footer != null && footer.isPresent() || portal != null && portal.isPresent()) {
            if (header != null && header.isPresent()) {
                this.patchLogos(customer, (MultipartFile)header.get(), AttachmentType.HEADER);
            }
            if (footer != null && footer.isPresent()) {
                this.patchLogos(customer, (MultipartFile)footer.get(), AttachmentType.FOOTER);
            }
            if (portal != null && portal.isPresent()) {
                this.patchLogos(customer, (MultipartFile)portal.get(), AttachmentType.PORTAL);
            }
        }
        customer.getGraphicIdentity().setHasCustomGraphicIdentity(newCustomGraphicIdentityValue);
    }

    protected void processPatch(Customer entity, Map<String, Object> partialDto) {
        super.processPatch((BaseIdDocument)entity, partialDto);
    }

    @Transactional
    public CustomerDto patch(CustomerPatchFormData customerData) {
        LOGGER.debug("Patch customer {}", (Object)customerData);
        Customer customer = this.beforePatch(customerData.getPartialCustomerDto());
        this.processPatch(customer, customerData);
        Assert.isTrue((boolean)this.getRepository().existsById((Object)customer.getId()), (String)("Unable to patch customer : no entity found with id: " + customer.getId()));
        Customer savedCustomer = (Customer)this.getRepository().save((Object)customer);
        return (CustomerDto)this.convertFromEntityToDto((BaseIdDocument)savedCustomer);
    }

    public CustomerDto getMyCustomer() {
        return (CustomerDto)this.getOne(this.securityService.getCustomerId(), Optional.empty());
    }

    private Customer find(String id, String message) {
        Assert.isTrue((boolean)StringUtils.isNotEmpty((CharSequence)id), (String)(message + ": no id"));
        return (Customer)this.getRepository().findById((Object)id).orElseThrow(() -> new IllegalArgumentException(message + ": no customer found for id " + id));
    }

    protected void checkCode(Optional<String> customerId, String customerCode) {
        Optional optCustomer = this.customerRepository.findByCode(customerCode);
        if (optCustomer.isPresent() && (customerId.isEmpty() || !((Customer)optCustomer.get()).getId().equals(customerId.get()))) {
            throw new IllegalArgumentException("Integrity constraint error on the customer %s : the new code is already used by another customer.".formatted(customerId.orElse("[Undefined]")));
        }
    }

    private void checkDefaultEmailDomains(String emailDomain, List<String> emailDomains, String message) {
        Assert.isTrue((boolean)StringUtils.isNotEmpty((CharSequence)emailDomain), (String)(message + ": a customer must have at least one default email domains."));
        boolean found = emailDomains.stream().anyMatch(i -> StringUtils.equals((CharSequence)i, (CharSequence)emailDomain));
        Assert.isTrue((boolean)found, (String)(message + ": the default email domain is not in the email Domain list"));
    }

    private void checkEmailDomains(List<String> emailDomains, String message) {
        Assert.isTrue((emailDomains != null && emailDomains.size() > 0 ? 1 : 0) != 0, (String)(message + ": a customer must have emails domains."));
        HashSet elements = new HashSet();
        List duplicatesDomains = emailDomains.stream().filter(n -> !elements.add(n)).collect(Collectors.toList());
        Assert.isTrue((boolean)CollectionUtils.isEmpty(duplicatesDomains), (String)("Duplicate email domain found " + String.join((CharSequence)",", duplicatesDomains)));
        for (String domain : emailDomains) {
            Assert.isTrue((boolean)StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{domain}), (String)(message + ": an email domain is empty"));
        }
    }

    private void checkEmailDomains(List<String> emailDomains, String customerId, String message) {
        Assert.isTrue((emailDomains != null && emailDomains.size() > 0 ? 1 : 0) != 0, (String)(message + ": a customer must have emails domains."));
        HashSet elements = new HashSet();
        List duplicatesDomains = emailDomains.stream().filter(n -> !elements.add(n)).collect(Collectors.toList());
        Assert.isTrue((boolean)CollectionUtils.isEmpty(duplicatesDomains), (String)(message + ":Duplicate email domain found " + String.join((CharSequence)",", duplicatesDomains)));
        for (String domain : emailDomains) {
            Assert.isTrue((boolean)StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{domain}), (String)(message + ": an email domain is empty"));
            Optional customerOpt = this.customerRepository.findByIdAndEmailDomainsIgnoreCase(customerId, domain);
            if (!customerOpt.isPresent()) continue;
            Assert.isTrue((boolean)StringUtils.equals((CharSequence)((Customer)customerOpt.get()).getId(), (CharSequence)customerId), (String)(message + ": The customer has already the email domain " + domain));
        }
    }

    private void checkOwners(List<OwnerDto> owners, String message) {
        Assert.isTrue((owners != null && owners.size() > 0 ? 1 : 0) != 0, (String)(message + ": a customer must have owners."));
    }

    public LogbookOperationsCommonResponseDto findHistoryById(String id) throws VitamClientException {
        LOGGER.debug("findHistoryById for id" + id);
        Integer tenantIdentifier = this.securityService.getTenantIdentifier();
        VitamContext vitamContext = new VitamContext(tenantIdentifier).setAccessContract(this.securityService.getTenant(tenantIdentifier).getAccessContractLogbookIdentifier()).setApplicationSessionId(this.securityService.getApplicationId());
        Optional customer = this.getRepository().findById((Object)id);
        customer.orElseThrow(() -> new NotFoundException("No user found with id : %s".formatted(id)));
        JsonNode body = this.logbookService.findEventsByIdentifierAndCollectionNames(((Customer)customer.get()).getIdentifier(), "customers", vitamContext).toJsonNode();
        try {
            return (LogbookOperationsCommonResponseDto)JsonUtils.treeToValue((JsonNode)body, LogbookOperationsCommonResponseDto.class, (boolean)false);
        }
        catch (JsonProcessingException e) {
            throw new InternalServerException("Error while parsing Vitam response", (Throwable)e);
        }
    }

    protected CustomerRepository getRepository() {
        return this.customerRepository;
    }

    protected Converter<CustomerDto, Customer> getConverter() {
        return this.customerConverter;
    }

    protected Class<Customer> getEntityClass() {
        return Customer.class;
    }

    protected String getObjectName() {
        return "customer";
    }

    public ResponseEntity<Resource> getLogo(String id, AttachmentType type) {
        Optional customer = this.customerRepository.findById((Object)id);
        if (customer.isPresent()) {
            String logo = switch (1.$SwitchMap$fr$gouv$vitamui$commons$api$enums$AttachmentType[type.ordinal()]) {
                case 1 -> ((Customer)customer.get()).getGraphicIdentity().getLogoHeaderBase64();
                case 2 -> ((Customer)customer.get()).getGraphicIdentity().getLogoFooterBase64();
                case 3 -> ((Customer)customer.get()).getGraphicIdentity().getLogoPortalBase64();
                default -> null;
            };
            LOGGER.debug("get customer logo => " + logo);
            HttpHeaders headers = new HttpHeaders();
            headers.add("Content-Disposition", "inline;");
            if (logo == null) {
                return new ResponseEntity((HttpStatusCode)HttpStatus.NO_CONTENT);
            }
            byte[] decodedLogo = Base64.getDecoder().decode(logo);
            return new ResponseEntity((Object)new ByteArrayResource(decodedLogo), (MultiValueMap)headers, (HttpStatusCode)HttpStatus.OK);
        }
        return null;
    }

    public boolean getGdprSettingStatus() {
        LOGGER.debug("get Gdpr Setting Status ");
        return this.gdprAlertReadonly;
    }

    public List<CustomerDto> getAllById(List<String> customerIds) {
        Iterable customers = this.customerRepository.findAllById(customerIds);
        ArrayList<CustomerDto> customerDtos = new ArrayList<CustomerDto>();
        for (Customer customer : customers) {
            customerDtos.add((CustomerDto)this.convertFromEntityToDto((BaseIdDocument)customer));
        }
        return customerDtos;
    }

    protected Collection<String> getAllowedKeys() {
        return List.of("id", "name", "code", "companyName", "enabled", "language", "otp", "defaultEmailDomain", "emailDomains", "subrogeable");
    }

    protected Collection<String> getRestrictedKeys() {
        return Collections.emptyList();
    }

    protected String getVersionApiCriteria() {
        return "v2";
    }

    @Generated
    public boolean isGdprAlertReadonly() {
        return this.gdprAlertReadonly;
    }

    @Generated
    public CustomerRepository getCustomerRepository() {
        return this.customerRepository;
    }

    @Generated
    public OwnerService getOwnerService() {
        return this.ownerService;
    }

    @Generated
    public UserService getUserService() {
        return this.userService;
    }

    @Generated
    public SecurityService getSecurityService() {
        return this.securityService;
    }

    @Generated
    public AddressService getAddressService() {
        return this.addressService;
    }

    @Generated
    public InitCustomerService getInitCustomerService() {
        return this.initCustomerService;
    }

    @Generated
    public IamLogbookService getIamLogbookService() {
        return this.iamLogbookService;
    }

    @Generated
    public CustomerConverter getCustomerConverter() {
        return this.customerConverter;
    }

    @Generated
    public LogbookService getLogbookService() {
        return this.logbookService;
    }

    @Generated
    public void setGdprAlertReadonly(boolean gdprAlertReadonly) {
        this.gdprAlertReadonly = gdprAlertReadonly;
    }
}

