/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitamui.iam.server.customer.domain;

import fr.gouv.vitamui.commons.mongo.IdDocument;
import fr.gouv.vitamui.iam.common.enums.OtpEnum;
import fr.gouv.vitamui.iam.server.common.domain.Address;
import fr.gouv.vitamui.iam.server.customer.domain.GraphicIdentity;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Size;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.springframework.data.annotation.TypeAlias;
import org.springframework.data.mongodb.core.index.Indexed;
import org.springframework.data.mongodb.core.mapping.Document;

@Document(collection="customers")
@TypeAlias(value="customers")
public class Customer
extends IdDocument {
    @NotNull
    @Size(min=1, max=12)
    private @NotNull @Size(min=1, max=12) String identifier;
    @NotNull
    @Size(min=4, max=25)
    @Indexed(name="idx_customer_code", unique=true, background=true)
    private @NotNull @Size(min=4, max=25) String code;
    @NotNull
    @Size(max=100)
    @Indexed(name="idx_customer_name", background=true)
    private @NotNull @Size(max=100) String name;
    @NotNull
    @Size(max=250)
    private @NotNull @Size(max=250) String companyName;
    private boolean enabled;
    @NotNull
    private String language;
    @NotNull
    private Integer passwordRevocationDelay;
    @NotNull
    private OtpEnum otp;
    @NotNull
    @Size(min=1)
    private @NotNull @Size(min=1) List<String> emailDomains;
    @NotNull
    private String defaultEmailDomain;
    @NotNull
    private Address address;
    private String internalCode;
    private boolean readonly = false;
    private boolean subrogeable = false;
    @NotNull
    private GraphicIdentity graphicIdentity = new GraphicIdentity();
    Map<String, String> portalTitles = new HashMap();
    Map<String, String> portalMessages = new HashMap();
    private boolean gdprAlert = false;
    private int gdprAlertDelay;

    @Generated
    public String getIdentifier() {
        return this.identifier;
    }

    @Generated
    public String getCode() {
        return this.code;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public String getCompanyName() {
        return this.companyName;
    }

    @Generated
    public boolean isEnabled() {
        return this.enabled;
    }

    @Generated
    public String getLanguage() {
        return this.language;
    }

    @Generated
    public Integer getPasswordRevocationDelay() {
        return this.passwordRevocationDelay;
    }

    @Generated
    public OtpEnum getOtp() {
        return this.otp;
    }

    @Generated
    public List<String> getEmailDomains() {
        return this.emailDomains;
    }

    @Generated
    public String getDefaultEmailDomain() {
        return this.defaultEmailDomain;
    }

    @Generated
    public Address getAddress() {
        return this.address;
    }

    @Generated
    public String getInternalCode() {
        return this.internalCode;
    }

    @Generated
    public boolean isReadonly() {
        return this.readonly;
    }

    @Generated
    public boolean isSubrogeable() {
        return this.subrogeable;
    }

    @Generated
    public GraphicIdentity getGraphicIdentity() {
        return this.graphicIdentity;
    }

    @Generated
    public Map<String, String> getPortalTitles() {
        return this.portalTitles;
    }

    @Generated
    public Map<String, String> getPortalMessages() {
        return this.portalMessages;
    }

    @Generated
    public int getGdprAlertDelay() {
        return this.gdprAlertDelay;
    }

    @Generated
    public void setIdentifier(String identifier) {
        this.identifier = identifier;
    }

    @Generated
    public void setCode(String code) {
        this.code = code;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setCompanyName(String companyName) {
        this.companyName = companyName;
    }

    @Generated
    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    @Generated
    public void setLanguage(String language) {
        this.language = language;
    }

    @Generated
    public void setPasswordRevocationDelay(Integer passwordRevocationDelay) {
        this.passwordRevocationDelay = passwordRevocationDelay;
    }

    @Generated
    public void setOtp(OtpEnum otp) {
        this.otp = otp;
    }

    @Generated
    public void setEmailDomains(List<String> emailDomains) {
        this.emailDomains = emailDomains;
    }

    @Generated
    public void setDefaultEmailDomain(String defaultEmailDomain) {
        this.defaultEmailDomain = defaultEmailDomain;
    }

    @Generated
    public void setAddress(Address address) {
        this.address = address;
    }

    @Generated
    public void setInternalCode(String internalCode) {
        this.internalCode = internalCode;
    }

    @Generated
    public void setReadonly(boolean readonly) {
        this.readonly = readonly;
    }

    @Generated
    public void setSubrogeable(boolean subrogeable) {
        this.subrogeable = subrogeable;
    }

    @Generated
    public void setGraphicIdentity(GraphicIdentity graphicIdentity) {
        this.graphicIdentity = graphicIdentity;
    }

    @Generated
    public void setPortalTitles(Map<String, String> portalTitles) {
        this.portalTitles = portalTitles;
    }

    @Generated
    public void setPortalMessages(Map<String, String> portalMessages) {
        this.portalMessages = portalMessages;
    }

    @Generated
    public void setGdprAlert(boolean gdprAlert) {
        this.gdprAlert = gdprAlert;
    }

    @Generated
    public void setGdprAlertDelay(int gdprAlertDelay) {
        this.gdprAlertDelay = gdprAlertDelay;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Customer)) {
            return false;
        }
        Customer other = (Customer)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.isEnabled() != other.isEnabled()) {
            return false;
        }
        if (this.isReadonly() != other.isReadonly()) {
            return false;
        }
        if (this.isSubrogeable() != other.isSubrogeable()) {
            return false;
        }
        if (this.isGdprAlert() != other.isGdprAlert()) {
            return false;
        }
        if (this.getGdprAlertDelay() != other.getGdprAlertDelay()) {
            return false;
        }
        Integer this$passwordRevocationDelay = this.getPasswordRevocationDelay();
        Integer other$passwordRevocationDelay = other.getPasswordRevocationDelay();
        if (this$passwordRevocationDelay == null ? other$passwordRevocationDelay != null : !((Object)this$passwordRevocationDelay).equals(other$passwordRevocationDelay)) {
            return false;
        }
        String this$identifier = this.getIdentifier();
        String other$identifier = other.getIdentifier();
        if (this$identifier == null ? other$identifier != null : !this$identifier.equals(other$identifier)) {
            return false;
        }
        String this$code = this.getCode();
        String other$code = other.getCode();
        if (this$code == null ? other$code != null : !this$code.equals(other$code)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$companyName = this.getCompanyName();
        String other$companyName = other.getCompanyName();
        if (this$companyName == null ? other$companyName != null : !this$companyName.equals(other$companyName)) {
            return false;
        }
        String this$language = this.getLanguage();
        String other$language = other.getLanguage();
        if (this$language == null ? other$language != null : !this$language.equals(other$language)) {
            return false;
        }
        OtpEnum this$otp = this.getOtp();
        OtpEnum other$otp = other.getOtp();
        if (this$otp == null ? other$otp != null : !this$otp.equals(other$otp)) {
            return false;
        }
        List this$emailDomains = this.getEmailDomains();
        List other$emailDomains = other.getEmailDomains();
        if (this$emailDomains == null ? other$emailDomains != null : !((Object)this$emailDomains).equals(other$emailDomains)) {
            return false;
        }
        String this$defaultEmailDomain = this.getDefaultEmailDomain();
        String other$defaultEmailDomain = other.getDefaultEmailDomain();
        if (this$defaultEmailDomain == null ? other$defaultEmailDomain != null : !this$defaultEmailDomain.equals(other$defaultEmailDomain)) {
            return false;
        }
        Address this$address = this.getAddress();
        Address other$address = other.getAddress();
        if (this$address == null ? other$address != null : !this$address.equals(other$address)) {
            return false;
        }
        String this$internalCode = this.getInternalCode();
        String other$internalCode = other.getInternalCode();
        if (this$internalCode == null ? other$internalCode != null : !this$internalCode.equals(other$internalCode)) {
            return false;
        }
        GraphicIdentity this$graphicIdentity = this.getGraphicIdentity();
        GraphicIdentity other$graphicIdentity = other.getGraphicIdentity();
        if (this$graphicIdentity == null ? other$graphicIdentity != null : !this$graphicIdentity.equals(other$graphicIdentity)) {
            return false;
        }
        Map this$portalTitles = this.getPortalTitles();
        Map other$portalTitles = other.getPortalTitles();
        if (this$portalTitles == null ? other$portalTitles != null : !((Object)this$portalTitles).equals(other$portalTitles)) {
            return false;
        }
        Map this$portalMessages = this.getPortalMessages();
        Map other$portalMessages = other.getPortalMessages();
        return !(this$portalMessages == null ? other$portalMessages != null : !((Object)this$portalMessages).equals(other$portalMessages));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Customer;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.isEnabled() ? 79 : 97);
        result = result * 59 + (this.isReadonly() ? 79 : 97);
        result = result * 59 + (this.isSubrogeable() ? 79 : 97);
        result = result * 59 + (this.isGdprAlert() ? 79 : 97);
        result = result * 59 + this.getGdprAlertDelay();
        Integer $passwordRevocationDelay = this.getPasswordRevocationDelay();
        result = result * 59 + ($passwordRevocationDelay == null ? 43 : ((Object)$passwordRevocationDelay).hashCode());
        String $identifier = this.getIdentifier();
        result = result * 59 + ($identifier == null ? 43 : $identifier.hashCode());
        String $code = this.getCode();
        result = result * 59 + ($code == null ? 43 : $code.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $companyName = this.getCompanyName();
        result = result * 59 + ($companyName == null ? 43 : $companyName.hashCode());
        String $language = this.getLanguage();
        result = result * 59 + ($language == null ? 43 : $language.hashCode());
        OtpEnum $otp = this.getOtp();
        result = result * 59 + ($otp == null ? 43 : $otp.hashCode());
        List $emailDomains = this.getEmailDomains();
        result = result * 59 + ($emailDomains == null ? 43 : ((Object)$emailDomains).hashCode());
        String $defaultEmailDomain = this.getDefaultEmailDomain();
        result = result * 59 + ($defaultEmailDomain == null ? 43 : $defaultEmailDomain.hashCode());
        Address $address = this.getAddress();
        result = result * 59 + ($address == null ? 43 : $address.hashCode());
        String $internalCode = this.getInternalCode();
        result = result * 59 + ($internalCode == null ? 43 : $internalCode.hashCode());
        GraphicIdentity $graphicIdentity = this.getGraphicIdentity();
        result = result * 59 + ($graphicIdentity == null ? 43 : $graphicIdentity.hashCode());
        Map $portalTitles = this.getPortalTitles();
        result = result * 59 + ($portalTitles == null ? 43 : ((Object)$portalTitles).hashCode());
        Map $portalMessages = this.getPortalMessages();
        result = result * 59 + ($portalMessages == null ? 43 : ((Object)$portalMessages).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "Customer(super=" + super.toString() + ", identifier=" + this.getIdentifier() + ", code=" + this.getCode() + ", name=" + this.getName() + ", companyName=" + this.getCompanyName() + ", enabled=" + this.isEnabled() + ", language=" + this.getLanguage() + ", passwordRevocationDelay=" + this.getPasswordRevocationDelay() + ", otp=" + String.valueOf(this.getOtp()) + ", emailDomains=" + String.valueOf(this.getEmailDomains()) + ", defaultEmailDomain=" + this.getDefaultEmailDomain() + ", address=" + String.valueOf(this.getAddress()) + ", internalCode=" + this.getInternalCode() + ", readonly=" + this.isReadonly() + ", subrogeable=" + this.isSubrogeable() + ", graphicIdentity=" + String.valueOf(this.getGraphicIdentity()) + ", portalTitles=" + String.valueOf(this.getPortalTitles()) + ", portalMessages=" + String.valueOf(this.getPortalMessages()) + ", gdprAlert=" + this.isGdprAlert() + ", gdprAlertDelay=" + this.getGdprAlertDelay() + ")";
    }

    @Generated
    public boolean isGdprAlert() {
        return this.gdprAlert;
    }
}

