/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitamui.iam.server.config;

import com.fasterxml.jackson.databind.ObjectMapper;
import fr.gouv.vitam.access.external.client.AdminExternalClient;
import fr.gouv.vitamui.commons.api.application.AbstractContextConfiguration;
import fr.gouv.vitamui.commons.mongo.dao.CustomSequenceRepository;
import fr.gouv.vitamui.commons.mongo.service.SequenceGeneratorService;
import fr.gouv.vitamui.commons.rest.RestExceptionHandler;
import fr.gouv.vitamui.commons.rest.client.BaseRestClientFactory;
import fr.gouv.vitamui.commons.rest.client.RestClientFactory;
import fr.gouv.vitamui.commons.rest.client.configuration.RestClientConfiguration;
import fr.gouv.vitamui.commons.security.client.config.password.PasswordConfiguration;
import fr.gouv.vitamui.commons.security.client.password.PasswordValidator;
import fr.gouv.vitamui.commons.vitam.api.access.LogbookService;
import fr.gouv.vitamui.commons.vitam.api.administration.AccessContractCommonService;
import fr.gouv.vitamui.commons.vitam.api.administration.ConfigurationService;
import fr.gouv.vitamui.commons.vitam.api.administration.IngestContractCommonService;
import fr.gouv.vitamui.commons.vitam.api.config.VitamAccessConfig;
import fr.gouv.vitamui.commons.vitam.api.config.VitamAdministrationConfig;
import fr.gouv.vitamui.iam.common.utils.IdentityProviderHelper;
import fr.gouv.vitamui.iam.common.utils.Pac4jClientBuilder;
import fr.gouv.vitamui.iam.security.provider.ApiAuthenticationProvider;
import fr.gouv.vitamui.iam.security.provider.ExternalApiAuthenticationProvider;
import fr.gouv.vitamui.iam.security.provider.InternalApiAuthenticationProvider;
import fr.gouv.vitamui.iam.security.service.SecurityService;
import fr.gouv.vitamui.iam.security.service.UserAuthenticationService;
import fr.gouv.vitamui.iam.server.application.service.ApplicationService;
import fr.gouv.vitamui.iam.server.cas.service.CasService;
import fr.gouv.vitamui.iam.server.common.service.AddressService;
import fr.gouv.vitamui.iam.server.config.ApiIamApplicationProperties;
import fr.gouv.vitamui.iam.server.config.ConverterConfig;
import fr.gouv.vitamui.iam.server.customer.config.CustomerInitConfig;
import fr.gouv.vitamui.iam.server.customer.converter.CustomerConverter;
import fr.gouv.vitamui.iam.server.customer.dao.CustomerRepository;
import fr.gouv.vitamui.iam.server.customer.service.CustomerService;
import fr.gouv.vitamui.iam.server.customer.service.InitCustomerService;
import fr.gouv.vitamui.iam.server.externalParameters.converter.ExternalParametersConverter;
import fr.gouv.vitamui.iam.server.externalParameters.dao.ExternalParametersRepository;
import fr.gouv.vitamui.iam.server.externalParameters.service.ExternalParametersService;
import fr.gouv.vitamui.iam.server.externalparamprofile.dao.ExternalParamProfileRepository;
import fr.gouv.vitamui.iam.server.externalparamprofile.service.ExternalParamProfileService;
import fr.gouv.vitamui.iam.server.group.converter.GroupConverter;
import fr.gouv.vitamui.iam.server.group.dao.GroupRepository;
import fr.gouv.vitamui.iam.server.group.service.GroupExportService;
import fr.gouv.vitamui.iam.server.group.service.GroupService;
import fr.gouv.vitamui.iam.server.idp.converter.IdentityProviderConverter;
import fr.gouv.vitamui.iam.server.idp.dao.IdentityProviderRepository;
import fr.gouv.vitamui.iam.server.idp.service.IdentityProviderService;
import fr.gouv.vitamui.iam.server.idp.service.SpMetadataGenerator;
import fr.gouv.vitamui.iam.server.logbook.service.IamLogbookService;
import fr.gouv.vitamui.iam.server.owner.converter.OwnerConverter;
import fr.gouv.vitamui.iam.server.owner.dao.OwnerRepository;
import fr.gouv.vitamui.iam.server.owner.service.OwnerService;
import fr.gouv.vitamui.iam.server.profile.converter.ProfileConverter;
import fr.gouv.vitamui.iam.server.profile.dao.ProfileRepository;
import fr.gouv.vitamui.iam.server.profile.service.ProfileService;
import fr.gouv.vitamui.iam.server.provisioning.config.ProvisioningClientConfiguration;
import fr.gouv.vitamui.iam.server.security.IamUserAuthentificationService;
import fr.gouv.vitamui.iam.server.security.WebSecurityConfig;
import fr.gouv.vitamui.iam.server.subrogation.converter.SubrogationConverter;
import fr.gouv.vitamui.iam.server.subrogation.dao.SubrogationRepository;
import fr.gouv.vitamui.iam.server.subrogation.service.SubrogationService;
import fr.gouv.vitamui.iam.server.tenant.converter.TenantConverter;
import fr.gouv.vitamui.iam.server.tenant.dao.TenantRepository;
import fr.gouv.vitamui.iam.server.tenant.service.InitVitamTenantService;
import fr.gouv.vitamui.iam.server.tenant.service.TenantService;
import fr.gouv.vitamui.iam.server.token.dao.TokenRepository;
import fr.gouv.vitamui.iam.server.user.converter.UserConverter;
import fr.gouv.vitamui.iam.server.user.converter.UserInfoConverter;
import fr.gouv.vitamui.iam.server.user.dao.UserInfoRepository;
import fr.gouv.vitamui.iam.server.user.dao.UserRepository;
import fr.gouv.vitamui.iam.server.user.service.ConnectionHistoryService;
import fr.gouv.vitamui.iam.server.user.service.UserEmailService;
import fr.gouv.vitamui.iam.server.user.service.UserExportService;
import fr.gouv.vitamui.iam.server.user.service.UserInfoService;
import fr.gouv.vitamui.iam.server.user.service.UserService;
import fr.gouv.vitamui.security.openapiclient.ContextsApi;
import fr.gouv.vitamui.security.openapiclient.SecurityApiClientsFactory;
import jakarta.servlet.Filter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.web.client.RestTemplateBuilder;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.boot.web.servlet.ServletRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.data.mongodb.MongoTransactionManager;
import org.springframework.data.mongodb.core.MongoOperations;
import org.springframework.security.crypto.bcrypt.BCryptPasswordEncoder;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.web.multipart.MultipartResolver;
import org.springframework.web.multipart.support.MultipartFilter;
import org.springframework.web.multipart.support.StandardServletMultipartResolver;

@Configuration
@Import(value={RestExceptionHandler.class, WebSecurityConfig.class, VitamAccessConfig.class, VitamAdministrationConfig.class, ConverterConfig.class})
@EnableConfigurationProperties(value={PasswordConfiguration.class})
public class ApiIamServerConfig
extends AbstractContextConfiguration {
    @Autowired
    private PasswordConfiguration passwordConfiguration;

    @Bean
    public MultipartResolver multipartResolver() {
        return new StandardServletMultipartResolver();
    }

    @Bean
    public PasswordValidator passwordValidator() {
        return new PasswordValidator();
    }

    @Bean
    public FilterRegistrationBean multipartFilterRegistrationBean() {
        MultipartFilter multipartFilter = new MultipartFilter();
        FilterRegistrationBean filterRegistrationBean = new FilterRegistrationBean((Filter)multipartFilter, new ServletRegistrationBean[0]);
        filterRegistrationBean.addInitParameter("multipartResolverBeanName", "commonsMultipartResolver");
        return filterRegistrationBean;
    }

    @Bean
    @ConfigurationProperties(value="cas-client")
    public RestClientConfiguration casClientProperties() {
        return new RestClientConfiguration();
    }

    @Bean
    @ConfigurationProperties(value="provisioning-client")
    public ProvisioningClientConfiguration provisioningClientProperties() {
        return new ProvisioningClientConfiguration();
    }

    @Bean
    public SecurityApiClientsFactory securityApiClientsFactory(RestTemplateBuilder restTemplateBuilder, ApiIamApplicationProperties apiIamApplicationProperties) {
        return new SecurityApiClientsFactory(apiIamApplicationProperties.getSecurityClient(), restTemplateBuilder);
    }

    @Bean
    public ContextsApi contextsApi(SecurityApiClientsFactory securityApiClientsFactory) {
        return securityApiClientsFactory.getContextsApi();
    }

    @Bean
    public IamUserAuthentificationService iamAuthentificationService(UserService userService, TokenRepository tokenRepository, SubrogationRepository subrogationRepository) {
        return new IamUserAuthentificationService(userService, tokenRepository, subrogationRepository);
    }

    @Bean
    public ApiAuthenticationProvider apiAuthenticationProvider(IamUserAuthentificationService iamUserAuthentificationService, ContextsApi contextsApi) {
        return new ApiAuthenticationProvider(new InternalApiAuthenticationProvider((UserAuthenticationService)iamUserAuthentificationService), new ExternalApiAuthenticationProvider(contextsApi, (UserAuthenticationService)iamUserAuthentificationService));
    }

    @Bean
    public Pac4jClientBuilder pac4jClientBuilder() {
        return new Pac4jClientBuilder();
    }

    @Bean
    public SpMetadataGenerator spMetadataGenerator() {
        return new SpMetadataGenerator();
    }

    @Bean
    public SequenceGeneratorService sequenceGeneratorService(CustomSequenceRepository sequenceRepository) {
        return new SequenceGeneratorService(sequenceRepository);
    }

    @Bean
    public IdentityProviderService identityProviderCrudService(SequenceGeneratorService sequenceGeneratorService, IdentityProviderRepository identityProviderRepository, SpMetadataGenerator spMetadataGenerator, CustomerRepository customerRepository, IamLogbookService iamLogbookService, IdentityProviderConverter idpConverter, SecurityService securityService) {
        return new IdentityProviderService(sequenceGeneratorService, identityProviderRepository, spMetadataGenerator, customerRepository, iamLogbookService, idpConverter, securityService);
    }

    @Bean
    public CustomerService customerCrudService(SequenceGeneratorService sequenceGeneratorService, CustomerRepository customerRepository, OwnerService ownerService, UserService userService, SecurityService securityService, AddressService addressService, InitCustomerService initCustomerService, IamLogbookService iamLogbookService, CustomerConverter customerConverter, LogbookService logbookService) {
        return new CustomerService(sequenceGeneratorService, customerRepository, ownerService, userService, securityService, addressService, initCustomerService, iamLogbookService, customerConverter, logbookService);
    }

    @Bean
    public InitCustomerService initCustomerCrudService() {
        return new InitCustomerService();
    }

    @Bean
    public OwnerService ownerCrudService(SequenceGeneratorService sequenceGeneratorService, OwnerRepository ownerRepository, CustomerRepository customerRepository, AddressService addressService, IamLogbookService iamLogbookService, SecurityService securityService, OwnerConverter ownerConverter, LogbookService logbookService, TenantRepository tenantRepository) {
        return new OwnerService(sequenceGeneratorService, ownerRepository, customerRepository, addressService, iamLogbookService, securityService, ownerConverter, logbookService, tenantRepository);
    }

    @Bean
    public InitVitamTenantService initVitamTenantService(AccessContractCommonService accessContractCommonService, IngestContractCommonService ingestContractCommonService, SecurityService securityService, TenantConverter tenantConverter) {
        return new InitVitamTenantService(accessContractCommonService, ingestContractCommonService, securityService, tenantConverter);
    }

    @Bean
    public TenantService tenantCrudService(SequenceGeneratorService sequenceGeneratorService, TenantRepository tenantRepository, CustomerRepository customerRepository, OwnerRepository ownerRepository, ProfileRepository profileRepository, GroupService groupService, UserService userService, OwnerService ownerService, SecurityService securityService, IamLogbookService iamLogbookService, TenantConverter tenantConverter, InitVitamTenantService initVitamTenantService, LogbookService logbookService, CustomerInitConfig customerInitConfig, ExternalParametersRepository externalParametersRepository, ExternalParametersService externalParametersService, ConfigurationService configurationService) {
        return new TenantService(sequenceGeneratorService, tenantRepository, customerRepository, ownerRepository, profileRepository, groupService, userService, ownerService, securityService, iamLogbookService, tenantConverter, initVitamTenantService, logbookService, customerInitConfig, externalParametersRepository, externalParametersService, configurationService);
    }

    @Bean
    public PasswordEncoder passwordEncoder() {
        return new BCryptPasswordEncoder();
    }

    @Bean
    public UserService userService(SequenceGeneratorService sequenceGeneratorService, UserRepository userRepository, ProfileService profileService, UserEmailService userEmailService, TenantRepository tenantRepository, SecurityService securityService, CustomerRepository customerRepository, GroupService groupService, IamLogbookService iamLogbookService, UserConverter userConverter, MongoTransactionManager mongoTransactionManager, LogbookService logbookService, AddressService addressService, ApplicationService applicationService, PasswordConfiguration passwordConfiguration, UserExportService userExportService, UserInfoService userInfoService, ConnectionHistoryService connectionHistoryService) {
        return new UserService(sequenceGeneratorService, userRepository, groupService, profileService, userEmailService, tenantRepository, securityService, customerRepository, iamLogbookService, userConverter, mongoTransactionManager, logbookService, addressService, applicationService, passwordConfiguration, userExportService, userInfoService, connectionHistoryService);
    }

    @Bean
    public UserInfoService userInfoService(SequenceGeneratorService sequenceGeneratorService, UserInfoRepository userInfoRepository, SecurityService securityService, UserInfoConverter userInfoConverter, IamLogbookService iamLogbookService, LogbookService logbookService) {
        return new UserInfoService(sequenceGeneratorService, userInfoRepository, securityService, userInfoConverter, iamLogbookService, logbookService);
    }

    @Bean
    public GroupService groupService(SequenceGeneratorService sequenceGeneratorService, GroupRepository groupRepository, CustomerRepository customerRepository, ProfileService profileService, UserRepository userRepository, SecurityService securityService, TenantRepository tenantRepository, IamLogbookService iamLogbookService, GroupConverter groupConverter, LogbookService logbookService, GroupExportService groupExportService) {
        return new GroupService(sequenceGeneratorService, groupRepository, customerRepository, profileService, userRepository, securityService, tenantRepository, iamLogbookService, groupConverter, logbookService, groupExportService);
    }

    @Bean
    public ProfileService profileCrudService(SequenceGeneratorService sequenceGeneratorService, ProfileRepository profileRepository, CustomerRepository customerRepository, GroupRepository groupRepository, TenantRepository tenantRepository, UserRepository userRepository, SecurityService securityService, IamLogbookService iamLogbookService, ProfileConverter profileConverter, LogbookService logbookService, CustomerInitConfig customerInitConfig) {
        return new ProfileService(sequenceGeneratorService, profileRepository, customerRepository, groupRepository, tenantRepository, userRepository, securityService, iamLogbookService, profileConverter, logbookService, customerInitConfig);
    }

    @Bean
    public UserEmailService userEmailService(RestTemplateBuilder restTemplateBuilder, RestClientConfiguration casClientProperties) {
        BaseRestClientFactory factory = new BaseRestClientFactory(casClientProperties, restTemplateBuilder);
        return new UserEmailService((RestClientFactory)factory);
    }

    @Bean
    public IdentityProviderHelper identityProviderHelper() {
        return new IdentityProviderHelper();
    }

    @Bean
    public SubrogationService subrogationCrudService(SequenceGeneratorService sequenceGeneratorService, SubrogationRepository subrogationRepository, UserRepository userRepository, UserService userService, GroupService groupService, GroupRepository groupRepository, ProfileRepository profilRepository, SecurityService securityService, CustomerRepository customerRepository, SubrogationConverter subrogationConverter, IamLogbookService iamLogbookService) {
        return new SubrogationService(sequenceGeneratorService, subrogationRepository, userRepository, userService, groupService, groupRepository, profilRepository, securityService, customerRepository, subrogationConverter, iamLogbookService);
    }

    @Bean
    public CasService casService() {
        return new CasService();
    }

    @Bean
    public AddressService addressService() {
        return new AddressService();
    }

    @Bean
    public ExternalParametersService externalParametersService(SequenceGeneratorService sequenceGeneratorService, ExternalParametersRepository externalParametersRepository, ExternalParametersConverter externalParametersConverter, SecurityService securityService, IamLogbookService iamLogbookService) {
        return new ExternalParametersService(sequenceGeneratorService, externalParametersRepository, externalParametersConverter, securityService, iamLogbookService);
    }

    @Bean
    public ExternalParamProfileService externalParamProfileService(ExternalParametersService externalParametersService, ProfileService profileService, SecurityService securityService, IamLogbookService iamLogbookService, ExternalParamProfileRepository externalParamProfileRepository, LogbookService logbookService, ProfileConverter profileConverter) {
        return new ExternalParamProfileService(externalParametersService, profileService, securityService, iamLogbookService, externalParamProfileRepository, logbookService, profileConverter);
    }

    @Bean
    ExternalParamProfileRepository externalParamProfileRepository(MongoOperations mongoOperations) {
        return new ExternalParamProfileRepository(mongoOperations);
    }

    @Bean
    public ConfigurationService configurationService(AdminExternalClient adminExternalClient, ObjectMapper objectMapper) {
        return new ConfigurationService(adminExternalClient, objectMapper);
    }

    @Bean
    public SecurityService externalSecurityService() {
        return new SecurityService();
    }
}

