/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitamui.iam.openapiclient;

import fr.gouv.vitamui.commons.rest.client.HttpContext;
import fr.gouv.vitamui.iam.openapiclient.invoker.ApiClient;
import java.util.Collections;
import org.springframework.http.HttpHeaders;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.web.authentication.preauth.PreAuthenticatedAuthenticationToken;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

public class IamApiClient
extends ApiClient {
    public IamApiClient(RestTemplate restTemplate) {
        super(restTemplate);
    }

    @Override
    protected void updateParamsForAuth(String[] authNames, MultiValueMap<String, String> queryParams, HttpHeaders headerParams, MultiValueMap<String, String> cookieParams) {
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        if (authentication != null) {
            HttpContext context = authentication instanceof PreAuthenticatedAuthenticationToken ? (HttpContext)authentication.getPrincipal() : (HttpContext)authentication.getCredentials();
            this.updateParamsForAuth(headerParams, context);
        }
    }

    private void updateParamsForAuth(HttpHeaders headerParams, HttpContext context) {
        Integer tenantIdentifier = context.getTenantIdentifier();
        String userToken = context.getUserToken();
        String applicationId = context.getApplicationId();
        String identity = context.getIdentity();
        String requestId = context.getRequestId();
        String accessContractId = context.getAccessContract();
        headerParams.set("X-Origin", "INTERNAL");
        if (tenantIdentifier != null) {
            headerParams.put("X-Tenant-Id", Collections.singletonList(String.valueOf(tenantIdentifier)));
        }
        if (userToken != null) {
            headerParams.put("X-User-Token", Collections.singletonList(userToken));
        }
        if (applicationId != null) {
            headerParams.put("X-Application-Id", Collections.singletonList(applicationId));
        }
        if (identity != null) {
            headerParams.put("X-Identity", Collections.singletonList(identity));
        }
        if (requestId != null) {
            headerParams.put("X-Request-Id", Collections.singletonList(requestId));
        }
        if (accessContractId != null) {
            headerParams.put("X-Access-Contract-Id", Collections.singletonList(accessContractId));
        }
    }
}

