/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitamui.iam.openapiclient;

import fr.gouv.vitamui.iam.openapiclient.domain.CustomerDto;
import fr.gouv.vitamui.iam.openapiclient.domain.CustomerPatchFormData;
import fr.gouv.vitamui.iam.openapiclient.domain.LogbookOperationsCommonResponseDto;
import fr.gouv.vitamui.iam.openapiclient.domain.PaginatedValuesDtoCustomerDto;
import fr.gouv.vitamui.iam.openapiclient.invoker.ApiClient;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.core.io.Resource;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.web.client.RestClientException;

public class CustomersApi {
    private ApiClient apiClient;

    public CustomersApi() {
        this(new ApiClient());
    }

    public CustomersApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public void checkExist(String criteria) throws RestClientException {
        this.checkExistWithHttpInfo(criteria);
    }

    public ResponseEntity<Void> checkExistWithHttpInfo(String criteria) throws RestClientException {
        Object localVarPostBody = null;
        if (criteria == null) {
            throw new HttpClientErrorException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Missing the required parameter 'criteria' when calling checkExist");
        }
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarCookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        localVarQueryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "criteria", criteria));
        String[] localVarAccepts = new String[]{};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"x-tenant-id", "bearer"};
        ParameterizedTypeReference<Void> localReturnType = new ParameterizedTypeReference<Void>(){};
        return this.apiClient.invokeAPI("/iam/v1/customers/check", HttpMethod.HEAD, Collections.emptyMap(), (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
    }

    public CustomerDto create(CustomerDto customerDto, String tenantName, Integer tenantId) throws RestClientException {
        return (CustomerDto)((Object)this.createWithHttpInfo(customerDto, tenantName, tenantId).getBody());
    }

    public ResponseEntity<CustomerDto> createWithHttpInfo(CustomerDto customerDto, String tenantName, Integer tenantId) throws RestClientException {
        Object localVarPostBody = null;
        if (customerDto == null) {
            throw new HttpClientErrorException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Missing the required parameter 'customerDto' when calling create");
        }
        if (tenantName == null) {
            throw new HttpClientErrorException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Missing the required parameter 'tenantName' when calling create");
        }
        if (tenantId == null) {
            throw new HttpClientErrorException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Missing the required parameter 'tenantId' when calling create");
        }
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarCookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        if (customerDto != null) {
            localVarFormParams.add((Object)"customerDto", (Object)customerDto);
        }
        if (tenantName != null) {
            localVarFormParams.add((Object)"tenantName", (Object)tenantName);
        }
        if (tenantId != null) {
            localVarFormParams.add((Object)"tenantId", (Object)tenantId);
        }
        String[] localVarAccepts = new String[]{"*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"multipart/form-data"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"x-tenant-id", "bearer"};
        ParameterizedTypeReference<CustomerDto> localReturnType = new ParameterizedTypeReference<CustomerDto>(){};
        return this.apiClient.invokeAPI("/iam/v1/customers", HttpMethod.POST, Collections.emptyMap(), (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
    }

    public LogbookOperationsCommonResponseDto findHistoryById(String id) throws RestClientException {
        return (LogbookOperationsCommonResponseDto)((Object)this.findHistoryByIdWithHttpInfo(id).getBody());
    }

    public ResponseEntity<LogbookOperationsCommonResponseDto> findHistoryByIdWithHttpInfo(String id) throws RestClientException {
        Object localVarPostBody = null;
        if (id == null) {
            throw new HttpClientErrorException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Missing the required parameter 'id' when calling findHistoryById");
        }
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("id", id);
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarCookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"x-tenant-id", "bearer"};
        ParameterizedTypeReference<LogbookOperationsCommonResponseDto> localReturnType = new ParameterizedTypeReference<LogbookOperationsCommonResponseDto>(){};
        return this.apiClient.invokeAPI("/iam/v1/customers/{id}/history", HttpMethod.GET, uriVariables, (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
    }

    public List<CustomerDto> getAll(String criteria) throws RestClientException {
        return (List)this.getAllWithHttpInfo(criteria).getBody();
    }

    public ResponseEntity<List<CustomerDto>> getAllWithHttpInfo(String criteria) throws RestClientException {
        Object localVarPostBody = null;
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarCookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        localVarQueryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "criteria", criteria));
        String[] localVarAccepts = new String[]{"*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"x-tenant-id", "bearer"};
        ParameterizedTypeReference<List<CustomerDto>> localReturnType = new ParameterizedTypeReference<List<CustomerDto>>(){};
        return this.apiClient.invokeAPI("/iam/v1/customers", HttpMethod.GET, Collections.emptyMap(), (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
    }

    public PaginatedValuesDtoCustomerDto getAllPaginated(Integer page, Integer size, String criteria, String orderBy, String direction) throws RestClientException {
        return (PaginatedValuesDtoCustomerDto)((Object)this.getAllPaginatedWithHttpInfo(page, size, criteria, orderBy, direction).getBody());
    }

    public ResponseEntity<PaginatedValuesDtoCustomerDto> getAllPaginatedWithHttpInfo(Integer page, Integer size, String criteria, String orderBy, String direction) throws RestClientException {
        Object localVarPostBody = null;
        if (page == null) {
            throw new HttpClientErrorException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Missing the required parameter 'page' when calling getAllPaginated");
        }
        if (size == null) {
            throw new HttpClientErrorException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Missing the required parameter 'size' when calling getAllPaginated");
        }
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarCookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        localVarQueryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "page", page));
        localVarQueryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "size", size));
        localVarQueryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "criteria", criteria));
        localVarQueryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "orderBy", orderBy));
        localVarQueryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "direction", direction));
        String[] localVarAccepts = new String[]{"*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"x-tenant-id", "bearer"};
        ParameterizedTypeReference<PaginatedValuesDtoCustomerDto> localReturnType = new ParameterizedTypeReference<PaginatedValuesDtoCustomerDto>(){};
        return this.apiClient.invokeAPI("/iam/v1/customers/paginated", HttpMethod.GET, Collections.emptyMap(), (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
    }

    public Boolean getGdprSettingStatus() throws RestClientException {
        return (Boolean)this.getGdprSettingStatusWithHttpInfo().getBody();
    }

    public ResponseEntity<Boolean> getGdprSettingStatusWithHttpInfo() throws RestClientException {
        Object localVarPostBody = null;
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarCookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"x-tenant-id", "bearer"};
        ParameterizedTypeReference<Boolean> localReturnType = new ParameterizedTypeReference<Boolean>(){};
        return this.apiClient.invokeAPI("/iam/v1/customers/gdpr-status", HttpMethod.GET, Collections.emptyMap(), (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
    }

    public Resource getLogo(String id, String type) throws RestClientException {
        return (Resource)this.getLogoWithHttpInfo(id, type).getBody();
    }

    public ResponseEntity<Resource> getLogoWithHttpInfo(String id, String type) throws RestClientException {
        Object localVarPostBody = null;
        if (id == null) {
            throw new HttpClientErrorException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Missing the required parameter 'id' when calling getLogo");
        }
        if (type == null) {
            throw new HttpClientErrorException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Missing the required parameter 'type' when calling getLogo");
        }
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("id", id);
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarCookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        localVarQueryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "type", type));
        String[] localVarAccepts = new String[]{"*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"x-tenant-id", "bearer"};
        ParameterizedTypeReference<Resource> localReturnType = new ParameterizedTypeReference<Resource>(){};
        return this.apiClient.invokeAPI("/iam/v1/customers/{id}/logo", HttpMethod.GET, uriVariables, (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
    }

    public CustomerDto getMyCustomer() throws RestClientException {
        return (CustomerDto)((Object)this.getMyCustomerWithHttpInfo().getBody());
    }

    public ResponseEntity<CustomerDto> getMyCustomerWithHttpInfo() throws RestClientException {
        Object localVarPostBody = null;
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarCookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"x-tenant-id", "bearer"};
        ParameterizedTypeReference<CustomerDto> localReturnType = new ParameterizedTypeReference<CustomerDto>(){};
        return this.apiClient.invokeAPI("/iam/v1/customers/me", HttpMethod.GET, Collections.emptyMap(), (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
    }

    public CustomerDto getOne(String id) throws RestClientException {
        return (CustomerDto)((Object)this.getOneWithHttpInfo(id).getBody());
    }

    public ResponseEntity<CustomerDto> getOneWithHttpInfo(String id) throws RestClientException {
        Object localVarPostBody = null;
        if (id == null) {
            throw new HttpClientErrorException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Missing the required parameter 'id' when calling getOne");
        }
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("id", id);
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarCookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"x-tenant-id", "bearer"};
        ParameterizedTypeReference<CustomerDto> localReturnType = new ParameterizedTypeReference<CustomerDto>(){};
        return this.apiClient.invokeAPI("/iam/v1/customers/{id}", HttpMethod.GET, uriVariables, (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
    }

    public CustomerDto patch(String id, CustomerPatchFormData customerPatchFormData) throws RestClientException {
        return (CustomerDto)((Object)this.patchWithHttpInfo(id, customerPatchFormData).getBody());
    }

    public ResponseEntity<CustomerDto> patchWithHttpInfo(String id, CustomerPatchFormData customerPatchFormData) throws RestClientException {
        CustomerPatchFormData localVarPostBody = customerPatchFormData;
        if (id == null) {
            throw new HttpClientErrorException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Missing the required parameter 'id' when calling patch");
        }
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("id", id);
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarCookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"x-tenant-id", "bearer"};
        ParameterizedTypeReference<CustomerDto> localReturnType = new ParameterizedTypeReference<CustomerDto>(){};
        return this.apiClient.invokeAPI("/iam/v1/customers/{id}", HttpMethod.PATCH, uriVariables, (MultiValueMap<String, String>)localVarQueryParams, (Object)localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
    }

    public CustomerDto update(String id, CustomerDto customerDto) throws RestClientException {
        return (CustomerDto)((Object)this.updateWithHttpInfo(id, customerDto).getBody());
    }

    public ResponseEntity<CustomerDto> updateWithHttpInfo(String id, CustomerDto customerDto) throws RestClientException {
        CustomerDto localVarPostBody = customerDto;
        if (id == null) {
            throw new HttpClientErrorException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Missing the required parameter 'id' when calling update");
        }
        if (customerDto == null) {
            throw new HttpClientErrorException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Missing the required parameter 'customerDto' when calling update");
        }
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("id", id);
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarCookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"x-tenant-id", "bearer"};
        ParameterizedTypeReference<CustomerDto> localReturnType = new ParameterizedTypeReference<CustomerDto>(){};
        return this.apiClient.invokeAPI("/iam/v1/customers/{id}", HttpMethod.PUT, uriVariables, (MultiValueMap<String, String>)localVarQueryParams, (Object)localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
    }
}

