/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitamui.iam.openapiclient;

import fr.gouv.vitamui.iam.openapiclient.domain.CustomerDto;
import fr.gouv.vitamui.iam.openapiclient.domain.LoginRequestDto;
import fr.gouv.vitamui.iam.openapiclient.domain.SubrogationDto;
import fr.gouv.vitamui.iam.openapiclient.domain.UserDto;
import fr.gouv.vitamui.iam.openapiclient.invoker.ApiClient;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.web.client.RestClientException;

public class CasApi {
    private ApiClient apiClient;

    public CasApi() {
        this(new ApiClient());
    }

    public CasApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public String changePassword(String username, String password, String customerId) throws RestClientException {
        return (String)this.changePasswordWithHttpInfo(username, password, customerId).getBody();
    }

    public ResponseEntity<String> changePasswordWithHttpInfo(String username, String password, String customerId) throws RestClientException {
        Object localVarPostBody = null;
        if (username == null) {
            throw new HttpClientErrorException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Missing the required parameter 'username' when calling changePassword");
        }
        if (password == null) {
            throw new HttpClientErrorException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Missing the required parameter 'password' when calling changePassword");
        }
        if (customerId == null) {
            throw new HttpClientErrorException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Missing the required parameter 'customerId' when calling changePassword");
        }
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarCookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        if (username != null) {
            localVarHeaderParams.add("username", this.apiClient.parameterToString(username));
        }
        if (password != null) {
            localVarHeaderParams.add("password", this.apiClient.parameterToString(password));
        }
        if (customerId != null) {
            localVarHeaderParams.add("customerId", this.apiClient.parameterToString(customerId));
        }
        String[] localVarAccepts = new String[]{"*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"x-tenant-id", "bearer"};
        ParameterizedTypeReference<String> localReturnType = new ParameterizedTypeReference<String>(){};
        return this.apiClient.invokeAPI("/iam/v1/cas/password/change", HttpMethod.POST, Collections.emptyMap(), (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
    }

    public List<CustomerDto> getCustomersByIds(List<String> customerIds) throws RestClientException {
        return (List)this.getCustomersByIdsWithHttpInfo(customerIds).getBody();
    }

    public ResponseEntity<List<CustomerDto>> getCustomersByIdsWithHttpInfo(List<String> customerIds) throws RestClientException {
        Object localVarPostBody = null;
        if (customerIds == null) {
            throw new HttpClientErrorException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Missing the required parameter 'customerIds' when calling getCustomersByIds");
        }
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarCookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        localVarQueryParams.putAll(this.apiClient.parameterToMultiValueMap(ApiClient.CollectionFormat.valueOf("multi".toUpperCase(Locale.ROOT)), "customerIds", customerIds));
        String[] localVarAccepts = new String[]{"*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"x-tenant-id", "bearer"};
        ParameterizedTypeReference<List<CustomerDto>> localReturnType = new ParameterizedTypeReference<List<CustomerDto>>(){};
        return this.apiClient.invokeAPI("/iam/v1/cas/customers", HttpMethod.GET, Collections.emptyMap(), (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
    }

    public List<SubrogationDto> getSubrogationsBySuperUserIdOrEmailAndCustomerId(String superUserId, String superUserEmail, String superUserCustomerId) throws RestClientException {
        return (List)this.getSubrogationsBySuperUserIdOrEmailAndCustomerIdWithHttpInfo(superUserId, superUserEmail, superUserCustomerId).getBody();
    }

    public ResponseEntity<List<SubrogationDto>> getSubrogationsBySuperUserIdOrEmailAndCustomerIdWithHttpInfo(String superUserId, String superUserEmail, String superUserCustomerId) throws RestClientException {
        Object localVarPostBody = null;
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarCookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        localVarQueryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "superUserId", superUserId));
        localVarQueryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "superUserEmail", superUserEmail));
        localVarQueryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "superUserCustomerId", superUserCustomerId));
        String[] localVarAccepts = new String[]{"*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"x-tenant-id", "bearer"};
        ParameterizedTypeReference<List<SubrogationDto>> localReturnType = new ParameterizedTypeReference<List<SubrogationDto>>(){};
        return this.apiClient.invokeAPI("/iam/v1/cas/subrogations", HttpMethod.GET, Collections.emptyMap(), (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
    }

    public UserDto getUser(String loginEmail, String loginCustomerId, String idp, String userIdentifier, String embedded) throws RestClientException {
        return (UserDto)((Object)this.getUserWithHttpInfo(loginEmail, loginCustomerId, idp, userIdentifier, embedded).getBody());
    }

    public ResponseEntity<UserDto> getUserWithHttpInfo(String loginEmail, String loginCustomerId, String idp, String userIdentifier, String embedded) throws RestClientException {
        Object localVarPostBody = null;
        if (loginEmail == null) {
            throw new HttpClientErrorException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Missing the required parameter 'loginEmail' when calling getUser");
        }
        if (loginCustomerId == null) {
            throw new HttpClientErrorException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Missing the required parameter 'loginCustomerId' when calling getUser");
        }
        if (idp == null) {
            throw new HttpClientErrorException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Missing the required parameter 'idp' when calling getUser");
        }
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarCookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        localVarQueryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "loginEmail", loginEmail));
        localVarQueryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "loginCustomerId", loginCustomerId));
        localVarQueryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "idp", idp));
        localVarQueryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "userIdentifier", userIdentifier));
        localVarQueryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "embedded", embedded));
        String[] localVarAccepts = new String[]{"*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"x-tenant-id", "bearer"};
        ParameterizedTypeReference<UserDto> localReturnType = new ParameterizedTypeReference<UserDto>(){};
        return this.apiClient.invokeAPI("/iam/v1/cas/users/provisioning", HttpMethod.GET, Collections.emptyMap(), (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
    }

    public List<UserDto> getUsersByEmail(String email, String embedded) throws RestClientException {
        return (List)this.getUsersByEmailWithHttpInfo(email, embedded).getBody();
    }

    public ResponseEntity<List<UserDto>> getUsersByEmailWithHttpInfo(String email, String embedded) throws RestClientException {
        Object localVarPostBody = null;
        if (email == null) {
            throw new HttpClientErrorException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Missing the required parameter 'email' when calling getUsersByEmail");
        }
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarCookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        localVarQueryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "email", email));
        localVarQueryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "embedded", embedded));
        String[] localVarAccepts = new String[]{"*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"x-tenant-id", "bearer"};
        ParameterizedTypeReference<List<UserDto>> localReturnType = new ParameterizedTypeReference<List<UserDto>>(){};
        return this.apiClient.invokeAPI("/iam/v1/cas/users", HttpMethod.GET, Collections.emptyMap(), (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
    }

    public UserDto login(LoginRequestDto loginRequestDto) throws RestClientException {
        return (UserDto)((Object)this.loginWithHttpInfo(loginRequestDto).getBody());
    }

    public ResponseEntity<UserDto> loginWithHttpInfo(LoginRequestDto loginRequestDto) throws RestClientException {
        LoginRequestDto localVarPostBody = loginRequestDto;
        if (loginRequestDto == null) {
            throw new HttpClientErrorException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Missing the required parameter 'loginRequestDto' when calling login");
        }
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarCookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"x-tenant-id", "bearer"};
        ParameterizedTypeReference<UserDto> localReturnType = new ParameterizedTypeReference<UserDto>(){};
        return this.apiClient.invokeAPI("/iam/v1/cas/login", HttpMethod.POST, Collections.emptyMap(), (MultiValueMap<String, String>)localVarQueryParams, (Object)localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
    }

    public void logout(String authToken, String superUser, String superUserCustomerId) throws RestClientException {
        this.logoutWithHttpInfo(authToken, superUser, superUserCustomerId);
    }

    public ResponseEntity<Void> logoutWithHttpInfo(String authToken, String superUser, String superUserCustomerId) throws RestClientException {
        Object localVarPostBody = null;
        if (authToken == null) {
            throw new HttpClientErrorException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Missing the required parameter 'authToken' when calling logout");
        }
        if (superUser == null) {
            throw new HttpClientErrorException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Missing the required parameter 'superUser' when calling logout");
        }
        if (superUserCustomerId == null) {
            throw new HttpClientErrorException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Missing the required parameter 'superUserCustomerId' when calling logout");
        }
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarCookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        localVarQueryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "authToken", authToken));
        localVarQueryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "superUser", superUser));
        localVarQueryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "superUserCustomerId", superUserCustomerId));
        String[] localVarAccepts = new String[]{};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"x-tenant-id", "bearer"};
        ParameterizedTypeReference<Void> localReturnType = new ParameterizedTypeReference<Void>(){};
        return this.apiClient.invokeAPI("/iam/v1/cas/logout", HttpMethod.GET, Collections.emptyMap(), (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
    }
}

