/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitamui.iam.openapiclient;

import fr.gouv.vitamui.iam.openapiclient.domain.ApplicationDto;
import fr.gouv.vitamui.iam.openapiclient.invoker.ApiClient;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.web.client.RestClientException;

public class ApplicationsApi {
    private ApiClient apiClient;

    public ApplicationsApi() {
        this(new ApiClient());
    }

    public ApplicationsApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public List<ApplicationDto> getAll(String criteria, String embedded) throws RestClientException {
        return (List)this.getAllWithHttpInfo(criteria, embedded).getBody();
    }

    public ResponseEntity<List<ApplicationDto>> getAllWithHttpInfo(String criteria, String embedded) throws RestClientException {
        Object localVarPostBody = null;
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarCookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        localVarQueryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "criteria", criteria));
        localVarQueryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "embedded", embedded));
        String[] localVarAccepts = new String[]{"*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"x-tenant-id", "bearer"};
        ParameterizedTypeReference<List<ApplicationDto>> localReturnType = new ParameterizedTypeReference<List<ApplicationDto>>(){};
        return this.apiClient.invokeAPI("/iam/v1/applications", HttpMethod.GET, Collections.emptyMap(), (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
    }

    public Map<String, List<ApplicationDto>> getApplicationsFromUi(Boolean filterApp) throws RestClientException {
        return (Map)this.getApplicationsFromUiWithHttpInfo(filterApp).getBody();
    }

    public ResponseEntity<Map<String, List<ApplicationDto>>> getApplicationsFromUiWithHttpInfo(Boolean filterApp) throws RestClientException {
        Object localVarPostBody = null;
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarCookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        localVarQueryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "filterApp", filterApp));
        String[] localVarAccepts = new String[]{"*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"x-tenant-id", "bearer"};
        ParameterizedTypeReference<Map<String, List<ApplicationDto>>> localReturnType = new ParameterizedTypeReference<Map<String, List<ApplicationDto>>>(){};
        return this.apiClient.invokeAPI("/iam/v1/applications/filtered", HttpMethod.GET, Collections.emptyMap(), (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
    }

    public Boolean isApplicationExternalIdentifierEnabled(String identifier) throws RestClientException {
        return (Boolean)this.isApplicationExternalIdentifierEnabledWithHttpInfo(identifier).getBody();
    }

    public ResponseEntity<Boolean> isApplicationExternalIdentifierEnabledWithHttpInfo(String identifier) throws RestClientException {
        Object localVarPostBody = null;
        if (identifier == null) {
            throw new HttpClientErrorException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Missing the required parameter 'identifier' when calling isApplicationExternalIdentifierEnabled");
        }
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("identifier", identifier);
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarCookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"x-tenant-id", "bearer"};
        ParameterizedTypeReference<Boolean> localReturnType = new ParameterizedTypeReference<Boolean>(){};
        return this.apiClient.invokeAPI("/iam/v1/applications/{identifier}/externalid", HttpMethod.GET, uriVariables, (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
    }
}

