/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitamui.archives.search.server.service;

import com.fasterxml.jackson.databind.JsonNode;
import fr.gouv.vitam.common.client.VitamContext;
import fr.gouv.vitam.common.exception.VitamClientException;
import fr.gouv.vitam.common.model.RequestResponse;
import fr.gouv.vitam.common.model.dip.DataObjectVersions;
import fr.gouv.vitam.common.model.export.dip.DipExportType;
import fr.gouv.vitam.common.model.export.dip.DipRequest;
import fr.gouv.vitamui.archives.search.common.dto.ExportDipCriteriaDto;
import fr.gouv.vitamui.archives.search.server.service.ArchiveSearchExternalParametersService;
import fr.gouv.vitamui.archives.search.server.service.ArchiveSearchService;
import fr.gouv.vitamui.archives.search.server.service.ArchiveSearchThresholdService;
import fr.gouv.vitamui.commons.vitam.api.access.ExportDipV2Service;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

@Service
public class ExportDipService {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExportDipService.class);
    public static final String OPERATION_IDENTIFIER = "itemId";
    private final ExportDipV2Service exportDipV2Service;
    private final ArchiveSearchService archiveSearchService;
    private final ArchiveSearchThresholdService archiveSearchThresholdService;
    private final ArchiveSearchExternalParametersService archiveSearchExternalParametersService;

    public ExportDipService(@Lazy ArchiveSearchService archiveSearchService, ExportDipV2Service exportDipV2Service, ArchiveSearchThresholdService archiveSearchThresholdService, ArchiveSearchExternalParametersService archiveSearchExternalParametersService) {
        this.archiveSearchService = archiveSearchService;
        this.exportDipV2Service = exportDipV2Service;
        this.archiveSearchThresholdService = archiveSearchThresholdService;
        this.archiveSearchExternalParametersService = archiveSearchExternalParametersService;
    }

    private JsonNode exportDIP(VitamContext vitamContext, DipRequest dipRequest) throws VitamClientException {
        RequestResponse response = this.exportDipV2Service.exportDip(vitamContext, dipRequest);
        return response.toJsonNode();
    }

    private DipRequest prepareDipRequestBody(ExportDipCriteriaDto exportDipCriteriaDto, JsonNode dslQuery) {
        DipRequest dipRequest = new DipRequest();
        if (exportDipCriteriaDto != null) {
            DataObjectVersions dataObjectVersionToExport = new DataObjectVersions();
            dataObjectVersionToExport.setDataObjectVersionsPatterns(exportDipCriteriaDto.getDataObjectVersionsPatterns());
            dipRequest.setExportWithLogBookLFC(exportDipCriteriaDto.isLifeCycleLogs());
            dipRequest.setExportWithoutObjects(exportDipCriteriaDto.isWithoutObjects());
            dipRequest.setDslRequest(dslQuery);
            dipRequest.setDipExportType(DipExportType.FULL);
            dipRequest.setDataObjectVersionToExport(dataObjectVersionToExport);
            dipRequest.setDipRequestParameters(exportDipCriteriaDto.getDipRequestParameters());
            dipRequest.setSedaVersion(exportDipCriteriaDto.getSedaVersion());
            dipRequest.setExportWithTree(exportDipCriteriaDto.isExportWithTree());
            dipRequest.setUseOriginalFilenames(exportDipCriteriaDto.isExportWithTree());
        }
        return dipRequest;
    }

    public String requestToExportDIP(ExportDipCriteriaDto exportDipCriteriaDto) throws VitamClientException {
        LOGGER.debug("Export DIP by criteria {} ", (Object)exportDipCriteriaDto.toString());
        VitamContext vitamContext = this.archiveSearchExternalParametersService.buildVitamContextFromExternalParam();
        Optional<Long> thresholdOpt = this.archiveSearchThresholdService.retrieveProfilThresholds();
        thresholdOpt.ifPresent(aLong -> exportDipCriteriaDto.getExportDIPSearchCriteria().setThreshold(aLong));
        JsonNode dslQuery = this.archiveSearchService.prepareDslQuery(exportDipCriteriaDto.getExportDIPSearchCriteria(), vitamContext);
        LOGGER.debug("Export DIP final DSL query {} ", (Object)dslQuery);
        DipRequest dipRequest = this.prepareDipRequestBody(exportDipCriteriaDto, dslQuery);
        JsonNode response = this.exportDIP(vitamContext, dipRequest);
        return response.findValue(OPERATION_IDENTIFIER).textValue();
    }
}

