/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitamui.archives.search.server.service;

import fr.gouv.vitamui.commons.vitam.api.dto.QualifiersDto;
import fr.gouv.vitamui.commons.vitam.api.dto.ResultsDto;
import fr.gouv.vitamui.commons.vitam.api.dto.VersionsDto;
import fr.gouv.vitamui.commons.vitam.api.model.ObjectQualifierType;
import jakarta.validation.constraints.NotNull;
import jakarta.ws.rs.core.Response;
import java.io.InputStream;
import java.util.Comparator;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.springframework.core.io.InputStreamResource;
import org.springframework.core.io.Resource;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import reactor.core.publisher.Mono;

public final class ArchiveSearchUtils {
    public static QualifiersDto getLastObjectQualifier(ResultsDto got) {
        for (String qualifierName : ObjectQualifierType.allValuesOrdered) {
            QualifiersDto qualifierFound = got.getQualifiers().stream().filter(qualifier -> qualifierName.equals(qualifier.getQualifier())).reduce((first, second) -> second).orElse(null);
            if (!Objects.nonNull(qualifierFound)) continue;
            return qualifierFound;
        }
        return null;
    }

    public static VersionsDto getLastVersion(QualifiersDto qualifier) {
        return qualifier.getVersions().stream().max(Comparator.comparing(ArchiveSearchUtils::extractVersion)).orElse(null);
    }

    @NotNull
    public static Integer extractVersion(VersionsDto versionsDto) {
        return Integer.parseInt(versionsDto.getDataObjectVersion().split("_")[1]);
    }

    public static String getExtension(VersionsDto version) {
        String uriExtension = "";
        if (StringUtils.isNotBlank((CharSequence)version.getUri()) && version.getUri().contains(".")) {
            uriExtension = version.getUri().substring(version.getUri().lastIndexOf(46) + 1);
        }
        String filenameExtension = "";
        if (Objects.nonNull(version.getFileInfoModel()) && StringUtils.isNotBlank((CharSequence)version.getFileInfoModel().getFilename()) && version.getFileInfoModel().getFilename().contains(".")) {
            filenameExtension = version.getFileInfoModel().getFilename().substring(version.getFileInfoModel().getFilename().lastIndexOf(46) + 1);
        }
        if (StringUtils.isNotBlank((CharSequence)filenameExtension)) {
            return "." + filenameExtension;
        }
        if (StringUtils.isNotBlank((CharSequence)uriExtension)) {
            return "." + uriExtension;
        }
        return "";
    }

    public static String getFilename(VersionsDto version) {
        if (Objects.isNull(version) || StringUtils.isEmpty((CharSequence)version.getId())) {
            return null;
        }
        return version.getId() + ArchiveSearchUtils.getExtension(version);
    }

    public static Mono<ResponseEntity<Resource>> convertResponseToMono(Response jaxRsResponse, String fileName) {
        return Mono.fromCallable(() -> {
            InputStream inputStream = (InputStream)jaxRsResponse.readEntity(InputStream.class);
            InputStreamResource resource = new InputStreamResource(inputStream);
            HttpHeaders headers = new HttpHeaders();
            headers.add("Content-Disposition", "attachment; filename=" + fileName);
            headers.add("Content-Type", "application/octet-stream");
            return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatusCode)HttpStatus.OK).headers(headers)).body((Object)resource);
        });
    }
}

