/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitamui.archives.search.server.service;

import fr.gouv.vitam.access.external.client.AccessExternalClient;
import fr.gouv.vitam.common.client.VitamContext;
import fr.gouv.vitam.common.database.builder.request.multiple.UpdateMultiQuery;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.exception.VitamClientException;
import fr.gouv.vitam.common.json.JsonHandler;
import fr.gouv.vitam.common.model.RequestResponse;
import fr.gouv.vitamui.archives.search.common.dto.OperationIdDto;
import fr.gouv.vitamui.archives.search.common.dto.UpdateArchiveUnitDto;
import fr.gouv.vitamui.archives.search.common.dto.converter.UpdateArchiveUnitDtoToUpdateMultiQueryConverter;
import fr.gouv.vitamui.archives.search.common.exception.ArchiveUnitUpdateException;
import fr.gouv.vitamui.archives.search.common.model.OperationId;
import fr.gouv.vitamui.archives.search.common.service.ArchiveUnitService;
import fr.gouv.vitamui.archives.search.server.service.ArchiveSearchExternalParametersService;
import fr.gouv.vitamui.commons.api.converter.JsonPatchDtoToUpdateMultiQueryConverter;
import fr.gouv.vitamui.commons.api.converter.UpdateMultiQueriesToBulkCommandDto;
import fr.gouv.vitamui.commons.api.dtos.BulkCommandDto;
import fr.gouv.vitamui.commons.api.dtos.JsonPatchDto;
import fr.gouv.vitamui.commons.api.dtos.MultiJsonPatchDto;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class ArchiveSearchUnitServiceImpl
implements ArchiveUnitService {
    private static final Logger log = LoggerFactory.getLogger(ArchiveSearchUnitServiceImpl.class);
    private final AccessExternalClient accessExternalClient;
    private final UpdateArchiveUnitDtoToUpdateMultiQueryConverter updateArchiveUnitDtoToUpdateMultiQueryConverter;
    private final ArchiveSearchExternalParametersService archiveSearchExternalParametersService;
    private final JsonPatchDtoToUpdateMultiQueryConverter jsonPatchDtoToUpdateMultiQueryConverter;
    private final UpdateMultiQueriesToBulkCommandDto updateMultiQueriesToBulkCommandDto;

    public ArchiveSearchUnitServiceImpl(AccessExternalClient accessExternalClient, UpdateArchiveUnitDtoToUpdateMultiQueryConverter updateArchiveUnitDtoToUpdateMultiQueryConverter, ArchiveSearchExternalParametersService archiveSearchExternalParametersService, JsonPatchDtoToUpdateMultiQueryConverter jsonPatchDtoToUpdateMultiQueryConverter, UpdateMultiQueriesToBulkCommandDto updateMultiQueriesToBulkCommandDto) {
        this.accessExternalClient = accessExternalClient;
        this.updateArchiveUnitDtoToUpdateMultiQueryConverter = updateArchiveUnitDtoToUpdateMultiQueryConverter;
        this.archiveSearchExternalParametersService = archiveSearchExternalParametersService;
        this.jsonPatchDtoToUpdateMultiQueryConverter = jsonPatchDtoToUpdateMultiQueryConverter;
        this.updateMultiQueriesToBulkCommandDto = updateMultiQueriesToBulkCommandDto;
    }

    public OperationIdDto update(Set<UpdateArchiveUnitDto> updateArchiveUnitDtoSet) {
        Set<UpdateMultiQuery> updateMultiQueries = updateArchiveUnitDtoSet.stream().map(arg_0 -> ((UpdateArchiveUnitDtoToUpdateMultiQueryConverter)this.updateArchiveUnitDtoToUpdateMultiQueryConverter).convert(arg_0)).filter(Objects::nonNull).collect(Collectors.toSet());
        if (updateArchiveUnitDtoSet.size() != updateMultiQueries.size()) {
            throw new ArchiveUnitUpdateException("Fail to convert some archive unit updates payload to dsl queries");
        }
        return this.send(updateMultiQueries);
    }

    public OperationIdDto update(JsonPatchDto jsonPatchDto) {
        UpdateMultiQuery updateMultiQuery = this.jsonPatchDtoToUpdateMultiQueryConverter.convert(jsonPatchDto);
        if (updateMultiQuery == null) {
            throw new ArchiveUnitUpdateException("Fail to convert json patch payload to dsl query");
        }
        Set<UpdateMultiQuery> updateMultiQueries = Set.of(updateMultiQuery);
        return this.send(updateMultiQueries);
    }

    public OperationIdDto update(MultiJsonPatchDto multiJsonPatchDto) {
        Set<UpdateMultiQuery> updateMultiQueries = multiJsonPatchDto.stream().map(arg_0 -> ((JsonPatchDtoToUpdateMultiQueryConverter)this.jsonPatchDtoToUpdateMultiQueryConverter).convert(arg_0)).filter(Objects::nonNull).collect(Collectors.toSet());
        if (multiJsonPatchDto.size() != updateMultiQueries.size()) {
            throw new ArchiveUnitUpdateException("Fail to convert some json patch payloads to dsl queries");
        }
        return this.send(updateMultiQueries);
    }

    private OperationIdDto send(Set<UpdateMultiQuery> updateMultiQueries) {
        VitamContext context = this.archiveSearchExternalParametersService.buildVitamContextFromExternalParam();
        BulkCommandDto bulkCommandDto = this.updateMultiQueriesToBulkCommandDto.convert(updateMultiQueries);
        try {
            RequestResponse payload = this.accessExternalClient.bulkAtomicUpdateUnits(context, JsonHandler.toJsonNode((Object)bulkCommandDto));
            OperationId operationId = new OperationId(payload.getHeaderString("X-Request-Id"));
            OperationIdDto operationIdDto = new OperationIdDto().setOperationId(operationId);
            log.info("Operation started: {}", (Object)operationIdDto);
            return operationIdDto;
        }
        catch (InvalidParseOperationException | VitamClientException e) {
            log.error("{}", e);
            throw new ArchiveUnitUpdateException(e);
        }
    }
}

