/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitamui.archives.search.server.service;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import fr.gouv.vitam.common.client.VitamContext;
import fr.gouv.vitam.common.database.builder.query.BooleanQuery;
import fr.gouv.vitam.common.database.builder.query.Query;
import fr.gouv.vitam.common.database.builder.query.QueryHelper;
import fr.gouv.vitam.common.database.builder.request.exception.InvalidCreateOperationException;
import fr.gouv.vitam.common.database.builder.request.single.Select;
import fr.gouv.vitam.common.exception.VitamClientException;
import fr.gouv.vitam.common.model.RequestResponse;
import fr.gouv.vitam.common.model.administration.FileRulesModel;
import fr.gouv.vitamui.commons.api.dtos.CriteriaValue;
import fr.gouv.vitamui.commons.api.dtos.SearchCriteriaDto;
import fr.gouv.vitamui.commons.api.dtos.SearchCriteriaEltDto;
import fr.gouv.vitamui.commons.api.exception.BadRequestException;
import fr.gouv.vitamui.commons.api.utils.ArchiveSearchConsts;
import fr.gouv.vitamui.commons.vitam.api.administration.RuleCommonService;
import fr.gouv.vitamui.commons.vitam.api.dto.RuleNodeResponseDto;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class ArchiveSearchRulesService {
    private static final Logger LOGGER = LoggerFactory.getLogger(ArchiveSearchRulesService.class);
    private final ObjectMapper objectMapper;
    private final RuleCommonService ruleCommonService;

    public ArchiveSearchRulesService(ObjectMapper objectMapper, RuleCommonService ruleCommonService) {
        this.objectMapper = objectMapper;
        this.ruleCommonService = ruleCommonService;
    }

    public void mapManagementRulesTitlesToCodes(SearchCriteriaDto searchQuery, VitamContext vitamContext) throws VitamClientException {
        if (!CollectionUtils.isEmpty((Collection)searchQuery.getCriteriaList())) {
            for (ArchiveSearchConsts.CriteriaMgtRulesCategory mgtRulesCategory : ArchiveSearchConsts.CriteriaMgtRulesCategory.values()) {
                ArchiveSearchConsts.CriteriaCategory category = ArchiveSearchConsts.CriteriaCategory.valueOf((String)mgtRulesCategory.name());
                if (category == null) continue;
                List titleRulesCriteriaList = searchQuery.extractCriteriaListByCategoryAndFieldNames(category, List.of("RULE_TITLE"));
                List<SearchCriteriaEltDto> appraisalMgtRulesCriteriaListProcessed = searchQuery.getCriteriaList().stream().filter(criteriaElt -> !category.equals((Object)criteriaElt.getCategory()) || !criteriaElt.getCriteria().equals("RULE_TITLE")).collect(Collectors.toList());
                if (CollectionUtils.isEmpty((Collection)titleRulesCriteriaList)) continue;
                for (SearchCriteriaEltDto titleCriteriaElt : titleRulesCriteriaList) {
                    if (CollectionUtils.isEmpty((Collection)titleCriteriaElt.getValues())) continue;
                    List<String> mgtRulesIdsFound = this.findRulesByNames(vitamContext, titleCriteriaElt.getValues().stream().map(CriteriaValue::getValue).collect(Collectors.toList()), ArchiveSearchConsts.CriteriaMgtRulesCategory.valueOf((String)category.name()).getFieldMapping()).stream().map(FileRulesModel::getRuleId).collect(Collectors.toList());
                    this.handleFoundRules(searchQuery, category, appraisalMgtRulesCriteriaListProcessed, mgtRulesIdsFound);
                }
            }
        }
    }

    private void handleFoundRules(SearchCriteriaDto searchQuery, ArchiveSearchConsts.CriteriaCategory category, List<SearchCriteriaEltDto> appraisalMgtRulesCriteriaListProcessed, List<String> mgtRulesIdsFound) {
        if (!CollectionUtils.isEmpty(mgtRulesIdsFound)) {
            SearchCriteriaEltDto ruleIdCriteria;
            Map appraisalMgtRulesCriteriaMap = appraisalMgtRulesCriteriaListProcessed.stream().collect(Collectors.toMap(SearchCriteriaEltDto::getCriteria, Function.identity()));
            if (appraisalMgtRulesCriteriaMap.containsKey("RULE_IDENTIFIER")) {
                ruleIdCriteria = (SearchCriteriaEltDto)appraisalMgtRulesCriteriaMap.get("RULE_IDENTIFIER");
                if (!CollectionUtils.isEmpty(mgtRulesIdsFound)) {
                    mgtRulesIdsFound.addAll(ruleIdCriteria.getValues().stream().map(CriteriaValue::getValue).collect(Collectors.toList()));
                }
            } else {
                ruleIdCriteria = new SearchCriteriaEltDto();
                ruleIdCriteria.setCriteria("RULE_IDENTIFIER");
                ruleIdCriteria.setOperator(ArchiveSearchConsts.CriteriaOperators.EQ.name());
                ruleIdCriteria.setCategory(category);
            }
            ruleIdCriteria.setValues(mgtRulesIdsFound.stream().map(CriteriaValue::new).collect(Collectors.toList()));
            appraisalMgtRulesCriteriaMap.put("RULE_IDENTIFIER", ruleIdCriteria);
            searchQuery.setCriteriaList(new ArrayList(appraisalMgtRulesCriteriaMap.values()));
        }
    }

    public List<FileRulesModel> findRulesByCriteria(VitamContext vitamContext, String field, List<String> rulesIdentifiers, String ruleType) throws VitamClientException {
        List<Object> rules = new ArrayList<FileRulesModel>();
        if (rulesIdentifiers != null && !rulesIdentifiers.isEmpty()) {
            LOGGER.debug("Finding management rules by field {}  values {} ", (Object)field, rulesIdentifiers);
            HashMap<String, String> searchCriteriaMap = new HashMap<String, String>();
            searchCriteriaMap.put(field, rulesIdentifiers.get(0));
            if (ruleType != null) {
                searchCriteriaMap.put("RuleType", ruleType);
            }
            try {
                Select select = new Select();
                BooleanQuery query = QueryHelper.and();
                BooleanQuery queryOr = QueryHelper.or();
                for (String elt : rulesIdentifiers) {
                    queryOr.add(new Query[]{QueryHelper.eq((String)field, (String)elt)});
                }
                query.add(new Query[]{queryOr});
                select.setLimitFilter(0L, (long)rulesIdentifiers.size());
                if (ruleType != null) {
                    query.add(new Query[]{QueryHelper.eq((String)"RuleType", (String)ruleType)});
                }
                select.setQuery((Query)query);
                ObjectNode queryRules = select.getFinalSelect();
                RequestResponse requestResponse = this.ruleCommonService.findRules(vitamContext, (JsonNode)queryRules);
                rules = ((RuleNodeResponseDto)this.objectMapper.treeToValue((TreeNode)requestResponse.toJsonNode(), RuleNodeResponseDto.class)).getResults();
            }
            catch (InvalidCreateOperationException e) {
                throw new VitamClientException("Unable to find the rules ", (Throwable)e);
            }
            catch (JsonProcessingException e1) {
                throw new BadRequestException("Error parsing query ", (Throwable)e1);
            }
        }
        LOGGER.debug("management rules  found {} ", rules);
        return rules;
    }

    public List<FileRulesModel> findRulesByNames(VitamContext vitamContext, List<String> rulesIdentifiers, String ruleType) throws VitamClientException {
        ArrayList<String> rulesIdentifiersList = new ArrayList<String>(rulesIdentifiers);
        return this.findRulesByCriteria(vitamContext, "RuleValue", rulesIdentifiersList, ruleType);
    }
}

