/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitamui.archives.search.server.service;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import fr.gouv.vitam.common.client.VitamContext;
import fr.gouv.vitam.common.exception.VitamClientException;
import fr.gouv.vitam.common.model.RequestResponse;
import fr.gouv.vitam.common.model.administration.AccessContractModel;
import fr.gouv.vitam.common.model.massupdate.MassUpdateUnitRuleRequest;
import fr.gouv.vitam.common.model.massupdate.RuleActions;
import fr.gouv.vitamui.archives.search.common.common.RulesUpdateCommonService;
import fr.gouv.vitamui.archives.search.common.dto.RuleSearchCriteriaDto;
import fr.gouv.vitamui.archives.search.server.converter.RuleOperationsConverter;
import fr.gouv.vitamui.archives.search.server.service.ArchiveSearchExternalParametersService;
import fr.gouv.vitamui.archives.search.server.service.ArchiveSearchService;
import fr.gouv.vitamui.archives.search.server.service.ArchiveSearchThresholdService;
import fr.gouv.vitamui.commons.api.dtos.SearchCriteriaDto;
import fr.gouv.vitamui.commons.api.exception.ForbiddenException;
import fr.gouv.vitamui.commons.api.exception.InternalServerException;
import fr.gouv.vitamui.commons.api.utils.MetadataSearchCriteriaUtils;
import fr.gouv.vitamui.commons.vitam.api.access.UnitCommonService;
import fr.gouv.vitamui.commons.vitam.api.administration.AccessContractCommonService;
import fr.gouv.vitamui.commons.vitam.api.dto.AccessContractResponseDto;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class ArchiveSearchMgtRulesService {
    private static final Logger LOGGER = LoggerFactory.getLogger(ArchiveSearchMgtRulesService.class);
    private final ObjectMapper objectMapper;
    private final ArchiveSearchService archiveSearchService;
    private final RuleOperationsConverter ruleOperationsConverter;
    private final AccessContractCommonService accessContractCommonService;
    private final ArchiveSearchThresholdService archiveSearchThresholdService;
    private final ArchiveSearchExternalParametersService archiveSearchExternalParametersService;
    private final UnitCommonService unitCommonService;

    public ArchiveSearchMgtRulesService(@Lazy ArchiveSearchService archiveSearchService, RuleOperationsConverter ruleOperationsConverter, AccessContractCommonService accessContractCommonService, UnitCommonService unitCommonService, ObjectMapper objectMapper, ArchiveSearchThresholdService archiveSearchThresholdService, ArchiveSearchExternalParametersService archiveSearchExternalParametersService) {
        this.archiveSearchService = archiveSearchService;
        this.objectMapper = objectMapper;
        this.ruleOperationsConverter = ruleOperationsConverter;
        this.accessContractCommonService = accessContractCommonService;
        this.unitCommonService = unitCommonService;
        this.archiveSearchThresholdService = archiveSearchThresholdService;
        this.archiveSearchExternalParametersService = archiveSearchExternalParametersService;
    }

    public String updateArchiveUnitsRules(RuleSearchCriteriaDto ruleSearchCriteriaDto) throws VitamClientException {
        LOGGER.debug("Add Rules to ArchiveUnits using query : {} and DSL actions : {}", (Object)ruleSearchCriteriaDto.getSearchCriteriaDto().toString(), (Object)ruleSearchCriteriaDto.getRuleActions());
        VitamContext vitamContext = this.archiveSearchExternalParametersService.buildVitamContextFromExternalParam();
        Optional<Long> thresholdOpt = this.archiveSearchThresholdService.retrieveProfilThresholds();
        thresholdOpt.ifPresent(aLong -> ruleSearchCriteriaDto.getSearchCriteriaDto().setThreshold(aLong));
        boolean hasAccessContractWritePermission = this.checkAccessContractWritePermission(vitamContext);
        if (!hasAccessContractWritePermission) {
            LOGGER.error("the access contract : {} ,using to update unit rules has no writing permission to update units", (Object)vitamContext.getAccessContract());
            throw new ForbiddenException("the access contract using to update unit rules has no writing permission to update units");
        }
        RuleActions ruleActions = this.ruleOperationsConverter.convertToVitamRuleActions(ruleSearchCriteriaDto.getRuleActions());
        MassUpdateUnitRuleRequest massUpdateUnitRuleRequest = new MassUpdateUnitRuleRequest();
        JsonNode dslQuery = MetadataSearchCriteriaUtils.mapRequestToDslQuery((SearchCriteriaDto)ruleSearchCriteriaDto.getSearchCriteriaDto());
        ObjectNode dslRequest = (ObjectNode)dslQuery;
        RulesUpdateCommonService.deleteAttributesFromObjectNode((ObjectNode)dslRequest, (String[])new String[]{"$projection", "$filter", "$facets"});
        RulesUpdateCommonService.setMassUpdateUnitRuleRequest((MassUpdateUnitRuleRequest)massUpdateUnitRuleRequest, (RuleActions)ruleActions, (ObjectNode)dslRequest);
        this.objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        JsonNode updateQuery = (JsonNode)this.objectMapper.convertValue((Object)massUpdateUnitRuleRequest, JsonNode.class);
        LOGGER.debug("Add Rules to UA final updateQuery : {}", (Object)updateQuery);
        return this.massUpdateUnitsRules(vitamContext, updateQuery);
    }

    public String massUpdateUnitsRules(VitamContext vitamContext, JsonNode updateQuery) throws VitamClientException {
        JsonNode response = this.unitCommonService.massUpdateUnitsRules(vitamContext, updateQuery).toJsonNode();
        return response.findValue("itemId").textValue();
    }

    private boolean checkAccessContractWritePermission(VitamContext vitamContext) {
        AccessContractResponseDto accessContractResponseDto;
        LOGGER.debug("Check access contract writing permissions : {}", (Object)vitamContext.getAccessContract());
        try {
            RequestResponse response = this.accessContractCommonService.findAccessContractById(vitamContext, vitamContext.getAccessContract());
            accessContractResponseDto = (AccessContractResponseDto)this.objectMapper.treeToValue((TreeNode)response.toJsonNode(), AccessContractResponseDto.class);
        }
        catch (JsonProcessingException | VitamClientException e) {
            throw new InternalServerException("Error while parsing Vitam response", e);
        }
        if (Objects.nonNull(accessContractResponseDto) && !CollectionUtils.isEmpty((Collection)accessContractResponseDto.getResults())) {
            return ((AccessContractModel)accessContractResponseDto.getResults().get(0)).getWritingPermission();
        }
        LOGGER.error("the access contract {} using to update unit rules is not found in vitam", (Object)vitamContext.getAccessContract());
        throw new ForbiddenException("the access contract is not found, update unit rules will fail.");
    }
}

