/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitamui.archives.search.server.service;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import fr.gouv.vitam.common.client.VitamContext;
import fr.gouv.vitam.common.database.builder.facet.Facet;
import fr.gouv.vitam.common.database.builder.facet.FacetHelper;
import fr.gouv.vitam.common.database.builder.facet.RangeFacetValue;
import fr.gouv.vitam.common.database.builder.request.exception.InvalidCreateOperationException;
import fr.gouv.vitam.common.database.builder.request.multiple.SelectMultiQuery;
import fr.gouv.vitam.common.database.facet.model.FacetOrder;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.exception.VitamClientException;
import fr.gouv.vitamui.archives.search.server.service.ArchiveSearchService;
import fr.gouv.vitamui.commons.api.dtos.CriteriaValue;
import fr.gouv.vitamui.commons.api.dtos.SearchCriteriaDto;
import fr.gouv.vitamui.commons.api.dtos.SearchCriteriaEltDto;
import fr.gouv.vitamui.commons.api.exception.BadRequestException;
import fr.gouv.vitamui.commons.api.utils.ArchiveSearchConsts;
import fr.gouv.vitamui.commons.api.utils.MetadataSearchCriteriaUtils;
import fr.gouv.vitamui.commons.vitam.api.dto.FacetBucketDto;
import fr.gouv.vitamui.commons.vitam.api.dto.FacetResultsDto;
import fr.gouv.vitamui.commons.vitam.api.dto.VitamUISearchResponseDto;
import jakarta.validation.constraints.NotNull;
import java.time.LocalDateTime;
import java.time.format.DateTimeParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class ArchiveSearchFacetsService {
    private static final Logger LOGGER = LoggerFactory.getLogger(ArchiveSearchFacetsService.class);
    public static final String SOME_OLD_DATE = "01/01/0001";
    public static final String SOME_FUTUR_DATE = "31/12/9999";
    public static final String COMPUTED_FIELDS = "#computedInheritedRules.";
    public static final String MAX_END_DATE_FIELD = ".MaxEndDate";
    public static final String RULES_RULE_ID_FIELD = ".Rules.Rule";
    public static final String FINAL_ACTION_FIELD = ".FinalAction";
    private final ArchiveSearchService archiveSearchService;
    private final ObjectMapper objectMapper;

    public ArchiveSearchFacetsService(@Lazy ArchiveSearchService archiveSearchService, ObjectMapper objectMapper) {
        this.archiveSearchService = archiveSearchService;
        this.objectMapper = objectMapper;
    }

    private List<FacetResultsDto> computeFacetsForAuHavingRules(SearchCriteriaDto searchQuery, ArchiveSearchConsts.CriteriaCategory category, boolean trackTotalHits, VitamContext vitamContext) throws InvalidParseOperationException, InvalidCreateOperationException, VitamClientException, JsonProcessingException {
        ArrayList<SearchCriteriaEltDto> criteriaList = new ArrayList<SearchCriteriaEltDto>(searchQuery.getCriteriaList());
        criteriaList.add(new SearchCriteriaEltDto("RULES_COMPUTED", ArchiveSearchConsts.CriteriaCategory.FIELDS, ArchiveSearchConsts.CriteriaOperators.EQ.name(), List.of(new CriteriaValue("true")), ArchiveSearchConsts.CriteriaDataType.STRING.name()));
        criteriaList.add(new SearchCriteriaEltDto("RULE_ORIGIN", category, ArchiveSearchConsts.CriteriaOperators.EQ.name(), List.of(new CriteriaValue(ArchiveSearchConsts.RuleOriginValues.ORIGIN_LOCAL_OR_INHERIT_RULES.name())), ArchiveSearchConsts.CriteriaDataType.STRING.name()));
        SelectMultiQuery selectMultiQuery = MetadataSearchCriteriaUtils.createSelectMultiQuery(criteriaList);
        selectMultiQuery.setLimitFilter(0L, 1L);
        selectMultiQuery.trackTotalHits(trackTotalHits);
        try {
            List<SearchCriteriaEltDto> rulesCriteriaList = searchQuery.getCriteriaList().stream().filter(Objects::nonNull).filter(searchCriteriaEltDto -> category.equals((Object)searchCriteriaEltDto.getCategory())).collect(Collectors.toList());
            String computedRulesIdentifierMapping = COMPUTED_FIELDS + ArchiveSearchConsts.CriteriaMgtRulesCategory.valueOf((String)category.name()).getFieldMapping() + RULES_RULE_ID_FIELD;
            if (ArchiveSearchConsts.CriteriaCategory.APPRAISAL_RULE.equals((Object)category) || ArchiveSearchConsts.CriteriaCategory.STORAGE_RULE.equals((Object)category)) {
                String computedRulesFinalActionMapping = COMPUTED_FIELDS + ArchiveSearchConsts.CriteriaMgtRulesCategory.valueOf((String)category.name()).getFieldMapping() + FINAL_ACTION_FIELD;
                selectMultiQuery.addFacets(new Facet[]{FacetHelper.terms((String)("FINAL_ACTION_COMPUTED_" + category.name()), (String)computedRulesFinalActionMapping, (Integer)3, (FacetOrder)FacetOrder.ASC)});
            }
            selectMultiQuery.addFacets(new Facet[]{FacetHelper.terms((String)("RULES_COMPUTED_NUMBER_" + category.name()), (String)computedRulesIdentifierMapping, (Integer)100, (FacetOrder)FacetOrder.ASC)});
            this.addExpirationRulesFacet(rulesCriteriaList, category, selectMultiQuery);
        }
        catch (DateTimeParseException e) {
            throw new InvalidCreateOperationException((Throwable)e);
        }
        ObjectNode dslQuery = selectMultiQuery.getFinalSelect();
        JsonNode vitamResponse = this.archiveSearchService.searchArchiveUnits((JsonNode)dslQuery, vitamContext);
        VitamUISearchResponseDto archivesUnitsResults = (VitamUISearchResponseDto)this.objectMapper.treeToValue((TreeNode)vitamResponse, VitamUISearchResponseDto.class);
        List auWithRulesFacets = archivesUnitsResults.getFacetResults();
        if (ArchiveSearchConsts.CriteriaCategory.APPRAISAL_RULE.equals((Object)category) || ArchiveSearchConsts.CriteriaCategory.STORAGE_RULE.equals((Object)category)) {
            FacetResultsDto finalActionIndexedFacet = this.buildComputedAuFinalActionFacet(searchQuery.getCriteriaList(), category, auWithRulesFacets, trackTotalHits, vitamContext);
            auWithRulesFacets = auWithRulesFacets.stream().filter(facet -> !("FINAL_ACTION_COMPUTED_" + category.name()).equals(facet.getName())).collect(Collectors.toList());
            auWithRulesFacets.add(finalActionIndexedFacet);
        }
        return auWithRulesFacets;
    }

    @NotNull
    private List<FacetBucketDto> computeFinalActionFacetsForComputedAppraisalRules(List<SearchCriteriaEltDto> indexedArchiveUnitsCriteriaList, List<FacetResultsDto> indexedRulesFacets, ArchiveSearchConsts.CriteriaCategory category, boolean trackTotalHits, VitamContext vitamContext) throws VitamClientException, JsonProcessingException {
        HashMap<String, Long> finalActionCountMap = new HashMap<String, Long>();
        finalActionCountMap.put("Keep", 0L);
        finalActionCountMap.put("Destroy", 0L);
        finalActionCountMap.put("Conflict", 0L);
        Optional<FacetResultsDto> facetFinalActionValue = indexedRulesFacets.stream().filter(facet -> ("FINAL_ACTION_COMPUTED_" + category.name()).equals(facet.getName())).findAny();
        facetFinalActionValue.ifPresent(facetResultsDto -> facetResultsDto.getBuckets().stream().forEach(bucket -> finalActionCountMap.put(bucket.getValue(), bucket.getCount())));
        Integer withConflictFinalActionUnitsCount = this.computeFinalActionCountByValue(indexedArchiveUnitsCriteriaList, "FINAL_ACTION_TYPE_CONFLICT", category, trackTotalHits, vitamContext);
        finalActionCountMap.put("Conflict", Long.valueOf(withConflictFinalActionUnitsCount.intValue()));
        if (withConflictFinalActionUnitsCount != 0) {
            Long withKeepFinalActionAppraisalRulesUnitsCount = (Long)finalActionCountMap.get("Keep");
            Long withDestroyFinalActionAppraisalRulesUnitsCount = (Long)finalActionCountMap.get("Destroy");
            if (withKeepFinalActionAppraisalRulesUnitsCount > 0L) {
                finalActionCountMap.put("Keep", withKeepFinalActionAppraisalRulesUnitsCount - (long)withConflictFinalActionUnitsCount.intValue());
            }
            if (withDestroyFinalActionAppraisalRulesUnitsCount > 0L) {
                finalActionCountMap.put("Destroy", withDestroyFinalActionAppraisalRulesUnitsCount - (long)withConflictFinalActionUnitsCount.intValue());
            }
        }
        ArrayList<FacetBucketDto> finalActionBuckets = new ArrayList<FacetBucketDto>();
        for (Map.Entry entry : finalActionCountMap.entrySet()) {
            finalActionBuckets.add(new FacetBucketDto((String)entry.getKey(), (Long)entry.getValue()));
        }
        return finalActionBuckets;
    }

    public FacetResultsDto buildComputedAuFinalActionFacet(List<SearchCriteriaEltDto> indexedArchiveUnitsCriteriaList, ArchiveSearchConsts.CriteriaCategory category, List<FacetResultsDto> indexedRulesFacets, boolean trackTotalHits, VitamContext vitamContext) throws VitamClientException, JsonProcessingException {
        FacetResultsDto finalActionIndexedFacet = new FacetResultsDto();
        if (ArchiveSearchConsts.CriteriaCategory.APPRAISAL_RULE.equals((Object)category)) {
            List<FacetBucketDto> finalActionBuckets = this.computeFinalActionFacetsForComputedAppraisalRules(indexedArchiveUnitsCriteriaList, indexedRulesFacets, category, trackTotalHits, vitamContext);
            finalActionIndexedFacet.setName("FINAL_ACTION_COMPUTED_" + category.name());
            finalActionIndexedFacet.setBuckets(finalActionBuckets);
        } else if (ArchiveSearchConsts.CriteriaCategory.STORAGE_RULE.equals((Object)category)) {
            Optional<FacetResultsDto> finalActionIndexedFacetOpt = indexedRulesFacets.stream().filter(facet -> ("FINAL_ACTION_COMPUTED_" + category.name()).equals(facet.getName())).findAny();
            if (finalActionIndexedFacetOpt.isPresent()) {
                finalActionIndexedFacet = finalActionIndexedFacetOpt.get();
            } else {
                finalActionIndexedFacet = new FacetResultsDto();
                finalActionIndexedFacet.setName("FINAL_ACTION_COMPUTED_" + category.name());
                finalActionIndexedFacet.setBuckets(List.of());
            }
        }
        return finalActionIndexedFacet;
    }

    public List<FacetResultsDto> fillManagementRulesFacets(SearchCriteriaDto searchQuery, boolean trackTotalHits, VitamContext vitamContext) throws InvalidCreateOperationException, VitamClientException, JsonProcessingException {
        ArrayList<FacetResultsDto> facetResults = new ArrayList<FacetResultsDto>();
        if (searchQuery.isComputeMgtRulesFacets()) {
            try {
                LOGGER.debug("Start computing facets for units with computed inheritance rules  ");
                List<ArchiveSearchConsts.CriteriaCategory> categories = List.of(ArchiveSearchConsts.CriteriaCategory.APPRAISAL_RULE, ArchiveSearchConsts.CriteriaCategory.ACCESS_RULE, ArchiveSearchConsts.CriteriaCategory.STORAGE_RULE, ArchiveSearchConsts.CriteriaCategory.REUSE_RULE, ArchiveSearchConsts.CriteriaCategory.DISSEMINATION_RULE);
                for (ArchiveSearchConsts.CriteriaCategory category : categories) {
                    LOGGER.debug("Start computing facets for management rules for category {}  ", (Object)category.name());
                    FacetResultsDto withoutRulesByCategoryFacet = this.computeNoRulesFacets(searchQuery, category, trackTotalHits, vitamContext);
                    facetResults.add(withoutRulesByCategoryFacet);
                    List<FacetResultsDto> facetsForAuHavingRules = this.computeFacetsForAuHavingRules(searchQuery, category, trackTotalHits, vitamContext);
                    facetResults.addAll(facetsForAuHavingRules);
                }
            }
            catch (InvalidParseOperationException e) {
                throw new BadRequestException("Can't parse criteria as Vitam query" + e.getMessage());
            }
        }
        return facetResults;
    }

    public FacetResultsDto computeNoRulesFacets(SearchCriteriaDto searchQuery, ArchiveSearchConsts.CriteriaCategory category, boolean trackTotalHits, VitamContext vitamContext) throws VitamClientException, JsonProcessingException {
        ArrayList<SearchCriteriaEltDto> criteriaListFacet = new ArrayList<SearchCriteriaEltDto>(searchQuery.getCriteriaList());
        criteriaListFacet.add(new SearchCriteriaEltDto("RULES_COMPUTED", ArchiveSearchConsts.CriteriaCategory.FIELDS, ArchiveSearchConsts.CriteriaOperators.EQ.name(), List.of(new CriteriaValue("true")), ArchiveSearchConsts.CriteriaDataType.STRING.name()));
        criteriaListFacet.add(new SearchCriteriaEltDto("RULE_ORIGIN", category, ArchiveSearchConsts.CriteriaOperators.EQ.name(), List.of(new CriteriaValue(ArchiveSearchConsts.RuleOriginValues.ORIGIN_HAS_NO_ONE.name())), ArchiveSearchConsts.CriteriaDataType.STRING.name()));
        FacetResultsDto noRuleFacet = new FacetResultsDto();
        noRuleFacet.setName("COUNT_WITHOUT_RULES_" + category.name());
        noRuleFacet.setBuckets(List.of(new FacetBucketDto("COUNT_WITHOUT_RULES", Long.valueOf(this.countArchiveUnitByCriteriaList(criteriaListFacet, trackTotalHits, vitamContext).intValue()))));
        return noRuleFacet;
    }

    private Integer countArchiveUnitByCriteriaList(List<SearchCriteriaEltDto> criteriaList, boolean trackTotalHits, VitamContext vitamContext) throws VitamClientException, JsonProcessingException {
        SearchCriteriaDto facetSearchQuery = new SearchCriteriaDto();
        facetSearchQuery.setCriteriaList(criteriaList);
        facetSearchQuery.setSize(Integer.valueOf(1));
        facetSearchQuery.setTrackTotalHits(trackTotalHits);
        facetSearchQuery.setFieldsList(List.of("Title"));
        JsonNode dslQuery = MetadataSearchCriteriaUtils.mapRequestToDslQuery((SearchCriteriaDto)facetSearchQuery);
        JsonNode vitamResponse = this.archiveSearchService.searchArchiveUnits(dslQuery, vitamContext);
        VitamUISearchResponseDto archivesUnitsResults = (VitamUISearchResponseDto)this.objectMapper.treeToValue((TreeNode)vitamResponse, VitamUISearchResponseDto.class);
        return archivesUnitsResults.getHits().getTotal();
    }

    private Integer computeFinalActionCountByValue(List<SearchCriteriaEltDto> initialCriteriaList, String value, ArchiveSearchConsts.CriteriaCategory category, boolean trackTotalHits, VitamContext vitamContext) throws VitamClientException, JsonProcessingException {
        ArrayList<SearchCriteriaEltDto> criteriaListFacet = new ArrayList<SearchCriteriaEltDto>();
        criteriaListFacet.addAll(initialCriteriaList);
        SearchCriteriaDto countSearchQuery = new SearchCriteriaDto();
        criteriaListFacet.add(new SearchCriteriaEltDto("FINAL_ACTION_TYPE", category, ArchiveSearchConsts.CriteriaOperators.EQ.name(), List.of(new CriteriaValue(value)), ArchiveSearchConsts.CriteriaDataType.STRING.name()));
        criteriaListFacet.add(new SearchCriteriaEltDto("RULES_COMPUTED", ArchiveSearchConsts.CriteriaCategory.FIELDS, ArchiveSearchConsts.CriteriaOperators.EQ.name(), List.of(new CriteriaValue("true")), ArchiveSearchConsts.CriteriaDataType.STRING.name()));
        countSearchQuery.setCriteriaList(criteriaListFacet);
        countSearchQuery.setFieldsList(List.of("Title"));
        countSearchQuery.setSize(Integer.valueOf(1));
        countSearchQuery.setTrackTotalHits(trackTotalHits);
        JsonNode dslQuery = MetadataSearchCriteriaUtils.mapRequestToDslQuery((SearchCriteriaDto)countSearchQuery);
        JsonNode vitamResponse = this.archiveSearchService.searchArchiveUnits(dslQuery, vitamContext);
        VitamUISearchResponseDto archivesUnitsResults = (VitamUISearchResponseDto)this.objectMapper.treeToValue((TreeNode)vitamResponse, VitamUISearchResponseDto.class);
        return archivesUnitsResults.getHits().getTotal();
    }

    private void addExpirationRulesFacet(List<SearchCriteriaEltDto> mgtRulesCriteriaList, ArchiveSearchConsts.CriteriaCategory category, SelectMultiQuery select) throws InvalidCreateOperationException {
        String strDateExpirationCriteria = this.extractRuleExpirationDateFromCriteria(mgtRulesCriteriaList, category);
        String managementRuleEndDateMapping = COMPUTED_FIELDS + ArchiveSearchConsts.CriteriaMgtRulesCategory.valueOf((String)category.name()).getFieldMapping() + MAX_END_DATE_FIELD;
        select.addFacets(new Facet[]{FacetHelper.dateRange((String)("EXPIRED_RULES_COMPUTED_" + category.name()), (String)managementRuleEndDateMapping, (String)"dd/MM/yyyy", List.of(new RangeFacetValue(SOME_OLD_DATE, strDateExpirationCriteria)))});
        select.addFacets(new Facet[]{FacetHelper.dateRange((String)("UNEXPIRED_RULES_COMPUTED_" + category.name()), (String)managementRuleEndDateMapping, (String)"dd/MM/yyyy", List.of(new RangeFacetValue(strDateExpirationCriteria, SOME_FUTUR_DATE)))});
    }

    @NotNull
    private String extractRuleExpirationDateFromCriteria(List<SearchCriteriaEltDto> mgtRulesCriteriaList, ArchiveSearchConsts.CriteriaCategory category) {
        String strDateExpirationCriteria = ArchiveSearchConsts.ONLY_DATE_FRENCH_FORMATTER_WITH_SLASH.format(LocalDateTime.now());
        Optional<SearchCriteriaEltDto> endDateCriteria = mgtRulesCriteriaList.stream().filter(searchCriteriaEltDto -> category.equals((Object)searchCriteriaEltDto.getCategory()) && "RULE_END_DATE".equals(searchCriteriaEltDto.getCriteria())).findAny();
        if (endDateCriteria.isPresent() && !CollectionUtils.isEmpty((Collection)endDateCriteria.get().getValues())) {
            String beginDtStr = ((CriteriaValue)endDateCriteria.get().getValues().get(0)).getBeginInterval();
            String endDtStr = ((CriteriaValue)endDateCriteria.get().getValues().get(0)).getEndInterval();
            strDateExpirationCriteria = ArchiveSearchFacetsService.getFormatedDateFromCriteria(beginDtStr, endDtStr);
        }
        return strDateExpirationCriteria;
    }

    @NotNull
    private static String getFormatedDateFromCriteria(String beginDtStr, String endDtStr) {
        LocalDateTime beginDt = null;
        if (!StringUtils.isEmpty((CharSequence)beginDtStr)) {
            beginDt = LocalDateTime.parse(beginDtStr, ArchiveSearchConsts.ISO_FRENCH_FORMATER);
        }
        LocalDateTime endDt = null;
        if (!StringUtils.isEmpty((CharSequence)endDtStr)) {
            endDt = LocalDateTime.parse(endDtStr, ArchiveSearchConsts.ISO_FRENCH_FORMATER);
        }
        String strDateExpirationCriteria = beginDt != null && endDt != null ? (endDt.isAfter(beginDt) ? ArchiveSearchConsts.ONLY_DATE_FRENCH_FORMATTER_WITH_SLASH.format(endDt) : ArchiveSearchConsts.ONLY_DATE_FRENCH_FORMATTER_WITH_SLASH.format(beginDt)) : (beginDt != null ? ArchiveSearchConsts.ONLY_DATE_FRENCH_FORMATTER_WITH_SLASH.format(beginDt) : (endDt != null ? ArchiveSearchConsts.ONLY_DATE_FRENCH_FORMATTER_WITH_SLASH.format(endDt) : ArchiveSearchConsts.ONLY_DATE_FRENCH_FORMATTER_WITH_SLASH.format(LocalDateTime.now())));
        return strDateExpirationCriteria;
    }
}

