/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitamui.archives.search.server.searchcriteria.service;

import fr.gouv.vitamui.archives.search.server.searchcriteria.converter.SearchCriteriaHistoryConverter;
import fr.gouv.vitamui.archives.search.server.searchcriteria.dao.SearchCriteriaHistoryRepository;
import fr.gouv.vitamui.archives.search.server.searchcriteria.domain.SearchCriteriaHistory;
import fr.gouv.vitamui.commons.api.converter.Converter;
import fr.gouv.vitamui.commons.api.domain.Criterion;
import fr.gouv.vitamui.commons.api.domain.CriterionOperator;
import fr.gouv.vitamui.commons.api.domain.QueryDto;
import fr.gouv.vitamui.commons.api.dtos.SearchCriteriaHistoryDto;
import fr.gouv.vitamui.commons.mongo.service.SequenceGeneratorService;
import fr.gouv.vitamui.commons.mongo.service.VitamUICrudService;
import fr.gouv.vitamui.commons.security.client.dto.AuthUserDto;
import fr.gouv.vitamui.iam.security.service.SecurityService;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.Assert;

public class SearchCriteriaHistoryService
extends VitamUICrudService<SearchCriteriaHistoryDto, SearchCriteriaHistory> {
    private static final Logger LOGGER = LoggerFactory.getLogger(SearchCriteriaHistoryService.class);
    private final SearchCriteriaHistoryRepository searchCriteriaHistoryRepo;
    private final SearchCriteriaHistoryConverter searchCriteriaHistoryConverter;
    private final SecurityService securityService;

    @Autowired
    public SearchCriteriaHistoryService(SequenceGeneratorService sequenceGeneratorService, SearchCriteriaHistoryRepository searchCriteriaHistoryRepo, SearchCriteriaHistoryConverter searchCriteriaHistoryConverter, SecurityService securityService) {
        super(sequenceGeneratorService);
        this.searchCriteriaHistoryRepo = searchCriteriaHistoryRepo;
        this.searchCriteriaHistoryConverter = searchCriteriaHistoryConverter;
        this.securityService = securityService;
    }

    public List<SearchCriteriaHistoryDto> getSearchCriteriaHistoryDtos() {
        LOGGER.debug("getSearchCriteriaHistoryDtos");
        AuthUserDto authUserDto = this.securityService.getUser();
        LOGGER.debug("Get the search history for user : {}", (Object)authUserDto.getIdentifier());
        QueryDto criteria = new QueryDto();
        criteria.addCriterion(new Criterion("userId", (Object)authUserDto.getIdentifier(), CriterionOperator.EQUALS));
        return this.getAll(criteria);
    }

    protected void beforeCreate(SearchCriteriaHistoryDto dto) {
        AuthUserDto authUserDto = this.securityService.getUser();
        dto.setUserId(authUserDto.getIdentifier());
        List<SearchCriteriaHistoryDto> list = this.getSearchCriteriaHistoryDtos();
        Assert.isTrue((list != null && list.size() < 10 ? 1 : 0) != 0, (String)"L\u2019enregistrement n'est pas possible car vous avez atteint le nombre limite de recherches enregistr\u00e9es. Veuillez supprimer au moins une de vos recherches.");
    }

    protected SearchCriteriaHistoryRepository getRepository() {
        return this.searchCriteriaHistoryRepo;
    }

    protected Class<SearchCriteriaHistory> getEntityClass() {
        return SearchCriteriaHistory.class;
    }

    protected String getObjectName() {
        return "searchCriteriaHistory";
    }

    protected Converter<SearchCriteriaHistoryDto, SearchCriteriaHistory> getConverter() {
        return this.searchCriteriaHistoryConverter;
    }

    @Generated
    public SearchCriteriaHistoryRepository getSearchCriteriaHistoryRepo() {
        return this.searchCriteriaHistoryRepo;
    }

    @Generated
    public SearchCriteriaHistoryConverter getSearchCriteriaHistoryConverter() {
        return this.searchCriteriaHistoryConverter;
    }

    @Generated
    public SecurityService getSecurityService() {
        return this.securityService;
    }
}

