/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitamui.referential.common.service;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import fr.gouv.vitam.access.external.client.AdminExternalClient;
import fr.gouv.vitam.access.external.common.exception.AccessExternalClientException;
import fr.gouv.vitam.common.client.VitamContext;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.json.JsonHandler;
import fr.gouv.vitam.common.model.RequestResponseOK;
import fr.gouv.vitamui.referential.common.service.VitamUIManagementContractCommonService;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;

@ExtendWith(value={MockitoExtension.class})
public class VitamUIManagementContractCommonServiceTest {
    @Mock
    private AdminExternalClient adminExternalClient;
    @InjectMocks
    private VitamUIManagementContractCommonService vitamUIManagementContractCommonService;

    @Test
    public void patchAccessContract_should_return_ok_when_vitamAdminExternalClient_ok() throws InvalidParseOperationException, AccessExternalClientException {
        VitamContext vitamSecurityProfile = new VitamContext(Integer.valueOf(0));
        String id = "id_0";
        ObjectNode jsonNode = JsonHandler.createObjectNode();
        Mockito.when((Object)this.adminExternalClient.updateManagementContract(vitamSecurityProfile, id, (JsonNode)jsonNode)).thenReturn((Object)new RequestResponseOK().setHttpCode(200));
        Assertions.assertThatCode(() -> this.lambda$patchAccessContract_should_return_ok_when_vitamAdminExternalClient_ok$0(vitamSecurityProfile, id, (JsonNode)jsonNode)).doesNotThrowAnyException();
    }

    @Test
    public void patchAccessContract_should_return_ok_when_vitamAdminExternalClient_400() throws InvalidParseOperationException, AccessExternalClientException {
        VitamContext vitamSecurityProfile = new VitamContext(Integer.valueOf(0));
        String id = "id_0";
        ObjectNode jsonNode = JsonHandler.createObjectNode();
        Mockito.when((Object)this.adminExternalClient.updateManagementContract(vitamSecurityProfile, id, (JsonNode)jsonNode)).thenReturn((Object)new RequestResponseOK().setHttpCode(400));
        Assertions.assertThatCode(() -> this.lambda$patchAccessContract_should_return_ok_when_vitamAdminExternalClient_400$1(vitamSecurityProfile, id, (JsonNode)jsonNode)).doesNotThrowAnyException();
    }

    @Test
    public void patchAccessContract_should_throw_InvalidParseOperationException_when_vitamAdminExternalClient_throws_InvalidParseOperationException() throws InvalidParseOperationException, AccessExternalClientException {
        VitamContext vitamSecurityProfile = new VitamContext(Integer.valueOf(0));
        String id = "id_0";
        ObjectNode jsonNode = JsonHandler.createObjectNode();
        Mockito.when((Object)this.adminExternalClient.updateManagementContract(vitamSecurityProfile, id, (JsonNode)jsonNode)).thenThrow(new Throwable[]{new InvalidParseOperationException("Exception thrown by Vitam")});
        Assertions.assertThatCode(() -> this.lambda$patchAccessContract_should_throw_InvalidParseOperationException_when_vitamAdminExternalClient_throws_InvalidParseOperationException$2(vitamSecurityProfile, id, (JsonNode)jsonNode)).isInstanceOf(InvalidParseOperationException.class);
    }

    @Test
    public void patchAccessContract_should_throw_AccessExternalClientException_when_vitamAdminExternalClient_throws_AccessExternalClientException() throws InvalidParseOperationException, AccessExternalClientException {
        VitamContext vitamSecurityProfile = new VitamContext(Integer.valueOf(0));
        String id = "id_0";
        ObjectNode jsonNode = JsonHandler.createObjectNode();
        Mockito.when((Object)this.adminExternalClient.updateManagementContract(vitamSecurityProfile, id, (JsonNode)jsonNode)).thenThrow(new Throwable[]{new AccessExternalClientException("Exception thrown by Vitam")});
        Assertions.assertThatCode(() -> this.lambda$patchAccessContract_should_throw_AccessExternalClientException_when_vitamAdminExternalClient_throws_AccessExternalClientException$3(vitamSecurityProfile, id, (JsonNode)jsonNode)).isInstanceOf(AccessExternalClientException.class);
    }

    private /* synthetic */ void lambda$patchAccessContract_should_throw_AccessExternalClientException_when_vitamAdminExternalClient_throws_AccessExternalClientException$3(VitamContext vitamSecurityProfile, String id, JsonNode jsonNode) throws Throwable {
        this.vitamUIManagementContractCommonService.patchManagementContract(vitamSecurityProfile, id, jsonNode);
    }

    private /* synthetic */ void lambda$patchAccessContract_should_throw_InvalidParseOperationException_when_vitamAdminExternalClient_throws_InvalidParseOperationException$2(VitamContext vitamSecurityProfile, String id, JsonNode jsonNode) throws Throwable {
        this.vitamUIManagementContractCommonService.patchManagementContract(vitamSecurityProfile, id, jsonNode);
    }

    private /* synthetic */ void lambda$patchAccessContract_should_return_ok_when_vitamAdminExternalClient_400$1(VitamContext vitamSecurityProfile, String id, JsonNode jsonNode) throws Throwable {
        this.vitamUIManagementContractCommonService.patchManagementContract(vitamSecurityProfile, id, jsonNode);
    }

    private /* synthetic */ void lambda$patchAccessContract_should_return_ok_when_vitamAdminExternalClient_ok$0(VitamContext vitamSecurityProfile, String id, JsonNode jsonNode) throws Throwable {
        this.vitamUIManagementContractCommonService.patchManagementContract(vitamSecurityProfile, id, jsonNode);
    }
}

