/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitamui.referential.common.service;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import fr.gouv.vitam.access.external.client.AdminExternalClient;
import fr.gouv.vitam.access.external.common.exception.AccessExternalClientException;
import fr.gouv.vitam.common.client.VitamContext;
import fr.gouv.vitam.common.error.VitamError;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.json.JsonHandler;
import fr.gouv.vitam.common.model.RequestResponseOK;
import fr.gouv.vitamui.referential.common.service.VitamUIAccessContractCommonService;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.ArgumentMatchers;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.junit.jupiter.MockitoExtension;

@ExtendWith(value={MockitoExtension.class})
public class VitamUIAccessContractCommonServiceTest {
    @Mock
    private AdminExternalClient adminExternalClient;
    @InjectMocks
    private VitamUIAccessContractCommonService vitamUIAccessContractCommonService;

    @BeforeEach
    void setUp() {
        MockitoAnnotations.openMocks(VitamUIAccessContractCommonServiceTest.class);
    }

    @Test
    public void patchAccessContract_should_return_ok_when_vitamclient_ok() throws InvalidParseOperationException, AccessExternalClientException {
        VitamContext vitamSecurityProfile = new VitamContext(Integer.valueOf(0));
        String id = "id_0";
        ObjectNode jsonNode = JsonHandler.createObjectNode();
        Mockito.when((Object)this.adminExternalClient.updateAccessContract(vitamSecurityProfile, id, (JsonNode)jsonNode)).thenReturn((Object)new RequestResponseOK().setHttpCode(200));
        Assertions.assertThatCode(() -> this.lambda$patchAccessContract_should_return_ok_when_vitamclient_ok$0(vitamSecurityProfile, id, (JsonNode)jsonNode)).doesNotThrowAnyException();
    }

    @Test
    public void patchAccessContract_should_return_400_when_vitamclient_400() throws InvalidParseOperationException, AccessExternalClientException {
        VitamContext vitamSecurityProfile = new VitamContext(Integer.valueOf(0));
        String id = "id_0";
        ObjectNode jsonNode = JsonHandler.createObjectNode();
        Mockito.when((Object)this.adminExternalClient.updateAccessContract(vitamSecurityProfile, id, (JsonNode)jsonNode)).thenReturn((Object)new VitamError("ERR_VITAM").setHttpCode(400).setMessage("DSL malformated"));
        Assertions.assertThatCode(() -> this.lambda$patchAccessContract_should_return_400_when_vitamclient_400$1(vitamSecurityProfile, id, (JsonNode)jsonNode)).hasMessageContaining("DSL malformated");
    }

    @Test
    public void patchAccessContract_should_throw_InvalidParseOperationException_when_vitamclient_throws_InvalidParseOperationException() throws InvalidParseOperationException, AccessExternalClientException {
        VitamContext vitamSecurityProfile = new VitamContext(Integer.valueOf(0));
        String id = "id_0";
        ObjectNode jsonNode = JsonHandler.createObjectNode();
        Mockito.when((Object)this.adminExternalClient.updateAccessContract(vitamSecurityProfile, id, (JsonNode)jsonNode)).thenThrow(new Throwable[]{new InvalidParseOperationException("Exception thrown by Vitam")});
        Assertions.assertThatCode(() -> this.lambda$patchAccessContract_should_throw_InvalidParseOperationException_when_vitamclient_throws_InvalidParseOperationException$2(vitamSecurityProfile, id, (JsonNode)jsonNode)).isInstanceOf(InvalidParseOperationException.class);
    }

    @Test
    public void patchAccessContract_should_throw_AccessExternalClientException_when_vitamclient_throws_AccessExternalClientException() throws InvalidParseOperationException, AccessExternalClientException {
        VitamContext vitamSecurityProfile = new VitamContext(Integer.valueOf(0));
        String id = "id_0";
        ObjectNode jsonNode = JsonHandler.createObjectNode();
        Mockito.when((Object)this.adminExternalClient.updateAccessContract((VitamContext)ArgumentMatchers.eq((Object)vitamSecurityProfile), (String)ArgumentMatchers.eq((Object)id), (JsonNode)ArgumentMatchers.eq((Object)jsonNode))).thenThrow(new Throwable[]{new AccessExternalClientException("Exception thrown by Vitam")});
        Assertions.assertThatCode(() -> this.lambda$patchAccessContract_should_throw_AccessExternalClientException_when_vitamclient_throws_AccessExternalClientException$3(vitamSecurityProfile, id, (JsonNode)jsonNode)).isInstanceOf(AccessExternalClientException.class);
    }

    private /* synthetic */ void lambda$patchAccessContract_should_throw_AccessExternalClientException_when_vitamclient_throws_AccessExternalClientException$3(VitamContext vitamSecurityProfile, String id, JsonNode jsonNode) throws Throwable {
        this.vitamUIAccessContractCommonService.patchAccessContract(vitamSecurityProfile, id, jsonNode);
    }

    private /* synthetic */ void lambda$patchAccessContract_should_throw_InvalidParseOperationException_when_vitamclient_throws_InvalidParseOperationException$2(VitamContext vitamSecurityProfile, String id, JsonNode jsonNode) throws Throwable {
        this.vitamUIAccessContractCommonService.patchAccessContract(vitamSecurityProfile, id, jsonNode);
    }

    private /* synthetic */ void lambda$patchAccessContract_should_return_400_when_vitamclient_400$1(VitamContext vitamSecurityProfile, String id, JsonNode jsonNode) throws Throwable {
        this.vitamUIAccessContractCommonService.patchAccessContract(vitamSecurityProfile, id, jsonNode);
    }

    private /* synthetic */ void lambda$patchAccessContract_should_return_ok_when_vitamclient_ok$0(VitamContext vitamSecurityProfile, String id, JsonNode jsonNode) throws Throwable {
        this.vitamUIAccessContractCommonService.patchAccessContract(vitamSecurityProfile, id, jsonNode);
    }
}

