/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitamui.referential.common.service;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import fr.gouv.vitam.access.external.client.AdminExternalClient;
import fr.gouv.vitam.access.external.common.exception.AccessExternalClientException;
import fr.gouv.vitam.common.client.VitamContext;
import fr.gouv.vitam.common.database.builder.request.single.Select;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.exception.VitamClientException;
import fr.gouv.vitam.common.json.JsonHandler;
import fr.gouv.vitam.common.model.RequestResponseOK;
import fr.gouv.vitamui.commons.api.exception.BadRequestException;
import fr.gouv.vitamui.referential.common.service.VitamSecurityProfileCommonService;
import java.io.InputStream;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;

@ExtendWith(value={MockitoExtension.class})
public class VitamSecurityProfileCommonServiceTest {
    @Mock
    private AdminExternalClient adminExternalClient;
    private VitamSecurityProfileCommonService vitamSecurityProfileCommonService;

    @BeforeEach
    public void setUp() {
        ObjectMapper objectMapper = new ObjectMapper().disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
        this.vitamSecurityProfileCommonService = new VitamSecurityProfileCommonService(this.adminExternalClient, objectMapper);
    }

    @Test
    public void patchSecurityProfile_should_return_ok_when_vitamclient_ok() throws VitamClientException {
        VitamContext vitamSecurityProfile = new VitamContext(Integer.valueOf(0));
        String id = "id_0";
        ObjectNode jsonNode = JsonHandler.createObjectNode();
        Mockito.when((Object)this.adminExternalClient.updateSecurityProfile(vitamSecurityProfile, id, (JsonNode)jsonNode)).thenReturn((Object)new RequestResponseOK().setHttpCode(200));
        Assertions.assertThatCode(() -> this.lambda$patchSecurityProfile_should_return_ok_when_vitamclient_ok$0(vitamSecurityProfile, id, (JsonNode)jsonNode)).doesNotThrowAnyException();
    }

    @Test
    public void patchSecurityProfile_should_return_ok_when_vitamclient_400() throws VitamClientException {
        VitamContext vitamSecurityProfile = new VitamContext(Integer.valueOf(0));
        String id = "id_0";
        ObjectNode jsonNode = JsonHandler.createObjectNode();
        Mockito.when((Object)this.adminExternalClient.updateSecurityProfile(vitamSecurityProfile, id, (JsonNode)jsonNode)).thenReturn((Object)new RequestResponseOK().setHttpCode(400));
        Assertions.assertThatCode(() -> this.lambda$patchSecurityProfile_should_return_ok_when_vitamclient_400$1(vitamSecurityProfile, id, (JsonNode)jsonNode)).doesNotThrowAnyException();
    }

    @Test
    public void patchSecurityProfile_should_throw_VitamClientException_when_vitamclient_throws_VitamClientException() throws VitamClientException {
        VitamContext vitamSecurityProfile = new VitamContext(Integer.valueOf(0));
        String id = "id_0";
        ObjectNode jsonNode = JsonHandler.createObjectNode();
        Mockito.when((Object)this.adminExternalClient.updateSecurityProfile(vitamSecurityProfile, id, (JsonNode)jsonNode)).thenThrow(new Throwable[]{new VitamClientException("Exception thrown by Vitam")});
        Assertions.assertThatCode(() -> this.lambda$patchSecurityProfile_should_throw_VitamClientException_when_vitamclient_throws_VitamClientException$2(vitamSecurityProfile, id, (JsonNode)jsonNode)).isInstanceOf(VitamClientException.class);
    }

    @Test
    public void deleteSecurityProfile_should_return_ok_when_vitamclient_ok() throws VitamClientException, AccessExternalClientException, InvalidParseOperationException {
        VitamContext vitamSecurityProfile = new VitamContext(Integer.valueOf(0));
        String id = "1";
        Mockito.when((Object)this.adminExternalClient.createSecurityProfiles((VitamContext)ArgumentMatchers.any(VitamContext.class), (InputStream)ArgumentMatchers.any(InputStream.class), (String)ArgumentMatchers.any(String.class))).thenReturn((Object)new RequestResponseOK().setHttpCode(200));
        Mockito.when((Object)this.adminExternalClient.findSecurityProfiles((VitamContext)ArgumentMatchers.any(VitamContext.class), (JsonNode)ArgumentMatchers.any(ObjectNode.class))).thenReturn((Object)new RequestResponseOK().setHttpCode(200));
        Assertions.assertThatCode(() -> this.vitamSecurityProfileCommonService.deleteSecurityProfile(vitamSecurityProfile, id)).doesNotThrowAnyException();
    }

    @Test
    public void deleteSecurityProfile_should_throw_JsonProcessingException_when_vitamclient_400() throws VitamClientException, AccessExternalClientException, InvalidParseOperationException {
        VitamContext vitamSecurityProfile = new VitamContext(Integer.valueOf(0));
        String id = "1";
        Mockito.when((Object)this.adminExternalClient.createSecurityProfiles((VitamContext)ArgumentMatchers.any(VitamContext.class), (InputStream)ArgumentMatchers.any(InputStream.class), (String)ArgumentMatchers.any(String.class))).thenReturn((Object)new RequestResponseOK().setHttpCode(400));
        Mockito.when((Object)this.adminExternalClient.findSecurityProfiles((VitamContext)ArgumentMatchers.any(VitamContext.class), (JsonNode)ArgumentMatchers.any(ObjectNode.class))).thenReturn((Object)new RequestResponseOK().setHttpCode(400));
        Assertions.assertThatCode(() -> this.vitamSecurityProfileCommonService.deleteSecurityProfile(vitamSecurityProfile, id)).doesNotThrowAnyException();
    }

    @Test
    public void deleteSecurityProfile_should_throw_VitamClientException_when_vitamclient_throws_VitamClientException() throws VitamClientException, AccessExternalClientException, InvalidParseOperationException {
        VitamContext vitamSecurityProfile = new VitamContext(Integer.valueOf(0));
        String id = "id_0";
        Mockito.when((Object)this.adminExternalClient.findSecurityProfiles(vitamSecurityProfile, (JsonNode)new Select().getFinalSelect())).thenThrow(new Throwable[]{new VitamClientException("Exception thrown by Vitam")});
        Assertions.assertThatCode(() -> this.vitamSecurityProfileCommonService.deleteSecurityProfile(vitamSecurityProfile, id)).isInstanceOf(VitamClientException.class);
    }

    @Test
    public void findSecurityProfiles_should_return_ok_when_vitamclient_ok() throws VitamClientException {
        VitamContext vitamSecurityProfile = new VitamContext(Integer.valueOf(0));
        ObjectNode jsonNode = JsonHandler.createObjectNode();
        Mockito.when((Object)this.adminExternalClient.findSecurityProfiles(vitamSecurityProfile, (JsonNode)jsonNode)).thenReturn((Object)new RequestResponseOK().setHttpCode(200));
        Assertions.assertThatCode(() -> this.lambda$findSecurityProfiles_should_return_ok_when_vitamclient_ok$6(vitamSecurityProfile, (JsonNode)jsonNode)).doesNotThrowAnyException();
    }

    @Test
    public void findSecurityProfiles_should_throw_BadRequestException_when_vitamclient_400() throws VitamClientException {
        VitamContext vitamSecurityProfile = new VitamContext(Integer.valueOf(0));
        ObjectNode jsonNode = JsonHandler.createObjectNode();
        Mockito.when((Object)this.adminExternalClient.findSecurityProfiles(vitamSecurityProfile, (JsonNode)jsonNode)).thenReturn((Object)new RequestResponseOK().setHttpCode(400));
        Assertions.assertThatCode(() -> this.lambda$findSecurityProfiles_should_throw_BadRequestException_when_vitamclient_400$7(vitamSecurityProfile, (JsonNode)jsonNode)).isInstanceOf(BadRequestException.class);
    }

    @Test
    public void findSecurityProfiles_should_throw_VitamClientException_when_vitamclient_throws_VitamClientException() throws VitamClientException {
        VitamContext vitamSecurityProfile = new VitamContext(Integer.valueOf(0));
        ObjectNode jsonNode = JsonHandler.createObjectNode();
        Mockito.when((Object)this.adminExternalClient.findSecurityProfiles(vitamSecurityProfile, (JsonNode)jsonNode)).thenThrow(new Throwable[]{new VitamClientException("Exception thrown by Vitam")});
        Assertions.assertThatCode(() -> this.lambda$findSecurityProfiles_should_throw_VitamClientException_when_vitamclient_throws_VitamClientException$8(vitamSecurityProfile, (JsonNode)jsonNode)).isInstanceOf(VitamClientException.class);
    }

    @Test
    public void findSecurityProfileById_should_return_ok_when_vitamclient_ok() throws VitamClientException {
        VitamContext vitamSecurityProfile = new VitamContext(Integer.valueOf(0));
        String securityProfileId = "SPId_0";
        Mockito.when((Object)this.adminExternalClient.findSecurityProfileById(vitamSecurityProfile, securityProfileId)).thenReturn((Object)new RequestResponseOK().setHttpCode(200));
        Assertions.assertThatCode(() -> this.vitamSecurityProfileCommonService.findSecurityProfileById(vitamSecurityProfile, securityProfileId)).doesNotThrowAnyException();
    }

    @Test
    public void findSecurityProfileById_should_return_InternalServerException_when_vitamclient_400() throws VitamClientException {
        VitamContext vitamSecurityProfile = new VitamContext(Integer.valueOf(0));
        String securityProfileId = "SPId_0";
        Mockito.when((Object)this.adminExternalClient.findSecurityProfileById(vitamSecurityProfile, securityProfileId)).thenReturn((Object)new RequestResponseOK().setHttpCode(400));
        Assertions.assertThatCode(() -> this.vitamSecurityProfileCommonService.findSecurityProfileById(vitamSecurityProfile, securityProfileId)).isInstanceOf(BadRequestException.class);
    }

    @Test
    public void findSecurityProfileById_should_throw_VitamClientException_when_vitamclient_throws_VitamClientException() throws VitamClientException {
        VitamContext vitamSecurityProfile = new VitamContext(Integer.valueOf(0));
        String securityProfileId = "SPId_0";
        Mockito.when((Object)this.adminExternalClient.findSecurityProfileById(vitamSecurityProfile, securityProfileId)).thenThrow(new Throwable[]{new VitamClientException("Exception thrown by Vitam")});
        Assertions.assertThatCode(() -> this.vitamSecurityProfileCommonService.findSecurityProfileById(vitamSecurityProfile, securityProfileId)).isInstanceOf(VitamClientException.class);
    }

    private /* synthetic */ void lambda$findSecurityProfiles_should_throw_VitamClientException_when_vitamclient_throws_VitamClientException$8(VitamContext vitamSecurityProfile, JsonNode jsonNode) throws Throwable {
        this.vitamSecurityProfileCommonService.findSecurityProfiles(vitamSecurityProfile, jsonNode);
    }

    private /* synthetic */ void lambda$findSecurityProfiles_should_throw_BadRequestException_when_vitamclient_400$7(VitamContext vitamSecurityProfile, JsonNode jsonNode) throws Throwable {
        this.vitamSecurityProfileCommonService.findSecurityProfiles(vitamSecurityProfile, jsonNode);
    }

    private /* synthetic */ void lambda$findSecurityProfiles_should_return_ok_when_vitamclient_ok$6(VitamContext vitamSecurityProfile, JsonNode jsonNode) throws Throwable {
        this.vitamSecurityProfileCommonService.findSecurityProfiles(vitamSecurityProfile, jsonNode);
    }

    private /* synthetic */ void lambda$patchSecurityProfile_should_throw_VitamClientException_when_vitamclient_throws_VitamClientException$2(VitamContext vitamSecurityProfile, String id, JsonNode jsonNode) throws Throwable {
        this.vitamSecurityProfileCommonService.patchSecurityProfile(vitamSecurityProfile, id, jsonNode);
    }

    private /* synthetic */ void lambda$patchSecurityProfile_should_return_ok_when_vitamclient_400$1(VitamContext vitamSecurityProfile, String id, JsonNode jsonNode) throws Throwable {
        this.vitamSecurityProfileCommonService.patchSecurityProfile(vitamSecurityProfile, id, jsonNode);
    }

    private /* synthetic */ void lambda$patchSecurityProfile_should_return_ok_when_vitamclient_ok$0(VitamContext vitamSecurityProfile, String id, JsonNode jsonNode) throws Throwable {
        this.vitamSecurityProfileCommonService.patchSecurityProfile(vitamSecurityProfile, id, jsonNode);
    }
}

