/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitamui.referential.common.service;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import fr.gouv.vitam.access.external.client.AccessExternalClient;
import fr.gouv.vitam.access.external.client.AdminExternalClient;
import fr.gouv.vitam.access.external.common.exception.AccessExternalClientException;
import fr.gouv.vitam.common.client.VitamContext;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.exception.VitamClientException;
import fr.gouv.vitam.common.json.JsonHandler;
import fr.gouv.vitam.common.model.RequestResponseOK;
import fr.gouv.vitam.common.model.administration.FileRulesModel;
import fr.gouv.vitam.common.model.administration.RuleMeasurementEnum;
import fr.gouv.vitam.common.model.administration.RuleType;
import fr.gouv.vitam.common.model.logbook.LogbookOperation;
import fr.gouv.vitamui.commons.api.exception.BadRequestException;
import fr.gouv.vitamui.commons.api.exception.ConflictException;
import fr.gouv.vitamui.commons.rest.dto.RuleDto;
import fr.gouv.vitamui.referential.common.service.VitamRuleCommonService;
import jakarta.ws.rs.core.Response;
import java.io.InputStream;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.junit.jupiter.MockitoExtension;

@ExtendWith(value={MockitoExtension.class})
public class VitamRuleCommonServiceTest {
    @Mock
    private AdminExternalClient adminExternalClient;
    @Mock
    private AccessExternalClient accessExternalClient;
    private VitamRuleCommonService vitamRuleCommonService;

    @BeforeEach
    public void setUp() {
        MockitoAnnotations.openMocks(VitamRuleCommonServiceTest.class);
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
        this.vitamRuleCommonService = new VitamRuleCommonService(this.adminExternalClient, objectMapper, this.accessExternalClient);
    }

    @Test
    public void findRules_should_return_ok_when_vitamclient_ok() throws VitamClientException {
        VitamContext vitamContext = new VitamContext(Integer.valueOf(0));
        ObjectNode select = JsonHandler.createObjectNode();
        Mockito.when((Object)this.adminExternalClient.findRules(vitamContext, (JsonNode)select)).thenReturn((Object)new RequestResponseOK().setHttpCode(200));
        Assertions.assertThatCode(() -> this.lambda$findRules_should_return_ok_when_vitamclient_ok$0(vitamContext, (JsonNode)select)).doesNotThrowAnyException();
    }

    @Test
    public void findRules_should_throw_BadRequestException_when_vitamclient_400() throws VitamClientException {
        VitamContext vitamContext = new VitamContext(Integer.valueOf(0));
        ObjectNode select = JsonHandler.createObjectNode();
        Mockito.when((Object)this.adminExternalClient.findRules(vitamContext, (JsonNode)select)).thenReturn((Object)new RequestResponseOK().setHttpCode(400));
        Assertions.assertThatCode(() -> this.lambda$findRules_should_throw_BadRequestException_when_vitamclient_400$1(vitamContext, (JsonNode)select)).isInstanceOf(BadRequestException.class);
    }

    @Test
    public void findRules_should_throw_VitamClientException_when_vitamclient_throws_VitamClientException() throws VitamClientException {
        VitamContext vitamContext = new VitamContext(Integer.valueOf(0));
        ObjectNode select = JsonHandler.createObjectNode();
        Mockito.when((Object)this.adminExternalClient.findRules(vitamContext, (JsonNode)select)).thenThrow(new Throwable[]{new VitamClientException("Exception thrown by Vitam")});
        Assertions.assertThatCode(() -> this.lambda$findRules_should_throw_VitamClientException_when_vitamclient_throws_VitamClientException$2(vitamContext, (JsonNode)select)).isInstanceOf(VitamClientException.class);
    }

    @Test
    public void findRuleById_should_return_ok_when_vitamclient_ok() throws VitamClientException {
        VitamContext vitamContext = new VitamContext(Integer.valueOf(0));
        String id = "id_0";
        Mockito.when((Object)this.adminExternalClient.findRuleById(vitamContext, id)).thenReturn((Object)new RequestResponseOK().setHttpCode(200));
        Assertions.assertThatCode(() -> this.vitamRuleCommonService.findRuleById(vitamContext, id)).doesNotThrowAnyException();
    }

    @Test
    public void findRuleById_should_throw_BadRequestException_when_vitamclient_400() throws VitamClientException {
        VitamContext vitamContext = new VitamContext(Integer.valueOf(0));
        String id = "id_0";
        Mockito.when((Object)this.adminExternalClient.findRuleById(vitamContext, id)).thenReturn((Object)new RequestResponseOK().setHttpCode(400));
        Assertions.assertThatCode(() -> this.vitamRuleCommonService.findRuleById(vitamContext, id)).isInstanceOf(BadRequestException.class);
    }

    @Test
    public void findRuleById_should_throw_VitamClientException_when_vitamclient_throws_VitamClientException() throws VitamClientException {
        VitamContext vitamContext = new VitamContext(Integer.valueOf(0));
        String id = "id_0";
        Mockito.when((Object)this.adminExternalClient.findRuleById(vitamContext, id)).thenThrow(new Throwable[]{new VitamClientException("Exception thrown by Vitam")});
        Assertions.assertThatCode(() -> this.vitamRuleCommonService.findRuleById(vitamContext, id)).isInstanceOf(VitamClientException.class);
    }

    @Test
    public void export_should_return_ok_when_vitamclient_ok() throws VitamClientException {
        VitamContext vitamContext = new VitamContext(Integer.valueOf(1));
        LogbookOperation logbookOperation = new LogbookOperation();
        logbookOperation.setEvId("1");
        Mockito.when((Object)this.accessExternalClient.selectOperations((VitamContext)ArgumentMatchers.any(VitamContext.class), (JsonNode)ArgumentMatchers.any(JsonNode.class))).thenReturn((Object)new RequestResponseOK().addResult((Object)logbookOperation).setHttpCode(200));
        Mockito.when((Object)this.adminExternalClient.downloadRulesCsvAsStream((VitamContext)ArgumentMatchers.any(VitamContext.class), (String)ArgumentMatchers.any(String.class))).thenReturn((Object)Response.status((int)200).build());
        Assertions.assertThatCode(() -> this.vitamRuleCommonService.export(vitamContext)).doesNotThrowAnyException();
    }

    @Test
    public void export_should_throw_VitamClientException_when_vitamclient_400() throws VitamClientException {
        VitamContext vitamContext = new VitamContext(Integer.valueOf(1));
        LogbookOperation logbookOperation = new LogbookOperation();
        logbookOperation.setEvId("1");
        Mockito.when((Object)this.accessExternalClient.selectOperations((VitamContext)ArgumentMatchers.any(VitamContext.class), (JsonNode)ArgumentMatchers.any(JsonNode.class))).thenReturn((Object)new RequestResponseOK().setHttpCode(400));
        Assertions.assertThatCode(() -> this.vitamRuleCommonService.export(vitamContext)).isInstanceOf(VitamClientException.class);
    }

    @Test
    public void export_should_throw_VitamClientException_when_vitamclient_throw_VitamClientException() throws VitamClientException {
        VitamContext vitamContext = new VitamContext(Integer.valueOf(1));
        LogbookOperation logbookOperation = new LogbookOperation();
        logbookOperation.setEvId("1");
        Mockito.when((Object)this.accessExternalClient.selectOperations((VitamContext)ArgumentMatchers.any(VitamContext.class), (JsonNode)ArgumentMatchers.any(JsonNode.class))).thenThrow(new Throwable[]{new VitamClientException("Exception thrown by vitam")});
        Assertions.assertThatCode(() -> this.vitamRuleCommonService.export(vitamContext)).isInstanceOf(VitamClientException.class);
    }

    @Test
    public void patchRule_should_return_ok_when_findRules_ok() throws VitamClientException, InvalidParseOperationException, AccessExternalClientException {
        VitamContext vitamContext = new VitamContext(Integer.valueOf(1));
        String id = "id_0";
        FileRulesModel patchRule = new FileRulesModel();
        Mockito.when((Object)this.adminExternalClient.findRules((VitamContext)ArgumentMatchers.any(VitamContext.class), (JsonNode)ArgumentMatchers.any(JsonNode.class))).thenReturn((Object)new RequestResponseOK().setHttpCode(200));
        Mockito.when((Object)this.adminExternalClient.createRules((VitamContext)ArgumentMatchers.any(VitamContext.class), (InputStream)ArgumentMatchers.any(InputStream.class), (String)ArgumentMatchers.any(String.class))).thenReturn((Object)new RequestResponseOK().setHttpCode(200));
        Assertions.assertThatCode(() -> this.vitamRuleCommonService.patchRule(vitamContext, id, patchRule)).doesNotThrowAnyException();
    }

    @Test
    public void patchRule_should_throw_BadRequestException_when_findRules_400() throws VitamClientException {
        VitamContext vitamContext = new VitamContext(Integer.valueOf(1));
        String id = "id_0";
        FileRulesModel patchRule = new FileRulesModel();
        Mockito.when((Object)this.adminExternalClient.findRules((VitamContext)ArgumentMatchers.any(VitamContext.class), (JsonNode)ArgumentMatchers.any(JsonNode.class))).thenReturn((Object)new RequestResponseOK().setHttpCode(400));
        Assertions.assertThatCode(() -> this.vitamRuleCommonService.patchRule(vitamContext, id, patchRule)).isInstanceOf(BadRequestException.class);
    }

    @Test
    public void patchRule_should_throw_VitamClientException_when_vitamclient_VitamClientException() throws VitamClientException {
        VitamContext vitamContext = new VitamContext(Integer.valueOf(1));
        String id = "id_0";
        FileRulesModel patchRule = new FileRulesModel();
        Mockito.when((Object)this.adminExternalClient.findRules((VitamContext)ArgumentMatchers.any(VitamContext.class), (JsonNode)ArgumentMatchers.any(JsonNode.class))).thenThrow(new Throwable[]{new VitamClientException("Exception thrown by vitam")});
        Assertions.assertThatCode(() -> this.vitamRuleCommonService.patchRule(vitamContext, id, patchRule)).isInstanceOf(VitamClientException.class);
    }

    @Test
    public void deleteRule_should_return_ok_when_findRules_ok() throws VitamClientException, InvalidParseOperationException, AccessExternalClientException {
        VitamContext vitamContext = new VitamContext(Integer.valueOf(1));
        String id = "id_0";
        Mockito.when((Object)this.adminExternalClient.findRules((VitamContext)ArgumentMatchers.any(VitamContext.class), (JsonNode)ArgumentMatchers.any(JsonNode.class))).thenReturn((Object)new RequestResponseOK().setHttpCode(200));
        Mockito.when((Object)this.adminExternalClient.createRules((VitamContext)ArgumentMatchers.any(VitamContext.class), (InputStream)ArgumentMatchers.any(InputStream.class), (String)ArgumentMatchers.any(String.class))).thenReturn((Object)new RequestResponseOK().setHttpCode(200));
        Assertions.assertThatCode(() -> this.vitamRuleCommonService.deleteRule(vitamContext, id)).doesNotThrowAnyException();
    }

    @Test
    public void deleteRule_should_throw_BadRequestException_when_findRules_400() throws VitamClientException {
        VitamContext vitamContext = new VitamContext(Integer.valueOf(1));
        String id = "id_0";
        Mockito.when((Object)this.adminExternalClient.findRules((VitamContext)ArgumentMatchers.any(VitamContext.class), (JsonNode)ArgumentMatchers.any(JsonNode.class))).thenReturn((Object)new RequestResponseOK().setHttpCode(400));
        Assertions.assertThatCode(() -> this.vitamRuleCommonService.deleteRule(vitamContext, id)).isInstanceOf(BadRequestException.class);
    }

    @Test
    public void deleteRule_should_throw_VitamClientException_when_findRules_VitamClientException() throws VitamClientException {
        VitamContext vitamContext = new VitamContext(Integer.valueOf(1));
        String id = "id_0";
        Mockito.when((Object)this.adminExternalClient.findRules((VitamContext)ArgumentMatchers.any(VitamContext.class), (JsonNode)ArgumentMatchers.any(JsonNode.class))).thenThrow(new Throwable[]{new VitamClientException("Exception throw by vitam")});
        Assertions.assertThatCode(() -> this.vitamRuleCommonService.deleteRule(vitamContext, id)).isInstanceOf(VitamClientException.class);
    }

    @Test
    public void create_should_return_ok_when_findRules_ok() throws VitamClientException, InvalidParseOperationException, AccessExternalClientException {
        VitamContext vitamContext = new VitamContext(Integer.valueOf(1));
        FileRulesModel newRule = new FileRulesModel();
        newRule.setRuleType(RuleType.AppraisalRule);
        newRule.setRuleMeasurement(RuleMeasurementEnum.YEAR);
        Mockito.when((Object)this.adminExternalClient.findRules((VitamContext)ArgumentMatchers.any(VitamContext.class), (JsonNode)ArgumentMatchers.any(JsonNode.class))).thenReturn((Object)new RequestResponseOK().setHttpCode(200));
        Mockito.when((Object)this.adminExternalClient.createRules((VitamContext)ArgumentMatchers.any(VitamContext.class), (InputStream)ArgumentMatchers.any(InputStream.class), (String)ArgumentMatchers.any(String.class))).thenReturn((Object)new RequestResponseOK().setHttpCode(200));
        Assertions.assertThatCode(() -> this.vitamRuleCommonService.createRule(vitamContext, newRule)).doesNotThrowAnyException();
    }

    @Test
    public void create_should_throw_BadRequestException_when_findRules_400() throws VitamClientException {
        VitamContext vitamContext = new VitamContext(Integer.valueOf(1));
        FileRulesModel newRule = new FileRulesModel();
        Mockito.when((Object)this.adminExternalClient.findRules((VitamContext)ArgumentMatchers.any(VitamContext.class), (JsonNode)ArgumentMatchers.any(JsonNode.class))).thenReturn((Object)new RequestResponseOK().setHttpCode(400));
        Assertions.assertThatCode(() -> this.vitamRuleCommonService.createRule(vitamContext, newRule)).isInstanceOf(BadRequestException.class);
    }

    @Test
    public void create_should_throw_VitamClientException_when_findRules_VitamClientException() throws VitamClientException {
        VitamContext vitamContext = new VitamContext(Integer.valueOf(1));
        FileRulesModel newRule = new FileRulesModel();
        Mockito.when((Object)this.adminExternalClient.findRules((VitamContext)ArgumentMatchers.any(VitamContext.class), (JsonNode)ArgumentMatchers.any(JsonNode.class))).thenThrow(new Throwable[]{new VitamClientException("Exception thrown by vitam")});
        Assertions.assertThatCode(() -> this.vitamRuleCommonService.createRule(vitamContext, newRule)).isInstanceOf(VitamClientException.class);
    }

    @Test
    public void checkRule_should_return_exception_when_vitam_response_is_null() throws VitamClientException {
        VitamContext vitamContext = new VitamContext(Integer.valueOf(1));
        RuleDto ruleDto = new RuleDto();
        Assertions.assertThatCode(() -> this.vitamRuleCommonService.checkExistenceOfRuleInVitam(ruleDto, vitamContext)).hasMessage("The body is not found");
        Assertions.assertThatCode(() -> this.vitamRuleCommonService.checkExistenceOfRuleInVitam(ruleDto, vitamContext)).isInstanceOf(BadRequestException.class);
    }

    @Test
    public void checkRule_should_not_throw_ConflictException_when_requested_ruleId_and_ruleType_already_exist_in_vitam() throws VitamClientException {
        VitamContext vitamContext = new VitamContext(Integer.valueOf(1));
        FileRulesModel existingRule = new FileRulesModel();
        existingRule.setId("id_0");
        existingRule.setRuleId("APP-00001");
        existingRule.setRuleType(RuleType.AppraisalRule);
        FileRulesModel secondExistingRule = new FileRulesModel();
        secondExistingRule.setId("id_1");
        secondExistingRule.setRuleId("ACC-00001");
        secondExistingRule.setRuleType(RuleType.AccessRule);
        RuleDto ruleDto = new RuleDto();
        ruleDto.setId("id_0");
        ruleDto.setRuleId("APP-00001");
        ruleDto.setRuleType("AppraisalRule");
        RequestResponseOK mockResponse = new RequestResponseOK();
        mockResponse.setHttpCode(200);
        mockResponse.addResult((Object)existingRule);
        mockResponse.addResult((Object)secondExistingRule);
        Mockito.when((Object)this.adminExternalClient.findRules((VitamContext)ArgumentMatchers.any(VitamContext.class), (JsonNode)ArgumentMatchers.any(JsonNode.class))).thenReturn((Object)mockResponse);
        Assertions.assertThat((List)mockResponse.getResults()).hasSize(2);
        Assertions.assertThatCode(() -> this.vitamRuleCommonService.checkExistenceOfRuleInVitam(ruleDto, vitamContext)).doesNotThrowAnyException();
    }

    @Test
    public void checkRule_should_throw_ConflictException_when_requested_rule_does_not_exists_in_vitam() throws VitamClientException {
        VitamContext vitamContext = new VitamContext(Integer.valueOf(1));
        FileRulesModel existingRule = new FileRulesModel();
        existingRule.setId("id_0");
        existingRule.setRuleId("APP-00001");
        existingRule.setRuleType(RuleType.AppraisalRule);
        RuleDto ruleDto = new RuleDto();
        ruleDto.setId("id_0");
        ruleDto.setRuleId("APP-00002");
        ruleDto.setRuleType("AppraisalRule");
        RequestResponseOK mockResponse = new RequestResponseOK();
        mockResponse.setHttpCode(200);
        mockResponse.addResult((Object)existingRule);
        Mockito.when((Object)this.adminExternalClient.findRules((VitamContext)ArgumentMatchers.any(VitamContext.class), (JsonNode)ArgumentMatchers.any(JsonNode.class))).thenReturn((Object)mockResponse);
        Assertions.assertThat((List)mockResponse.getResults()).hasSize(1);
        Assertions.assertThatCode(() -> this.vitamRuleCommonService.checkExistenceOfRuleInVitam(ruleDto, vitamContext)).isInstanceOf(ConflictException.class);
    }

    @Test
    public void checkRule_should_not_throw_ConflictException_when_requested_ruleId_already_exist_in_vitam() throws VitamClientException {
        VitamContext vitamContext = new VitamContext(Integer.valueOf(1));
        FileRulesModel existingRule = new FileRulesModel();
        existingRule.setId("id_0");
        existingRule.setRuleId("APP-00001");
        existingRule.setRuleType(RuleType.AppraisalRule);
        FileRulesModel secondExistingRule = new FileRulesModel();
        secondExistingRule.setId("id_1");
        secondExistingRule.setRuleId("ACC-00001");
        secondExistingRule.setRuleType(RuleType.AccessRule);
        FileRulesModel storageExistingRule = new FileRulesModel();
        secondExistingRule.setId("id_2");
        secondExistingRule.setRuleId("STO-00001");
        secondExistingRule.setRuleType(RuleType.StorageRule);
        RuleDto ruleDto = new RuleDto();
        ruleDto.setId("id_0");
        ruleDto.setRuleId("APP-00001");
        RequestResponseOK mockResponse = new RequestResponseOK();
        mockResponse.setHttpCode(200);
        mockResponse.addResult((Object)existingRule);
        mockResponse.addResult((Object)secondExistingRule);
        mockResponse.addResult((Object)storageExistingRule);
        Mockito.when((Object)this.adminExternalClient.findRules((VitamContext)ArgumentMatchers.any(VitamContext.class), (JsonNode)ArgumentMatchers.any(JsonNode.class))).thenReturn((Object)mockResponse);
        Assertions.assertThat((List)mockResponse.getResults()).hasSize(3);
        Assertions.assertThatCode(() -> this.vitamRuleCommonService.checkExistenceOfRuleInVitam(ruleDto, vitamContext)).doesNotThrowAnyException();
    }

    @Test
    public void checkRule_should_throw_BadRequestException_when_requested_rule_is_null() throws VitamClientException {
        VitamContext vitamContext = new VitamContext(Integer.valueOf(1));
        FileRulesModel existingRule = new FileRulesModel();
        existingRule.setId("id_0");
        existingRule.setRuleId("APP-00001");
        existingRule.setRuleType(RuleType.AppraisalRule);
        FileRulesModel secondExistingRule = new FileRulesModel();
        secondExistingRule.setId("id_1");
        secondExistingRule.setRuleId("ACC-00001");
        secondExistingRule.setRuleType(RuleType.AccessRule);
        FileRulesModel storageExistingRule = new FileRulesModel();
        secondExistingRule.setId("id_2");
        secondExistingRule.setRuleId("STO-00001");
        secondExistingRule.setRuleType(RuleType.StorageRule);
        RuleDto ruleDto = new RuleDto();
        RequestResponseOK mockResponse = new RequestResponseOK();
        mockResponse.setHttpCode(200);
        mockResponse.addResult((Object)existingRule);
        mockResponse.addResult((Object)secondExistingRule);
        mockResponse.addResult((Object)storageExistingRule);
        Assertions.assertThat((List)mockResponse.getResults()).hasSize(3);
        Assertions.assertThatCode(() -> this.vitamRuleCommonService.checkExistenceOfRuleInVitam(ruleDto, vitamContext)).isInstanceOf(BadRequestException.class);
        Assertions.assertThatCode(() -> this.vitamRuleCommonService.checkExistenceOfRuleInVitam(ruleDto, vitamContext)).hasMessage("The body is not found");
    }

    private /* synthetic */ void lambda$findRules_should_throw_VitamClientException_when_vitamclient_throws_VitamClientException$2(VitamContext vitamContext, JsonNode select) throws Throwable {
        this.vitamRuleCommonService.findRules(vitamContext, select);
    }

    private /* synthetic */ void lambda$findRules_should_throw_BadRequestException_when_vitamclient_400$1(VitamContext vitamContext, JsonNode select) throws Throwable {
        this.vitamRuleCommonService.findRules(vitamContext, select);
    }

    private /* synthetic */ void lambda$findRules_should_return_ok_when_vitamclient_ok$0(VitamContext vitamContext, JsonNode select) throws Throwable {
        this.vitamRuleCommonService.findRules(vitamContext, select);
    }
}

