/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitamui.referential.common.service;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import fr.gouv.vitam.access.external.client.AdminExternalClient;
import fr.gouv.vitam.access.external.common.exception.AccessExternalClientException;
import fr.gouv.vitam.common.client.VitamContext;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.exception.VitamClientException;
import fr.gouv.vitam.common.json.JsonHandler;
import fr.gouv.vitam.common.model.RequestResponseOK;
import fr.gouv.vitamui.commons.api.exception.BadRequestException;
import fr.gouv.vitamui.referential.common.dto.ContextDto;
import fr.gouv.vitamui.referential.common.dto.ContextVitamDto;
import fr.gouv.vitamui.referential.common.dto.PermissionDto;
import fr.gouv.vitamui.referential.common.dto.converter.ContextDtoConverterUtil;
import fr.gouv.vitamui.referential.common.service.VitamContextCommonService;
import fr.gouv.vitamui.referential.common.utils.ReferentialDtoBuilder;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.junit.jupiter.MockitoExtension;

@ExtendWith(value={MockitoExtension.class})
public class VitamContextCommonServiceTest {
    @Mock
    private AdminExternalClient adminExternalClient;
    private ObjectMapper objectMapper;
    private VitamContextCommonService vitamContextCommonService;

    @BeforeEach
    public void setUp() {
        MockitoAnnotations.openMocks(VitamContextCommonServiceTest.class);
        this.objectMapper = new ObjectMapper();
        this.vitamContextCommonService = new VitamContextCommonService(this.adminExternalClient, this.objectMapper);
    }

    @Test
    public void patchContext_should_return_ok_when_vitamclient_ok() throws AccessExternalClientException, InvalidParseOperationException {
        VitamContext vitamContext = new VitamContext(Integer.valueOf(0));
        String id = "0";
        ObjectNode jsonNode = JsonHandler.createObjectNode();
        Mockito.when((Object)this.adminExternalClient.updateContext((VitamContext)ArgumentMatchers.any(VitamContext.class), (String)ArgumentMatchers.any(String.class), (JsonNode)ArgumentMatchers.any(JsonNode.class))).thenReturn((Object)new RequestResponseOK().setHttpCode(200));
        Assertions.assertThatCode(() -> this.lambda$patchContext_should_return_ok_when_vitamclient_ok$0(vitamContext, (JsonNode)jsonNode)).doesNotThrowAnyException();
    }

    @Test
    public void patchContext_should_return_ok_when_vitamclient_400() throws AccessExternalClientException, InvalidParseOperationException {
        VitamContext vitamContext = new VitamContext(Integer.valueOf(0));
        String id = "0";
        ObjectNode jsonNode = JsonHandler.createObjectNode();
        Mockito.when((Object)this.adminExternalClient.updateContext((VitamContext)ArgumentMatchers.any(VitamContext.class), (String)ArgumentMatchers.any(String.class), (JsonNode)ArgumentMatchers.any(JsonNode.class))).thenReturn((Object)new RequestResponseOK().setHttpCode(400));
        Assertions.assertThatCode(() -> this.lambda$patchContext_should_return_ok_when_vitamclient_400$1(vitamContext, (JsonNode)jsonNode)).doesNotThrowAnyException();
    }

    @Test
    public void patchContext_should_throw_AccessExternalClientException_when_vitamclient_throws_AccessExternalClientException() throws AccessExternalClientException, InvalidParseOperationException {
        VitamContext vitamContext = new VitamContext(Integer.valueOf(0));
        String id = "0";
        ObjectNode jsonNode = JsonHandler.createObjectNode();
        Mockito.when((Object)this.adminExternalClient.updateContext((VitamContext)ArgumentMatchers.any(VitamContext.class), (String)ArgumentMatchers.any(String.class), (JsonNode)ArgumentMatchers.any(JsonNode.class))).thenThrow(new Throwable[]{new AccessExternalClientException("Exception thrown by Vitam")});
        Assertions.assertThatCode(() -> this.lambda$patchContext_should_throw_AccessExternalClientException_when_vitamclient_throws_AccessExternalClientException$2(vitamContext, (JsonNode)jsonNode)).isInstanceOf(AccessExternalClientException.class);
    }

    @Test
    public void patchContext_should_throw_InvalidParseOperationException_when_vitamclient_throws_InvalidParseOperationException() throws AccessExternalClientException, InvalidParseOperationException {
        VitamContext vitamContext = new VitamContext(Integer.valueOf(0));
        String id = "0";
        ObjectNode jsonNode = JsonHandler.createObjectNode();
        Mockito.when((Object)this.adminExternalClient.updateContext((VitamContext)ArgumentMatchers.any(VitamContext.class), (String)ArgumentMatchers.any(String.class), (JsonNode)ArgumentMatchers.any(JsonNode.class))).thenThrow(new Throwable[]{new InvalidParseOperationException("Exception thrown by Vitam")});
        Assertions.assertThatCode(() -> this.lambda$patchContext_should_throw_InvalidParseOperationException_when_vitamclient_throws_InvalidParseOperationException$3(vitamContext, (JsonNode)jsonNode)).isInstanceOf(InvalidParseOperationException.class);
    }

    @Test
    public void findContexts_should_return_ok_when_vitamclient_return_ok() throws VitamClientException {
        VitamContext vitamContext = new VitamContext(Integer.valueOf(0));
        ObjectNode jsonNode = JsonHandler.createObjectNode();
        Mockito.when((Object)this.adminExternalClient.findContexts((VitamContext)ArgumentMatchers.any(VitamContext.class), (JsonNode)ArgumentMatchers.any(JsonNode.class))).thenReturn((Object)new RequestResponseOK().setHttpCode(200));
        Assertions.assertThatCode(() -> this.lambda$findContexts_should_return_ok_when_vitamclient_return_ok$4(vitamContext, (JsonNode)jsonNode)).doesNotThrowAnyException();
    }

    @Test
    public void findContexts_should_throw_BadRequestException_when_vitamclient_return_400() throws VitamClientException {
        VitamContext vitamContext = new VitamContext(Integer.valueOf(0));
        ObjectNode jsonNode = JsonHandler.createObjectNode();
        Mockito.when((Object)this.adminExternalClient.findContexts((VitamContext)ArgumentMatchers.any(VitamContext.class), (JsonNode)ArgumentMatchers.any(JsonNode.class))).thenReturn((Object)new RequestResponseOK().setHttpCode(400));
        Assertions.assertThatCode(() -> this.lambda$findContexts_should_throw_BadRequestException_when_vitamclient_return_400$5(vitamContext, (JsonNode)jsonNode)).isInstanceOf(BadRequestException.class);
    }

    @Test
    public void findContexts_should_throw_VitamClientException_when_vitamclient_throws_VitamClientException() throws VitamClientException {
        VitamContext vitamContext = new VitamContext(Integer.valueOf(0));
        ObjectNode jsonNode = JsonHandler.createObjectNode();
        Mockito.when((Object)this.adminExternalClient.findContexts((VitamContext)ArgumentMatchers.any(VitamContext.class), (JsonNode)ArgumentMatchers.any(JsonNode.class))).thenThrow(new Throwable[]{new VitamClientException("Exception thrown by Vitam")});
        Assertions.assertThatCode(() -> this.lambda$findContexts_should_throw_VitamClientException_when_vitamclient_throws_VitamClientException$6(vitamContext, (JsonNode)jsonNode)).isInstanceOf(VitamClientException.class);
    }

    @Test
    public void findContextById_should_return_ok_when_vitamclient_return_ok() throws VitamClientException {
        VitamContext vitamContext = new VitamContext(Integer.valueOf(0));
        String contextId = "CId_0";
        Mockito.when((Object)this.adminExternalClient.findContextById((VitamContext)ArgumentMatchers.any(VitamContext.class), (String)ArgumentMatchers.any(String.class))).thenReturn((Object)new RequestResponseOK().setHttpCode(200));
        Assertions.assertThatCode(() -> this.vitamContextCommonService.findContextById(vitamContext, contextId)).doesNotThrowAnyException();
    }

    @Test
    public void findContextById_should_throw_InternalServerException_when_vitamclient_return_400() throws VitamClientException {
        VitamContext vitamContext = new VitamContext(Integer.valueOf(0));
        String contextId = "CId_0";
        Mockito.when((Object)this.adminExternalClient.findContextById((VitamContext)ArgumentMatchers.any(VitamContext.class), (String)ArgumentMatchers.any(String.class))).thenReturn((Object)new RequestResponseOK().setHttpCode(400));
        Assertions.assertThatCode(() -> this.vitamContextCommonService.findContextById(vitamContext, contextId)).isInstanceOf(BadRequestException.class);
    }

    @Test
    public void findContextById_should_throw_VitamClientException_when_vitamclient_throws_VitamClientException() throws VitamClientException {
        VitamContext vitamContext = new VitamContext(Integer.valueOf(0));
        String contextId = "CId_0";
        Mockito.when((Object)this.adminExternalClient.findContextById((VitamContext)ArgumentMatchers.any(VitamContext.class), (String)ArgumentMatchers.any(String.class))).thenThrow(new Throwable[]{new VitamClientException("Exception thrown by Vitam")});
        Assertions.assertThatCode(() -> this.vitamContextCommonService.findContextById(vitamContext, contextId)).isInstanceOf(VitamClientException.class);
    }

    @Test
    public void should_convert_contextDto_to_vitamContextDto() {
        ContextDto contextModels = ReferentialDtoBuilder.getContextDto();
        List contextVitamDtos = ContextDtoConverterUtil.convertContextsToModelOfCreation(Collections.singletonList(contextModels));
        JsonNode jsonNodeContextDto = (JsonNode)this.objectMapper.convertValue((Object)contextModels.getPermissions(), JsonNode.class);
        JsonNode jsonNodeContextVitamDto = (JsonNode)this.objectMapper.convertValue((Object)((ContextVitamDto)contextVitamDtos.get(0)).getPermissions(), JsonNode.class);
        Assertions.assertThat((Iterable)jsonNodeContextDto).isEqualTo((Object)jsonNodeContextVitamDto);
    }

    @Test
    public void should_convert_contextDtos_to_vitamContextDtos() {
        ContextDto contextModels = ReferentialDtoBuilder.buildContextDto(null);
        Set<PermissionDto> permissionDtos = ReferentialDtoBuilder.buildPermissions();
        contextModels.setPermissions(permissionDtos);
        List contextVitamDtos = ContextDtoConverterUtil.convertContextsToModelOfCreation(Collections.singletonList(contextModels));
        JsonNode jsonNodeContextDto = (JsonNode)this.objectMapper.convertValue((Object)contextModels.getPermissions(), JsonNode.class);
        JsonNode jsonNodeContextVitamDto = (JsonNode)this.objectMapper.convertValue((Object)((ContextVitamDto)contextVitamDtos.get(0)).getPermissions(), JsonNode.class);
        Assertions.assertThat((Iterable)jsonNodeContextDto).hasSameElementsAs((Iterable)jsonNodeContextVitamDto);
    }

    private /* synthetic */ void lambda$findContexts_should_throw_VitamClientException_when_vitamclient_throws_VitamClientException$6(VitamContext vitamContext, JsonNode jsonNode) throws Throwable {
        this.vitamContextCommonService.findContexts(vitamContext, jsonNode);
    }

    private /* synthetic */ void lambda$findContexts_should_throw_BadRequestException_when_vitamclient_return_400$5(VitamContext vitamContext, JsonNode jsonNode) throws Throwable {
        this.vitamContextCommonService.findContexts(vitamContext, jsonNode);
    }

    private /* synthetic */ void lambda$findContexts_should_return_ok_when_vitamclient_return_ok$4(VitamContext vitamContext, JsonNode jsonNode) throws Throwable {
        this.vitamContextCommonService.findContexts(vitamContext, jsonNode);
    }

    private /* synthetic */ void lambda$patchContext_should_throw_InvalidParseOperationException_when_vitamclient_throws_InvalidParseOperationException$3(VitamContext vitamContext, JsonNode jsonNode) throws Throwable {
        this.vitamContextCommonService.patchContext(vitamContext, "0", jsonNode);
    }

    private /* synthetic */ void lambda$patchContext_should_throw_AccessExternalClientException_when_vitamclient_throws_AccessExternalClientException$2(VitamContext vitamContext, JsonNode jsonNode) throws Throwable {
        this.vitamContextCommonService.patchContext(vitamContext, "0", jsonNode);
    }

    private /* synthetic */ void lambda$patchContext_should_return_ok_when_vitamclient_400$1(VitamContext vitamContext, JsonNode jsonNode) throws Throwable {
        this.vitamContextCommonService.patchContext(vitamContext, "0", jsonNode);
    }

    private /* synthetic */ void lambda$patchContext_should_return_ok_when_vitamclient_ok$0(VitamContext vitamContext, JsonNode jsonNode) throws Throwable {
        this.vitamContextCommonService.patchContext(vitamContext, "0", jsonNode);
    }
}

