/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitamui.referential.common.service;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import fr.gouv.vitam.access.external.client.AdminExternalClient;
import fr.gouv.vitam.access.external.common.exception.AccessExternalClientException;
import fr.gouv.vitam.common.client.VitamContext;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.exception.VitamClientException;
import fr.gouv.vitam.common.json.JsonHandler;
import fr.gouv.vitam.common.model.RequestResponseOK;
import fr.gouv.vitam.common.model.administration.OntologyModel;
import fr.gouv.vitamui.commons.api.exception.BadRequestException;
import fr.gouv.vitamui.referential.common.service.OntologyCommonService;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;

public class OntologyCommonServiceTest {
    @Mock
    private AdminExternalClient adminExternalClient;
    @InjectMocks
    private OntologyCommonService ontologyCommonService;

    @BeforeEach
    public void setUp() {
        MockitoAnnotations.openMocks((Object)this);
    }

    @Test
    public void findOntologyById_should_return_ontologies_when_vitamclient_ok() throws VitamClientException {
        VitamContext vitamContext = new VitamContext(Integer.valueOf(0));
        String identifier = "0";
        Mockito.when((Object)this.adminExternalClient.findOntologyById((VitamContext)ArgumentMatchers.any(VitamContext.class), (String)ArgumentMatchers.eq((Object)identifier))).thenReturn((Object)new RequestResponseOK().setHttpCode(200));
        Assertions.assertThatCode(() -> this.ontologyCommonService.findOntologyById(vitamContext, identifier)).doesNotThrowAnyException();
    }

    @Test
    public void findOntologyById_should_return_vitamClientException_when_vitamClient_400() throws VitamClientException {
        VitamContext vitamContext = new VitamContext(Integer.valueOf(1));
        String identifier = "1";
        Mockito.when((Object)this.adminExternalClient.findOntologyById((VitamContext)ArgumentMatchers.any(VitamContext.class), (String)ArgumentMatchers.eq((Object)identifier))).thenReturn((Object)new RequestResponseOK().setHttpCode(400));
        Assertions.assertThatCode(() -> this.ontologyCommonService.findOntologyById(vitamContext, identifier)).isInstanceOf(BadRequestException.class);
    }

    @Test
    public void findOntologyById_should_return_vitamClientException_when_vitamClient_throws_vitamClientException() throws VitamClientException {
        VitamContext vitamContext = new VitamContext(Integer.valueOf(1));
        String identifier = "1";
        Mockito.when((Object)this.adminExternalClient.findOntologyById((VitamContext)ArgumentMatchers.any(VitamContext.class), (String)ArgumentMatchers.eq((Object)identifier))).thenThrow(new Throwable[]{new VitamClientException("Exception thrown by Vitam")});
        Assertions.assertThatCode(() -> this.ontologyCommonService.findOntologyById(vitamContext, identifier)).isInstanceOf(VitamClientException.class);
    }

    @Test
    public void findOntologies_should_return_ontologies_when_vitamclient_ok() throws VitamClientException {
        VitamContext vitamContext = new VitamContext(Integer.valueOf(0));
        ObjectNode jsonNode = JsonHandler.createObjectNode();
        Mockito.when((Object)this.adminExternalClient.findOntologies((VitamContext)ArgumentMatchers.any(VitamContext.class), (JsonNode)ArgumentMatchers.any(JsonNode.class))).thenReturn((Object)new RequestResponseOK().setHttpCode(200));
        Assertions.assertThatCode(() -> this.lambda$findOntologies_should_return_ontologies_when_vitamclient_ok$3(vitamContext, (JsonNode)jsonNode)).doesNotThrowAnyException();
    }

    @Test
    public void findOntologies_should_return_vitamClientException_when_vitamClient_400() throws VitamClientException {
        VitamContext vitamContext = new VitamContext(Integer.valueOf(1));
        ObjectNode jsonNode = JsonHandler.createObjectNode();
        Mockito.when((Object)this.adminExternalClient.findOntologies((VitamContext)ArgumentMatchers.any(VitamContext.class), (JsonNode)ArgumentMatchers.any(JsonNode.class))).thenReturn((Object)new RequestResponseOK().setHttpCode(400));
        Assertions.assertThatCode(() -> this.lambda$findOntologies_should_return_vitamClientException_when_vitamClient_400$4(vitamContext, (JsonNode)jsonNode)).isInstanceOf(BadRequestException.class);
    }

    @Test
    public void findOntologies_should_return_vitamClientException_when_vitamClient_throws_vitamClientException() throws VitamClientException {
        VitamContext vitamContext = new VitamContext(Integer.valueOf(2));
        ObjectNode jsonNode = JsonHandler.createObjectNode();
        Mockito.when((Object)this.adminExternalClient.findOntologies((VitamContext)ArgumentMatchers.any(VitamContext.class), (JsonNode)ArgumentMatchers.any(JsonNode.class))).thenThrow(new Throwable[]{new VitamClientException("Exception thrown by Vitam")});
        Assertions.assertThatCode(() -> this.lambda$findOntologies_should_return_vitamClientException_when_vitamClient_throws_vitamClientException$5(vitamContext, (JsonNode)jsonNode)).isInstanceOf(VitamClientException.class);
    }

    @Test
    public void importOntologies_should_return_ok_when_vitamclient_ok() throws InvalidParseOperationException, AccessExternalClientException {
        VitamContext vitamContext = new VitamContext(Integer.valueOf(0));
        ArrayList<OntologyModel> ontologies = new ArrayList<OntologyModel>();
        OntologyModel ontologyModel = new OntologyModel();
        ontologyModel.setIdentifier("identifier");
        ontologyModel.setId("1");
        ontologyModel.setTenant(Integer.valueOf(0));
        ontologies.add(ontologyModel);
        Mockito.when((Object)this.adminExternalClient.importOntologies(((Boolean)ArgumentMatchers.any(Boolean.class)).booleanValue(), (VitamContext)ArgumentMatchers.any(VitamContext.class), (InputStream)ArgumentMatchers.any(ByteArrayInputStream.class))).thenReturn((Object)new RequestResponseOK().setHttpCode(200));
        Assertions.assertThatCode(() -> this.ontologyCommonService.importOntologies(vitamContext, ontologies)).doesNotThrowAnyException();
    }

    @Test
    public void importOntologies_should_return_ok_when_vitamclient_400() throws InvalidParseOperationException, AccessExternalClientException {
        VitamContext vitamContext = new VitamContext(Integer.valueOf(0));
        ArrayList ontologies = new ArrayList();
        Mockito.when((Object)this.adminExternalClient.importOntologies(((Boolean)ArgumentMatchers.any(Boolean.class)).booleanValue(), (VitamContext)ArgumentMatchers.any(VitamContext.class), (InputStream)ArgumentMatchers.any(ByteArrayInputStream.class))).thenReturn((Object)new RequestResponseOK().setHttpCode(400));
        Assertions.assertThatCode(() -> this.ontologyCommonService.importOntologies(vitamContext, ontologies)).doesNotThrowAnyException();
    }

    @Test
    public void importOntologies_should_throw_InvalidParseOperationException_when_vitamclient_throws_InvalidParseOperationException() throws InvalidParseOperationException, AccessExternalClientException {
        VitamContext vitamContext = new VitamContext(Integer.valueOf(0));
        ArrayList ontologies = new ArrayList();
        Mockito.when((Object)this.adminExternalClient.importOntologies(((Boolean)ArgumentMatchers.any(Boolean.class)).booleanValue(), (VitamContext)ArgumentMatchers.any(VitamContext.class), (InputStream)ArgumentMatchers.any(ByteArrayInputStream.class))).thenThrow(new Throwable[]{new InvalidParseOperationException("Exception thrown by Vitam")});
        Assertions.assertThatCode(() -> this.ontologyCommonService.importOntologies(vitamContext, ontologies)).isInstanceOf(InvalidParseOperationException.class);
    }

    @Test
    public void importOntologies_should_throw_AccessExternalClientException_when_vitamclient_throws_AccessExternalClientException() throws InvalidParseOperationException, AccessExternalClientException {
        VitamContext vitamContext = new VitamContext(Integer.valueOf(0));
        ArrayList ontologies = new ArrayList();
        Mockito.when((Object)this.adminExternalClient.importOntologies(((Boolean)ArgumentMatchers.any(Boolean.class)).booleanValue(), (VitamContext)ArgumentMatchers.any(VitamContext.class), (InputStream)ArgumentMatchers.any(ByteArrayInputStream.class))).thenThrow(new Throwable[]{new AccessExternalClientException("Exception thrown by Vitam")});
        Assertions.assertThatCode(() -> this.ontologyCommonService.importOntologies(vitamContext, ontologies)).isInstanceOf(AccessExternalClientException.class);
    }

    private /* synthetic */ void lambda$findOntologies_should_return_vitamClientException_when_vitamClient_throws_vitamClientException$5(VitamContext vitamContext, JsonNode jsonNode) throws Throwable {
        this.ontologyCommonService.findOntologies(vitamContext, jsonNode);
    }

    private /* synthetic */ void lambda$findOntologies_should_return_vitamClientException_when_vitamClient_400$4(VitamContext vitamContext, JsonNode jsonNode) throws Throwable {
        this.ontologyCommonService.findOntologies(vitamContext, jsonNode);
    }

    private /* synthetic */ void lambda$findOntologies_should_return_ontologies_when_vitamclient_ok$3(VitamContext vitamContext, JsonNode jsonNode) throws Throwable {
        this.ontologyCommonService.findOntologies(vitamContext, jsonNode);
    }
}

