/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitamui.referential.common.service;

import fr.gouv.vitam.access.external.client.AdminExternalClient;
import fr.gouv.vitam.common.client.VitamContext;
import fr.gouv.vitam.common.exception.VitamClientException;
import fr.gouv.vitam.common.model.RequestResponseOK;
import fr.gouv.vitamui.commons.api.exception.BadRequestException;
import fr.gouv.vitamui.referential.common.service.IngestContractCommonService;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;

@ExtendWith(value={MockitoExtension.class})
public class IngestContractCommonServiceTest {
    @Mock
    private AdminExternalClient adminExternalClient;
    @InjectMocks
    private IngestContractCommonService ingestContractCommonService;

    @Test
    public void findIngestContract_should_return_ingestContracts_when_vitamclient_ok() throws VitamClientException {
        VitamContext vitamContext = new VitamContext(Integer.valueOf(0));
        String contractId = "IC-0";
        Mockito.when((Object)this.adminExternalClient.findIngestContractById(vitamContext, contractId)).thenReturn((Object)new RequestResponseOK().setHttpCode(200));
        Assertions.assertThatCode(() -> this.ingestContractCommonService.findIngestContractById(vitamContext, contractId)).doesNotThrowAnyException();
    }

    @Test
    public void findIngestContract_should_throw_VitamClienException_when_vitamclient_returns_400() throws VitamClientException {
        VitamContext vitamContext = new VitamContext(Integer.valueOf(1));
        String contractId = "IC-1";
        Mockito.when((Object)this.adminExternalClient.findIngestContractById(vitamContext, contractId)).thenReturn((Object)new RequestResponseOK().setHttpCode(400));
        Assertions.assertThatThrownBy(() -> this.ingestContractCommonService.findIngestContractById(vitamContext, contractId)).isInstanceOf(BadRequestException.class);
    }

    @Test
    public void findIngestContract_should_throw_VitamClienException_when_vitamclient_throws_VitamClientException() throws VitamClientException {
        VitamContext vitamContext = new VitamContext(Integer.valueOf(1));
        String contractId = "IC-2";
        Mockito.when((Object)this.adminExternalClient.findIngestContractById(vitamContext, contractId)).thenThrow(new Throwable[]{new VitamClientException("Exception thrown by Vitam")});
        Assertions.assertThatThrownBy(() -> this.ingestContractCommonService.findIngestContractById(vitamContext, contractId)).isInstanceOf(VitamClientException.class);
    }
}

