/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitamui.referential.common.export.probativevalue;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.io.ByteStreams;
import fr.gouv.vitamui.referential.common.export.probativevalue.dto.ProbativeReportDto;
import java.io.IOException;
import java.io.InputStream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ProbativeReportDtoTest {
    @Test
    public void testProbativeReportDtoFromJsonWARNING() throws JsonParseException, JsonMappingException, IOException {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        InputStream inputStream = ProbativeReportDtoTest.class.getClassLoader().getResourceAsStream("provative_report_WARNING.json");
        ProbativeReportDto report = (ProbativeReportDto)objectMapper.readValue(ByteStreams.toByteArray((InputStream)inputStream), ProbativeReportDto.class);
        Assertions.assertNotNull((Object)report);
        Assertions.assertEquals((int)1, (int)report.getReportEntries().size());
    }

    @Test
    public void testProbativeReportDtoFromJsonKO() throws JsonParseException, JsonMappingException, IOException {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        InputStream inputStream = ProbativeReportDtoTest.class.getClassLoader().getResourceAsStream("provative_report_KO.json");
        ProbativeReportDto report = (ProbativeReportDto)objectMapper.readValue(ByteStreams.toByteArray((InputStream)inputStream), ProbativeReportDto.class);
        Assertions.assertNotNull((Object)report);
        Assertions.assertEquals((int)1, (int)report.getReportEntries().size());
    }
}

