/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitamui.referential.common.dto;

import com.fasterxml.jackson.databind.ObjectMapper;
import fr.gouv.vitamui.referential.common.dto.ImportSchemaDto;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

class ImportSchemaDtoTest {
    private ImportSchemaDto importSchemaDto;

    ImportSchemaDtoTest() {
    }

    @BeforeEach
    void setUp() {
        this.importSchemaDto = new ImportSchemaDto();
    }

    @Test
    void testGettersAndSetters() {
        this.importSchemaDto.setPath("test/path");
        this.importSchemaDto.setCardinality("1..n");
        this.importSchemaDto.setObject(true);
        this.importSchemaDto.setShortName("Test ShortName");
        this.importSchemaDto.setDescription("Test Description");
        Assertions.assertEquals((Object)"test/path", (Object)this.importSchemaDto.getPath());
        Assertions.assertEquals((Object)"1..n", (Object)this.importSchemaDto.getCardinality());
        Assertions.assertTrue((boolean)this.importSchemaDto.isObject());
        Assertions.assertEquals((Object)"Test ShortName", (Object)this.importSchemaDto.getShortName());
        Assertions.assertEquals((Object)"Test Description", (Object)this.importSchemaDto.getDescription());
    }

    @Test
    void testSerialization() throws Exception {
        this.importSchemaDto.setPath("test/path");
        this.importSchemaDto.setCardinality("1..1");
        this.importSchemaDto.setObject(false);
        this.importSchemaDto.setShortName("UniqueName");
        this.importSchemaDto.setDescription("A short description");
        ObjectMapper objectMapper = new ObjectMapper();
        String json = objectMapper.writeValueAsString((Object)this.importSchemaDto);
        Assertions.assertTrue((boolean)json.contains("test/path"));
        Assertions.assertTrue((boolean)json.contains("1..1"));
        Assertions.assertTrue((boolean)json.contains("UniqueName"));
        Assertions.assertTrue((boolean)json.contains("A short description"));
    }

    @Test
    void testToString() {
        this.importSchemaDto.setPath("test/path");
        this.importSchemaDto.setCardinality("1..1");
        this.importSchemaDto.setObject(true);
        this.importSchemaDto.setShortName("TestShort");
        this.importSchemaDto.setDescription("A description");
        String toString = this.importSchemaDto.toString();
        Assertions.assertTrue((boolean)toString.contains("test/path"));
        Assertions.assertTrue((boolean)toString.contains("1..1"));
        Assertions.assertTrue((boolean)toString.contains("TestShort"));
        Assertions.assertTrue((boolean)toString.contains("A description"));
    }
}

