/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitamui.iam.security.service;

import fr.gouv.vitam.common.client.VitamContext;
import fr.gouv.vitamui.commons.api.domain.ProfileDto;
import fr.gouv.vitamui.commons.api.domain.Role;
import fr.gouv.vitamui.commons.api.domain.TenantDto;
import fr.gouv.vitamui.commons.api.exception.ApplicationServerException;
import fr.gouv.vitamui.commons.api.exception.UnAuthorizedException;
import fr.gouv.vitamui.commons.rest.client.HttpContext;
import fr.gouv.vitamui.commons.security.client.dto.AuthUserDto;
import fr.gouv.vitamui.iam.security.authentication.AuthenticationToken;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;

public class SecurityService {
    public AuthenticationToken getAuthentication() {
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        if (authentication instanceof AuthenticationToken) {
            AuthenticationToken authenticationToken = (AuthenticationToken)authentication;
            return authenticationToken;
        }
        throw new UnAuthorizedException("Unable to get the security context. You probably are not authenticated.");
    }

    public boolean hasRole(String role) {
        AuthUserDto user = this.getAuthentication().getPrincipal();
        List<Role> roles = SecurityService.getRoles(user);
        return roles == null ? false : roles.stream().anyMatch(r -> r.getName().equalsIgnoreCase(role));
    }

    public Integer getTenantIdentifier() {
        Integer tenantIdentifier = this.getAuthentication().getCredentials().getTenantIdentifier();
        if (tenantIdentifier == null) {
            throw new ApplicationServerException("Tenant not found in security context");
        }
        return tenantIdentifier;
    }

    public boolean isLevelAllowed(String childLevel) {
        if (childLevel == null) {
            throw new IllegalArgumentException("childLevel is node defined");
        }
        String parentLevel = this.getLevel();
        return parentLevel.isEmpty() || childLevel.startsWith(parentLevel + ".");
    }

    public String getLevel() {
        return this.getUser().getLevel();
    }

    public String getCustomerId() {
        return this.getUser().getCustomerId();
    }

    public AuthUserDto getUser() {
        AuthUserDto user = this.getAuthentication().getPrincipal();
        if (user == null) {
            throw new ApplicationServerException("User not found in security context");
        }
        return user;
    }

    public HttpContext getHttpContext() {
        HttpContext httpContext = this.getAuthentication().getCredentials();
        if (httpContext == null) {
            throw new ApplicationServerException("HttpContext not found in security context");
        }
        return httpContext;
    }

    public Integer getProofTenantIdentifier() {
        Integer tenantIdentifier = this.getAuthentication().getPrincipal().getProofTenantIdentifier();
        if (tenantIdentifier == null) {
            throw new ApplicationServerException("Proof tenant identifier not found in security context");
        }
        return tenantIdentifier;
    }

    public static List<Role> getRoles(AuthUserDto user) {
        if (user.getProfileGroup() == null) {
            return Collections.emptyList();
        }
        List profiles = user.getProfileGroup().getProfiles();
        return profiles == null || profiles.size() == 0 ? Collections.emptyList() : profiles.stream().filter(ProfileDto::isEnabled).flatMap(p -> p.getRoles().stream()).collect(Collectors.toList());
    }

    public static List<Role> getRoles(AuthUserDto user, Integer tenantIdentifier) {
        if (user.getProfileGroup() == null) {
            return Collections.emptyList();
        }
        List profiles = user.getProfileGroup().getProfiles();
        return profiles == null || profiles.size() == 0 ? Collections.emptyList() : profiles.stream().filter(ProfileDto::isEnabled).filter(p -> tenantIdentifier.equals(p.getTenantIdentifier())).flatMap(p -> p.getRoles().stream()).collect(Collectors.toList());
    }

    public TenantDto getTenant(Integer tenantIdentifier) {
        Optional<TenantDto> tenant = this.getUser().getTenantsByApp().stream().flatMap(t -> t.getTenants().stream()).filter(t -> tenantIdentifier.equals(t.getIdentifier())).findAny();
        tenant.orElseThrow(() -> new ApplicationServerException("Tenant not found"));
        return tenant.get();
    }

    public String getApplicationId() {
        String applicationId = this.getAuthentication().getCredentials().getApplicationId();
        if (applicationId == null) {
            throw new ApplicationServerException("Application ID not found in security context");
        }
        return applicationId;
    }

    public boolean userIsRootLevel() {
        return StringUtils.equals((CharSequence)this.getLevel(), (CharSequence)"");
    }

    public VitamContext getVitamContext() {
        return this.buildVitamContext(this.getTenantIdentifier());
    }

    public VitamContext buildVitamContext(Integer tenantId) {
        return new VitamContext(tenantId).setApplicationSessionId(this.getApplicationId());
    }

    public VitamContext buildVitamContext(Integer tenantId, String accessContractId) {
        return new VitamContext(tenantId).setAccessContract(accessContractId).setApplicationSessionId(this.getApplicationId());
    }
}

