/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitamui.iam.security.service;

import fr.gouv.vitamui.commons.api.domain.ProfileDto;
import fr.gouv.vitamui.commons.api.exception.NotFoundException;
import fr.gouv.vitamui.commons.rest.client.HttpContext;
import fr.gouv.vitamui.iam.openapiclient.UsersApi;
import fr.gouv.vitamui.iam.openapiclient.domain.AuthUserDto;
import fr.gouv.vitamui.iam.security.service.UserAuthenticationService;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.web.authentication.preauth.PreAuthenticatedAuthenticationToken;
import org.springframework.stereotype.Service;

@Service
public class IamClientUserAuthenticationService
implements UserAuthenticationService {
    private static final Logger LOGGER = LoggerFactory.getLogger(IamClientUserAuthenticationService.class);
    private final UsersApi usersApi;

    @Autowired
    public IamClientUserAuthenticationService(UsersApi usersApi) {
        this.usersApi = usersApi;
    }

    @Override
    public fr.gouv.vitamui.commons.security.client.dto.AuthUserDto getUserFromHttpContext(PreAuthenticatedAuthenticationToken token) {
        Integer tenantIdentifier;
        fr.gouv.vitamui.commons.security.client.dto.AuthUserDto userDto = this.getAuthenticatedUser(token);
        HttpContext httpContext = (HttpContext)token.getPrincipal();
        List userTenants = userDto.getProfileGroup().getProfiles().stream().filter(ProfileDto::isEnabled).map(ProfileDto::getTenantIdentifier).collect(Collectors.toList());
        if (!userTenants.contains(tenantIdentifier = httpContext.getTenantIdentifier())) {
            LOGGER.debug("Tenant id [{}] not in user tenants [{}]", (Object)tenantIdentifier, userTenants);
            throw new BadCredentialsException("This tenant: " + httpContext.getTenantIdentifier() + " is not allowed for this user: " + userDto.getId());
        }
        return userDto;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private fr.gouv.vitamui.commons.security.client.dto.AuthUserDto getAuthenticatedUser(PreAuthenticatedAuthenticationToken token) {
        try {
            if (SecurityContextHolder.getContext().getAuthentication() != null) {
                throw new BadCredentialsException("Authentication should ne be set yet");
            }
            SecurityContextHolder.getContext().setAuthentication((Authentication)token);
            String userToken = ((HttpContext)token.getPrincipal()).getUserToken();
            if (StringUtils.isBlank((CharSequence)userToken)) {
                throw new BadCredentialsException("User token is empty");
            }
            AuthUserDto userDto = this.usersApi.getMe();
            if (userDto == null) {
                throw new NotFoundException("User not found for token: " + userToken);
            }
            AuthUserDto authUserDto = userDto;
            return authUserDto;
        }
        finally {
            SecurityContextHolder.getContext().setAuthentication(null);
        }
    }
}

