/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitamui.iam.security.provider;

import fr.gouv.vitamui.commons.rest.client.HttpContext;
import fr.gouv.vitamui.iam.security.provider.ExternalApiAuthenticationProvider;
import fr.gouv.vitamui.iam.security.provider.InternalApiAuthenticationProvider;
import java.security.cert.X509Certificate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.core.Authentication;
import org.springframework.security.web.authentication.preauth.PreAuthenticatedAuthenticationToken;
import org.springframework.stereotype.Service;

@Service
public class ApiAuthenticationProvider
implements AuthenticationProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(ApiAuthenticationProvider.class);
    private final InternalApiAuthenticationProvider internalApiAuthenticationProvider;
    private final ExternalApiAuthenticationProvider externalApiAuthenticationProvider;

    public ApiAuthenticationProvider(InternalApiAuthenticationProvider internalApiAuthenticationProvider, ExternalApiAuthenticationProvider externalApiAuthenticationProvider) {
        this.internalApiAuthenticationProvider = internalApiAuthenticationProvider;
        this.externalApiAuthenticationProvider = externalApiAuthenticationProvider;
    }

    public Authentication authenticate(Authentication authentication) {
        if (!this.supports(authentication.getClass())) {
            throw new BadCredentialsException("Unable to authenticate REST call");
        }
        PreAuthenticatedAuthenticationToken token = (PreAuthenticatedAuthenticationToken)authentication;
        HttpContext httpContext = (HttpContext)token.getPrincipal();
        X509Certificate certificate = (X509Certificate)token.getCredentials();
        LOGGER.debug("Principal: {}", (Object)httpContext);
        LOGGER.debug("Certificate: {}", (Object)certificate);
        Integer tenantIdentifier = httpContext.getTenantIdentifier();
        LOGGER.debug("tenantIdentifier: {}", (Object)tenantIdentifier);
        if (httpContext.isExternalRequest()) {
            return this.externalApiAuthenticationProvider.authenticate(authentication);
        }
        return this.internalApiAuthenticationProvider.authenticate(authentication);
    }

    public boolean supports(Class<?> authentication) {
        return authentication.equals(PreAuthenticatedAuthenticationToken.class);
    }
}

