/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitamui.iam.security.filter;

import jakarta.servlet.http.HttpServletRequest;
import org.springframework.util.StringUtils;

@FunctionalInterface
public interface TokenExtractor {
    public static TokenExtractor headerExtractor(String tokenHeaderName) {
        return request -> request.getHeader(tokenHeaderName);
    }

    public static TokenExtractor bearerExtractor() {
        return request -> {
            String headerAuth = request.getHeader("Authorization");
            if (StringUtils.hasText((String)headerAuth) && headerAuth.startsWith("Bearer ")) {
                return headerAuth.substring(7);
            }
            return null;
        };
    }

    public String extract(HttpServletRequest var1);
}

