/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitamui.iam.security.filter;

import fr.gouv.vitamui.commons.api.domain.Role;
import fr.gouv.vitamui.commons.api.exception.ApplicationServerException;
import fr.gouv.vitamui.commons.api.exception.UnAuthorizedException;
import fr.gouv.vitamui.commons.security.client.dto.AuthUserDto;
import fr.gouv.vitamui.iam.security.service.SecurityService;
import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.List;
import java.util.Objects;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.filter.OncePerRequestFilter;

public class TenantHeaderFilter
extends OncePerRequestFilter {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TenantHeaderFilter.class);
    public static final String ROLE_CROSS_TENANTS_SUFFIX = "_OTHER_TENANTS";
    private final SecurityService securityService;
    private final Integer casTenant;

    public TenantHeaderFilter(SecurityService securityService, Integer casTenant) {
        this.securityService = securityService;
        this.casTenant = casTenant;
    }

    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        block6: {
            String tenantIdHeader = request.getHeader("X-Tenant-Id");
            if (StringUtils.isNotBlank((CharSequence)tenantIdHeader)) {
                try {
                    List<Role> userRoles;
                    boolean hasAnyCrossTenantRole;
                    AuthUserDto user = this.securityService.getUser();
                    Integer requestTenantId = Integer.parseInt(tenantIdHeader);
                    Integer sessionTenantId = user.getProofTenantIdentifier();
                    if (Objects.equals(requestTenantId, sessionTenantId) || (hasAnyCrossTenantRole = (userRoles = SecurityService.getRoles(this.securityService.getUser())).stream().anyMatch(r -> r.getName().endsWith(ROLE_CROSS_TENANTS_SUFFIX))) || this.casTenant.equals(requestTenantId)) break block6;
                    try {
                        this.securityService.getTenant(requestTenantId);
                    }
                    catch (ApplicationServerException e) {
                        log.error("User not allowed on tenant {}", (Object)tenantIdHeader);
                        response.sendError(403, "Unauthorized access to tenant");
                        return;
                    }
                }
                catch (NumberFormatException e) {
                    log.warn("Invalid tenant ID format: {}", (Object)tenantIdHeader);
                    response.sendError(400, "Invalid tenant ID format");
                    return;
                }
                catch (UnAuthorizedException e) {
                    log.error("User not authenticated ", (Throwable)e);
                    response.sendError(401, "Unauthorized user");
                    return;
                }
            }
        }
        filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
    }
}

