/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitamui.iam.security.filter;

import fr.gouv.vitamui.commons.rest.client.HttpContext;
import fr.gouv.vitamui.iam.security.filter.TokenExtractor;
import fr.gouv.vitamui.iam.security.filter.X509CertificateExtractor;
import jakarta.servlet.http.HttpServletRequest;
import java.util.List;
import java.util.Objects;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.web.authentication.preauth.x509.X509AuthenticationFilter;

public class RequestHeadersAuthenticationFilter
extends X509AuthenticationFilter {
    private final List<X509CertificateExtractor> x509CertificateExtractors;
    private final List<TokenExtractor> tokenExtractors;

    public RequestHeadersAuthenticationFilter(AuthenticationManager authenticationManager, List<X509CertificateExtractor> x509CertificateExtractors, List<TokenExtractor> tokenExtractors) {
        this.setAuthenticationManager(authenticationManager);
        this.x509CertificateExtractors = x509CertificateExtractors;
        this.tokenExtractors = tokenExtractors;
    }

    protected Object getPreAuthenticatedPrincipal(HttpServletRequest request) {
        this.logger.debug((Object)("request: " + request.getRequestURI() + " - " + request.getQueryString()));
        return HttpContext.buildFromExternalRequest((HttpServletRequest)request, (String)this.extractToken(request));
    }

    private String extractToken(HttpServletRequest request) {
        return this.tokenExtractors.stream().map(tokenExtractor -> tokenExtractor.extract(request)).filter(Objects::nonNull).findFirst().orElse(null);
    }

    protected Object getPreAuthenticatedCredentials(HttpServletRequest request) {
        return this.x509CertificateExtractors.stream().map(x509CertificateExtractor -> x509CertificateExtractor.extract(request)).filter(Objects::nonNull).findFirst().orElse(null);
    }
}

