/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitamui.pastis.server.service;

import fr.gouv.vitam.common.model.administration.schema.SchemaCardinality;
import fr.gouv.vitam.common.model.administration.schema.SchemaResponse;
import fr.gouv.vitam.common.model.administration.schema.SchemaType;
import fr.gouv.vitamui.pastis.common.dto.profiles.ProfileVersion;
import fr.gouv.vitamui.pastis.common.dto.seda.SedaNode;
import fr.gouv.vitamui.pastis.common.util.SedaNodeUtils;
import fr.gouv.vitamui.pastis.server.service.ExternalSchemaService;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class MetaModelService {
    private static final Logger LOGGER = LoggerFactory.getLogger(MetaModelService.class);
    private final ExternalSchemaService externalSchemaService;

    public SedaNode getMetaModelForVersion(ProfileVersion profileVersion) throws IOException {
        String resourcePath = "metamodel/metamodel-" + profileVersion.getVersion() + ".json";
        SedaNode sedaNode = SedaNodeUtils.parseSedaNodeFromResource((String)resourcePath);
        List<SedaNode> externalSedaNodes = this.getMetaModelFromExternalSchema();
        return this.mergeSedaNodesIntoContent(sedaNode, externalSedaNodes);
    }

    public SedaNode getArchiveUnitMetaModelForVersion(ProfileVersion profileVersion) throws IOException {
        SedaNode sedaNode = this.getMetaModelForVersion(profileVersion);
        return sedaNode.getChild("DataObjectPackage").getChild("DescriptiveMetadata").getChild("ArchiveUnit");
    }

    private List<SedaNode> getMetaModelFromExternalSchema() {
        List<SchemaResponse> schemaResponsesList = this.externalSchemaService.getExternalSchemaModels();
        return this.convertSchemaModelsToSedaNodes(schemaResponsesList);
    }

    private List<SedaNode> convertSchemaModelsToSedaNodes(List<SchemaResponse> externalSchemaModels) {
        SedaNode sedaNode;
        HashMap<String, SedaNode> schemaPathToSedaNode = new HashMap<String, SedaNode>();
        for (SchemaResponse schemaResponse : externalSchemaModels) {
            String schemaPath = schemaResponse.getPath();
            String schemaName = schemaResponse.getFieldName();
            sedaNode = this.convertSchemaModelToSedaNode(schemaName, schemaResponse);
            schemaPathToSedaNode.put(schemaPath, sedaNode);
        }
        ArrayList<SedaNode> result = new ArrayList<SedaNode>();
        for (Map.Entry entry : schemaPathToSedaNode.entrySet()) {
            String schemaPath = (String)entry.getKey();
            sedaNode = (SedaNode)entry.getValue();
            int lastDotPointer = schemaPath.lastIndexOf(46);
            if (lastDotPointer != -1) {
                String parentSchemaPath = schemaPath.substring(0, lastDotPointer);
                SedaNode parentSedaNode = (SedaNode)schemaPathToSedaNode.get(parentSchemaPath);
                if (parentSedaNode == null) {
                    LOGGER.error("Schema item {} does not have its parent {}", (Object)schemaPath, (Object)parentSchemaPath);
                    continue;
                }
                parentSedaNode.getChildren().add(sedaNode);
                continue;
            }
            result.add(sedaNode);
        }
        return result;
    }

    private SedaNode convertSchemaModelToSedaNode(String schemaName, SchemaResponse schemaResponse) {
        SedaNode result = new SedaNode();
        result.setName(schemaName);
        result.setNameFr(schemaResponse.getShortName());
        result.setElement(schemaResponse.getType() == SchemaType.OBJECT ? "Complex" : "Simple");
        result.setCardinality(switch (schemaResponse.getCardinality()) {
            default -> throw new IncompatibleClassChangeError();
            case SchemaCardinality.ZERO, SchemaCardinality.ONE -> "0-1";
            case SchemaCardinality.ONE_REQUIRED -> "1";
            case SchemaCardinality.MANY -> "0-N";
            case SchemaCardinality.MANY_REQUIRED -> "1-N";
        });
        result.setType(switch (schemaResponse.getType()) {
            default -> throw new IncompatibleClassChangeError();
            case SchemaType.OBJECT -> "null";
            case SchemaType.DATE -> "date";
            case SchemaType.ENUM, SchemaType.KEYWORD -> "token";
            case SchemaType.LONG -> "int";
            case SchemaType.TEXT -> "string";
            case SchemaType.DOUBLE -> "decimal";
            case SchemaType.BOOLEAN -> "boolean";
        });
        result.setChoice("no");
        result.setExtensible("no");
        result.setEnumeration(new ArrayList());
        if (schemaResponse.getType() == SchemaType.BOOLEAN) {
            result.getEnumeration().addAll(List.of("false", "true"));
        }
        result.setDefinition(schemaResponse.getDescription());
        result.setCollection("Unit\u00e9s d'archives");
        result.setChildren(new ArrayList());
        result.setExternal(true);
        return result;
    }

    private SedaNode mergeSedaNodesIntoContent(SedaNode main, List<SedaNode> otherNodes) {
        SedaNode content = main.getChild("DataObjectPackage").getChild("DescriptiveMetadata").getChild("ArchiveUnit").getChild("Content");
        content.getChildren().addAll(otherNodes);
        return main;
    }

    @Generated
    public MetaModelService(ExternalSchemaService externalSchemaService) {
        this.externalSchemaService = externalSchemaService;
    }
}

