/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitamui.pastis.server.service;

import fr.gouv.vitam.access.external.client.AdminExternalClient;
import fr.gouv.vitam.common.client.VitamContext;
import fr.gouv.vitam.common.exception.VitamClientException;
import fr.gouv.vitam.common.model.RequestResponse;
import fr.gouv.vitam.common.model.RequestResponseOK;
import fr.gouv.vitam.common.model.administration.schema.SchemaOrigin;
import fr.gouv.vitam.common.model.administration.schema.SchemaResponse;
import fr.gouv.vitamui.commons.api.exception.InternalServerException;
import fr.gouv.vitamui.iam.security.service.SecurityService;
import fr.gouv.vitamui.pastis.server.service.ExternalSchemaService;
import java.util.Collections;
import java.util.List;
import lombok.Generated;
import org.springframework.context.annotation.Profile;
import org.springframework.stereotype.Service;

@Service
@Profile(value={"!standalone"})
public class ExternalSchemaServiceImpl
implements ExternalSchemaService {
    private final AdminExternalClient adminExternalClient;
    private final SecurityService securityService;

    private VitamContext getVitamContext() {
        return new VitamContext(this.securityService.getTenantIdentifier()).setApplicationSessionId(this.securityService.getApplicationId());
    }

    @Override
    public List<SchemaResponse> getExternalSchemaModels() {
        VitamContext context = this.getVitamContext();
        try {
            RequestResponse requestResponse = this.adminExternalClient.getUnitSchema(context);
            if (requestResponse.isOk()) {
                List schemaModels = ((RequestResponseOK)requestResponse).getResults();
                return schemaModels.stream().filter(sr -> sr.getOrigin() == SchemaOrigin.EXTERNAL).toList();
            }
            return Collections.emptyList();
        }
        catch (VitamClientException e) {
            throw new InternalServerException("Unable to get schema information", (Throwable)e);
        }
    }

    @Generated
    public ExternalSchemaServiceImpl(AdminExternalClient adminExternalClient, SecurityService securityService) {
        this.adminExternalClient = adminExternalClient;
        this.securityService = securityService;
    }
}

