/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitamui.collect.server.service;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.opencsv.CSVWriterBuilder;
import com.opencsv.ICSVWriter;
import fr.gouv.vitam.common.LocalDateUtil;
import fr.gouv.vitam.common.client.VitamContext;
import fr.gouv.vitam.common.database.builder.facet.Facet;
import fr.gouv.vitam.common.database.builder.facet.FacetHelper;
import fr.gouv.vitam.common.database.builder.facet.RangeFacetValue;
import fr.gouv.vitam.common.database.builder.query.BooleanQuery;
import fr.gouv.vitam.common.database.builder.query.Query;
import fr.gouv.vitam.common.database.builder.query.QueryHelper;
import fr.gouv.vitam.common.database.builder.request.configuration.BuilderToken;
import fr.gouv.vitam.common.database.builder.request.exception.InvalidCreateOperationException;
import fr.gouv.vitam.common.database.builder.request.multiple.SelectMultiQuery;
import fr.gouv.vitam.common.database.builder.request.single.Select;
import fr.gouv.vitam.common.database.facet.model.FacetOrder;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.exception.VitamClientException;
import fr.gouv.vitam.common.json.JsonHandler;
import fr.gouv.vitam.common.model.RequestResponse;
import fr.gouv.vitam.common.model.RequestResponseOK;
import fr.gouv.vitam.common.model.administration.FileRulesModel;
import fr.gouv.vitam.common.model.elimination.DeletionRequestBody;
import fr.gouv.vitamui.archives.search.common.common.RulesUpdateCommonService;
import fr.gouv.vitamui.archives.search.common.dsl.VitamQueryHelper;
import fr.gouv.vitamui.archives.search.common.dto.AgencyResponseDto;
import fr.gouv.vitamui.archives.search.common.dto.ArchiveUnit;
import fr.gouv.vitamui.archives.search.common.dto.ArchiveUnitCsv;
import fr.gouv.vitamui.archives.search.common.dto.ArchiveUnitsDto;
import fr.gouv.vitamui.archives.search.common.dto.VitamUIArchiveUnitResponseDto;
import fr.gouv.vitamui.common.security.SanityChecker;
import fr.gouv.vitamui.commons.api.domain.AgencyModelDto;
import fr.gouv.vitamui.commons.api.domain.DirectionDto;
import fr.gouv.vitamui.commons.api.dtos.CriteriaValue;
import fr.gouv.vitamui.commons.api.dtos.ExportSearchResultParam;
import fr.gouv.vitamui.commons.api.dtos.SearchCriteriaDto;
import fr.gouv.vitamui.commons.api.dtos.SearchCriteriaEltDto;
import fr.gouv.vitamui.commons.api.dtos.VitamUiOntologyDto;
import fr.gouv.vitamui.commons.api.exception.BadRequestException;
import fr.gouv.vitamui.commons.api.exception.InternalServerException;
import fr.gouv.vitamui.commons.api.exception.InvalidTypeException;
import fr.gouv.vitamui.commons.api.exception.RequestEntityTooLargeException;
import fr.gouv.vitamui.commons.api.utils.ArchiveSearchConsts;
import fr.gouv.vitamui.commons.api.utils.MetadataSearchCriteriaUtils;
import fr.gouv.vitamui.commons.api.utils.OntologyServiceReader;
import fr.gouv.vitamui.commons.vitam.api.administration.AgencyCommonService;
import fr.gouv.vitamui.commons.vitam.api.administration.RuleCommonService;
import fr.gouv.vitamui.commons.vitam.api.collect.CollectService;
import fr.gouv.vitamui.commons.vitam.api.dto.FacetBucketDto;
import fr.gouv.vitamui.commons.vitam.api.dto.FacetResultsDto;
import fr.gouv.vitamui.commons.vitam.api.dto.ResultsDto;
import fr.gouv.vitamui.commons.vitam.api.dto.RuleNodeResponseDto;
import fr.gouv.vitamui.commons.vitam.api.dto.VitamUISearchResponseDto;
import fr.gouv.vitamui.commons.vitam.api.util.VitamRestUtils;
import jakarta.validation.constraints.NotNull;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.time.format.DateTimeParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.core.io.Resource;
import org.springframework.stereotype.Service;

@Service
public class TransactionArchiveUnitService {
    private static final Logger LOGGER = LoggerFactory.getLogger(TransactionArchiveUnitService.class);
    private static final String RESULTS = "$results";
    private static final String DSL_QUERY_FACETS = "$facets";
    private static final String TITLE_FIELD = "Title";
    private final CollectService collectService;
    private final AgencyCommonService agencyCommonService;
    private final RuleCommonService ruleCommonService;
    private final ObjectMapper objectMapper;
    @Value(value="${ontologies_file_path}")
    private String ontologiesFilePath;

    public VitamUIArchiveUnitResponseDto searchArchiveUnitsByCriteria(String transactionId, SearchCriteriaDto searchQuery, VitamContext vitamContext) throws VitamClientException, JsonProcessingException, InvalidParseOperationException, InvalidCreateOperationException {
        LOGGER.debug("get units by query {}", (Object)searchQuery);
        SanityChecker.sanitizeCriteria((Object)searchQuery);
        SelectMultiQuery searchQuerySelectMultiQuery = CollectionUtils.isEmpty((Collection)searchQuery.getCriteriaList()) ? MetadataSearchCriteriaUtils.getBasicQuery((SearchCriteriaDto)searchQuery) : MetadataSearchCriteriaUtils.createDslQueryWithFacets((SearchCriteriaDto)searchQuery);
        ObjectNode searchQueryToDSL = searchQuerySelectMultiQuery.getFinalSelect();
        RequestResponse result = this.collectService.searchUnitsByTransactionId(transactionId, (JsonNode)searchQueryToDSL, vitamContext);
        VitamRestUtils.checkResponse((RequestResponse)result, (Integer[])new Integer[0]);
        VitamUISearchResponseDto archivesOriginResponse = (VitamUISearchResponseDto)this.objectMapper.treeToValue((TreeNode)result.toJsonNode(), VitamUISearchResponseDto.class);
        VitamUIArchiveUnitResponseDto responseFilled = new VitamUIArchiveUnitResponseDto();
        responseFilled.setContext(archivesOriginResponse.getContext());
        responseFilled.setFacetResults(archivesOriginResponse.getFacetResults());
        responseFilled.setResults(JsonHandler.getFromJsonNodeList((List)((RequestResponseOK)result).getResults(), ArchiveUnit.class));
        responseFilled.setHits(archivesOriginResponse.getHits());
        ArchiveUnitsDto resultedArchiveUnits = new ArchiveUnitsDto(responseFilled);
        this.fillFacets(transactionId, searchQuery, resultedArchiveUnits, vitamContext);
        return resultedArchiveUnits.getArchives();
    }

    public Resource exportToCsvSearchArchiveUnitsByCriteria(String transactionId, SearchCriteriaDto searchQuery, VitamContext vitamContext) throws VitamClientException {
        LOGGER.info("Calling exportToCsvSearchArchiveUnitsByCriteria with query {} ", (Object)searchQuery);
        Locale locale = Locale.FRENCH;
        if (Locale.FRENCH.getLanguage().equals(searchQuery.getLanguage()) || Locale.ENGLISH.getLanguage().equals(searchQuery.getLanguage())) {
            locale = Locale.forLanguageTag(searchQuery.getLanguage());
        }
        ExportSearchResultParam exportSearchResultParam = new ExportSearchResultParam(locale);
        return this.exportToCsvSearchArchiveUnitsByCriteriaAndParams(transactionId, searchQuery, exportSearchResultParam, vitamContext);
    }

    public ResultsDto findArchiveUnitById(String id, VitamContext vitamContext) throws VitamClientException {
        try {
            LOGGER.debug("Archive Unit Id : {}", (Object)id);
            String re = StringUtils.chop((String)this.collectService.findUnitById(id, vitamContext).toJsonNode().get(RESULTS).toString().substring(1));
            return (ResultsDto)this.objectMapper.readValue(re, ResultsDto.class);
        }
        catch (JsonProcessingException e) {
            LOGGER.error("Can not get the archive unit {} ", (Throwable)e);
            throw new VitamClientException("Unable to find the UA", (Throwable)e);
        }
    }

    private String getArchiveUnitTitle(ArchiveUnit archiveUnit) {
        return this.getArchiveUnitI18nAttribute(archiveUnit, ResultsDto::getTitle, ResultsDto::getTitle_);
    }

    private String getArchiveUnitDescription(ArchiveUnit archiveUnit) {
        return this.getArchiveUnitI18nAttribute(archiveUnit, ResultsDto::getDescription, ResultsDto::getDescription_);
    }

    private String getArchiveUnitI18nAttribute(ArchiveUnit archiveUnit, Function<ArchiveUnit, String> attributeExtractor, Function<ArchiveUnit, Map<String, String>> i18nAttributeExtractor) {
        if (archiveUnit == null) {
            return null;
        }
        String attribute = attributeExtractor.apply(archiveUnit);
        if (StringUtils.isNotBlank((CharSequence)attribute)) {
            return attribute;
        }
        Map<String, String> attribute_ = i18nAttributeExtractor.apply(archiveUnit);
        if (attribute_ == null) {
            return null;
        }
        return Stream.of("fr", "en").map(lang -> attribute_.entrySet().stream().filter(e -> lang.equalsIgnoreCase((String)e.getKey())).findFirst()).flatMap(Optional::stream).findFirst().map(Map.Entry::getValue).or(() -> attribute_.values().stream().findFirst()).orElse(null);
    }

    private String getArchiveUnitType(ArchiveUnit archiveUnit, String language) {
        String archiveUnitType = null;
        if (archiveUnit != null && !StringUtils.isEmpty((CharSequence)archiveUnit.getUnitType())) {
            switch (archiveUnit.getUnitType()) {
                case "FILING_UNIT": {
                    archiveUnitType = language.equals(Locale.FRENCH.getLanguage()) ? "Plan de classement" : "Filling scheme";
                    break;
                }
                case "HOLDING_UNIT": {
                    archiveUnitType = language.equals(Locale.FRENCH.getLanguage()) ? "Arbre de positionnement" : "Holding scheme";
                    break;
                }
                case "INGEST": {
                    if (StringUtils.isEmpty((CharSequence)archiveUnit.getUnitObject())) {
                        archiveUnitType = language.equals(Locale.FRENCH.getLanguage()) ? "Archive sans objet" : "Archive without object";
                        break;
                    }
                    archiveUnitType = language.equals(Locale.FRENCH.getLanguage()) ? "Archive avec objet" : "Archive with object";
                    break;
                }
                default: {
                    throw new InvalidTypeException("Description Level Type is Unknown !");
                }
            }
        }
        return archiveUnitType;
    }

    private void fillFacets(String transactionId, SearchCriteriaDto searchQuery, ArchiveUnitsDto archiveUnitsDto, VitamContext vitamContext) throws InvalidCreateOperationException, VitamClientException, JsonProcessingException {
        if (searchQuery.isComputeMgtRulesFacets()) {
            ArrayList<FacetResultsDto> facetResults = archiveUnitsDto.getArchives().getFacetResults();
            if (org.springframework.util.CollectionUtils.isEmpty((Collection)facetResults)) {
                facetResults = new ArrayList<FacetResultsDto>();
            }
            facetResults.addAll(this.computeFacetsForIndexedRulesCriteria(transactionId, searchQuery.getCriteriaList(), vitamContext));
            archiveUnitsDto.getArchives().setFacetResults(facetResults);
        }
    }

    private List<FacetResultsDto> computeFacetsForIndexedRulesCriteria(String transactionId, List<SearchCriteriaEltDto> initialArchiveUnitsCriteriaList, VitamContext vitamContext) throws InvalidCreateOperationException, VitamClientException, JsonProcessingException {
        LOGGER.debug("Start finding facets for computed rules  ");
        ArrayList<FacetResultsDto> globalRulesFacets = new ArrayList<FacetResultsDto>();
        try {
            List<ArchiveSearchConsts.CriteriaCategory> categories = List.of(ArchiveSearchConsts.CriteriaCategory.APPRAISAL_RULE, ArchiveSearchConsts.CriteriaCategory.ACCESS_RULE, ArchiveSearchConsts.CriteriaCategory.STORAGE_RULE, ArchiveSearchConsts.CriteriaCategory.REUSE_RULE, ArchiveSearchConsts.CriteriaCategory.DISSEMINATION_RULE);
            ArrayList<SearchCriteriaEltDto> indexedArchiveUnitsCriteriaList = new ArrayList<SearchCriteriaEltDto>(initialArchiveUnitsCriteriaList);
            indexedArchiveUnitsCriteriaList.add(new SearchCriteriaEltDto("RULES_COMPUTED", ArchiveSearchConsts.CriteriaCategory.FIELDS, ArchiveSearchConsts.CriteriaOperators.EQ.name(), List.of(new CriteriaValue("true")), ArchiveSearchConsts.CriteriaDataType.STRING.name()));
            SelectMultiQuery selectMultiQuery = MetadataSearchCriteriaUtils.createSelectMultiQuery(indexedArchiveUnitsCriteriaList);
            selectMultiQuery.addUsedProjection(new String[]{"#id"});
            selectMultiQuery.setLimitFilter(0L, 1L);
            RequestResponse result = this.collectService.searchUnitsByTransactionId(transactionId, (JsonNode)selectMultiQuery.getFinalSelect(), vitamContext);
            VitamRestUtils.checkResponse((RequestResponse)result, (Integer[])new Integer[0]);
            VitamUISearchResponseDto archivesUnitsResults = (VitamUISearchResponseDto)this.objectMapper.treeToValue((TreeNode)result.toJsonNode(), VitamUISearchResponseDto.class);
            List indexedAuFacets = archivesUnitsResults.getFacetResults();
            globalRulesFacets.addAll(indexedAuFacets);
            for (ArchiveSearchConsts.CriteriaCategory category : categories) {
                FacetResultsDto withoutRulesByCategoryFacet = this.computeNoRulesFacets(transactionId, indexedArchiveUnitsCriteriaList, category, vitamContext);
                globalRulesFacets.add(withoutRulesByCategoryFacet);
                List<FacetResultsDto> facetsForAuHavingRules = this.computeFacetsForAuHavingRules(transactionId, indexedArchiveUnitsCriteriaList, category, vitamContext);
                globalRulesFacets.addAll(facetsForAuHavingRules);
            }
        }
        catch (InvalidParseOperationException e) {
            throw new BadRequestException("Can't parse criteria as Vitam query" + e.getMessage());
        }
        return globalRulesFacets;
    }

    private FacetResultsDto computeNoRulesFacets(String transactionId, List<SearchCriteriaEltDto> indexedCriteriaList, ArchiveSearchConsts.CriteriaCategory category, VitamContext vitamContext) throws VitamClientException, JsonProcessingException, InvalidCreateOperationException, InvalidParseOperationException {
        ArrayList<SearchCriteriaEltDto> criteriaListFacet = new ArrayList<SearchCriteriaEltDto>(indexedCriteriaList);
        criteriaListFacet.add(new SearchCriteriaEltDto("RULE_ORIGIN", category, ArchiveSearchConsts.CriteriaOperators.EQ.name(), List.of(new CriteriaValue(ArchiveSearchConsts.RuleOriginValues.ORIGIN_HAS_NO_ONE.name())), ArchiveSearchConsts.CriteriaDataType.STRING.name()));
        FacetResultsDto noRuleFacet = new FacetResultsDto();
        noRuleFacet.setName("COUNT_WITHOUT_RULES_" + category.name());
        noRuleFacet.setBuckets(List.of(new FacetBucketDto("COUNT_WITHOUT_RULES", Long.valueOf(this.countArchiveUnitByCriteriaList(transactionId, criteriaListFacet, vitamContext).intValue()))));
        return noRuleFacet;
    }

    private Integer countArchiveUnitByCriteriaList(String transactionId, List<SearchCriteriaEltDto> criteriaList, VitamContext vitamContext) throws VitamClientException, JsonProcessingException, InvalidCreateOperationException, InvalidParseOperationException {
        SearchCriteriaDto facetSearchQuery = new SearchCriteriaDto();
        facetSearchQuery.setCriteriaList(criteriaList);
        facetSearchQuery.setFieldsList(List.of(TITLE_FIELD));
        VitamUIArchiveUnitResponseDto vitamResponse = this.searchArchiveUnitsByCriteria(transactionId, facetSearchQuery, vitamContext);
        return vitamResponse.getHits().getTotal();
    }

    private List<FacetResultsDto> computeFacetsForAuHavingRules(String transactionId, List<SearchCriteriaEltDto> indexedArchiveUnitsCriteriaList, ArchiveSearchConsts.CriteriaCategory category, VitamContext vitamContext) throws InvalidParseOperationException, InvalidCreateOperationException, VitamClientException, JsonProcessingException {
        ArrayList<SearchCriteriaEltDto> criteriaList = new ArrayList<SearchCriteriaEltDto>(indexedArchiveUnitsCriteriaList);
        criteriaList.add(new SearchCriteriaEltDto("RULE_ORIGIN", category, ArchiveSearchConsts.CriteriaOperators.EQ.name(), List.of(new CriteriaValue(ArchiveSearchConsts.RuleOriginValues.ORIGIN_LOCAL_OR_INHERIT_RULES.name())), ArchiveSearchConsts.CriteriaDataType.STRING.name()));
        SelectMultiQuery selectMultiQuery = MetadataSearchCriteriaUtils.createSelectMultiQuery(criteriaList);
        selectMultiQuery.setLimitFilter(0L, 1L);
        selectMultiQuery.trackTotalHits(false);
        try {
            List<SearchCriteriaEltDto> rulesCriteriaList = indexedArchiveUnitsCriteriaList.stream().filter(Objects::nonNull).filter(searchCriteriaEltDto -> category.equals((Object)searchCriteriaEltDto.getCategory())).collect(Collectors.toList());
            String computedRulesIdentifierMapping = "#computedInheritedRules." + ArchiveSearchConsts.CriteriaMgtRulesCategory.valueOf((String)category.name()).getFieldMapping() + ".Rules.Rule";
            if (ArchiveSearchConsts.CriteriaCategory.APPRAISAL_RULE.equals((Object)category) || ArchiveSearchConsts.CriteriaCategory.STORAGE_RULE.equals((Object)category)) {
                String computedRulesFinalActionMapping = "#computedInheritedRules." + ArchiveSearchConsts.CriteriaMgtRulesCategory.valueOf((String)category.name()).getFieldMapping() + ".FinalAction";
                selectMultiQuery.addFacets(new Facet[]{FacetHelper.terms((String)("FINAL_ACTION_COMPUTED_" + category.name()), (String)computedRulesFinalActionMapping, (Integer)3, (FacetOrder)FacetOrder.ASC)});
            }
            selectMultiQuery.addFacets(new Facet[]{FacetHelper.terms((String)("RULES_COMPUTED_NUMBER_" + category.name()), (String)computedRulesIdentifierMapping, (Integer)100, (FacetOrder)FacetOrder.ASC)});
            this.addExpirationRulesFacet(rulesCriteriaList, category, selectMultiQuery);
        }
        catch (DateTimeParseException e) {
            throw new InvalidCreateOperationException((Throwable)e);
        }
        RequestResponse result = this.collectService.searchUnitsByTransactionId(transactionId, (JsonNode)selectMultiQuery.getFinalSelect(), vitamContext);
        VitamRestUtils.checkResponse((RequestResponse)result, (Integer[])new Integer[0]);
        VitamUISearchResponseDto archivesUnitsResults = (VitamUISearchResponseDto)this.objectMapper.treeToValue((TreeNode)result.toJsonNode(), VitamUISearchResponseDto.class);
        List auWithRulesFacets = archivesUnitsResults.getFacetResults();
        if (ArchiveSearchConsts.CriteriaCategory.APPRAISAL_RULE.equals((Object)category) || ArchiveSearchConsts.CriteriaCategory.STORAGE_RULE.equals((Object)category)) {
            FacetResultsDto finalActionIndexedFacet = this.buildComputedAuFinalActionFacet(transactionId, indexedArchiveUnitsCriteriaList, category, auWithRulesFacets, vitamContext);
            auWithRulesFacets = auWithRulesFacets.stream().filter(facet -> !("FINAL_ACTION_COMPUTED_" + category.name()).equals(facet.getName())).collect(Collectors.toList());
            auWithRulesFacets.add(finalActionIndexedFacet);
        }
        return auWithRulesFacets;
    }

    private void addExpirationRulesFacet(List<SearchCriteriaEltDto> mgtRulesCriteriaList, ArchiveSearchConsts.CriteriaCategory category, SelectMultiQuery select) throws InvalidCreateOperationException {
        String strDateExpirationCriteria = this.extractRuleExpirationDateFromCriteria(mgtRulesCriteriaList, category);
        String managementRuleEndDateMapping = "#computedInheritedRules." + ArchiveSearchConsts.CriteriaMgtRulesCategory.valueOf((String)category.name()).getFieldMapping() + ".MaxEndDate";
        select.addFacets(new Facet[]{FacetHelper.dateRange((String)("EXPIRED_RULES_COMPUTED_" + category.name()), (String)managementRuleEndDateMapping, (String)"dd/MM/yyyy", List.of(new RangeFacetValue("01/01/0001", strDateExpirationCriteria)))});
        select.addFacets(new Facet[]{FacetHelper.dateRange((String)("UNEXPIRED_RULES_COMPUTED_" + category.name()), (String)managementRuleEndDateMapping, (String)"dd/MM/yyyy", List.of(new RangeFacetValue(strDateExpirationCriteria, "31/12/9999")))});
    }

    private FacetResultsDto buildComputedAuFinalActionFacet(String transactionId, List<SearchCriteriaEltDto> indexedArchiveUnitsCriteriaList, ArchiveSearchConsts.CriteriaCategory category, List<FacetResultsDto> indexedRulesFacets, VitamContext vitamContext) throws VitamClientException, JsonProcessingException, InvalidCreateOperationException, InvalidParseOperationException {
        FacetResultsDto finalActionIndexedFacet = new FacetResultsDto();
        if (ArchiveSearchConsts.CriteriaCategory.APPRAISAL_RULE.equals((Object)category)) {
            List<FacetBucketDto> finalActionBuckets = this.computeFinalActionFacetsForComputedAppraisalRules(transactionId, indexedArchiveUnitsCriteriaList, indexedRulesFacets, category, vitamContext);
            finalActionIndexedFacet.setName("FINAL_ACTION_COMPUTED_" + category.name());
            finalActionIndexedFacet.setBuckets(finalActionBuckets);
        } else if (ArchiveSearchConsts.CriteriaCategory.STORAGE_RULE.equals((Object)category)) {
            Optional<FacetResultsDto> finalActionIndexedFacetOpt = indexedRulesFacets.stream().filter(facet -> ("FINAL_ACTION_COMPUTED_" + category.name()).equals(facet.getName())).findAny();
            finalActionIndexedFacet = finalActionIndexedFacetOpt.isPresent() ? finalActionIndexedFacetOpt.get() : new FacetResultsDto();
        }
        return finalActionIndexedFacet;
    }

    @NotNull
    private List<FacetBucketDto> computeFinalActionFacetsForComputedAppraisalRules(String transactionId, List<SearchCriteriaEltDto> indexedArchiveUnitsCriteriaList, List<FacetResultsDto> indexedRulesFacets, ArchiveSearchConsts.CriteriaCategory category, VitamContext vitamContext) throws VitamClientException, JsonProcessingException, InvalidCreateOperationException, InvalidParseOperationException {
        HashMap<String, Long> finalActionCountMap = new HashMap<String, Long>();
        finalActionCountMap.put("Keep", 0L);
        finalActionCountMap.put("Destroy", 0L);
        finalActionCountMap.put("Conflict", 0L);
        Optional<FacetResultsDto> facetFinalActionValue = indexedRulesFacets.stream().filter(facet -> ("FINAL_ACTION_COMPUTED_" + category.name()).equals(facet.getName())).findAny();
        facetFinalActionValue.ifPresent(facetResultsDto -> facetResultsDto.getBuckets().stream().forEach(bucket -> finalActionCountMap.put(bucket.getValue(), bucket.getCount())));
        Integer withConflictFinalActionUnitsCount = this.computeFinalActionCountByValue(transactionId, indexedArchiveUnitsCriteriaList, "FINAL_ACTION_TYPE_CONFLICT", category, vitamContext);
        finalActionCountMap.put("Conflict", Long.valueOf(withConflictFinalActionUnitsCount.intValue()));
        if (withConflictFinalActionUnitsCount != 0) {
            Long withKeepFinalActionAppraisalRulesUnitsCount = (Long)finalActionCountMap.get("Keep");
            Long withDestroyFinalActionAppraisalRulesUnitsCount = (Long)finalActionCountMap.get("Destroy");
            if (withKeepFinalActionAppraisalRulesUnitsCount > 0L) {
                finalActionCountMap.put("Keep", withKeepFinalActionAppraisalRulesUnitsCount - (long)withConflictFinalActionUnitsCount.intValue());
            }
            if (withDestroyFinalActionAppraisalRulesUnitsCount > 0L) {
                finalActionCountMap.put("Destroy", withDestroyFinalActionAppraisalRulesUnitsCount - (long)withConflictFinalActionUnitsCount.intValue());
            }
        }
        ArrayList<FacetBucketDto> finalActionBuckets = new ArrayList<FacetBucketDto>();
        for (Map.Entry entry : finalActionCountMap.entrySet()) {
            finalActionBuckets.add(new FacetBucketDto((String)entry.getKey(), (Long)entry.getValue()));
        }
        return finalActionBuckets;
    }

    private Integer computeFinalActionCountByValue(String transactionId, List<SearchCriteriaEltDto> initialCriteriaList, String value, ArchiveSearchConsts.CriteriaCategory category, VitamContext vitamContext) throws VitamClientException, JsonProcessingException, InvalidCreateOperationException, InvalidParseOperationException {
        ArrayList<SearchCriteriaEltDto> criteriaListFacet = new ArrayList<SearchCriteriaEltDto>();
        criteriaListFacet.addAll(initialCriteriaList);
        SearchCriteriaDto countSearchQuery = new SearchCriteriaDto();
        criteriaListFacet.add(new SearchCriteriaEltDto("FINAL_ACTION_TYPE", category, ArchiveSearchConsts.CriteriaOperators.EQ.name(), List.of(new CriteriaValue(value)), ArchiveSearchConsts.CriteriaDataType.STRING.name()));
        criteriaListFacet.add(new SearchCriteriaEltDto("RULES_COMPUTED", ArchiveSearchConsts.CriteriaCategory.FIELDS, ArchiveSearchConsts.CriteriaOperators.EQ.name(), List.of(new CriteriaValue("true")), ArchiveSearchConsts.CriteriaDataType.STRING.name()));
        countSearchQuery.setCriteriaList(criteriaListFacet);
        countSearchQuery.setFieldsList(List.of(TITLE_FIELD));
        VitamUIArchiveUnitResponseDto archiveUnitsDto = this.searchArchiveUnitsByCriteria(transactionId, countSearchQuery, vitamContext);
        return archiveUnitsDto.getHits().getTotal();
    }

    @NotNull
    private String extractRuleExpirationDateFromCriteria(List<SearchCriteriaEltDto> mgtRulesCriteriaList, ArchiveSearchConsts.CriteriaCategory category) {
        String strDateExpirationCriteria;
        Optional<SearchCriteriaEltDto> endDateCriteria = mgtRulesCriteriaList.stream().filter(searchCriteriaEltDto -> category.equals((Object)searchCriteriaEltDto.getCategory()) && "RULE_END_DATE".equals(searchCriteriaEltDto.getCriteria())).findAny();
        if (endDateCriteria.isPresent() && !org.springframework.util.CollectionUtils.isEmpty((Collection)endDateCriteria.get().getValues())) {
            String beginDtStr = ((CriteriaValue)endDateCriteria.get().getValues().get(0)).getBeginInterval();
            String endDtStr = ((CriteriaValue)endDateCriteria.get().getValues().get(0)).getEndInterval();
            LocalDateTime beginDt = null;
            if (!StringUtils.isEmpty((CharSequence)beginDtStr)) {
                beginDt = LocalDateTime.parse(beginDtStr, ArchiveSearchConsts.ISO_FRENCH_FORMATER);
            }
            LocalDateTime endDt = null;
            if (!StringUtils.isEmpty((CharSequence)endDtStr)) {
                endDt = LocalDateTime.parse(endDtStr, ArchiveSearchConsts.ISO_FRENCH_FORMATER);
            }
            strDateExpirationCriteria = beginDt != null && endDt != null ? (endDt.isAfter(beginDt) ? ArchiveSearchConsts.ONLY_DATE_FRENCH_FORMATTER_WITH_SLASH.format(endDt) : ArchiveSearchConsts.ONLY_DATE_FRENCH_FORMATTER_WITH_SLASH.format(beginDt)) : (beginDt != null ? ArchiveSearchConsts.ONLY_DATE_FRENCH_FORMATTER_WITH_SLASH.format(beginDt) : (endDt != null ? ArchiveSearchConsts.ONLY_DATE_FRENCH_FORMATTER_WITH_SLASH.format(endDt) : ArchiveSearchConsts.ONLY_DATE_FRENCH_FORMATTER_WITH_SLASH.format(LocalDateTime.now())));
        } else {
            strDateExpirationCriteria = ArchiveSearchConsts.ONLY_DATE_FRENCH_FORMATTER_WITH_SLASH.format(LocalDateTime.now());
        }
        return strDateExpirationCriteria;
    }

    private Resource exportToCsvSearchArchiveUnitsByCriteriaAndParams(String transactionId, SearchCriteriaDto searchQuery, ExportSearchResultParam exportSearchResultParam, VitamContext vitamContext) throws VitamClientException {
        try {
            this.mapAgenciesNameToCodes(searchQuery, vitamContext);
            List<ArchiveUnitCsv> unitCsvList = this.exportArchiveUnitsByCriteriaToCsvFile(transactionId, searchQuery, vitamContext);
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            OutputStreamWriter writer = new OutputStreamWriter((OutputStream)outputStream, StandardCharsets.UTF_8.name());
            String[] headerRecordFr = exportSearchResultParam.getHeaders().toArray(new String[exportSearchResultParam.getHeaders().size()]);
            SimpleDateFormat dateFormat = new SimpleDateFormat(exportSearchResultParam.getPatternDate());
            ICSVWriter csvWriter = new CSVWriterBuilder((Writer)writer).withSeparator(exportSearchResultParam.getSeparator()).withQuoteChar('\"').withEscapeChar('\"').withLineEnd("\n").build();
            csvWriter.writeNext(headerRecordFr);
            unitCsvList.stream().forEach(archiveUnitCsv -> {
                String startDt = null;
                String endDt = null;
                if (archiveUnitCsv.getStartDate() != null) {
                    try {
                        startDt = dateFormat.format(LocalDateUtil.getDate((String)archiveUnitCsv.getStartDate()));
                    }
                    catch (ParseException e) {
                        LOGGER.error("Error parsing starting date {} ", (Object)archiveUnitCsv.getStartDate());
                    }
                }
                if (archiveUnitCsv.getEndDate() != null) {
                    try {
                        endDt = dateFormat.format(LocalDateUtil.getDate((String)archiveUnitCsv.getEndDate()));
                    }
                    catch (ParseException e) {
                        LOGGER.error("Error parsing end date {} ", (Object)archiveUnitCsv.getEndDate());
                    }
                }
                csvWriter.writeNext(new String[]{archiveUnitCsv.getId(), archiveUnitCsv.getArchiveUnitType(), archiveUnitCsv.getOriginatingAgencyName(), (String)exportSearchResultParam.getDescriptionLevelMap().get(archiveUnitCsv.getDescriptionLevel()), archiveUnitCsv.getTitle(), startDt, endDt, archiveUnitCsv.getDescription()});
            });
            csvWriter.close();
            ((Writer)writer).close();
            return new ByteArrayResource(outputStream.toByteArray());
        }
        catch (IOException ex) {
            throw new BadRequestException("Unable to export csv file ", (Throwable)ex);
        }
    }

    public ResultsDto findObjectGroupById(String objectId, VitamContext vitamContext) throws VitamClientException {
        try {
            LOGGER.debug("[INTERNAL] : Get Object Group by Id");
            String resultStringValue = StringUtils.chop((String)this.collectService.getObjectById(vitamContext, objectId).toJsonNode().get(RESULTS).toString().substring(1));
            return (ResultsDto)this.objectMapper.readValue(resultStringValue, ResultsDto.class);
        }
        catch (JsonProcessingException e) {
            LOGGER.error("Can not get the object group {} ", (Throwable)e);
            throw new InternalServerException("Unable to find the ObjectGroup", (Throwable)e);
        }
    }

    private List<ArchiveUnitCsv> exportArchiveUnitsByCriteriaToCsvFile(String transactionId, SearchCriteriaDto searchQuery, VitamContext vitamContext) throws VitamClientException {
        try {
            LOGGER.info("Calling exporting  export ArchiveUnits to CSV with criteria {}", (Object)searchQuery);
            this.checkSizeLimit(transactionId, vitamContext, searchQuery);
            searchQuery.setPageNumber(Integer.valueOf(0));
            searchQuery.setSize(ArchiveSearchConsts.EXPORT_ARCHIVE_UNITS_MAX_ELEMENTS);
            VitamUIArchiveUnitResponseDto archiveUnitsResult = this.searchArchiveUnitsByCriteria(transactionId, searchQuery, vitamContext);
            LOGGER.info("archivesResponse found {} ", (Object)archiveUnitsResult.getResults().size());
            Set originesAgenciesCodes = archiveUnitsResult.getResults().stream().map(ResultsDto::getOriginatingAgency).filter(Objects::nonNull).collect(Collectors.toSet());
            List<AgencyModelDto> originAgenciesFound = this.findOriginAgenciesByCriteria(vitamContext, "Name", new ArrayList<String>(originesAgenciesCodes));
            Map<String, AgencyModelDto> agenciesMapByIdentifier = originAgenciesFound.stream().collect(Collectors.toMap(AgencyModelDto::getIdentifier, agency -> agency));
            return archiveUnitsResult.getResults().stream().map(archiveUnit -> this.fillOriginatingAgencyName((ResultsDto)archiveUnit, agenciesMapByIdentifier)).map(archiveUnit -> this.cleanAndMapArchiveUnitResult((ArchiveUnit)archiveUnit, searchQuery.getLanguage())).collect(Collectors.toList());
        }
        catch (InvalidCreateOperationException | InvalidParseOperationException | IOException e) {
            throw new BadRequestException("Can't parse criteria as Vitam query", e);
        }
    }

    public ArchiveUnit fillOriginatingAgencyName(ResultsDto originResponse, Map<String, AgencyModelDto> actualAgenciesMapById) {
        AgencyModelDto agencyModel;
        ArchiveUnit archiveUnit = new ArchiveUnit();
        BeanUtils.copyProperties((Object)originResponse, (Object)archiveUnit);
        if (actualAgenciesMapById != null && !actualAgenciesMapById.isEmpty() && (agencyModel = actualAgenciesMapById.get(originResponse.getOriginatingAgency())) != null) {
            archiveUnit.setOriginatingAgencyName(agencyModel.getName());
        }
        return archiveUnit;
    }

    private void checkSizeLimit(String transactionId, VitamContext vitamContext, SearchCriteriaDto searchQuery) throws VitamClientException, IOException, InvalidCreateOperationException, InvalidParseOperationException {
        SearchCriteriaDto searchQueryCounting = new SearchCriteriaDto();
        searchQueryCounting.setCriteriaList(searchQuery.getCriteriaList());
        VitamUIArchiveUnitResponseDto archiveUnitsResult = this.searchArchiveUnitsByCriteria(transactionId, searchQueryCounting, vitamContext);
        Integer nbResults = archiveUnitsResult.getHits().getTotal();
        if (nbResults >= ArchiveSearchConsts.EXPORT_ARCHIVE_UNITS_MAX_ELEMENTS) {
            LOGGER.error("The archives units result found is greater than allowed {} ", (Object)ArchiveSearchConsts.EXPORT_ARCHIVE_UNITS_MAX_ELEMENTS);
            throw new RequestEntityTooLargeException("The archives units result found is greater than allowed:  " + ArchiveSearchConsts.EXPORT_ARCHIVE_UNITS_MAX_ELEMENTS);
        }
    }

    public List<AgencyModelDto> findOriginAgenciesByCriteria(VitamContext vitamContext, String field, List<String> originAgenciesCodes) throws VitamClientException {
        List<Object> agencies = new ArrayList<AgencyModelDto>();
        if (originAgenciesCodes != null && !originAgenciesCodes.isEmpty()) {
            LOGGER.debug("Finding originating agencies by field {}  values {} ", (Object)field, originAgenciesCodes);
            HashMap<String, List<String>> searchCriteriaMap = new HashMap<String, List<String>>();
            searchCriteriaMap.put(field, originAgenciesCodes);
            try {
                JsonNode queryOriginAgencies = VitamQueryHelper.createQueryDSL(searchCriteriaMap, Optional.empty(), Optional.empty());
                RequestResponse requestResponse = this.agencyCommonService.findAgencies(vitamContext, queryOriginAgencies);
                agencies = ((AgencyResponseDto)this.objectMapper.treeToValue((TreeNode)requestResponse.toJsonNode(), AgencyResponseDto.class)).getResults();
            }
            catch (InvalidCreateOperationException e) {
                throw new VitamClientException("Unable to find the agencies ", (Throwable)e);
            }
            catch (JsonProcessingException | InvalidParseOperationException e1) {
                throw new BadRequestException("Error parsing query ", e1);
            }
        }
        LOGGER.debug("origin agencies  found {} ", agencies);
        return agencies;
    }

    private void mapAgenciesNamesToAgenciesCodesInCriteria(SearchCriteriaDto searchQuery, List<AgencyModelDto> actualAgencies) {
        if (searchQuery != null && searchQuery.getCriteriaList() != null && !searchQuery.getCriteriaList().isEmpty()) {
            List mergedCriteriaList = searchQuery.getCriteriaList().stream().filter(criteria -> !"SP_CODE".equals(criteria.getCriteria()) && !"SP_LABEL".equals(criteria.getCriteria())).collect(Collectors.toList());
            List filteredAgenciesId = actualAgencies.stream().map(AgencyModelDto::getIdentifier).collect(Collectors.toList());
            List<SearchCriteriaEltDto> idCriteriaList = searchQuery.getCriteriaList().stream().filter(criteria -> "SP_CODE".equals(criteria.getCriteria())).collect(Collectors.toList());
            if (org.springframework.util.CollectionUtils.isEmpty(idCriteriaList)) {
                SearchCriteriaEltDto idCriteria = new SearchCriteriaEltDto();
                idCriteria.setCriteria("SP_CODE");
                idCriteria.setValues(filteredAgenciesId.stream().map(CriteriaValue::new).collect(Collectors.toList()));
                idCriteria.setOperator(ArchiveSearchConsts.CriteriaOperators.EQ.name());
                idCriteria.setCategory(ArchiveSearchConsts.CriteriaCategory.FIELDS);
                mergedCriteriaList.add(idCriteria);
            } else {
                idCriteriaList.forEach(criteria -> {
                    if (!org.springframework.util.CollectionUtils.isEmpty((Collection)criteria.getValues())) {
                        filteredAgenciesId.addAll(criteria.getValues().stream().map(CriteriaValue::getValue).collect(Collectors.toList()));
                    }
                    criteria.setValues(filteredAgenciesId.stream().map(CriteriaValue::new).collect(Collectors.toList()));
                    mergedCriteriaList.add(criteria);
                });
            }
            searchQuery.setCriteriaList(mergedCriteriaList);
        }
    }

    private ArchiveUnitCsv cleanAndMapArchiveUnitResult(ArchiveUnit archiveUnit, String language) {
        if (archiveUnit == null) {
            return null;
        }
        ArchiveUnitCsv archiveUnitCsv = new ArchiveUnitCsv();
        BeanUtils.copyProperties((Object)archiveUnit, (Object)archiveUnitCsv);
        archiveUnitCsv.setDescription(MetadataSearchCriteriaUtils.cleanString((String)this.getArchiveUnitDescription(archiveUnit)));
        archiveUnitCsv.setDescriptionLevel(archiveUnit.getDescriptionLevel() != null ? MetadataSearchCriteriaUtils.cleanString((String)archiveUnit.getDescriptionLevel()) : null);
        archiveUnitCsv.setArchiveUnitType(this.getArchiveUnitType(archiveUnit, language));
        archiveUnitCsv.setTitle(MetadataSearchCriteriaUtils.cleanString((String)this.getArchiveUnitTitle(archiveUnit)));
        archiveUnitCsv.setOriginatingAgencyName(archiveUnit.getOriginatingAgencyName() != null ? MetadataSearchCriteriaUtils.cleanString((String)archiveUnit.getOriginatingAgencyName()) : null);
        return archiveUnitCsv;
    }

    public List<VitamUiOntologyDto> readExternalOntologiesFromFile(Integer tenantId) throws IOException {
        LOGGER.debug("get ontologies file from path : {} ", (Object)this.ontologiesFilePath);
        return OntologyServiceReader.readExternalOntologiesFromFile((Integer)tenantId, (String)this.ontologiesFilePath);
    }

    public ResultsDto selectUnitWithInheritedRules(SearchCriteriaDto searchQuery, String transactionId, VitamContext vitamContext) throws VitamClientException, IOException {
        ResultsDto resultsDto = new ResultsDto();
        LOGGER.debug("calling select Units With Inherited Rules by criteria {} ", (Object)searchQuery.toString());
        this.mapAgenciesNameToCodes(searchQuery, vitamContext);
        SelectMultiQuery selectMultiQuery = TransactionArchiveUnitService.mapRequestToSelectMultiQuery(searchQuery);
        ObjectNode dslQuery = selectMultiQuery.getFinalSelect();
        RulesUpdateCommonService.deleteAttributesFromObjectNode((ObjectNode)dslQuery, (String[])new String[]{DSL_QUERY_FACETS});
        JsonNode vitamResponse = this.collectService.selectUnitWithInheritedRules((JsonNode)dslQuery, transactionId, vitamContext);
        VitamUISearchResponseDto archivesOriginResponse = (VitamUISearchResponseDto)this.objectMapper.treeToValue((TreeNode)vitamResponse, VitamUISearchResponseDto.class);
        VitamUIArchiveUnitResponseDto responseFilled = new VitamUIArchiveUnitResponseDto();
        responseFilled.setContext(archivesOriginResponse.getContext());
        responseFilled.setFacetResults(archivesOriginResponse.getFacetResults());
        responseFilled.setResults(archivesOriginResponse.getResults().stream().map(archiveUnit -> RulesUpdateCommonService.fillOriginatingAgencyName((ResultsDto)archiveUnit, null)).collect(Collectors.toList()));
        responseFilled.setHits(archivesOriginResponse.getHits());
        ArchiveUnitsDto archiveUnitsFound = new ArchiveUnitsDto(responseFilled);
        if (Objects.nonNull(archiveUnitsFound.getArchives()) && !org.springframework.util.CollectionUtils.isEmpty((Collection)archiveUnitsFound.getArchives().getResults())) {
            resultsDto = (ResultsDto)archiveUnitsFound.getArchives().getResults().get(0);
        }
        return resultsDto;
    }

    public List<AgencyModelDto> findOriginAgenciesByNames(VitamContext vitamContext, Set<String> originAgenciesCodes) throws VitamClientException {
        ArrayList<String> originAgenciesCodesList = new ArrayList<String>(originAgenciesCodes);
        return this.findOriginAgenciesByCriteria(vitamContext, "Name", originAgenciesCodesList);
    }

    public void mapAgenciesNameToCodes(SearchCriteriaDto searchQuery, VitamContext vitamContext) throws VitamClientException {
        LOGGER.debug("calling mapAgenciesNameToCodes  {} ", (Object)searchQuery.toString());
        HashSet<String> agencyOriginNamesCriteria = new HashSet<String>();
        searchQuery.getCriteriaList().stream().filter(criteriaElt -> criteriaElt.getCriteria().equals("SP_LABEL")).forEach(criteriaElt -> agencyOriginNamesCriteria.addAll(criteriaElt.getValues().stream().map(CriteriaValue::getValue).toList()));
        if (!agencyOriginNamesCriteria.isEmpty()) {
            LOGGER.debug(" trying to mapping agencies labels {} ", (Object)((Object)agencyOriginNamesCriteria).toString());
            List<AgencyModelDto> agenciesOrigins = this.findOriginAgenciesByNames(vitamContext, agencyOriginNamesCriteria);
            if (!org.springframework.util.CollectionUtils.isEmpty(agenciesOrigins)) {
                this.mapAgenciesNamesToAgenciesCodesInCriteria(searchQuery, agenciesOrigins);
            }
        }
    }

    public List<FileRulesModel> findRulesByCriteria(VitamContext vitamContext, String field, List<String> rulesIdentifiers, String ruleType) throws VitamClientException {
        List<Object> rules = new ArrayList<FileRulesModel>();
        if (rulesIdentifiers != null && !rulesIdentifiers.isEmpty()) {
            LOGGER.debug("Finding management rules by field {}  values {} ", (Object)field, rulesIdentifiers);
            try {
                Select select = new Select();
                BooleanQuery query = QueryHelper.and();
                BooleanQuery queryOr = QueryHelper.or();
                for (String elt : rulesIdentifiers) {
                    queryOr.add(new Query[]{QueryHelper.eq((String)field, (String)elt)});
                }
                query.add(new Query[]{queryOr});
                select.setLimitFilter(0L, (long)rulesIdentifiers.size());
                if (ruleType != null) {
                    query.add(new Query[]{QueryHelper.eq((String)"RuleType", (String)ruleType)});
                }
                select.setQuery((Query)query);
                ObjectNode queryRules = select.getFinalSelect();
                RequestResponse requestResponse = this.ruleCommonService.findRules(vitamContext, (JsonNode)queryRules);
                rules = ((RuleNodeResponseDto)this.objectMapper.treeToValue((TreeNode)requestResponse.toJsonNode(), RuleNodeResponseDto.class)).getResults();
            }
            catch (InvalidCreateOperationException e) {
                throw new VitamClientException("Unable to find the rules ", (Throwable)e);
            }
            catch (JsonProcessingException e1) {
                throw new BadRequestException("Error parsing query ", (Throwable)e1);
            }
        }
        LOGGER.debug("management rules  found {} ", rules);
        return rules;
    }

    public List<FileRulesModel> findRulesByNames(VitamContext vitamContext, List<String> rulesIdentifiers, String ruleType) throws VitamClientException {
        ArrayList<String> rulesIdentifiersList = new ArrayList<String>(rulesIdentifiers);
        return this.findRulesByCriteria(vitamContext, "RuleValue", rulesIdentifiersList, ruleType);
    }

    public void mapManagementRulesTitlesToCodes(SearchCriteriaDto searchQuery, VitamContext vitamContext) throws VitamClientException {
        if (!org.springframework.util.CollectionUtils.isEmpty((Collection)searchQuery.getCriteriaList())) {
            for (ArchiveSearchConsts.CriteriaMgtRulesCategory mgtRulesCategory : ArchiveSearchConsts.CriteriaMgtRulesCategory.values()) {
                ArchiveSearchConsts.CriteriaCategory category = ArchiveSearchConsts.CriteriaCategory.valueOf((String)mgtRulesCategory.name());
                List titleRulesCriteriaList = searchQuery.extractCriteriaListByCategoryAndFieldNames(category, List.of("RULE_TITLE"));
                List<SearchCriteriaEltDto> appraisalMgtRulesCriteriaListProcessed = searchQuery.getCriteriaList().stream().filter(criteriaElt -> !category.equals((Object)criteriaElt.getCategory()) || !criteriaElt.getCriteria().equals("RULE_TITLE")).collect(Collectors.toList());
                if (org.springframework.util.CollectionUtils.isEmpty((Collection)titleRulesCriteriaList)) continue;
                for (SearchCriteriaEltDto titleCriteriaElt : titleRulesCriteriaList) {
                    if (org.springframework.util.CollectionUtils.isEmpty((Collection)titleCriteriaElt.getValues())) continue;
                    List<String> mgtRulesIdsFound = this.findRulesByNames(vitamContext, titleCriteriaElt.getValues().stream().map(CriteriaValue::getValue).collect(Collectors.toList()), ArchiveSearchConsts.CriteriaMgtRulesCategory.valueOf((String)category.name()).getFieldMapping()).stream().map(FileRulesModel::getRuleId).collect(Collectors.toList());
                    this.handleFoundRules(searchQuery, category, appraisalMgtRulesCriteriaListProcessed, mgtRulesIdsFound);
                }
            }
        }
    }

    private void handleFoundRules(SearchCriteriaDto searchQuery, ArchiveSearchConsts.CriteriaCategory category, List<SearchCriteriaEltDto> appraisalMgtRulesCriteriaListProcessed, List<String> mgtRulesIdsFound) {
        if (!org.springframework.util.CollectionUtils.isEmpty(mgtRulesIdsFound)) {
            SearchCriteriaEltDto ruleIdCriteria;
            Map appraisalMgtRulesCriteriaMap = appraisalMgtRulesCriteriaListProcessed.stream().collect(Collectors.toMap(SearchCriteriaEltDto::getCriteria, Function.identity()));
            if (appraisalMgtRulesCriteriaMap.containsKey("RULE_IDENTIFIER")) {
                ruleIdCriteria = (SearchCriteriaEltDto)appraisalMgtRulesCriteriaMap.get("RULE_IDENTIFIER");
                if (!org.springframework.util.CollectionUtils.isEmpty(mgtRulesIdsFound)) {
                    mgtRulesIdsFound.addAll(ruleIdCriteria.getValues().stream().map(CriteriaValue::getValue).toList());
                }
            } else {
                ruleIdCriteria = new SearchCriteriaEltDto();
                ruleIdCriteria.setCriteria("RULE_IDENTIFIER");
                ruleIdCriteria.setOperator(ArchiveSearchConsts.CriteriaOperators.EQ.name());
                ruleIdCriteria.setCategory(category);
            }
            ruleIdCriteria.setValues(mgtRulesIdsFound.stream().map(CriteriaValue::new).collect(Collectors.toList()));
            appraisalMgtRulesCriteriaMap.put("RULE_IDENTIFIER", ruleIdCriteria);
            searchQuery.setCriteriaList(new ArrayList(appraisalMgtRulesCriteriaMap.values()));
        }
    }

    public static SelectMultiQuery mapRequestToSelectMultiQuery(SearchCriteriaDto searchQuery) throws VitamClientException {
        SelectMultiQuery selectMultiQuery;
        if (searchQuery == null) {
            throw new BadRequestException("Can't parse null criteria");
        }
        Optional<Object> orderBy = Optional.empty();
        Optional<Object> direction = Optional.empty();
        try {
            if (searchQuery.getSortingCriteria() != null) {
                direction = Optional.of(searchQuery.getSortingCriteria().getSorting());
                orderBy = Optional.of(searchQuery.getSortingCriteria().getCriteria());
            }
            selectMultiQuery = MetadataSearchCriteriaUtils.createSelectMultiQuery((List)searchQuery.getCriteriaList());
            if (orderBy.isPresent()) {
                if (DirectionDto.DESC.equals(direction.get())) {
                    selectMultiQuery.addOrderByDescFilter(new String[]{(String)orderBy.get()});
                } else {
                    selectMultiQuery.addOrderByAscFilter(new String[]{(String)orderBy.get()});
                }
            }
            selectMultiQuery.setLimitFilter((long)searchQuery.getPageNumber().intValue() * (long)searchQuery.getSize().intValue(), (long)searchQuery.getSize().intValue());
            selectMultiQuery.trackTotalHits(searchQuery.isTrackTotalHits());
            LOGGER.debug("Final query: {}", (Object)selectMultiQuery.getFinalSelect().toPrettyString());
            if (searchQuery.getThreshold() != null) {
                selectMultiQuery.setThreshold(searchQuery.getThreshold());
            }
        }
        catch (InvalidCreateOperationException ioe) {
            throw new VitamClientException("Unable to find archive units with pagination", (Throwable)ioe);
        }
        catch (InvalidParseOperationException e) {
            throw new BadRequestException("Can't parse criteria as Vitam query" + e.getMessage());
        }
        return selectMultiQuery;
    }

    public JsonNode mapRequestToDslQuery(SearchCriteriaDto searchQuery) throws VitamClientException {
        SelectMultiQuery selectMultiQuery = TransactionArchiveUnitService.mapRequestToSelectMultiQuery(searchQuery);
        return selectMultiQuery.getFinalSelect();
    }

    public JsonNode prepareDslQuery(SearchCriteriaDto searchQuery, VitamContext vitamContext) throws VitamClientException {
        searchQuery.setPageNumber(Integer.valueOf(0));
        this.mapAgenciesNameToCodes(searchQuery, vitamContext);
        this.mapManagementRulesTitlesToCodes(searchQuery, vitamContext);
        return this.mapRequestToDslQuery(searchQuery);
    }

    public DeletionRequestBody getDeletionRequestBody(JsonNode updateSet, Long threshold) {
        ObjectNode query = JsonHandler.createObjectNode();
        query.set(BuilderToken.GLOBAL.ROOTS.exactToken(), updateSet.get(BuilderToken.GLOBAL.ROOTS.exactToken()));
        query.set(BuilderToken.GLOBAL.QUERY.exactToken(), updateSet.get(BuilderToken.GLOBAL.QUERY.exactToken()));
        if (threshold != null) {
            query.set(BuilderToken.GLOBAL.THRESOLD.exactToken(), (JsonNode)this.objectMapper.convertValue((Object)threshold, JsonNode.class));
        }
        DeletionRequestBody requestBody = new DeletionRequestBody();
        requestBody.setDslRequest((JsonNode)query);
        return requestBody;
    }

    public JsonNode startDeletionAction(VitamContext vitamContext, String transactionId, SearchCriteriaDto searchQuery) throws VitamClientException {
        LOGGER.debug("Deletion action by criteria {} ", (Object)searchQuery.toString());
        JsonNode dslQuery = this.prepareDslQuery(searchQuery, vitamContext);
        DeletionRequestBody deletionRequestBody = this.getDeletionRequestBody(dslQuery, searchQuery.getThreshold());
        LOGGER.debug("Deletion action final query {} ", (Object)JsonHandler.prettyPrint((Object)deletionRequestBody.getDslRequest()));
        RequestResponse jsonNodeRequestResponse = this.collectService.startDeletionAction(vitamContext, transactionId, deletionRequestBody);
        return jsonNodeRequestResponse.toJsonNode();
    }

    @Generated
    public TransactionArchiveUnitService(CollectService collectService, AgencyCommonService agencyCommonService, RuleCommonService ruleCommonService, ObjectMapper objectMapper) {
        this.collectService = collectService;
        this.agencyCommonService = agencyCommonService;
        this.ruleCommonService = ruleCommonService;
        this.objectMapper = objectMapper;
    }
}

