/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitamui.collect.server.service;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import fr.gouv.vitam.common.client.VitamContext;
import fr.gouv.vitam.common.exception.VitamClientException;
import fr.gouv.vitamui.commons.api.exception.InternalServerException;
import fr.gouv.vitamui.commons.vitam.api.collect.CollectService;
import fr.gouv.vitamui.commons.vitam.api.dto.QualifiersDto;
import fr.gouv.vitamui.commons.vitam.api.dto.ResultsDto;
import fr.gouv.vitamui.commons.vitam.api.dto.VersionsDto;
import fr.gouv.vitamui.commons.vitam.api.model.ObjectQualifierType;
import jakarta.validation.constraints.NotNull;
import jakarta.ws.rs.core.Response;
import java.io.InputStream;
import java.util.Comparator;
import java.util.Objects;
import lombok.Generated;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.InputStreamResource;
import org.springframework.core.io.Resource;
import org.springframework.http.CacheControl;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Schedulers;

@Service
public class ProjectObjectGroupService {
    private static final Logger LOGGER = LoggerFactory.getLogger(ProjectObjectGroupService.class);
    private static final String RESULTS = "$results";
    private final CollectService collectService;
    private final ObjectMapper objectMapper;

    public Mono<ResponseEntity<Resource>> downloadObjectFromUnit(String id, String objectId, String usage, Integer version, VitamContext vitamContext) throws VitamClientException {
        String fileName = null;
        ResultsDto got = this.findObjectById(objectId, vitamContext);
        if (Objects.nonNull(got)) {
            QualifiersDto qualifier;
            if (ObjectUtils.isEmpty((Object)usage)) {
                qualifier = this.getLastObjectQualifier(got);
            } else {
                String finalUsage = usage;
                qualifier = got.getQualifiers().stream().filter(q -> finalUsage.equals(q.getQualifier())).findFirst().orElse(null);
            }
            if (Objects.nonNull(qualifier)) {
                VersionsDto versionsDto;
                usage = qualifier.getQualifier();
                if (Objects.isNull(version)) {
                    versionsDto = this.getLastVersion(qualifier);
                } else {
                    Integer finalVersion = version;
                    versionsDto = qualifier.getVersions().stream().filter(v -> finalVersion.equals(ProjectObjectGroupService.extractVersion(v))).findFirst().orElse(null);
                }
                if (Objects.nonNull(versionsDto)) {
                    version = ProjectObjectGroupService.extractVersion(versionsDto);
                    fileName = this.getFilename(versionsDto);
                }
            }
        }
        LOGGER.debug("Download Archive Unit Object with id {} , usage {} and version {}", new Object[]{id, usage, version});
        String finalUsage = usage;
        Integer finalVersion = version;
        String finalFileName = fileName;
        return Mono.fromCallable(() -> {
            Response response = this.collectService.getObjectStreamByUnitId(id, finalUsage, finalVersion.intValue(), vitamContext);
            return new InputStreamResource((InputStream)response.getEntity());
        }).subscribeOn(Schedulers.boundedElastic()).flatMap(Objects.nonNull(fileName) ? resource -> Mono.just((Object)((ResponseEntity.BodyBuilder)((ResponseEntity.BodyBuilder)ResponseEntity.ok().header("Content-Disposition", new String[]{"attachment;filename=" + finalFileName})).cacheControl(CacheControl.noCache())).body(resource)) : resource -> Mono.just((Object)((ResponseEntity.BodyBuilder)ResponseEntity.ok().cacheControl(CacheControl.noCache())).body(resource)));
    }

    public ResultsDto findObjectById(String id, VitamContext vitamContext) throws VitamClientException {
        try {
            LOGGER.debug("Get Object Group");
            String resultStringValue = StringUtils.chop((String)this.collectService.getObjectById(vitamContext, id).toJsonNode().get(RESULTS).toString().substring(1));
            return (ResultsDto)this.objectMapper.readValue(resultStringValue, ResultsDto.class);
        }
        catch (JsonProcessingException e) {
            LOGGER.error("Can not get the object group", (Throwable)e);
            throw new InternalServerException("Unable to find the ObjectGroup", (Throwable)e);
        }
    }

    private QualifiersDto getLastObjectQualifier(ResultsDto got) {
        for (String qualifierName : ObjectQualifierType.allValuesOrdered) {
            QualifiersDto qualifierFound = got.getQualifiers().stream().filter(qualifier -> qualifierName.equals(qualifier.getQualifier())).reduce((first, second) -> second).orElse(null);
            if (!Objects.nonNull(qualifierFound)) continue;
            return qualifierFound;
        }
        return null;
    }

    private VersionsDto getLastVersion(QualifiersDto qualifier) {
        return qualifier.getVersions().stream().max(Comparator.comparing(ProjectObjectGroupService::extractVersion)).orElse(null);
    }

    @NotNull
    private static Integer extractVersion(VersionsDto versionsDto) {
        return Integer.parseInt(versionsDto.getDataObjectVersion().split("_")[1]);
    }

    private String getFilename(VersionsDto version) {
        if (Objects.isNull(version) || StringUtils.isEmpty((CharSequence)version.getId())) {
            return null;
        }
        return version.getId() + this.getExtension(version);
    }

    private String getExtension(VersionsDto version) {
        String uriExtension = "";
        if (StringUtils.isNotBlank((CharSequence)version.getUri()) && version.getUri().contains(".")) {
            uriExtension = version.getUri().substring(version.getUri().lastIndexOf(46) + 1);
        }
        String filenameExtension = "";
        if (Objects.nonNull(version.getFileInfoModel()) && StringUtils.isNotBlank((CharSequence)version.getFileInfoModel().getFilename()) && version.getFileInfoModel().getFilename().contains(".")) {
            filenameExtension = version.getFileInfoModel().getFilename().substring(version.getFileInfoModel().getFilename().lastIndexOf(46) + 1);
        }
        if (StringUtils.isNotBlank((CharSequence)filenameExtension)) {
            return "." + filenameExtension;
        }
        if (StringUtils.isNotBlank((CharSequence)uriExtension)) {
            return "." + uriExtension;
        }
        return "";
    }

    @Generated
    public ProjectObjectGroupService(CollectService collectService, ObjectMapper objectMapper) {
        this.collectService = collectService;
        this.objectMapper = objectMapper;
    }
}

