/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitamui.collect.server.rest;

import fr.gouv.vitam.common.exception.VitamClientException;
import fr.gouv.vitamui.archives.search.common.dto.ReclassificationCriteriaDto;
import fr.gouv.vitamui.collect.common.dto.CollectTransactionDto;
import fr.gouv.vitamui.collect.server.service.ExternalParametersService;
import fr.gouv.vitamui.collect.server.service.TransactionService;
import fr.gouv.vitamui.common.security.SafeFileChecker;
import fr.gouv.vitamui.common.security.SanityChecker;
import fr.gouv.vitamui.commons.api.ParameterChecker;
import fr.gouv.vitamui.commons.api.exception.PreconditionFailedException;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.io.InputStream;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.annotation.Secured;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import reactor.core.publisher.Mono;

@RequestMapping(value={"/collect-api/v1/transactions"})
@RestController
@Tag(name="Collect")
@ResponseBody
public class TransactionController {
    private static final Logger LOGGER = LoggerFactory.getLogger(TransactionController.class);
    private static final String MANDATORY_IDENTIFIER = "The Identifier is a mandatory parameter: ";
    private static final String MANDATORY_QUERY = "The query is a mandatory parameter: ";
    private static final String TRANSACTION_ID = "The transaction id {} ";
    private final TransactionService transactionService;
    private final ExternalParametersService externalParametersService;

    @Secured(value={"ROLE_SEND_TRANSACTIONS"})
    @PutMapping(value={"/{id}/send"})
    public void sendTransaction(@PathVariable(value="id") String id) throws PreconditionFailedException, VitamClientException {
        ParameterChecker.checkParameter((String)MANDATORY_IDENTIFIER, (String[])new String[]{id});
        SanityChecker.checkSecureParameter((String[])new String[]{id});
        LOGGER.debug(TRANSACTION_ID, (Object)id);
        this.transactionService.sendTransaction(id, this.externalParametersService.buildVitamContextFromExternalParam());
    }

    @Secured(value={"ROLE_REOPEN_TRANSACTIONS"})
    @PutMapping(value={"/{id}/reopen"})
    public void reopenTransaction(@PathVariable(value="id") String id) throws PreconditionFailedException, VitamClientException {
        ParameterChecker.checkParameter((String)MANDATORY_IDENTIFIER, (String[])new String[]{id});
        SanityChecker.checkSecureParameter((String[])new String[]{id});
        LOGGER.debug(TRANSACTION_ID, (Object)id);
        this.transactionService.reopenTransaction(id, this.externalParametersService.buildVitamContextFromExternalParam());
    }

    @Secured(value={"ROLE_ABORT_TRANSACTIONS"})
    @PutMapping(value={"/{id}/abort"})
    public void abortTransaction(@PathVariable(value="id") String id) throws PreconditionFailedException, VitamClientException {
        ParameterChecker.checkParameter((String)MANDATORY_IDENTIFIER, (String[])new String[]{id});
        SanityChecker.checkSecureParameter((String[])new String[]{id});
        LOGGER.debug(TRANSACTION_ID, (Object)id);
        this.transactionService.abortTransaction(id, this.externalParametersService.buildVitamContextFromExternalParam());
    }

    @Secured(value={"ROLE_CLOSE_TRANSACTIONS"})
    @PutMapping(value={"/{id}/validate"})
    public void validateTransaction(@PathVariable(value="id") String id) throws PreconditionFailedException, VitamClientException {
        ParameterChecker.checkParameter((String)MANDATORY_IDENTIFIER, (String[])new String[]{id});
        SanityChecker.checkSecureParameter((String[])new String[]{id});
        LOGGER.debug(TRANSACTION_ID, (Object)id);
        this.transactionService.validateTransaction(id, this.externalParametersService.buildVitamContextFromExternalParam());
    }

    @Operation(summary="Get transaction by id")
    @Secured(value={"ROLE_GET_TRANSACTIONS"})
    @GetMapping(value={"/{id}"})
    public CollectTransactionDto getTransactionById(@PathVariable(value="id") String id) throws PreconditionFailedException, VitamClientException {
        ParameterChecker.checkParameter((String)MANDATORY_IDENTIFIER, (String[])new String[]{id});
        SanityChecker.checkSecureParameter((String[])new String[]{id});
        LOGGER.debug("Find the Transactions with project Id {}", (Object)id);
        return this.transactionService.getTransactionById(id, this.externalParametersService.buildVitamContextFromExternalParam());
    }

    @Secured(value={"ROLE_UPDATE_TRANSACTIONS"})
    @PutMapping
    public CollectTransactionDto updateTransaction(@RequestBody CollectTransactionDto transactionDto) throws PreconditionFailedException {
        ParameterChecker.checkParameter((String)MANDATORY_IDENTIFIER, (String[])new String[]{transactionDto.getId()});
        SanityChecker.checkSecureParameter((String[])new String[]{transactionDto.getId()});
        SanityChecker.sanitizeCriteria((Object)((Object)transactionDto));
        LOGGER.debug("[External] Transaction to update : {}", (Object)transactionDto);
        return this.transactionService.updateTransaction(transactionDto, this.externalParametersService.buildVitamContextFromExternalParam());
    }

    @Secured(value={"ROLE_COLLECT_UPDATE_BULK_ARCHIVE_UNIT"})
    @Operation(summary="Upload on streaming metadata file and update archive units")
    @PutMapping(value={"/{transactionId}/update-units-metadata"}, consumes={"application/octet-stream"})
    public String updateArchiveUnitsMetadataFromFile(@PathVariable(value="transactionId") String transactionId, InputStream inputStream, @RequestHeader(value="X-Original-Filename") String originalFileName) throws PreconditionFailedException {
        ParameterChecker.checkParameter((String)" [External] The transactionId is a mandatory parameter: ", (String[])new String[]{transactionId});
        SanityChecker.checkSecureParameter((String[])new String[]{transactionId});
        SanityChecker.isValidFileName((String)originalFileName);
        SafeFileChecker.checkSafeFilePath((String)originalFileName);
        LOGGER.debug("[External] Calling update archive units metadata for transaction Id  {} ", (Object)transactionId);
        return this.transactionService.updateArchiveUnitsFromFile(inputStream, transactionId, this.externalParametersService.buildVitamContextFromExternalParam());
    }

    @Secured(value={"ROLE_COLLECT_RECLASSIFICATION"})
    @PostMapping(value={"/{transactionId}/reclassification"})
    public String reclassification(@PathVariable(value="transactionId") String transactionId, @RequestBody ReclassificationCriteriaDto reclassificationCriteriaDto) throws PreconditionFailedException, VitamClientException {
        ParameterChecker.checkParameter((String)MANDATORY_QUERY, (Object[])new Object[]{reclassificationCriteriaDto});
        SanityChecker.sanitizeCriteria((Object)reclassificationCriteriaDto);
        LOGGER.debug("Reclassification query {}", (Object)reclassificationCriteriaDto);
        return this.transactionService.reclassification(transactionId, reclassificationCriteriaDto, this.externalParametersService.buildVitamContextFromExternalParam());
    }

    @Operation(summary="Download SIP transaction as a zip file")
    @Secured(value={"ROLE_DOWNLOAD_SIP_TRANSACTIONS"})
    @GetMapping(value={"/{id}/downloadSip"})
    public Mono<ResponseEntity<Resource>> downloadSipTransaction(@PathVariable(value="id") String id) throws PreconditionFailedException, VitamClientException {
        ParameterChecker.checkParameter((String)MANDATORY_IDENTIFIER, (String[])new String[]{id});
        SanityChecker.checkSecureParameter((String[])new String[]{id});
        LOGGER.debug("Download SIP transaction with id: {}", (Object)id);
        return this.transactionService.downloadSipTransaction(id, this.externalParametersService.buildVitamContextFromExternalParam());
    }

    @Generated
    public TransactionController(TransactionService transactionService, ExternalParametersService externalParametersService) {
        this.transactionService = transactionService;
        this.externalParametersService = externalParametersService;
    }
}

