/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitamui.collect.server.rest;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import fr.gouv.vitam.common.database.builder.request.exception.InvalidCreateOperationException;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.exception.VitamClientException;
import fr.gouv.vitamui.archives.search.common.dto.VitamUIArchiveUnitResponseDto;
import fr.gouv.vitamui.collect.server.service.ExternalParametersService;
import fr.gouv.vitamui.collect.server.service.TransactionArchiveUnitService;
import fr.gouv.vitamui.common.security.SanityChecker;
import fr.gouv.vitamui.commons.api.ParameterChecker;
import fr.gouv.vitamui.commons.api.dtos.SearchCriteriaDto;
import fr.gouv.vitamui.commons.api.dtos.VitamUiOntologyDto;
import fr.gouv.vitamui.commons.api.exception.PreconditionFailedException;
import fr.gouv.vitamui.commons.vitam.api.dto.ResultsDto;
import fr.gouv.vitamui.iam.security.service.SecurityService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.ws.rs.Consumes;
import java.io.IOException;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;
import org.springframework.http.HttpStatus;
import org.springframework.security.access.annotation.Secured;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;

@RequestMapping(value={"/collect-api/v1/transactions"})
@RestController
@Tag(name="Collect")
@ResponseBody
public class TransactionArchiveUnitController {
    private static final Logger LOGGER = LoggerFactory.getLogger(TransactionArchiveUnitController.class);
    private static final String MANDATORY_QUERY = "The query is a mandatory parameter: ";
    private static final String MANDATORY_IDENTIFIER = "The identifier is a mandatory parameter: ";
    private final TransactionArchiveUnitService transactionArchiveUnitService;
    private final ExternalParametersService externalParametersService;
    private final SecurityService securityService;

    @Operation(summary="find archive units by criteria")
    @Secured(value={"ROLE_GET_PROJECTS"})
    @PostMapping(value={"/{transactionId}/archive-units"})
    @Consumes(value={"application/json"})
    @ResponseStatus(value=HttpStatus.OK)
    public VitamUIArchiveUnitResponseDto searchArchiveUnits(@PathVariable(value="transactionId") String transactionId, @RequestBody SearchCriteriaDto searchQuery) throws PreconditionFailedException, InvalidCreateOperationException, VitamClientException, InvalidParseOperationException, JsonProcessingException {
        ParameterChecker.checkParameter((String)"The Query and the transactionId are mandatories parameters: ", (Object[])new Object[]{transactionId, searchQuery});
        SanityChecker.sanitizeCriteria((Object)searchQuery);
        SanityChecker.checkSecureParameter((String[])new String[]{transactionId});
        LOGGER.debug("search archives Units by criteria = {}", (Object)searchQuery);
        return this.transactionArchiveUnitService.searchArchiveUnitsByCriteria(transactionId, searchQuery, this.externalParametersService.buildVitamContextFromExternalParam());
    }

    @PostMapping(value={"/{transactionId}/archive-units/export-csv-search"})
    @Secured(value={"ROLE_COLLECT_GET_ARCHIVE_SEARCH"})
    public Resource exportCsvArchiveUnitsByCriteria(@PathVariable(value="transactionId") String transactionId, @RequestBody SearchCriteriaDto query) throws PreconditionFailedException, VitamClientException {
        ParameterChecker.checkParameter((String)MANDATORY_QUERY, (Object[])new Object[]{query});
        SanityChecker.checkSecureParameter((String[])new String[]{transactionId});
        SanityChecker.sanitizeCriteria((Object)query);
        LOGGER.debug("Calling export to csv search archive Units By Criteria {} ", (Object)query);
        return this.transactionArchiveUnitService.exportToCsvSearchArchiveUnitsByCriteria(transactionId, query, this.externalParametersService.buildVitamContextFromExternalParam());
    }

    @GetMapping(value={"/archiveunit/{id}"})
    @Secured(value={"ROLE_COLLECT_GET_ARCHIVE_SEARCH"})
    public ResultsDto findUnitById(@PathVariable(value="id") String id) throws PreconditionFailedException, VitamClientException {
        ParameterChecker.checkParameter((String)MANDATORY_IDENTIFIER, (String[])new String[]{id});
        SanityChecker.checkSecureParameter((String[])new String[]{id});
        LOGGER.debug("the UA by id {} ", (Object)id);
        return this.transactionArchiveUnitService.findArchiveUnitById(id, this.externalParametersService.buildVitamContextFromExternalParam());
    }

    @GetMapping(value={"/objects/{id}"})
    @Secured(value={"ROLE_COLLECT_GET_ARCHIVE_SEARCH"})
    public ResultsDto getObjectGroupById(@PathVariable(value="id") String objectId) throws PreconditionFailedException, VitamClientException {
        ParameterChecker.checkParameter((String)MANDATORY_IDENTIFIER, (String[])new String[]{objectId});
        SanityChecker.checkSecureParameter((String[])new String[]{objectId});
        LOGGER.debug("[EXTERNAL] : Get ObjectGroup By id : {}", (Object)objectId);
        return this.transactionArchiveUnitService.findObjectGroupById(objectId, this.externalParametersService.buildVitamContextFromExternalParam());
    }

    @GetMapping(value={"/external-ontologies"})
    @Secured(value={"ROLE_COLLECT_GET_ARCHIVE_SEARCH"})
    public List<VitamUiOntologyDto> getExternalOntologiesList() throws IOException {
        LOGGER.debug("[EXTERNAL] : Get external ontologies list");
        return this.transactionArchiveUnitService.readExternalOntologiesFromFile(this.securityService.getTenantIdentifier());
    }

    @PostMapping(value={"/{transactionId}/unit-with-inherited-rules"})
    @Secured(value={"ROLE_COLLECT_GET_ARCHIVE_SEARCH"})
    public ResultsDto selectUnitWithInheritedRules(@PathVariable(value="transactionId") String transactionId, @RequestBody SearchCriteriaDto query) throws PreconditionFailedException, VitamClientException, IOException {
        ParameterChecker.checkParameter((String)MANDATORY_QUERY, (Object[])new Object[]{query});
        SanityChecker.checkSecureParameter((String[])new String[]{transactionId});
        SanityChecker.sanitizeCriteria((Object)query);
        LOGGER.debug("Calling select Unit With Inherited Rules By Criteria {} ", (Object)query);
        return this.transactionArchiveUnitService.selectUnitWithInheritedRules(query, transactionId, this.externalParametersService.buildVitamContextFromExternalParam());
    }

    @Secured(value={"ROLE_COLLECT_DELETE_ARCHIVE_UNIT"})
    @Operation(summary="Upload on streaming metadata file and update archive units")
    @PostMapping(value={"/{transactionId}/deletion/action"}, consumes={"application/json"})
    public JsonNode startDeletionAction(@PathVariable(value="transactionId") String transactionId, @RequestBody SearchCriteriaDto query) throws PreconditionFailedException, VitamClientException {
        ParameterChecker.checkParameter((String)MANDATORY_QUERY, (Object[])new Object[]{query});
        SanityChecker.sanitizeCriteria((Object)query);
        LOGGER.debug("Calling deletion action by criteria {} ", (Object)query);
        return this.transactionArchiveUnitService.startDeletionAction(this.externalParametersService.buildVitamContextFromExternalParam(), transactionId, query);
    }

    @Generated
    public TransactionArchiveUnitController(TransactionArchiveUnitService transactionArchiveUnitService, ExternalParametersService externalParametersService, SecurityService securityService) {
        this.transactionArchiveUnitService = transactionArchiveUnitService;
        this.externalParametersService = externalParametersService;
        this.securityService = securityService;
    }
}

